/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.bpmn.bpd.reactions;

import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigurePlaneRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.actions.ACMovePoint;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionFactory;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourcePoint;
import com.arcway.planagent.planmodel.bpmn.bpd.access.readwrite.IPMPlanElementBPMNBPDGatewayRW;
import com.arcway.planagent.planmodel.reactions.IRAChangeGeometryFigure;
import com.arcway.planagent.planmodel.reactions.PositionAndPoint;
import java.util.List;

public class RAFixGateway
implements IRAChangeGeometryFigure {
    private static final ILogger logger = Logger.getLogger(RAFixGateway.class);

    public ActionIterator createReactionsFigureGeometryChanged(IPMFigureRW figure, List<PositionAndPoint> oldGeometry, ActionContext context) {
        if (logger.isTraceEnabled()) {
            logger.trace("RAFixAnchoringsAfterFigureModify createReactions(" + figure + ") - start");
        }
        PredeterminedActionIterator actions = new PredeterminedActionIterator(4);
        this.addFixActions(figure, context, actions);
        if (actions.isEmpty()) {
            actions = null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("getReActionIterator(Action) - end - return value = " + actions);
        }
        return actions;
    }

    private void addFixActions(IPMFigureRW figure, ActionContext actionContext, PredeterminedActionIterator actions) {
        IPMFigurePlaneRW geometryFigure = null;
        boolean route = true;
        if (route && !(figure.getPlanElementRW() instanceof IPMPlanElementBPMNBPDGatewayRW)) {
            route &= false;
        }
        if (route && !(figure instanceof IPMFigurePlaneRW)) {
            route &= false;
        }
        if (route) {
            IPMFigurePlaneRW plane = (IPMFigurePlaneRW)figure;
            if (!plane.getRole().equals("geometryFigure")) {
                route &= false;
            }
            if (route) {
                geometryFigure = plane;
            }
        }
        if (geometryFigure != null) {
            IPMFigurePlaneRW oldGatewayFigure = ((IPMPlanElementBPMNBPDGatewayRW)geometryFigure.getPlanElementRW()).getGatewayFigureRW();
            IPMPointRW upperPoint = null;
            IPMPointRW rightPoint = null;
            IPMPointRW lowerPoint = null;
            IPMPointRW leftPoint = null;
            int i = 0;
            while (i < oldGatewayFigure.getPointListRW().getPointCount()) {
                IPMPointRW currentPoint = oldGatewayFigure.getPointListRW().getPointRW(i);
                if (upperPoint == null) {
                    upperPoint = currentPoint;
                } else if (currentPoint.getPosition().y - 1.0E-10 < upperPoint.getPosition().y) {
                    upperPoint = currentPoint;
                }
                if (rightPoint == null) {
                    rightPoint = currentPoint;
                } else if (currentPoint.getPosition().x + 1.0E-10 > rightPoint.getPosition().x) {
                    rightPoint = currentPoint;
                }
                if (lowerPoint == null) {
                    lowerPoint = currentPoint;
                } else if (currentPoint.getPosition().y + 1.0E-10 > lowerPoint.getPosition().y) {
                    lowerPoint = currentPoint;
                }
                if (leftPoint == null) {
                    leftPoint = currentPoint;
                } else if (currentPoint.getPosition().x - 1.0E-10 < leftPoint.getPosition().x) {
                    leftPoint = currentPoint;
                }
                ++i;
            }
            IPMPointRW upperLeftGeometry = null;
            IPMPointRW lowerRightGeometry = null;
            int i2 = 0;
            while (i2 < geometryFigure.getPointListRW().getPointCount()) {
                IPMPointRW currentPoint = geometryFigure.getPointListRW().getPointRW(i2);
                if (upperLeftGeometry == null) {
                    upperLeftGeometry = currentPoint;
                } else if (currentPoint.getPosition().y + 1.0E-10 < upperLeftGeometry.getPosition().y) {
                    upperLeftGeometry = currentPoint;
                } else if (Geo.equals((double)currentPoint.getPosition().y, (double)upperLeftGeometry.getPosition().y) && currentPoint.getPosition().x - 1.0E-10 < upperLeftGeometry.getPosition().x) {
                    upperLeftGeometry = currentPoint;
                }
                if (lowerRightGeometry == null) {
                    lowerRightGeometry = currentPoint;
                } else if (currentPoint.getPosition().y - 1.0E-10 > lowerRightGeometry.getPosition().y) {
                    lowerRightGeometry = currentPoint;
                } else if (Geo.equals((double)currentPoint.getPosition().y, (double)lowerRightGeometry.getPosition().y) && currentPoint.getPosition().x - 1.0E-10 > lowerRightGeometry.getPosition().x) {
                    lowerRightGeometry = currentPoint;
                }
                ++i2;
            }
            assert (upperPoint != null) : "upper point has not been calculated";
            assert (rightPoint != null) : "right point has not been calculated";
            assert (lowerPoint != null) : "lower point has not been calculated";
            assert (leftPoint != null) : "left point has not been calculated";
            assert (upperLeftGeometry != null) : "upper left point of geometry figure has not been calculated";
            assert (lowerRightGeometry != null) : "lower right point of geometry figure has not been calculated";
            double x1 = upperLeftGeometry.getPosition().x;
            double x2 = lowerRightGeometry.getPosition().x;
            double y1 = upperLeftGeometry.getPosition().y;
            double y2 = lowerRightGeometry.getPosition().y;
            double xC = (x1 + x2) / 2.0;
            double yC = (y1 + y2) / 2.0;
            ACMovePoint moveUpper = ActionFactory.createACMovePoint((ActionContext)actionContext, (IAnchoringSourcePoint)upperPoint, (GeoVector)new GeoVector(upperPoint.getPosition(), new Point(xC, y1)), (boolean)false);
            actions.addAction((Action)moveUpper);
            ACMovePoint moveRight = ActionFactory.createACMovePoint((ActionContext)actionContext, (IAnchoringSourcePoint)rightPoint, (GeoVector)new GeoVector(rightPoint.getPosition(), new Point(x2, yC)), (boolean)false);
            actions.addAction((Action)moveRight);
            ACMovePoint moveLower = ActionFactory.createACMovePoint((ActionContext)actionContext, (IAnchoringSourcePoint)lowerPoint, (GeoVector)new GeoVector(lowerPoint.getPosition(), new Point(xC, y2)), (boolean)false);
            actions.addAction((Action)moveLower);
            ACMovePoint moveLeft = ActionFactory.createACMovePoint((ActionContext)actionContext, (IAnchoringSourcePoint)leftPoint, (GeoVector)new GeoVector(leftPoint.getPosition(), new Point(x1, yC)), (boolean)false);
            actions.addAction((Action)moveLeft);
        }
    }
}

