/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.bpmn.bpd.implementation;

import com.arcway.planagent.controllinginterface.planagent.FlowType;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.anchoring.IAnchoring;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDecider;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestination;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationFigure;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationPoint;
import com.arcway.planagent.planmodel.anchoring.IAnchoringPoint2Figure;
import com.arcway.planagent.planmodel.anchoring.IAnchoringPoint2Point;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSource;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourcePoint;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineEndMarkerAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineMarkerAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineStartMarkerAppearanceRO;
import com.arcway.planagent.planmodel.bpmn.bpd.access.readonly.IPMPlanElementBPMNBPDEventRO;
import com.arcway.planagent.planmodel.bpmn.bpd.access.readwrite.IPMPlanElementBPMNBPDActivityRW;
import com.arcway.planagent.planmodel.bpmn.bpd.access.readwrite.IPMPlanElementBPMNBPDEventRW;
import com.arcway.planagent.planmodel.bpmn.bpd.check.BPMNBPDValidityMatrix;
import com.arcway.planagent.planmodel.bpmn.bpd.relations.BPMNBPDRelationMatrix;
import com.arcway.planagent.planmodel.cm.routing.CurveLineRouter;
import com.arcway.planagent.planmodel.cm.routing.ElongationToFigureCenterRouter;
import com.arcway.planagent.planmodel.cm.routing.RemoveAnchoringRouter;
import com.arcway.planagent.planmodel.cm.routing.SetPointOnFigureRouter;
import com.arcway.planagent.planmodel.cm.routing.SetPointToPointRouter;
import com.arcway.planagent.planmodel.implementation.PMPlan;
import com.arcway.planagent.planmodel.implementation.PlanModelMgr;
import com.arcway.planagent.planmodel.nesting.INestable;
import com.arcway.planagent.planmodel.nesting.INestingManager;
import com.arcway.planagent.planmodel.persistent.EOPlan;
import com.arcway.planagent.planmodel.relations.PlanElementRelation;
import com.arcway.planagent.planmodel.routing.IRouter;
import com.arcway.planagent.planmodel.routing.IRoutingManager;
import com.arcway.planagent.planmodel.routing.IRoutingParameters;
import com.arcway.planagent.planmodel.transactions.AllowAllTransactionsTransactionValidator;
import com.arcway.planagent.planmodel.transactions.ITransactionValidator;

public class PMPlanBPMNBPD
extends PMPlan
implements IAnchoringDecider,
IRoutingManager,
INestingManager {
    public static final String PLAN_TYPE_ID = "bpmn.bpd";
    private static String XML_TYPE = "bpmn.bpd";
    private static final String[] supportedPlanElementTypeIDs = new String[]{"bpmn.bpd.gateway", "bpmn.bpd.event" + IPMPlanElementBPMNBPDEventRW.EventVariant.Unspecified.getXMLSubType(), "bpmn.bpd.event" + IPMPlanElementBPMNBPDEventRW.EventVariant.Start.getXMLSubType(), "bpmn.bpd.event" + IPMPlanElementBPMNBPDEventRW.EventVariant.StartNonCanceling.getXMLSubType(), "bpmn.bpd.event" + IPMPlanElementBPMNBPDEventRW.EventVariant.Intermediate.getXMLSubType(), "bpmn.bpd.event" + IPMPlanElementBPMNBPDEventRW.EventVariant.IntermediateNonCanceling.getXMLSubType(), "bpmn.bpd.event" + IPMPlanElementBPMNBPDEventRW.EventVariant.IntermediateThrowing.getXMLSubType(), "bpmn.bpd.event" + IPMPlanElementBPMNBPDEventRW.EventVariant.End.getXMLSubType(), "bpmn.bpd.activity" + IPMPlanElementBPMNBPDActivityRW.ActivityVariant.Unspecified.getXMLSubType(), "bpmn.bpd.activity" + IPMPlanElementBPMNBPDActivityRW.ActivityVariant.CallActivity.getXMLSubType(), "bpmn.bpd.activity" + IPMPlanElementBPMNBPDActivityRW.ActivityVariant.EventSubProcess.getXMLSubType(), "bpmn.bpd.activity" + IPMPlanElementBPMNBPDActivityRW.ActivityVariant.Task.getXMLSubType(), "bpmn.bpd.activity" + IPMPlanElementBPMNBPDActivityRW.ActivityVariant.Transaction.getXMLSubType(), "bpmn.bpd.competency", "bpmn.bpd.relation", "bpmn.bpd.group", "bpmn.bpd.dataobject", "bpmn.bpd.dataobjectnew", "bpmn.bpd.message", "fmc.cm.lineshapecomment", "fmc.cm.planecomment", "fmc.cm.dotscomment", "bpmn.bpd.comment", "fmc.cm.legend"};

    public PMPlanBPMNBPD(PlanModelMgr planModelMgr, EOPlan eo) {
        super(planModelMgr, eo);
    }

    public PMPlanBPMNBPD(PlanModelMgr planModelMgr) {
        super(planModelMgr);
        this.setType(XML_TYPE);
    }

    public String[] getSupportedPlanElementTypeIDs() {
        return supportedPlanElementTypeIDs;
    }

    public IRoutingManager getRoutingManager() {
        return this;
    }

    public INestingManager getNestingManager() {
        return this;
    }

    public IAnchoringDecider getAnchoringDecider() {
        return this;
    }

    public boolean isDesirableAnchoring(IAnchoringSource source, IAnchoringDestination destination) {
        boolean isDesirable = false;
        IPMFigureRO fig1 = source.getAnchoringFigure();
        IPMFigureRO fig2 = destination.getAnchoringFigure();
        return isDesirable |= BPMNBPDValidityMatrix.isTouchValid(fig1, fig2);
    }

    protected boolean isAllowedAnchoring(IAnchoringSource source, IAnchoringDestination destination) {
        boolean isAllowed = false;
        if (source instanceof IAnchoringSourcePoint) {
            if (destination instanceof IAnchoringDestinationFigure) {
                isAllowed |= BPMNBPDValidityMatrix.isPointToFigureAnchoringPossible((IAnchoringSourcePoint)source, (IAnchoringDestinationFigure)destination);
            }
            if (destination instanceof IAnchoringDestinationPoint) {
                isAllowed |= BPMNBPDValidityMatrix.isPointToPointAnchoringPossible((IAnchoringSourcePoint)source, (IAnchoringDestinationPoint)destination);
            }
        }
        return isAllowed;
    }

    public IRouter getRouter(IAnchoring anchoring, IRoutingParameters routingParameters) {
        Object router;
        if (anchoring instanceof IAnchoringPoint2Figure) {
            boolean toCenterRouter = false;
            router = ((IAnchoringPoint2Figure)anchoring).getAnchoringSourcePoint().getAnchoringFigure().getPlanElementRO() instanceof IPMPlanElementBPMNBPDEventRO ? new SetPointOnFigureRouter() : (toCenterRouter ? new ElongationToFigureCenterRouter() : new CurveLineRouter());
        } else {
            router = anchoring instanceof IAnchoringPoint2Point ? new SetPointToPointRouter() : new RemoveAnchoringRouter();
        }
        return router;
    }

    public boolean decideNesting(INestable inner, INestable outer) {
        return false;
    }

    public ITransactionValidator getTransactionValidator() {
        return AllowAllTransactionsTransactionValidator.getInstance();
    }

    public PlanElementRelation analyzePlanElementRelation(String startPlanElementType, String endElementType, ILineStartMarkerAppearanceRO lineStartMarkerAppearanceRO, ILineEndMarkerAppearanceRO lineEndMarkerAppearanceRO, ILineAppearanceRO lineAppearanceRO) {
        int direction = BPMNBPDRelationMatrix.getDirection((ILineMarkerAppearanceRO)lineStartMarkerAppearanceRO, (ILineMarkerAppearanceRO)lineEndMarkerAppearanceRO);
        if (direction == 2) {
            if (BPMNBPDRelationMatrix.isAccess(startPlanElementType, endElementType)) {
                return new PlanElementRelation(0, direction);
            }
        } else {
            if (BPMNBPDRelationMatrix.isCausality(startPlanElementType, endElementType)) {
                return new PlanElementRelation(1, direction);
            }
            if (BPMNBPDRelationMatrix.isAccess(startPlanElementType, endElementType)) {
                return new PlanElementRelation(0, direction);
            }
        }
        return null;
    }

    public FlowType getFlowType() {
        return FlowType.UNKNOWN;
    }
}

