/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.acm.pd.reactions;

import com.arcway.lib.geometry.Corner;
import com.arcway.lib.geometry.Direction;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Line;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.StraightLine;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigurePlaneRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointListRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.acm.pd.access.readwrite.IPMPlanElementACMPDProcessStepRW;
import com.arcway.planagent.planmodel.actions.ACCreateFigurePlane;
import com.arcway.planagent.planmodel.actions.ACMovePoint;
import com.arcway.planagent.planmodel.actions.ACRemoveFigure;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionFactory;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourcePoint;
import com.arcway.planagent.planmodel.appearance.FillAppearance;
import com.arcway.planagent.planmodel.appearance.IFillAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.appearance.LineAppearance;
import com.arcway.planagent.planmodel.reactions.FigureMovements;
import com.arcway.planagent.planmodel.reactions.IRAChangeGeometryFigure;
import com.arcway.planagent.planmodel.reactions.IRAMoveFigure;
import com.arcway.planagent.planmodel.reactions.PositionAndPoint;
import java.util.List;

public class RAFixArrow
implements IRAChangeGeometryFigure,
IRAMoveFigure {
    private static final int NOT_BOUND = 0;
    private static final int BOTH_BOUND = 1;
    private static final int FIRST_BOUND = 2;
    private static final int SECOND_BOUND = 3;
    private static final double ARROW_OFFSET = 10.0;
    private static final ILogger logger = Logger.getLogger(RAFixArrow.class);

    public ActionIterator createReactionsFigureGeometryChanged(IPMFigureRW figure, List<PositionAndPoint> oldGeometry, ActionContext actionContext) {
        if (logger.isTraceEnabled()) {
            logger.trace("RAFixAnchoringsAfterFigureModify createReactions(" + figure + ") - start");
        }
        PredeterminedActionIterator actions = new PredeterminedActionIterator(6);
        this.addFixActions(figure, actionContext, actions);
        if (actions.isEmpty()) {
            actions = null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("getReActionIterator(Action) - end - return value = " + actions);
        }
        return actions;
    }

    public ActionIterator createReactionsFiguresMoved(FigureMovements figureMovements, ActionContext context) {
        PredeterminedActionIterator actions = new PredeterminedActionIterator(6 * figureMovements.size());
        for (IPMFigureRW figure : figureMovements) {
            this.addFixActions(figure, context, actions);
        }
        if (actions.isEmpty()) {
            actions = null;
        }
        return actions;
    }

    private void addFixActions(IPMFigureRW figure, ActionContext actionContext, PredeterminedActionIterator actions) {
        IPMFigurePlaneRW geometryFigure = null;
        boolean route = true;
        if (route && !(figure.getPlanElementRW() instanceof IPMPlanElementACMPDProcessStepRW)) {
            route &= false;
        }
        if (route && !(figure instanceof IPMFigurePlaneRW)) {
            route &= false;
        }
        if (route) {
            IPMFigurePlaneRW plane = (IPMFigurePlaneRW)figure;
            if (!plane.getRole().equals("geometryFigure")) {
                route &= false;
            }
            if (route) {
                geometryFigure = plane;
            }
        }
        if (geometryFigure != null) {
            int numberOfVerticalLines;
            int geometryPointCount;
            IPMFigurePlaneRW oldArrowFigure = ((IPMPlanElementACMPDProcessStepRW)geometryFigure.getPlanElementRW()).getArrowFigureRW();
            IPMPointListRW geometryPointList = geometryFigure.getPointListRW();
            IPMPointListRW oldArrowFigurePointList = oldArrowFigure.getPointListRW();
            int oldArrowFigurePointCount = oldArrowFigurePointList.getPointCount();
            if (oldArrowFigurePointCount != (geometryPointCount = geometryPointList.getPointCount()) + (numberOfVerticalLines = this.getNumberOfVerticalLinesInGeometryFigure(geometryFigure))) {
                this.addFixActions_old(figure, actionContext, actions);
                return;
            }
            int j = 0;
            int i = 0;
            while (i < geometryPointCount) {
                IPMPointRW currentGeometryPoint = geometryPointList.getPointRW(i);
                IPMPointRW currentArrowPoint = oldArrowFigurePointList.getPointRW(j);
                double currentGeometryPointX = currentGeometryPoint.getPosition().x;
                double currentGeometryPointY = currentGeometryPoint.getPosition().y;
                if (currentGeometryPoint.getLine2ndRW().getForce() != 3) {
                    Point newCurrentArrowPoint = new Point(currentGeometryPointX - 10.0, currentGeometryPointY);
                    if (!currentArrowPoint.getPosition().equalsPoint(newCurrentArrowPoint)) {
                        ACMovePoint movePointAction = ActionFactory.createACMovePoint((ActionContext)actionContext, (IAnchoringSourcePoint)currentArrowPoint, (GeoVector)new GeoVector(currentArrowPoint.getPosition(), newCurrentArrowPoint), (boolean)false);
                        actions.addAction((Action)movePointAction);
                    }
                } else {
                    ACMovePoint moveThirdPointAction;
                    Point newThirdArrowPoint;
                    ACMovePoint moveSecondPointAction;
                    Point newSecondArrowPoint;
                    ACMovePoint movePointAction;
                    Point newCurrentArrowPoint;
                    double centerY;
                    double secondGeometryPointY;
                    IPMPointRW secondGeometryPoint;
                    if (i + 1 < geometryPointCount) {
                        secondGeometryPoint = geometryPointList.getPointRW(i + 1);
                        i = geometryPointList.getPointIndex(secondGeometryPoint);
                    } else {
                        secondGeometryPoint = geometryPointList.getPointRW(0);
                    }
                    IPMPointRW secondArrowPoint = oldArrowFigurePointList.getPointRW(j + 1);
                    IPMPointRW thirdArrowPoint = null;
                    if (j + 2 < oldArrowFigurePointCount) {
                        thirdArrowPoint = oldArrowFigurePointList.getPointRW(j + 2);
                        j = oldArrowFigurePointList.getPointIndex(thirdArrowPoint);
                    }
                    if (currentGeometryPointY > (secondGeometryPointY = secondGeometryPoint.getPosition().y)) {
                        centerY = secondGeometryPointY + (currentGeometryPointY - secondGeometryPointY) / 2.0;
                        newCurrentArrowPoint = new Point(currentGeometryPointX, currentGeometryPointY);
                        if (!currentArrowPoint.getPosition().equalsPoint(newCurrentArrowPoint)) {
                            movePointAction = ActionFactory.createACMovePoint((ActionContext)actionContext, (IAnchoringSourcePoint)currentArrowPoint, (GeoVector)new GeoVector(currentArrowPoint.getPosition(), newCurrentArrowPoint), (boolean)false);
                            actions.addAction((Action)movePointAction);
                        }
                        newSecondArrowPoint = new Point(currentGeometryPointX + 10.0, centerY);
                        if (!secondArrowPoint.getPosition().equalsPoint(newSecondArrowPoint)) {
                            moveSecondPointAction = ActionFactory.createACMovePoint((ActionContext)actionContext, (IAnchoringSourcePoint)secondArrowPoint, (GeoVector)new GeoVector(secondArrowPoint.getPosition(), newSecondArrowPoint), (boolean)false);
                            actions.addAction((Action)moveSecondPointAction);
                        }
                        if (thirdArrowPoint != null) {
                            newThirdArrowPoint = new Point(currentGeometryPointX, secondGeometryPointY);
                            if (!thirdArrowPoint.getPosition().equalsPoint(newThirdArrowPoint)) {
                                moveThirdPointAction = ActionFactory.createACMovePoint((ActionContext)actionContext, (IAnchoringSourcePoint)thirdArrowPoint, (GeoVector)new GeoVector(thirdArrowPoint.getPosition(), newThirdArrowPoint), (boolean)false);
                                actions.addAction((Action)moveThirdPointAction);
                            }
                        }
                    } else {
                        centerY = currentGeometryPointY + (secondGeometryPointY - currentGeometryPointY) / 2.0;
                        newCurrentArrowPoint = new Point(currentGeometryPointX - 10.0, currentGeometryPointY);
                        if (!currentArrowPoint.getPosition().equalsPoint(newCurrentArrowPoint)) {
                            movePointAction = ActionFactory.createACMovePoint((ActionContext)actionContext, (IAnchoringSourcePoint)currentArrowPoint, (GeoVector)new GeoVector(currentArrowPoint.getPosition(), newCurrentArrowPoint), (boolean)false);
                            actions.addAction((Action)movePointAction);
                        }
                        newSecondArrowPoint = new Point(currentGeometryPointX, centerY);
                        if (!secondArrowPoint.getPosition().equalsPoint(newSecondArrowPoint)) {
                            moveSecondPointAction = ActionFactory.createACMovePoint((ActionContext)actionContext, (IAnchoringSourcePoint)secondArrowPoint, (GeoVector)new GeoVector(secondArrowPoint.getPosition(), newSecondArrowPoint), (boolean)false);
                            actions.addAction((Action)moveSecondPointAction);
                        }
                        if (thirdArrowPoint != null) {
                            newThirdArrowPoint = new Point(currentGeometryPointX - 10.0, secondGeometryPointY);
                            if (!thirdArrowPoint.getPosition().equalsPoint(newThirdArrowPoint)) {
                                moveThirdPointAction = ActionFactory.createACMovePoint((ActionContext)actionContext, (IAnchoringSourcePoint)thirdArrowPoint, (GeoVector)new GeoVector(thirdArrowPoint.getPosition(), newThirdArrowPoint), (boolean)false);
                                actions.addAction((Action)moveThirdPointAction);
                            }
                        }
                    }
                }
                ++j;
                ++i;
            }
        }
    }

    private int getNumberOfVerticalLinesInGeometryFigure(IPMFigurePlaneRW geometryFigure) {
        IPMPointListRW pointList = geometryFigure.getPointListRW();
        int pointCount = pointList.getPointCount();
        int numberOfVerticalLines = 0;
        int i = 0;
        while (i < pointCount) {
            if (pointList.getPointRW(i).getLine1stRW().getForce() == 3) {
                ++numberOfVerticalLines;
            }
            ++i;
        }
        return numberOfVerticalLines;
    }

    private void addFixActions_old(IPMFigureRW figure, ActionContext actionContext, PredeterminedActionIterator actions) {
        IPMFigurePlaneRW geometryFigure = null;
        boolean route = true;
        if (route && !(figure.getPlanElementRW() instanceof IPMPlanElementACMPDProcessStepRW)) {
            route &= false;
        }
        if (route && !(figure instanceof IPMFigurePlaneRW)) {
            route &= false;
        }
        if (route) {
            IPMFigurePlaneRW plane = (IPMFigurePlaneRW)figure;
            if (!plane.getRole().equals("geometryFigure")) {
                route &= false;
            }
            if (route) {
                geometryFigure = plane;
            }
        }
        if (geometryFigure != null) {
            IPMFigurePlaneRW oldArrowFigure = ((IPMPlanElementACMPDProcessStepRW)geometryFigure.getPlanElementRW()).getArrowFigureRW();
            PointAkku points = new PointAkku();
            IPMPointListRW gfPoints = geometryFigure.getPointListRW();
            int i = 0;
            while (i < gfPoints.getLineCount()) {
                Point secondPoint;
                Point firstPoint;
                IPMLineRW line = gfPoints.getLineRW(i);
                if (line.getForce() == 2 || line.getPoint1stRW().getCornerRadius() > 0.0 || line.getPoint2ndRW().getCornerRadius() > 0.0) {
                    if (line.getForce() == 2) {
                        points.addPoint(line.getPoint1stRW().getPosition());
                        points.addPoint(line.getPoint2ndRW().getPosition());
                    } else {
                        Corner firstCorner = !line.getPoint1stRW().getCornerRadiusInfinity() ? new Corner(line.getPoint1stRW().getPosition(), line.getPoint1stRW().getCornerRadius()) : new Corner(line.getPoint1stRW().getPosition());
                        Corner secondCorner = !line.getPoint2ndRW().getCornerRadiusInfinity() ? new Corner(line.getPoint2ndRW().getPosition(), line.getPoint2ndRW().getCornerRadius()) : new Corner(line.getPoint2ndRW().getPosition());
                        points.addPoint((Point)firstCorner);
                        points.addPoint((Point)secondCorner);
                    }
                } else if (line.getForce() == 3) {
                    Point endPoint;
                    Point arrow;
                    firstPoint = line.getPoint1stRW().getPosition();
                    secondPoint = line.getPoint2ndRW().getPosition();
                    boolean tail = firstPoint.x < line.getPoint1stRW().getLine1stRW().getPoint1stRW().getPosition().x && secondPoint.x < line.getPoint2ndRW().getLine2ndRW().getPoint2ndRW().getPosition().x;
                    if (tail) {
                        Point startPoint;
                        arrow = new Line(firstPoint, secondPoint).getCenter();
                        StraightLine firstHorizontalEven = new StraightLine(firstPoint, Direction.ANGLE_0);
                        StraightLine secondHorizontalEven = new StraightLine(secondPoint, Direction.ANGLE_0);
                        StraightLine upEven = new StraightLine(arrow, Direction.ANGLE_45);
                        StraightLine downEven = new StraightLine(arrow, Direction.ANGLE_minus45);
                        if (firstPoint.y > secondPoint.y) {
                            startPoint = firstHorizontalEven.getInterceptPoint(upEven);
                            endPoint = secondHorizontalEven.getInterceptPoint(downEven);
                        } else {
                            startPoint = firstHorizontalEven.getInterceptPoint(downEven);
                            endPoint = secondHorizontalEven.getInterceptPoint(upEven);
                        }
                        points.removeLast();
                        points.addPoint(startPoint);
                        points.addPoint(arrow);
                        points.addPoint(endPoint);
                        points.removeNext();
                    } else {
                        StraightLine upEven;
                        StraightLine downEven;
                        Point startPoint = firstPoint;
                        endPoint = secondPoint;
                        if (startPoint.y < endPoint.y) {
                            downEven = new StraightLine(startPoint, Direction.ANGLE_minus45);
                            upEven = new StraightLine(endPoint, Direction.ANGLE_45);
                        } else {
                            downEven = new StraightLine(endPoint, Direction.ANGLE_minus45);
                            upEven = new StraightLine(startPoint, Direction.ANGLE_45);
                        }
                        arrow = upEven.getInterceptPoint(downEven);
                        points.addPoint(startPoint);
                        points.addPoint(arrow);
                        points.addPoint(endPoint);
                    }
                } else {
                    Point slopePoint;
                    Point horPoint;
                    firstPoint = line.getPoint1stRW().getPosition();
                    secondPoint = line.getPoint2ndRW().getPosition();
                    points.addPoint(firstPoint);
                    int bound = this.getVerticallyBoundPoints(line);
                    switch (bound) {
                        case 2: {
                            horPoint = firstPoint;
                            slopePoint = secondPoint;
                            break;
                        }
                        case 3: {
                            horPoint = secondPoint;
                            slopePoint = firstPoint;
                            break;
                        }
                        case 1: {
                            Boolean up;
                            Line firstLine = new Line(firstPoint, line.getPoint1stRW().getLine1stRW().getPoint1stRW().getPosition());
                            Line secondLine = new Line(secondPoint, line.getPoint2ndRW().getLine2ndRW().getPoint2ndRW().getPosition());
                            if (firstLine.isZeroLengthLine() && secondLine.isZeroLengthLine()) {
                                up = null;
                            } else if (firstLine.isZeroLengthLine()) {
                                up = secondLine.end.y < secondLine.start.y;
                            } else if (secondLine.isZeroLengthLine()) {
                                up = firstLine.end.y < firstLine.start.y;
                            } else {
                                boolean up1 = firstLine.end.y < firstLine.start.y;
                                boolean up2 = secondLine.end.y < secondLine.start.y;
                                up = up1 == up2 ? Boolean.valueOf(up1) : null;
                            }
                            if (up != null) {
                                if (up ^ firstPoint.y > secondPoint.y) {
                                    horPoint = secondPoint;
                                    slopePoint = firstPoint;
                                    break;
                                }
                                horPoint = firstPoint;
                                slopePoint = secondPoint;
                                break;
                            }
                            horPoint = null;
                            slopePoint = null;
                            break;
                        }
                        case 0: {
                            assert (false) : "invalid geometry figure, every point must be at least on one line with lineforce V";
                        }
                        default: {
                            horPoint = firstPoint;
                            slopePoint = secondPoint;
                        }
                    }
                    if (slopePoint != null && horPoint != null) {
                        StraightLine horEven;
                        StraightLine slopeEven;
                        if (slopePoint.x < horPoint.x ^ slopePoint.y > horPoint.y) {
                            slopeEven = new StraightLine(slopePoint, Direction.ANGLE_minus45);
                            horEven = new StraightLine(horPoint, Direction.ANGLE_180);
                        } else {
                            slopeEven = new StraightLine(slopePoint, Direction.ANGLE_45);
                            horEven = new StraightLine(horPoint, Direction.ANGLE_0);
                        }
                        Point bendPoint = slopeEven.getInterceptPoint(horEven);
                        points.addPoint(bendPoint);
                    }
                    points.addPoint(secondPoint);
                }
                ++i;
            }
            points.finsh();
            int[] forces = new int[points.points.size()];
            int i2 = 0;
            while (i2 < forces.length) {
                forces[i2] = 1;
                ++i2;
            }
            ACRemoveFigure removeFigure = new ACRemoveFigure(actionContext, (IPMFigureRW)oldArrowFigure);
            actions.addAction((Action)removeFigure);
            ACCreateFigurePlane createFigure = new ACCreateFigurePlane(actionContext, "arrow", geometryFigure.getPlanElementRW(), points.points, forces, (ILineAppearanceRO)new LineAppearance((ILineAppearanceRO)oldArrowFigure.getLineAppearanceRW()), (IFillAppearanceRO)new FillAppearance((IFillAppearanceRO)oldArrowFigure.getFillAppearanceRW()), true);
            actions.addAction((Action)createFigure);
        }
    }

    private int getVerticallyBoundPoints(IPMLineRW line) {
        int bound = 0;
        if (line.getPoint1stRW().getLine1stRW().getForce() == 3) {
            bound = 2;
        }
        if (line.getPoint2ndRW().getLine2ndRW().getForce() == 3) {
            bound = bound == 2 ? 1 : 3;
        }
        return bound;
    }

    private static class PointAkku {
        Points points = new Points();
        boolean dontAddNext = false;

        private PointAkku() {
        }

        public void addPoint(Point point) {
            if (this.dontAddNext) {
                this.dontAddNext = false;
            } else {
                int i = 0;
                while (i < this.points.size()) {
                    if (this.points.get(i).equalsPoint(point)) {
                        return;
                    }
                    ++i;
                }
                this.points.add(point);
            }
        }

        public void removeLast() {
            this.points.remove(this.points.size() - 1);
        }

        public void removeNext() {
            this.dontAddNext = true;
        }

        public void finsh() {
            if (this.dontAddNext) {
                this.points.remove(0);
                this.dontAddNext = false;
            }
        }
    }
}

