/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.tools;

import com.arcway.planagent.planeditor.commands.RQCreateConnection;
import com.arcway.planagent.planeditor.handles.IHandle;
import com.arcway.planagent.planeditor.tools.AbstractInputProcessor;
import com.arcway.planagent.planeditor.tools.GenericTool;
import com.arcway.planagent.planeditor.tools.IEMouseButtonClicked;
import com.arcway.planagent.planeditor.tools.IEMouseMove;
import com.arcway.planagent.planeditor.tools.InputEvent;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.graphics.Cursor;

public class IPDrawConnectionFromHandle
extends AbstractInputProcessor {
    private IHandle handle;
    private boolean simple;
    private boolean switchToDefaultTool = false;
    private RQCreateConnection request;
    private boolean drawConnectionInProgress = false;

    public IPDrawConnectionFromHandle(GenericTool tool) {
        super(tool);
    }

    public void enterDrawConnectionState(IHandle handleToSelect) {
        this.switchToDefaultTool = true;
        this.handleStartDrawConnection(new Point(0, 0), handleToSelect);
    }

    public void setSimple(boolean simple) {
        this.simple = simple;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int handleEvent(InputEvent event) {
        if (this.doesUserWishToCancel(event)) {
            this.cancel();
            return 1;
        }
        if (!this.drawConnectionInProgress) {
            if (!(event instanceof IEMouseButtonClicked)) return 0;
            IEMouseButtonClicked clickEvent = (IEMouseButtonClicked)event;
            if (clickEvent.getButton() != 1) return 0;
            if (clickEvent.getTimes() != 1) return 0;
            IHandle handleHit = this.getHandle(clickEvent.getCurrentPosition());
            this.createNewRequest();
            this.updateRequestSetCurrentPosition(clickEvent.getCurrentPosition());
            if (handleHit == null) return 0;
            if (handleHit.getCommand(this.getRequest()) == null) return 0;
            this.handleStartDrawConnection(clickEvent.getCurrentPosition(), handleHit);
            return 2;
        }
        if (event instanceof IEMouseMove) {
            IEMouseMove moveEvent = (IEMouseMove)event;
            this.handleDrawConnectionInProgressMouseMoved(moveEvent);
            return 2;
        }
        if (!(event instanceof IEMouseButtonClicked)) return 2;
        IEMouseButtonClicked clickEvent = (IEMouseButtonClicked)event;
        if (this.simple) {
            this.handleFinisheDrawConnection(clickEvent);
            return 1;
        }
        if (clickEvent.getButton() != 1) return 2;
        if (clickEvent.getTimes() == 1) {
            this.handleDrawConnectionInProgressPointClicked(clickEvent);
            return 2;
        }
        this.handleFinisheDrawConnection(clickEvent);
        return 1;
    }

    @Override
    public void cancel() {
        this.handle.eraseTargetFeedback(this.getRequest());
        this.drawConnectionInProgress = false;
        this.request = null;
        this.handle = null;
        if (this.switchToDefaultTool) {
            this.getTool().setToolToSwitchTo((GenericTool)this.getTool().getCurrentViewer().getEditDomain().getDefaultTool(), false);
        }
    }

    @Override
    protected Request getRequest() {
        return this.request;
    }

    private void createNewRequest() {
        this.request = new RQCreateConnection();
    }

    private String getRequestType() {
        return "createConnection";
    }

    private void updateRequestSetCurrentPosition(Point point) {
        assert (point != null) : "point is null";
        this.request.setLastPosition(point);
    }

    private void updateRequestAddClickedPoint(Point point) {
        assert (point != null) : "point is null";
        this.request.addClickedPoint(point);
    }

    private void updateRequestSetTarget(Object target) {
        this.request.setTarget(target);
    }

    private void handleStartDrawConnection(Point mousePosition, IHandle handleToUse) {
        assert (mousePosition != null);
        assert (handleToUse != null);
        this.drawConnectionInProgress = true;
        this.handle = handleToUse;
        this.createNewRequest();
        this.updateRequestSetCurrentPosition(mousePosition);
        this.handle.showTargetFeedback(this.getRequest());
    }

    private void handleDrawConnectionInProgressMouseMoved(IEMouseMove moveEvent) {
        assert (moveEvent != null) : "moveEvent is null";
        this.handle.eraseTargetFeedback(this.getRequest());
        this.updateRequestSetCurrentPosition(moveEvent.getCurrentPosition());
        this.handle.showTargetFeedback(this.getRequest());
    }

    private void handleDrawConnectionInProgressPointClicked(IEMouseButtonClicked clickEvent) {
        assert (clickEvent != null) : "clickEvent is null";
        this.handle.eraseTargetFeedback(this.getRequest());
        this.updateRequestAddClickedPoint(clickEvent.getCurrentPosition());
        this.handle.showTargetFeedback(this.getRequest());
    }

    private void handleFinisheDrawConnection(IEMouseButtonClicked clickEvent) {
        EditPart hit;
        assert (clickEvent != null) : "clickEvent is null";
        IHandle target = this.getHandle(clickEvent.getCurrentPosition());
        if (target == null && (hit = this.getHit(clickEvent.getCurrentPosition(), false)) != null) {
            target = this.getTargetAscending(hit);
        }
        this.updateRequestSetCurrentPosition(clickEvent.getCurrentPosition());
        this.updateRequestSetTarget(target);
        Command command = this.handle.getCommand(this.getRequest());
        this.executeCommand(command);
        this.cancel();
    }

    @Override
    public Cursor getCursor() {
        Cursor cursor = null;
        Point position = this.getTool().getState().getMousePosition();
        IHandle handleHit = this.getHandle(position);
        if (handleHit != null) {
            int commandType = handleHit.getCommandType(this.getRequestType());
            cursor = this.getCursorByCommandType(commandType);
        }
        return cursor;
    }
}

