/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.tools;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planeditor.commands.CommandExecuter;
import com.arcway.planagent.planeditor.edit.PEPlan;
import com.arcway.planagent.planeditor.handles.IHandle;
import com.arcway.planagent.planeditor.handles.IHandleFigure;
import com.arcway.planagent.planeditor.inputinterpreter.TargetFinder;
import com.arcway.planagent.planeditor.tools.Cursors;
import com.arcway.planagent.planeditor.tools.GenericTool;
import com.arcway.planagent.planeditor.tools.IEKeyDown;
import com.arcway.planagent.planeditor.tools.IInputProcessor;
import com.arcway.planagent.planeditor.tools.InputEvent;
import java.util.HashSet;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Handle;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractInputProcessor
implements IInputProcessor {
    private static final ILogger logger = Logger.getLogger(AbstractInputProcessor.class);
    private final GenericTool tool;
    private final FeedbackCreator feedbackCreator = new FeedbackCreator();

    protected AbstractInputProcessor(GenericTool tool) {
        assert (tool != null);
        this.tool = tool;
    }

    protected abstract Request getRequest();

    protected EditPart getHit(Point p, boolean preferSelected) {
        Handle handle;
        assert (p != null) : "Point p is null";
        EditPartViewer viewer = this.tool.getCurrentViewer();
        if (viewer instanceof GraphicalViewer && (handle = ((GraphicalViewer)viewer).findHandleAt(p)) != null) {
            return null;
        }
        List selectedItems = viewer.getSelectedEditParts();
        if (!preferSelected || selectedItems == null || selectedItems.isEmpty()) {
            return viewer.findObjectAt(p);
        }
        EditPart hit = null;
        HashSet<IFigure> blackList = new HashSet<IFigure>();
        while (hit == null) {
            EditPart candidate = viewer.findObjectAtExcluding(p, blackList);
            if (candidate instanceof PEPlan) {
                return viewer.findObjectAt(p);
            }
            if (candidate instanceof GraphicalEditPart) {
                GraphicalEditPart gep = (GraphicalEditPart)candidate;
                if (!selectedItems.contains(candidate)) {
                    blackList.add(gep.getFigure());
                    continue;
                }
                hit = candidate;
                continue;
            }
            logger.warn("Something was hit, but it wasn't a GraphicalEditPart: " + candidate);
            return hit;
        }
        return hit;
    }

    protected IHandle getHandle(Point p) {
        block5: {
            assert (p != null) : "Point p is null";
            EditPartViewer viewer = this.tool.getCurrentViewer();
            if (viewer instanceof GraphicalViewer) {
                Handle gefHandle = ((GraphicalViewer)viewer).findHandleAt(p);
                if (gefHandle == null) {
                    return null;
                }
                try {
                    IHandle ourHandle = ((IHandleFigure)gefHandle).getHandle();
                    return ourHandle;
                }
                catch (ClassCastException e) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError((Object)("GEF handle found at " + p));
                }
            }
        }
        return null;
    }

    protected EditPart getTargetAscending(EditPart hit) {
        return TargetFinder.getTargetAscending(hit, this.getRequest());
    }

    protected EditPart getTargetImmediatly(EditPart hit) {
        return TargetFinder.getTargetImmediatly(hit, this.getRequest());
    }

    protected boolean doesUserWishToCancel(InputEvent event) {
        assert (event != null);
        if (event instanceof IEKeyDown) {
            IEKeyDown keyEvent = (IEKeyDown)event;
            if (keyEvent.getPressedKey().keyCode == 27) {
                return true;
            }
        }
        return false;
    }

    protected GenericTool getTool() {
        return this.tool;
    }

    protected void executeCommand(Command command) {
        try {
            this.getTool().getCurrentViewer().getControl().getShell().setCursor(org.eclipse.draw2d.Cursors.WAIT);
            CommandExecuter.execute(this.getTool().getCurrentViewer().getEditDomain().getCommandStack(), command);
            this.getTool().getCurrentViewer().getControl().getShell().setCursor(org.eclipse.draw2d.Cursors.ARROW);
        }
        catch (Throwable e) {
            logger.warn("Exception occured during execution of command =" + command, e);
        }
    }

    protected Cursor getCursorByCommandType(int commandType) {
        Cursor cursor = null;
        boolean modeCopy = (commandType & Integer.MIN_VALUE) != 0;
        switch (commandType &= Integer.MAX_VALUE) {
            case 1: {
                cursor = null;
                break;
            }
            case 2: {
                cursor = org.eclipse.draw2d.Cursors.ARROW;
                break;
            }
            case 3: {
                cursor = org.eclipse.draw2d.Cursors.CROSS;
                break;
            }
            case 4: {
                if (modeCopy) {
                    cursor = Cursors.ADDARROW;
                    break;
                }
                cursor = Cursors.MOVEARROW;
                break;
            }
            case 5: {
                if (modeCopy) {
                    cursor = Cursors.ADDARROW;
                    break;
                }
                cursor = org.eclipse.draw2d.Cursors.SIZEALL;
                break;
            }
            case 6: {
                if (modeCopy) {
                    cursor = Cursors.ADDARROW;
                    break;
                }
                cursor = Cursors.MOVEARROW;
                break;
            }
            case 7: {
                cursor = Cursors.SIZEWE;
                break;
            }
            case 8: {
                cursor = Cursors.SIZENS;
                break;
            }
            case 9: {
                cursor = org.eclipse.draw2d.Cursors.SIZENWSE;
                break;
            }
            case 10: {
                cursor = org.eclipse.draw2d.Cursors.SIZENESW;
                break;
            }
            default: {
                cursor = null;
            }
        }
        return cursor;
    }

    protected Viewport findViewPort() {
        EditPartViewer viewer = this.getTool().getCurrentViewer();
        GraphicalEditPart ep = (GraphicalEditPart)viewer.getRootEditPart();
        IFigure figure = null;
        Viewport port = null;
        do {
            if (!((figure = figure == null ? ep.getContentPane() : figure.getParent()) instanceof Viewport)) continue;
            port = (Viewport)figure;
            break;
        } while (figure != ep.getFigure() && figure != null);
        return port;
    }

    protected IFigure getFeedbackLayer() {
        IFigure feedbackLayer = null;
        LayerManager lm = (LayerManager)this.getTool().getCurrentViewer().getEditPartRegistry().get(LayerManager.ID);
        if (lm != null) {
            feedbackLayer = lm.getLayer((Object)"Feedback Layer");
        }
        return feedbackLayer;
    }

    protected void showTargetFeedback() {
        this.feedbackCreator.showFeedback(this.getRequest());
    }

    protected void eraseTargetFeedback() {
        this.feedbackCreator.showFeedback(null);
    }

    private class FeedbackCreator
    implements Runnable {
        private Request currentRequest = null;
        private Request nextRequest;
        private boolean enqueued = false;

        public synchronized void showFeedback(Request request) {
            this.nextRequest = request;
            if (!this.enqueued) {
                this.getDisplay().asyncExec((Runnable)this);
                this.enqueued = true;
            }
        }

        @Override
        public synchronized void run() {
            if (this.currentRequest != null) {
                this.getPlan().eraseTargetFeedback(this.currentRequest);
                this.currentRequest = null;
            }
            if (this.nextRequest != null) {
                this.currentRequest = this.nextRequest;
                this.nextRequest = null;
                this.getPlan().showTargetFeedback(this.currentRequest);
            }
            this.enqueued = false;
        }

        private Display getDisplay() {
            return AbstractInputProcessor.this.getTool().getCurrentViewer().getControl().getDisplay();
        }

        private PEPlan getPlan() {
            return (PEPlan)AbstractInputProcessor.this.getTool().getCurrentViewer().getContents();
        }
    }
}

