/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.pagebooks.palette;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planeditor.pagebooks.AbstractPageBookMgr;
import com.arcway.planagent.planeditor.pagebooks.palette.EXPaletteFactoryException;
import com.arcway.planagent.planeditor.pagebooks.palette.Palette;
import com.arcway.planagent.planeditor.pagebooks.palette.PaletteFactoryDispatcher;
import com.arcway.planagent.planeditor.pagebooks.palette.PalettePageBookViewDescriptor;
import de.plans.lib.eclipse.PlugInClassExtensionFactoryException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IWorkbenchPart;

public class PaletteMgr
extends AbstractPageBookMgr {
    private static final ILogger logger = Logger.getLogger(PaletteMgr.class);
    Palette palette = null;

    public PaletteMgr(IWorkbenchPart facade) {
        super(facade, PalettePageBookViewDescriptor.INSTANCE);
    }

    public void installPalette(String planTypeID, int mode) {
        if (logger.isDebugEnabled(70)) {
            logger.debug(70, ".. [PALETTE_MGR] Installing palette for plan type " + planTypeID + " in mode " + mode);
        }
        try {
            this.palette = PaletteFactoryDispatcher.getInstance().create(planTypeID);
        }
        catch (EXPaletteFactoryException e) {
            this.palette = null;
            logger.error("Could not create palette.", (Throwable)e);
        }
        catch (CoreException e) {
            this.palette = null;
            logger.error("Could not create palette.", (Throwable)e);
        }
        catch (PlugInClassExtensionFactoryException e) {
            this.palette = null;
            logger.error("Could not create palette.", (Throwable)e);
        }
        this.updatePalette(mode);
        if (logger.isDebugEnabled(70)) {
            logger.debug(70, ".. [PALETTE_MGR] ... installation finished.");
        }
    }

    public void changeMode(int mode) {
        if (logger.isDebugEnabled(70)) {
            logger.debug(70, ".. [PALETTE_MGR] Switch into mode " + mode);
        }
        this.updatePalette(mode);
        if (logger.isDebugEnabled(70)) {
            logger.debug(70, ".. [PALETTE_MGR] ... mode switch finished.");
        }
    }

    public void removePalette() {
        if (logger.isDebugEnabled(70)) {
            logger.debug(70, ".. [PALETTE_MGR] Removing Palette ...");
        }
        this.setContentProvider(null);
        this.closeViewIfNotNeededAnymore();
        this.palette.dispose();
        this.palette = null;
        if (logger.isDebugEnabled(70)) {
            logger.debug(70, ".. [PALETTE_MGR] ... removing Palette finished.");
        }
    }

    private void updatePalette(int mode) {
        if (mode == 1) {
            if (logger.isDebugEnabled(70)) {
                logger.debug(70, ".. [PALETTE_MGR] Show palette!");
            }
            this.setContentProvider(this.palette);
            this.openView();
        } else {
            if (logger.isDebugEnabled(70)) {
                logger.debug(70, ".. [PALETTE_MGR] Hide palette!");
            }
            this.setContentProvider(null);
            this.closeViewIfNotNeededAnymore();
        }
    }
}

