/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.commands;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.snap.ISnappablePoint;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planeditor.Messages;
import com.arcway.planagent.planeditor.commands.ICommandContext;
import com.arcway.planagent.planeditor.commands.SnappablePoint;
import com.arcway.planagent.planeditor.commands.TransactionCommand;
import com.arcway.planagent.planmodel.access.readonly.IPMLineRO;
import com.arcway.planagent.planmodel.transactions.TAMoveLine;
import com.arcway.planagent.planmodel.transactions.Transaction;
import java.util.Collection;

public class CMMoveLine
extends TransactionCommand {
    private static final ILogger logger = Logger.getLogger(CMMoveLine.class);
    private static final String COMMAND_LABEL = Messages.getString("CMMoveLine.Move_Line");

    public CMMoveLine(GeoVector transl, IPMLineRO line, ICommandContext commandContext) {
        super(commandContext);
        GeoVector translation = transl;
        if (logger.isTraceEnabled()) {
            logger.trace("CMMoveLine(GeoVector translation = " + translation + ", IPMLineRO line = " + line + ") - start");
        }
        assert (translation != null) : "translation is null";
        assert (line != null) : "line is null";
        Collection<? extends ISnappablePoint> points = SnappablePoint.gatherPoints(line);
        translation = commandContext.getGrid().snapPointTranslation(points, translation);
        TAMoveLine transaction = new TAMoveLine(line, this.getActionParameters(), translation);
        this.construct(COMMAND_LABEL, (Transaction)transaction);
        if (logger.isTraceEnabled()) {
            logger.trace("CMMoveLine(GeoVector, IPMLineRO) - end");
        }
    }
}

