/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.actions;

import com.arcway.planagent.planeditor.actions.AppearanceUtil;
import com.arcway.planagent.planeditor.actions.EditorActionProvider;
import com.arcway.planagent.planeditor.actions.IAppearanceButtonDecoration;
import java.util.ArrayList;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;

public abstract class MenuContributionItem
extends CompoundContributionItem {
    private IWorkbenchPage workbenchPage;
    private EditorActionProvider actionProvider;

    public MenuContributionItem() {
    }

    public MenuContributionItem(String id) {
        super(id);
    }

    public MenuContributionItem(IWorkbenchPage workbenchPage) {
        if (workbenchPage != null) {
            this.workbenchPage = workbenchPage;
            this.actionProvider = new EditorActionProvider(workbenchPage.getWorkbenchWindow(), this.getButtonType());
        }
    }

    protected abstract IAppearanceButtonDecoration getButtonType();

    protected EditorActionProvider getActionProvider() {
        IWorkbenchWindow window;
        IWorkbench workbench;
        if (this.actionProvider == null && (workbench = PlatformUI.getWorkbench()) != null && (window = workbench.getActiveWorkbenchWindow()) != null) {
            this.actionProvider = new EditorActionProvider(window, this.getButtonType());
        }
        return this.actionProvider;
    }

    protected IWorkbenchPage getWorkbenchPage() {
        IWorkbenchWindow window;
        IWorkbench workbench;
        if (this.workbenchPage == null && (workbench = PlatformUI.getWorkbench()) != null && (window = workbench.getActiveWorkbenchWindow()) != null) {
            this.workbenchPage = window.getActivePage();
        }
        return this.workbenchPage;
    }

    protected AppearanceUtil.SelectionInfoProvider getCurrentSelectionInfoOrNull() {
        EditorActionProvider actionProv = this.getActionProvider();
        AppearanceUtil.SelectionInfoProvider selectionInfo = actionProv != null ? actionProv.getCurrentSelectionInfo() : null;
        return selectionInfo;
    }

    protected boolean isActionEnabled(AppearanceUtil.SelectionInfoProvider selectionInfo, Object state) {
        boolean enabled = false;
        if (selectionInfo != null) {
            enabled = this.getActionProvider().testEnabled(selectionInfo, state);
        }
        return enabled;
    }

    protected ArrayList<Object> getSelectedStates(AppearanceUtil.SelectionInfoProvider selectionInfo) {
        ArrayList<Object> selectedStates = new ArrayList<Object>();
        if (selectionInfo != null) {
            selectedStates.addAll(selectionInfo.getSelectedStates());
        }
        return selectedStates;
    }
}

