/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor;

import com.arcway.lib.eclipse.transfer.AbstractTransferAgentForMultipleObjectTransfer;
import com.arcway.lib.eclipse.transfer.MultipleObjectTransferContent;
import com.arcway.planagent.controllinginterface.planagent.IPlanAgentPlanElement;
import com.arcway.planagent.controllinginterface.planagent.NameAndDescriptionAndCommentAndAspectID;
import com.arcway.planagent.controllinginterface.planeditor.plugin.ITransferableTemplateProvider;
import com.arcway.planagent.controllinginterface.planeditor.plugin.TransferableTemplate;
import com.arcway.planagent.planeditor.dnd.PlanTemplateTransfer;
import com.arcway.planagent.planmodel.PlanModelDirectAccessTool;
import com.arcway.planagent.planmodel.PlanModelExtensionMgr;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanRO;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import com.arcway.planagent.planmodel.transactions.TASetPlanElementNamesAndDescriptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class PlanEditorTemplateProvider
implements ITransferableTemplateProvider {
    public Collection<TransferableTemplate> getTransferableTemplates(String planElementTypeID, String planElementName, String planElementUID) {
        assert (planElementTypeID != null);
        ArrayList<TransferableTemplate> transferableTemplates = new ArrayList<TransferableTemplate>();
        Collection iPMPlanROTemplates = PlanModelExtensionMgr.getDefault().getTemplates(planElementTypeID);
        for (IPMPlanRO template : iPMPlanROTemplates) {
            TASetPlanElementNamesAndDescriptions setNameTransaction;
            if (template.getPlanElementCount() != 1) continue;
            final IPMPlanElementRO pmPlanElement = template.getPlanElementRO(0);
            assert (planElementTypeID.equals(pmPlanElement.getType())) : "created plan element is not of type " + planElementTypeID;
            if (planElementUID != null) {
                PlanModelDirectAccessTool.setPlanElementUID((IPMPlanElementRO)pmPlanElement, (String)planElementUID);
            }
            if (planElementName != null && (setNameTransaction = new TASetPlanElementNamesAndDescriptions(Collections.singletonMap(pmPlanElement, new NameAndDescriptionAndCommentAndAspectID(planElementName, null, null, null)), ActionParameters.DUMMY)).isValid()) {
                setNameTransaction.dodo();
            }
            IPlanAgentPlanElement iPlanElement = new IPlanAgentPlanElement(){

                public String getPlanElementUID() {
                    return pmPlanElement.getUid();
                }

                public String getPlanElementTypeID() {
                    return pmPlanElement.getType();
                }

                public String getPlanElementName() {
                    return pmPlanElement.getName();
                }

                public String getPlanElementDescription() {
                    return pmPlanElement.getDescription();
                }

                public String getPlanElementAspectID() {
                    return pmPlanElement.getAspectID();
                }
            };
            PlanTemplateTransfer transferAgent = PlanTemplateTransfer.getInstance();
            MultipleObjectTransferContent content = new MultipleObjectTransferContent((Object)template, (AbstractTransferAgentForMultipleObjectTransfer)transferAgent);
            TransferableTemplate transferableTemplate = new TransferableTemplate(content, iPlanElement);
            transferableTemplates.add(transferableTemplate);
        }
        return transferableTemplates;
    }
}

