/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.fmc.bd.actions;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.controllinginterface.planeditor.plugin.ContextMenuContext;
import com.arcway.planagent.controllinginterface.planeditor.plugin.IContextMenuActionProvider;
import com.arcway.planagent.planeditor.actions.AbstractUIAction;
import com.arcway.planagent.planeditor.fmc.bd.actions.UICreateRequestSymbol;
import com.arcway.planagent.planeditor.fmc.bd.actions.UIDeleteRequestSymbol;
import com.arcway.planagent.planeditor.fmc.bd.actions.UIFlipStorageAccess;
import com.arcway.planagent.planeditor.fmc.bd.actions.UIMakeDuplexStorageAccess;
import com.arcway.planagent.planeditor.fmc.bd.actions.UIMakeSimplexStorageAccess;
import com.arcway.planagent.planeditor.fmc.bd.actions.UITurnRequestSymbol;
import java.util.ArrayList;
import java.util.List;

public class ContextMenuActionProvider
implements IContextMenuActionProvider {
    private static final ILogger logger = Logger.getLogger(ContextMenuActionProvider.class);

    public List<AbstractUIAction> getActions(ContextMenuContext context) {
        return this.createActions(context);
    }

    private List<AbstractUIAction> createActions(ContextMenuContext context) {
        UIFlipStorageAccess flipStorageAccess;
        UIMakeDuplexStorageAccess makeDuplexStorageAccess;
        UIMakeSimplexStorageAccess makeSimplexStorageAccess;
        UITurnRequestSymbol flipRequestSymbol;
        UIDeleteRequestSymbol deleteRequestSymbol;
        if (logger.isTraceEnabled()) {
            logger.trace("createActions(ContextMenuContext context = " + context + ") - start");
        }
        ArrayList<AbstractUIAction> actions = new ArrayList<AbstractUIAction>();
        UICreateRequestSymbol createRequestSymbol = new UICreateRequestSymbol(context);
        if (createRequestSymbol.interested(context)) {
            actions.add((AbstractUIAction)createRequestSymbol);
        }
        if ((deleteRequestSymbol = new UIDeleteRequestSymbol(context)).interested(context)) {
            actions.add((AbstractUIAction)deleteRequestSymbol);
        }
        if ((flipRequestSymbol = new UITurnRequestSymbol(context)).interested(context)) {
            actions.add((AbstractUIAction)flipRequestSymbol);
        }
        if ((makeSimplexStorageAccess = new UIMakeSimplexStorageAccess(context)).interested(context)) {
            actions.add((AbstractUIAction)makeSimplexStorageAccess);
        }
        if ((makeDuplexStorageAccess = new UIMakeDuplexStorageAccess(context)).interested(context)) {
            actions.add((AbstractUIAction)makeDuplexStorageAccess);
        }
        if ((flipStorageAccess = new UIFlipStorageAccess(context)).interested(context)) {
            actions.add((AbstractUIAction)flipStorageAccess);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("createActions(ContextMenuContext) - end - return value = " + actions);
        }
        return actions;
    }
}

