/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.cm.actions;

import com.arcway.planagent.planeditor.actions.IAppearanceButtonDecorationWithMenu;
import com.arcway.planagent.planmodel.appearance.IAppearanceRO;
import com.arcway.planagent.planmodel.appearance.IAppearanceTpl;
import com.arcway.planagent.planmodel.appearance.ITextAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ITextStyleAppearanceTpl;
import com.arcway.planagent.planmodel.appearance.TextAppearanceTpl;
import com.arcway.planagent.planmodel.appearance.TextStyleAppearanceTpl;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class TextFontDecoration
implements IAppearanceButtonDecorationWithMenu {
    private static final String DEMOSTRING = "Abc";
    private static TextFontDecoration singelton;
    private static Map<String, ImageDescriptor> fontImageCache;
    private static Map<String, ImageDescriptor> restrainedFontImageCache;

    static {
        fontImageCache = new HashMap<String, ImageDescriptor>();
        restrainedFontImageCache = new HashMap<String, ImageDescriptor>();
    }

    private TextFontDecoration() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TextFontDecoration getInstance() {
        if (singelton != null) return singelton;
        Class<TextFontDecoration> clazz = TextFontDecoration.class;
        synchronized (TextFontDecoration.class) {
            if (singelton != null) return singelton;
            singelton = new TextFontDecoration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singelton;
        }
    }

    public Class[] getAppearanceClasses() {
        return new Class[]{ITextAppearanceRO.class};
    }

    public Object getStateOfAppearance(IAppearanceRO appearance) {
        return ((ITextAppearanceRO)appearance).getTextStyle().getFontName();
    }

    public String getToolTipText(Object state) {
        return (String)state;
    }

    private ImageDescriptor getFontImage(String fontName, boolean allowFontExtent, Map<String, ImageDescriptor> cache) {
        if (!cache.containsKey(fontName)) {
            GC g;
            Font font = new Font((Device)Display.getCurrent(), fontName, 10, 0);
            int w = 16;
            int h = 16;
            if (allowFontExtent) {
                Image dummy = new Image((Device)Display.getCurrent(), 50, 50);
                g = new GC((Drawable)dummy);
                g.setFont(font);
                Point size = g.textExtent(DEMOSTRING);
                g.dispose();
                dummy.dispose();
                w = size.x + 4;
                h = size.y + 2;
            }
            Image image = new Image((Device)Display.getCurrent(), w, h);
            g = new GC((Drawable)image);
            Color c = new Color(null, 0, 8, 8);
            g.setForeground(c);
            g.setBackground(c);
            g.fillRectangle(0, 0, w, h);
            c.dispose();
            int transparentPixel = image.getImageData().getPixel(0, 0);
            Color black = new Color((Device)Display.getCurrent(), 0, 0, 0);
            g.setFont(font);
            g.setForeground(black);
            g.drawText(DEMOSTRING, 0, 0);
            black.dispose();
            font.dispose();
            g.dispose();
            final ImageData imageData = image.getImageData();
            imageData.transparentPixel = transparentPixel;
            image.dispose();
            ImageDescriptor desc = new ImageDescriptor(){

                public ImageData getImageData() {
                    return imageData;
                }
            };
            cache.put(fontName, desc);
        }
        return cache.get(fontName);
    }

    public ImageDescriptor getButtonImageDescriptor(Object state) {
        return this.getFontImage((String)state, false, restrainedFontImageCache);
    }

    public ImageDescriptor getMenuEntryImage(Object state) {
        return this.getFontImage((String)state, true, fontImageCache);
    }

    public String getMenuEntryText(Object state) {
        return (String)state;
    }

    public IAppearanceTpl[] getAppearanceTemplates(Object state) {
        TextAppearanceTpl template = new TextAppearanceTpl();
        TextStyleAppearanceTpl subTpl = new TextStyleAppearanceTpl();
        subTpl.setFont((String)state);
        template.setTextStyleTpl((ITextStyleAppearanceTpl)subTpl);
        return new IAppearanceTpl[]{template};
    }
}

