/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.controllinginterface.lib.projections;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.graphics.Alignment;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.text.TextStyle;
import com.arcway.planagent.controllinginterface.lib.projections.AbstractProjection;

public class TextArrayProjection
extends AbstractProjection {
    public static final int MODE_WIDTH_IS_EXACT_WITDH = 1;
    public static final int MODE_WIDTH_IS_MINIMUM_WITDH = 2;
    public static final int MODE_WIDTH_IS_MAXMIMUM_WITDH = 3;
    private final String[] texts;
    private final Color textColors;
    private final double textArrayWidthHint;
    private final int textArrayWidthMode;
    private final TextStyle textStyle;
    private final double textHeight;
    private final Alignment alignment;
    private final double textArrayWidth;
    private final double textArrayEntryHeight;

    public TextArrayProjection(String[] texts, Color textColors, double textArrayWidthHint, int textArrayWidthMode, TextStyle textStyle, double textHeight, Alignment alignment) {
        this.texts = texts;
        this.textArrayWidthHint = textArrayWidthHint;
        this.textArrayWidthMode = textArrayWidthMode;
        this.textColors = textColors;
        this.textStyle = textStyle;
        this.textHeight = textHeight;
        this.alignment = alignment;
        AbstractProjection.VirtualDevice virtualDevice = new AbstractProjection.VirtualDevice();
        double longestText = 0.0;
        double textLength = 0.0;
        String[] stringArray = texts;
        int n = texts.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            textLength = virtualDevice.getTextLength(element, this.getTextStyle(), this.getTextHeight());
            longestText = Math.max(textLength, longestText);
            ++n2;
        }
        if (textArrayWidthMode == 1) {
            this.textArrayWidth = this.getTextArrayWidthHint();
        } else if (textArrayWidthMode == 3) {
            this.textArrayWidth = Math.min(longestText, this.getTextArrayWidthHint());
        } else if (textArrayWidthMode == 2) {
            this.textArrayWidth = Math.max(longestText, this.getTextArrayWidthHint());
        } else {
            throw new IllegalArgumentException();
        }
        this.textArrayEntryHeight = virtualDevice.getTextLineHeight(this.getTextStyle(), this.getTextHeight());
        virtualDevice.dispose();
    }

    @Override
    public String getProjectionTypeID() {
        return "textArray";
    }

    public String[] getTexts() {
        return this.texts;
    }

    public Color getTextColors() {
        return this.textColors;
    }

    public double getTextArrayWidthHint() {
        return this.textArrayWidthHint;
    }

    public int getTextArrayWidthMode() {
        return this.textArrayWidthMode;
    }

    public double getTextHeight() {
        return this.textHeight;
    }

    public TextStyle getTextStyle() {
        return this.textStyle;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    @Override
    protected Point getPositionInPixels(Rectangle area) {
        return area.upperLeft;
    }

    @Override
    protected void drawProjectionInPixels(Device device) {
        Rectangle rectangle = new Rectangle(0.0, 0.0, this.textArrayWidth, this.textArrayEntryHeight);
        GeoVector distanceToNextLine = new GeoVector(0.0, this.textArrayEntryHeight);
        String[] stringArray = this.texts;
        int n = this.texts.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            device.text(rectangle, this.getAlignment(), element, this.getTextStyle(), this.getTextHeight(), this.getTextColors(), false);
            rectangle = rectangle.move(distanceToNextLine);
            ++n2;
        }
    }
}

