/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.controllinginterface.lib.projections;

import com.arcway.lib.geometry.Corner;
import com.arcway.lib.geometry.Corners;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.Transformation;
import com.arcway.lib.geometry.TransformationAffiliate;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.FillColor;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.device.IDeviceRunnable;
import com.arcway.lib.graphics.fillstyles.FillStyle;
import com.arcway.lib.graphics.linestyles.LineStyle;
import com.arcway.planagent.controllinginterface.planviewer.IProjection;

public class BubbleContainerProjection
implements IProjection {
    private static final double CONVERSION_FACTOR_X = 0.35277777777777775;
    private static final double CONVERSION_FACTOR_Y = 0.35277777777777775;
    private final IProjection[] projections;
    private double width;
    private double height;
    private GeoVector[] offsets;
    private final double spacing = 1.411111111111111;
    private final double r = 2.822222222222222;
    private final double noseH = 5.291666666666666;
    private final double noseX = 5.291666666666666;
    private final double noseW = 1.7638888888888888;
    private final double noseShift = 1.7638888888888888;

    public BubbleContainerProjection(IProjection projection) {
        this(new IProjection[]{projection});
    }

    public BubbleContainerProjection(IProjection[] projections) {
        assert (projections != null);
        this.projections = projections;
        this.update();
    }

    @Override
    public String getProjectionTypeID() {
        return "bubbleContainer";
    }

    public IProjection[] getProjections() {
        return this.projections;
    }

    private void update() {
        this.updateSize();
        this.updateOffset();
    }

    private void updateSize() {
        this.width = 13.052777777777777;
        this.height = 6.7027777777777775;
        IProjection[] iProjectionArray = this.projections;
        int n = this.projections.length;
        int n2 = 0;
        while (n2 < n) {
            IProjection projection = iProjectionArray[n2];
            Rectangle projectionBoundary = projection.getBoundary();
            this.width = Math.max(this.width, projectionBoundary.w() + 2.822222222222222);
            this.height += projectionBoundary.h() + 1.411111111111111;
            ++n2;
        }
    }

    private void updateOffset() {
        this.offsets = new GeoVector[this.projections.length];
        double offsetY = 1.411111111111111 - this.height;
        int i = 0;
        while (i < this.projections.length) {
            IProjection projection = this.projections[i];
            Rectangle projectionBoundary = projection.getBoundary();
            this.offsets[i] = new GeoVector(-projectionBoundary.x() + 1.411111111111111 - 5.291666666666666, -projectionBoundary.y() + offsetY);
            offsetY += projectionBoundary.h() + 1.411111111111111;
            ++i;
        }
    }

    @Override
    public Point getPosition(Rectangle area) {
        return new Point(area.lowerRight.x - 1.5, area.upperLeft.y + 1.5);
    }

    @Override
    public Rectangle getBoundary() {
        return new Rectangle(-6.291666666666666, -this.height - 1.0, -5.291666666666666 + this.width + 1.0, 1.0);
    }

    @Override
    public void drawProjection(final Device device) {
        Corners bubble = new Corners();
        bubble.add((Point)new Corner(-5.291666666666666, -this.height, 2.822222222222222));
        bubble.add((Point)new Corner(this.width - 5.291666666666666, -this.height, 2.822222222222222));
        bubble.add((Point)new Corner(this.width - 5.291666666666666, -5.291666666666666, 2.822222222222222));
        bubble.add((Point)new Corner(3.5277777777777777, -5.291666666666666, 0.0));
        bubble.add((Point)new Corner(0.0, 0.0, 0.0));
        bubble.add((Point)new Corner(1.7638888888888888, -5.291666666666666, 0.0));
        bubble.add((Point)new Corner(-5.291666666666666, -5.291666666666666, 2.822222222222222));
        double lineThickness = 0.35277777777777775;
        Color lineColor = new Color(0, 0, 0);
        LineStyle lineStyle = LineStyle.SOLID;
        FillStyle fillStyle = FillStyle.SOLID;
        FillColor fillColor = new FillColor(255, 255, 153);
        device.polygon(bubble, fillColor, fillStyle, lineThickness, lineColor, lineStyle);
        int i = 0;
        while (i < this.projections.length) {
            final IProjection projection = this.projections[i];
            device.subElement(null, null, null, (Transformation)TransformationAffiliate.newTransformationTranslation((GeoVector)this.offsets[i]), (IDeviceRunnable)new IDeviceRunnable<RuntimeException>(){

                public void run() {
                    projection.drawProjection(device);
                }
            });
            ++i;
        }
    }
}

