/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.java.collections;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.IIteratorRW_;
import com.arcway.lib.java.collections.IIterator_;
import com.arcway.lib.java.collections.IListIterator_;
import com.arcway.lib.java.collections.IListRW_;
import com.arcway.lib.java.collections.IList_;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public final class JList_<T>
implements List<T> {
    private final IList_<T> list;

    public JList_(IList_<T> list) {
        this.list = list;
    }

    private IList_<T> getList() {
        return this.list;
    }

    private IListRW_<T> getListRW() {
        if (!(this.list instanceof IListRW_)) {
            Assert.unsupportedOperation();
        }
        return (IListRW_)this.list;
    }

    @Override
    public boolean add(T o) {
        this.getListRW().add(o);
        return true;
    }

    @Override
    public void add(int index, T element) {
        this.getListRW().add(element, index);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        assert (Assert.checkArgumentBeeingNotNull(c));
        for (T element : c) {
            this.getListRW().add(element);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        assert (Assert.checkArgumentBeeingNotNull(c));
        int i = index;
        for (T element : c) {
            this.getListRW().add(element, i++);
        }
        return true;
    }

    @Override
    public void clear() {
        this.getListRW().clear();
    }

    @Override
    public boolean contains(Object o) {
        boolean contains = false;
        for (Object element : this.getList()) {
            contains |= o.equals(element);
        }
        return contains;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        boolean contains = true;
        for (Object o : c) {
            contains &= this.contains(o);
        }
        return contains;
    }

    @Override
    public T get(int index) {
        return this.getList().get(index);
    }

    @Override
    public int indexOf(Object o) {
        int i = 0;
        for (Object element : this.getList()) {
            if (o.equals(element)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.getList().isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return new JIterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        int i = 0;
        int last = -1;
        for (Object element : this.getList()) {
            if (o.equals(element)) {
                last = i;
            }
            ++i;
        }
        return last;
    }

    @Override
    public ListIterator<T> listIterator() {
        return new JListIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new JListIterator(index);
    }

    @Override
    public boolean remove(Object o) {
        int index = this.indexOf(o);
        if (index == -1) {
            return false;
        }
        this.getListRW().remove(index);
        return true;
    }

    @Override
    public T remove(int index) {
        T element = this.getList().get(index);
        if (element != null) {
            this.getListRW().remove(index);
            return element;
        }
        return null;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object o : c) {
            modified |= this.remove(o);
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        Iterator i = this.getListRW().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (c.contains(o)) continue;
            i.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public T set(int index, T element) {
        T oldElement = this.getList().get(index);
        this.getListRW().set(element, index);
        return oldElement;
    }

    @Override
    public int size() {
        return this.getList().size();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        Assert.unsupportedOperation();
        return null;
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.getList().size()];
        int idx = 0;
        for (Object current : this.getList()) {
            array[idx++] = current;
        }
        return array;
    }

    @Override
    public <X> X[] toArray(X[] a) {
        Object[] array = a;
        int size = this.getList().size();
        if (array.length < size) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), size);
        }
        Iterator<T> it = this.iterator();
        X[] ar = array;
        int i = 0;
        while (i < size) {
            ar[i] = it.next();
            ++i;
        }
        if (array.length > size) {
            i = size;
            while (i < array.length) {
                array[i] = null;
                ++i;
            }
        }
        return array;
    }

    private final class JIterator
    implements Iterator<T> {
        private final IIterator_<T> iIterator;
        private final boolean isIIteratorRW;

        protected JIterator() {
            IList_ iList = JList_.this.getList();
            if (iList instanceof IListRW_) {
                IListRW_ iListRW = (IListRW_)iList;
                this.iIterator = iListRW.iterator();
                this.isIIteratorRW = true;
            } else {
                this.iIterator = iList.iterator();
                this.isIIteratorRW = false;
            }
        }

        @Override
        public boolean hasNext() {
            return this.iIterator.hasNext();
        }

        @Override
        public T next() {
            return this.iIterator.next();
        }

        @Override
        public void remove() {
            if (this.isIIteratorRW) {
                ((IIteratorRW_)this.iIterator).remove();
            } else {
                Assert.unsupportedOperation();
            }
        }
    }

    private final class JListIterator
    implements ListIterator<T> {
        private final IListIterator_<T> iListIterator;
        private int direction;
        private T lastReturned;

        public JListIterator() {
            this.iListIterator = JList_.this.getList().iterator();
            this.direction = 1;
            this.lastReturned = null;
        }

        public JListIterator(int currentIndex) {
            this.iListIterator = JList_.this.getList().iterator();
            assert (Assert.checkArgument(currentIndex >= 0));
            assert (Assert.checkArgument(currentIndex <= JList_.this.size()));
            int n = currentIndex;
            while (n > 0) {
                this.iListIterator.next();
                --n;
            }
            this.direction = 1;
            this.lastReturned = null;
        }

        @Override
        public int nextIndex() {
            if (this.direction == -1) {
                return this.iListIterator.index();
            }
            return this.iListIterator.index() + 1;
        }

        @Override
        public int previousIndex() {
            if (this.direction == 1) {
                return this.iListIterator.index();
            }
            return this.iListIterator.index() - 1;
        }

        @Override
        public boolean hasNext() {
            if (this.direction == -1) {
                return true;
            }
            return this.iListIterator.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            if (this.direction == 1) {
                return true;
            }
            return this.iListIterator.hasPrev();
        }

        @Override
        public T next() {
            if (this.direction == -1) {
                if (this.lastReturned != null) {
                    this.direction = 1;
                    return this.lastReturned;
                }
                throw new NoSuchElementException();
            }
            this.lastReturned = this.iListIterator.next();
            return this.lastReturned;
        }

        @Override
        public T previous() {
            if (this.direction == 1) {
                if (this.lastReturned != null) {
                    this.direction = -1;
                    return this.lastReturned;
                }
                throw new NoSuchElementException();
            }
            this.lastReturned = this.iListIterator.prev();
            return this.lastReturned;
        }

        @Override
        public void remove() {
            Assert.unsupportedOperation();
        }

        @Override
        public void add(Object arg0) {
            Assert.unsupportedOperation();
        }

        @Override
        public void set(Object arg0) {
            Assert.unsupportedOperation();
        }
    }
}

