/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.io;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class RelativeFilePath {
    private final List<String> names;

    public RelativeFilePath(List<String> names) {
        this(names, true);
    }

    public RelativeFilePath(String ... names) {
        this(Arrays.asList(names), false);
    }

    private RelativeFilePath(List<String> names, boolean copyNamesToEnsureImmutability) {
        assert (names != null);
        List<String> privateListOfNames = copyNamesToEnsureImmutability ? new ArrayList<String>(names) : names;
        this.names = Collections.unmodifiableList(privateListOfNames);
    }

    public File constructFile(File baseDir) {
        File intermediateResult = baseDir;
        for (String name : this.names) {
            intermediateResult = new File(intermediateResult, name);
        }
        return intermediateResult;
    }

    public List<String> getNames() {
        return this.names;
    }

    public int hashCode() {
        return this.names.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RelativeFilePath other = (RelativeFilePath)obj;
        return this.names.equals(other.names);
    }
}

