/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref.sax2dtm;

import java.util.Vector;
import javax.xml.transform.Source;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.dtm.DTMWSFilter;
import org.apache.xml.dtm.ref.ExtendedType;
import org.apache.xml.dtm.ref.sax2dtm.SAX2DTM;
import org.apache.xml.serializer.SerializationHandler;
import org.apache.xml.utils.FastStringBuffer;
import org.apache.xml.utils.SuballocatedIntVector;
import org.apache.xml.utils.XMLString;
import org.apache.xml.utils.XMLStringDefault;
import org.apache.xml.utils.XMLStringFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SAX2DTM2
extends SAX2DTM {
    private int[] m_exptype_map0;
    private int[] m_nextsib_map0;
    private int[] m_firstch_map0;
    private int[] m_parent_map0;
    private int[][] m_exptype_map;
    private int[][] m_nextsib_map;
    private int[][] m_firstch_map;
    private int[][] m_parent_map;
    protected ExtendedType[] m_extendedTypes;
    protected Vector m_values;
    private int m_valueIndex = 0;
    private int m_maxNodeIndex;
    protected int m_SHIFT;
    protected int m_MASK;
    protected int m_blocksize;
    protected static final int TEXT_LENGTH_BITS = 10;
    protected static final int TEXT_OFFSET_BITS = 21;
    protected static final int TEXT_LENGTH_MAX = 1023;
    protected static final int TEXT_OFFSET_MAX = 0x1FFFFF;
    protected boolean m_buildIdIndex = true;
    private static final String EMPTY_STR = "";
    private static final XMLString EMPTY_XML_STR = new XMLStringDefault("");

    public SAX2DTM2(DTMManager mgr, Source source, int dtmIdentity, DTMWSFilter whiteSpaceFilter, XMLStringFactory xstringfactory, boolean doIndexing) {
        this(mgr, source, dtmIdentity, whiteSpaceFilter, xstringfactory, doIndexing, 512, true, true, false);
    }

    public SAX2DTM2(DTMManager mgr, Source source, int dtmIdentity, DTMWSFilter whiteSpaceFilter, XMLStringFactory xstringfactory, boolean doIndexing, int blocksize, boolean usePrevsib, boolean buildIdIndex, boolean newNameTable) {
        super(mgr, source, dtmIdentity, whiteSpaceFilter, xstringfactory, doIndexing, blocksize, usePrevsib, newNameTable);
        int shift = 0;
        while ((blocksize >>>= 1) != 0) {
            ++shift;
        }
        this.m_blocksize = 1 << shift;
        this.m_SHIFT = shift;
        this.m_MASK = this.m_blocksize - 1;
        this.m_buildIdIndex = buildIdIndex;
        this.m_values = new Vector(32, 512);
        this.m_maxNodeIndex = 65536;
        this.m_exptype_map0 = this.m_exptype.getMap0();
        this.m_nextsib_map0 = this.m_nextsib.getMap0();
        this.m_firstch_map0 = this.m_firstch.getMap0();
        this.m_parent_map0 = this.m_parent.getMap0();
    }

    public final int _exptype(int identity) {
        return this.m_exptype.elementAt(identity);
    }

    public final int _exptype2(int identity) {
        if (identity < this.m_blocksize) {
            return this.m_exptype_map0[identity];
        }
        return this.m_exptype_map[identity >>> this.m_SHIFT][identity & this.m_MASK];
    }

    public final int _nextsib2(int identity) {
        if (identity < this.m_blocksize) {
            return this.m_nextsib_map0[identity];
        }
        return this.m_nextsib_map[identity >>> this.m_SHIFT][identity & this.m_MASK];
    }

    public final int _firstch2(int identity) {
        if (identity < this.m_blocksize) {
            return this.m_firstch_map0[identity];
        }
        return this.m_firstch_map[identity >>> this.m_SHIFT][identity & this.m_MASK];
    }

    public final int _parent2(int identity) {
        if (identity < this.m_blocksize) {
            return this.m_parent_map0[identity];
        }
        return this.m_parent_map[identity >>> this.m_SHIFT][identity & this.m_MASK];
    }

    public final int _type2(int identity) {
        int eType = identity < this.m_blocksize ? this.m_exptype_map0[identity] : this.m_exptype_map[identity >>> this.m_SHIFT][identity & this.m_MASK];
        if (-1 != eType) {
            return this.m_extendedTypes[eType].getNodeType();
        }
        return -1;
    }

    public final int getExpandedTypeID2(int nodeHandle) {
        int nodeID = this.makeNodeIdentity(nodeHandle);
        if (nodeID != -1) {
            if (nodeID < this.m_blocksize) {
                return this.m_exptype_map0[nodeID];
            }
            return this.m_exptype_map[nodeID >>> this.m_SHIFT][nodeID & this.m_MASK];
        }
        return -1;
    }

    public final int _exptype2Type(int exptype) {
        if (-1 != exptype) {
            return this.m_extendedTypes[exptype].getNodeType();
        }
        return -1;
    }

    public int getIdForNamespace(String uri) {
        int index = this.m_values.indexOf(uri);
        if (index < 0) {
            this.m_values.addElement(uri);
            return this.m_valueIndex++;
        }
        return index;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String prefix;
        this.charactersFlush();
        int exName = this.m_expandedNameTable.getExpandedTypeID(uri, localName, 1);
        int prefixIndex = qName.length() != localName.length() ? this.m_valuesOrPrefixes.stringToIndex(qName) : 0;
        int elemNode = this.addNode(1, exName, this.m_parents.peek(), this.m_previous, prefixIndex, true);
        if (this.m_indexing) {
            this.indexNode(exName, elemNode);
        }
        this.m_parents.push(elemNode);
        int startDecls = this.m_contextIndexes.peek();
        int nDecls = this.m_prefixMappings.size();
        if (!this.m_pastFirstElement) {
            prefix = "xml";
            String declURL = "http://www.w3.org/XML/1998/namespace";
            exName = this.m_expandedNameTable.getExpandedTypeID(null, prefix, 13);
            this.m_values.addElement(declURL);
            int val = this.m_valueIndex++;
            this.addNode(13, exName, elemNode, -1, val, false);
            this.m_pastFirstElement = true;
        }
        int i = startDecls;
        while (i < nDecls) {
            prefix = (String)this.m_prefixMappings.elementAt(i);
            if (prefix != null) {
                int val;
                String declURL = (String)this.m_prefixMappings.elementAt(i + 1);
                exName = this.m_expandedNameTable.getExpandedTypeID(null, prefix, 13);
                this.m_values.addElement(declURL);
                ++this.m_valueIndex;
                this.addNode(13, exName, elemNode, -1, val, false);
            }
            i += 2;
        }
        int n = attributes.getLength();
        int i2 = 0;
        while (i2 < n) {
            block10: {
                int val;
                int nodeType;
                String attrLocalName;
                String valString;
                String attrQName;
                String attrUri;
                block11: {
                    block9: {
                        attrUri = attributes.getURI(i2);
                        attrQName = attributes.getQName(i2);
                        valString = attributes.getValue(i2);
                        attrLocalName = attributes.getLocalName(i2);
                        if (null == attrQName || !attrQName.equals("xmlns") && !attrQName.startsWith("xmlns:")) break block9;
                        prefix = this.getPrefix(attrQName, attrUri);
                        if (this.declAlreadyDeclared(prefix)) break block10;
                        nodeType = 13;
                        break block11;
                    }
                    nodeType = 2;
                    if (this.m_buildIdIndex && attributes.getType(i2).equalsIgnoreCase("ID")) {
                        this.setIDAttribute(valString, elemNode);
                    }
                }
                if (null == valString) {
                    valString = EMPTY_STR;
                }
                this.m_values.addElement(valString);
                ++this.m_valueIndex;
                if (attrLocalName.length() != attrQName.length()) {
                    prefixIndex = this.m_valuesOrPrefixes.stringToIndex(attrQName);
                    int dataIndex = this.m_data.size();
                    this.m_data.addElement(prefixIndex);
                    this.m_data.addElement(val);
                    val = -dataIndex;
                }
                exName = this.m_expandedNameTable.getExpandedTypeID(attrUri, attrLocalName, nodeType);
                this.addNode(nodeType, exName, elemNode, -1, val, false);
            }
            ++i2;
        }
        if (null != this.m_wsfilter) {
            short wsv = this.m_wsfilter.getShouldStripSpace(this.makeNodeHandle(elemNode), (DTM)this);
            boolean shouldStrip = 3 == wsv ? this.getShouldStripWhitespace() : 2 == wsv;
            this.pushShouldStripWhitespace(shouldStrip);
        }
        this.m_previous = -1;
        this.m_contextIndexes.push(this.m_prefixMappings.size());
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.charactersFlush();
        this.m_contextIndexes.quickPop(1);
        int topContextIndex = this.m_contextIndexes.peek();
        if (topContextIndex != this.m_prefixMappings.size()) {
            this.m_prefixMappings.setSize(topContextIndex);
        }
        this.m_previous = this.m_parents.pop();
        this.popShouldStripWhitespace();
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.m_insideDTD) {
            return;
        }
        this.charactersFlush();
        this.m_values.addElement(new String(ch, start, length));
        int dataIndex = this.m_valueIndex++;
        this.m_previous = this.addNode(8, 8, this.m_parents.peek(), this.m_previous, dataIndex, false);
    }

    public void startDocument() throws SAXException {
        int doc = this.addNode(9, 9, -1, -1, 0, true);
        this.m_parents.push(doc);
        this.m_previous = -1;
        this.m_contextIndexes.push(this.m_prefixMappings.size());
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        this.m_exptype.addElement(-1);
        this.m_parent.addElement(-1);
        this.m_nextsib.addElement(-1);
        this.m_firstch.addElement(-1);
        this.m_extendedTypes = this.m_expandedNameTable.getExtendedTypes();
        this.m_exptype_map = this.m_exptype.getMap();
        this.m_nextsib_map = this.m_nextsib.getMap();
        this.m_firstch_map = this.m_firstch.getMap();
        this.m_parent_map = this.m_parent.getMap();
    }

    protected final int addNode(int type, int expandedTypeID, int parentIndex, int previousSibling, int dataOrPrefix, boolean canHaveFirstChild) {
        int nodeIndex;
        if ((nodeIndex = this.m_size++) == this.m_maxNodeIndex) {
            this.addNewDTMID(nodeIndex);
            this.m_maxNodeIndex += 65536;
        }
        this.m_firstch.addElement(-1);
        this.m_nextsib.addElement(-1);
        this.m_parent.addElement(parentIndex);
        this.m_exptype.addElement(expandedTypeID);
        this.m_dataOrQName.addElement(dataOrPrefix);
        if (this.m_prevsib != null) {
            this.m_prevsib.addElement(previousSibling);
        }
        if (this.m_locator != null && this.m_useSourceLocationProperty) {
            this.setSourceLocation();
        }
        switch (type) {
            case 13: {
                this.declareNamespaceInContext(parentIndex, nodeIndex);
                break;
            }
            case 2: {
                break;
            }
            default: {
                if (-1 != previousSibling) {
                    this.m_nextsib.setElementAt(nodeIndex, previousSibling);
                    break;
                }
                if (-1 == parentIndex) break;
                this.m_firstch.setElementAt(nodeIndex, parentIndex);
            }
        }
        return nodeIndex;
    }

    protected final void charactersFlush() {
        if (this.m_textPendingStart >= 0) {
            int length = this.m_chars.size() - this.m_textPendingStart;
            boolean doStrip = false;
            if (this.getShouldStripWhitespace()) {
                doStrip = this.m_chars.isWhitespace(this.m_textPendingStart, length);
            }
            if (doStrip) {
                this.m_chars.setLength(this.m_textPendingStart);
            } else if (length > 0) {
                if (length <= 1023 && this.m_textPendingStart <= 0x1FFFFF) {
                    this.m_previous = this.addNode(this.m_coalescedTextType, 3, this.m_parents.peek(), this.m_previous, length + (this.m_textPendingStart << 10), false);
                } else {
                    int dataIndex = this.m_data.size();
                    this.m_previous = this.addNode(this.m_coalescedTextType, 3, this.m_parents.peek(), this.m_previous, -dataIndex, false);
                    this.m_data.addElement(this.m_textPendingStart);
                    this.m_data.addElement(length);
                }
            }
            this.m_textPendingStart = -1;
            this.m_coalescedTextType = 3;
            this.m_textType = 3;
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.charactersFlush();
        int dataIndex = this.m_data.size();
        this.m_previous = this.addNode(7, 7, this.m_parents.peek(), this.m_previous, -dataIndex, false);
        this.m_data.addElement(this.m_valuesOrPrefixes.stringToIndex(target));
        this.m_values.addElement(data);
        this.m_data.addElement(this.m_valueIndex++);
    }

    public final int getFirstAttribute(int nodeHandle) {
        block2: {
            int nodeID = this.makeNodeIdentity(nodeHandle);
            if (nodeID == -1) {
                return -1;
            }
            int type = this._type2(nodeID);
            if (1 != type) break block2;
            do {
                if ((type = this._type2(++nodeID)) != 2) continue;
                return this.makeNodeHandle(nodeID);
            } while (13 == type);
        }
        return -1;
    }

    protected int getFirstAttributeIdentity(int identity) {
        block2: {
            if (identity == -1) {
                return -1;
            }
            int type = this._type2(identity);
            if (1 != type) break block2;
            do {
                if ((type = this._type2(++identity)) != 2) continue;
                return identity;
            } while (13 == type);
        }
        return -1;
    }

    protected int getNextAttributeIdentity(int identity) {
        int type;
        do {
            if ((type = this._type2(++identity)) != 2) continue;
            return identity;
        } while (type == 13);
        return -1;
    }

    protected final int getTypedAttribute(int nodeHandle, int attType) {
        block4: {
            int nodeID = this.makeNodeIdentity(nodeHandle);
            if (nodeID == -1) {
                return -1;
            }
            int type = this._type2(nodeID);
            if (1 != type) break block4;
            while (true) {
                int expType;
                if ((expType = this._exptype2(++nodeID)) == -1) {
                    return -1;
                }
                type = this.m_extendedTypes[expType].getNodeType();
                if (type == 2) {
                    if (expType != attType) continue;
                    return this.makeNodeHandle(nodeID);
                }
                if (13 != type) break;
            }
        }
        return -1;
    }

    public String getLocalName(int nodeHandle) {
        int expType = this._exptype(this.makeNodeIdentity(nodeHandle));
        if (expType == 7) {
            int dataIndex = this._dataOrQName(this.makeNodeIdentity(nodeHandle));
            dataIndex = this.m_data.elementAt(-dataIndex);
            return this.m_valuesOrPrefixes.indexToString(dataIndex);
        }
        return this.m_expandedNameTable.getLocalName(expType);
    }

    public final String getNodeNameX(int nodeHandle) {
        int nodeID = this.makeNodeIdentity(nodeHandle);
        int eType = this._exptype2(nodeID);
        if (eType == 7) {
            int dataIndex = this._dataOrQName(nodeID);
            dataIndex = this.m_data.elementAt(-dataIndex);
            return this.m_valuesOrPrefixes.indexToString(dataIndex);
        }
        ExtendedType extType = this.m_extendedTypes[eType];
        if (extType.getNamespace().length() == 0) {
            return extType.getLocalName();
        }
        int qnameIndex = this.m_dataOrQName.elementAt(nodeID);
        if (qnameIndex == 0) {
            return extType.getLocalName();
        }
        if (qnameIndex < 0) {
            qnameIndex = -qnameIndex;
            qnameIndex = this.m_data.elementAt(qnameIndex);
        }
        return this.m_valuesOrPrefixes.indexToString(qnameIndex);
    }

    public String getNodeName(int nodeHandle) {
        int nodeID = this.makeNodeIdentity(nodeHandle);
        int eType = this._exptype2(nodeID);
        ExtendedType extType = this.m_extendedTypes[eType];
        if (extType.getNamespace().length() == 0) {
            int type = extType.getNodeType();
            String localName = extType.getLocalName();
            if (type == 13) {
                if (localName.length() == 0) {
                    return "xmlns";
                }
                return "xmlns:" + localName;
            }
            if (type == 7) {
                int dataIndex = this._dataOrQName(nodeID);
                dataIndex = this.m_data.elementAt(-dataIndex);
                return this.m_valuesOrPrefixes.indexToString(dataIndex);
            }
            if (localName.length() == 0) {
                return this.getFixedNames(type);
            }
            return localName;
        }
        int qnameIndex = this.m_dataOrQName.elementAt(nodeID);
        if (qnameIndex == 0) {
            return extType.getLocalName();
        }
        if (qnameIndex < 0) {
            qnameIndex = -qnameIndex;
            qnameIndex = this.m_data.elementAt(qnameIndex);
        }
        return this.m_valuesOrPrefixes.indexToString(qnameIndex);
    }

    public XMLString getStringValue(int nodeHandle) {
        int identity = this.makeNodeIdentity(nodeHandle);
        if (identity == -1) {
            return EMPTY_XML_STR;
        }
        int type = this._type2(identity);
        if (type == 1 || type == 9) {
            int startNode = identity;
            if (-1 != (identity = this._firstch2(identity))) {
                int offset = -1;
                int length = 0;
                do {
                    if ((type = this._exptype2(identity)) != 3 && type != 4) continue;
                    int dataIndex = this.m_dataOrQName.elementAt(identity);
                    if (dataIndex >= 0) {
                        if (-1 == offset) {
                            offset = dataIndex >>> 10;
                        }
                        length += dataIndex & 0x3FF;
                        continue;
                    }
                    if (-1 == offset) {
                        offset = this.m_data.elementAt(-dataIndex);
                    }
                    length += this.m_data.elementAt(-dataIndex + 1);
                } while (this._parent2(++identity) >= startNode);
                if (length > 0) {
                    if (this.m_xstrf != null) {
                        return this.m_xstrf.newstr(this.m_chars, offset, length);
                    }
                    return new XMLStringDefault(this.m_chars.getString(offset, length));
                }
                return EMPTY_XML_STR;
            }
            return EMPTY_XML_STR;
        }
        if (3 == type || 4 == type) {
            int dataIndex = this.m_dataOrQName.elementAt(identity);
            if (dataIndex >= 0) {
                if (this.m_xstrf != null) {
                    return this.m_xstrf.newstr(this.m_chars, dataIndex >>> 10, dataIndex & 0x3FF);
                }
                return new XMLStringDefault(this.m_chars.getString(dataIndex >>> 10, dataIndex & 0x3FF));
            }
            if (this.m_xstrf != null) {
                return this.m_xstrf.newstr(this.m_chars, this.m_data.elementAt(-dataIndex), this.m_data.elementAt(-dataIndex + 1));
            }
            return new XMLStringDefault(this.m_chars.getString(this.m_data.elementAt(-dataIndex), this.m_data.elementAt(-dataIndex + 1)));
        }
        int dataIndex = this.m_dataOrQName.elementAt(identity);
        if (dataIndex < 0) {
            dataIndex = -dataIndex;
            dataIndex = this.m_data.elementAt(dataIndex + 1);
        }
        if (this.m_xstrf != null) {
            return this.m_xstrf.newstr((String)this.m_values.elementAt(dataIndex));
        }
        return new XMLStringDefault((String)this.m_values.elementAt(dataIndex));
    }

    public final String getStringValueX(int nodeHandle) {
        int identity = this.makeNodeIdentity(nodeHandle);
        if (identity == -1) {
            return EMPTY_STR;
        }
        int type = this._type2(identity);
        if (type == 1 || type == 9) {
            int startNode = identity;
            if (-1 != (identity = this._firstch2(identity))) {
                int offset = -1;
                int length = 0;
                do {
                    if ((type = this._exptype2(identity)) != 3 && type != 4) continue;
                    int dataIndex = this.m_dataOrQName.elementAt(identity);
                    if (dataIndex >= 0) {
                        if (-1 == offset) {
                            offset = dataIndex >>> 10;
                        }
                        length += dataIndex & 0x3FF;
                        continue;
                    }
                    if (-1 == offset) {
                        offset = this.m_data.elementAt(-dataIndex);
                    }
                    length += this.m_data.elementAt(-dataIndex + 1);
                } while (this._parent2(++identity) >= startNode);
                if (length > 0) {
                    return this.m_chars.getString(offset, length);
                }
                return EMPTY_STR;
            }
            return EMPTY_STR;
        }
        if (3 == type || 4 == type) {
            int dataIndex = this.m_dataOrQName.elementAt(identity);
            if (dataIndex >= 0) {
                return this.m_chars.getString(dataIndex >>> 10, dataIndex & 0x3FF);
            }
            return this.m_chars.getString(this.m_data.elementAt(-dataIndex), this.m_data.elementAt(-dataIndex + 1));
        }
        int dataIndex = this.m_dataOrQName.elementAt(identity);
        if (dataIndex < 0) {
            dataIndex = -dataIndex;
            dataIndex = this.m_data.elementAt(dataIndex + 1);
        }
        return (String)this.m_values.elementAt(dataIndex);
    }

    public String getStringValue() {
        int child = this._firstch2(0);
        if (child == -1) {
            return EMPTY_STR;
        }
        if (this._exptype2(child) == 3 && this._nextsib2(child) == -1) {
            int dataIndex = this.m_dataOrQName.elementAt(child);
            if (dataIndex >= 0) {
                return this.m_chars.getString(dataIndex >>> 10, dataIndex & 0x3FF);
            }
            return this.m_chars.getString(this.m_data.elementAt(-dataIndex), this.m_data.elementAt(-dataIndex + 1));
        }
        return this.getStringValueX(this.getDocument());
    }

    public final void dispatchCharactersEvents(int nodeHandle, ContentHandler ch, boolean normalize) throws SAXException {
        int identity = this.makeNodeIdentity(nodeHandle);
        if (identity == -1) {
            return;
        }
        int type = this._type2(identity);
        if (type == 1 || type == 9) {
            int startNode = identity;
            if (-1 != (identity = this._firstch2(identity))) {
                int offset = -1;
                int length = 0;
                do {
                    if ((type = this._exptype2(identity)) != 3 && type != 4) continue;
                    int dataIndex = this.m_dataOrQName.elementAt(identity);
                    if (dataIndex >= 0) {
                        if (-1 == offset) {
                            offset = dataIndex >>> 10;
                        }
                        length += dataIndex & 0x3FF;
                        continue;
                    }
                    if (-1 == offset) {
                        offset = this.m_data.elementAt(-dataIndex);
                    }
                    length += this.m_data.elementAt(-dataIndex + 1);
                } while (this._parent2(++identity) >= startNode);
                if (length > 0) {
                    if (normalize) {
                        this.m_chars.sendNormalizedSAXcharacters(ch, offset, length);
                    } else {
                        this.m_chars.sendSAXcharacters(ch, offset, length);
                    }
                }
            }
        } else if (3 == type || 4 == type) {
            int dataIndex = this.m_dataOrQName.elementAt(identity);
            if (dataIndex >= 0) {
                if (normalize) {
                    this.m_chars.sendNormalizedSAXcharacters(ch, dataIndex >>> 10, dataIndex & 0x3FF);
                } else {
                    this.m_chars.sendSAXcharacters(ch, dataIndex >>> 10, dataIndex & 0x3FF);
                }
            } else if (normalize) {
                this.m_chars.sendNormalizedSAXcharacters(ch, this.m_data.elementAt(-dataIndex), this.m_data.elementAt(-dataIndex + 1));
            } else {
                this.m_chars.sendSAXcharacters(ch, this.m_data.elementAt(-dataIndex), this.m_data.elementAt(-dataIndex + 1));
            }
        } else {
            int dataIndex = this.m_dataOrQName.elementAt(identity);
            if (dataIndex < 0) {
                dataIndex = -dataIndex;
                dataIndex = this.m_data.elementAt(dataIndex + 1);
            }
            String str = (String)this.m_values.elementAt(dataIndex);
            if (normalize) {
                FastStringBuffer.sendNormalizedSAXcharacters((char[])str.toCharArray(), (int)0, (int)str.length(), (ContentHandler)ch);
            } else {
                ch.characters(str.toCharArray(), 0, str.length());
            }
        }
    }

    public String getNodeValue(int nodeHandle) {
        int identity = this.makeNodeIdentity(nodeHandle);
        int type = this._type2(identity);
        if (type == 3 || type == 4) {
            int dataIndex = this._dataOrQName(identity);
            if (dataIndex > 0) {
                return this.m_chars.getString(dataIndex >>> 10, dataIndex & 0x3FF);
            }
            return this.m_chars.getString(this.m_data.elementAt(-dataIndex), this.m_data.elementAt(-dataIndex + 1));
        }
        if (1 == type || 11 == type || 9 == type) {
            return null;
        }
        int dataIndex = this.m_dataOrQName.elementAt(identity);
        if (dataIndex < 0) {
            dataIndex = -dataIndex;
            dataIndex = this.m_data.elementAt(dataIndex + 1);
        }
        return (String)this.m_values.elementAt(dataIndex);
    }

    protected final void copyTextNode(int nodeID, SerializationHandler handler) throws SAXException {
        if (nodeID != -1) {
            int dataIndex = this.m_dataOrQName.elementAt(nodeID);
            if (dataIndex >= 0) {
                this.m_chars.sendSAXcharacters((ContentHandler)handler, dataIndex >>> 10, dataIndex & 0x3FF);
            } else {
                this.m_chars.sendSAXcharacters((ContentHandler)handler, this.m_data.elementAt(-dataIndex), this.m_data.elementAt(-dataIndex + 1));
            }
        }
    }

    protected final String copyElement(int nodeID, int exptype, SerializationHandler handler) throws SAXException {
        ExtendedType extType = this.m_extendedTypes[exptype];
        String uri = extType.getNamespace();
        String name = extType.getLocalName();
        if (uri.length() == 0) {
            handler.startElement(name);
            return name;
        }
        int qnameIndex = this.m_dataOrQName.elementAt(nodeID);
        if (qnameIndex == 0) {
            handler.startElement(name);
            handler.namespaceAfterStartElement(EMPTY_STR, uri);
            return name;
        }
        if (qnameIndex < 0) {
            qnameIndex = -qnameIndex;
            qnameIndex = this.m_data.elementAt(qnameIndex);
        }
        String qName = this.m_valuesOrPrefixes.indexToString(qnameIndex);
        handler.startElement(qName);
        int prefixIndex = qName.indexOf(58);
        String prefix = prefixIndex > 0 ? qName.substring(0, prefixIndex) : null;
        handler.namespaceAfterStartElement(prefix, uri);
        return qName;
    }

    protected final void copyNS(int nodeID, SerializationHandler handler, boolean inScope) throws SAXException {
        int nextNSNode;
        if (this.m_namespaceDeclSetElements != null && this.m_namespaceDeclSetElements.size() == 1 && this.m_namespaceDeclSets != null && ((SuballocatedIntVector)this.m_namespaceDeclSets.elementAt(0)).size() == 1) {
            return;
        }
        SuballocatedIntVector nsContext = null;
        if (inScope) {
            nsContext = this.findNamespaceContext(nodeID);
            if (nsContext == null || nsContext.size() < 1) {
                return;
            }
            nextNSNode = this.makeNodeIdentity(nsContext.elementAt(0));
        } else {
            nextNSNode = this.getNextNamespaceNode2(nodeID);
        }
        int nsIndex = 1;
        while (nextNSNode != -1) {
            int eType = this._exptype2(nextNSNode);
            String nodeName = this.m_extendedTypes[eType].getLocalName();
            int dataIndex = this.m_dataOrQName.elementAt(nextNSNode);
            if (dataIndex < 0) {
                dataIndex = -dataIndex;
                dataIndex = this.m_data.elementAt(dataIndex + 1);
            }
            String nodeValue = (String)this.m_values.elementAt(dataIndex);
            handler.namespaceAfterStartElement(nodeName, nodeValue);
            if (inScope) {
                if (nsIndex < nsContext.size()) {
                    nextNSNode = this.makeNodeIdentity(nsContext.elementAt(nsIndex));
                    ++nsIndex;
                    continue;
                }
                return;
            }
            nextNSNode = this.getNextNamespaceNode2(nextNSNode);
        }
    }

    protected final int getNextNamespaceNode2(int baseID) {
        int type;
        while ((type = this._type2(++baseID)) == 2) {
        }
        if (type == 13) {
            return baseID;
        }
        return -1;
    }

    protected final void copyAttributes(int nodeID, SerializationHandler handler) throws SAXException {
        int current = this.getFirstAttributeIdentity(nodeID);
        while (current != -1) {
            int eType = this._exptype2(current);
            this.copyAttribute(current, eType, handler);
            current = this.getNextAttributeIdentity(current);
        }
    }

    protected final void copyAttribute(int nodeID, int exptype, SerializationHandler handler) throws SAXException {
        int dataIndex;
        ExtendedType extType = this.m_extendedTypes[exptype];
        String uri = extType.getNamespace();
        String localName = extType.getLocalName();
        String prefix = null;
        String qname = null;
        int valueIndex = dataIndex = this._dataOrQName(nodeID);
        if (dataIndex <= 0) {
            int prefixIndex = this.m_data.elementAt(-dataIndex);
            valueIndex = this.m_data.elementAt(-dataIndex + 1);
            qname = this.m_valuesOrPrefixes.indexToString(prefixIndex);
            int colonIndex = qname.indexOf(58);
            if (colonIndex > 0) {
                prefix = qname.substring(0, colonIndex);
            }
        }
        if (uri.length() != 0) {
            handler.namespaceAfterStartElement(prefix, uri);
        }
        String nodeName = prefix != null ? qname : localName;
        String nodeValue = (String)this.m_values.elementAt(valueIndex);
        handler.addAttribute(nodeName, nodeValue);
    }
}

