/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.shared.message;

import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.psc.shared.message.AbstractStreamDataBuffer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class StreamDataBuffer
extends AbstractStreamDataBuffer {
    private static final ILogger LOGGER = Logger.getLogger(StreamDataBuffer.class);
    private long mark = -1L;
    private StreamContent streamContent;
    private ContentInitialisationStream contentInitialisationStream;

    public StreamDataBuffer(AbstractStreamDataBuffer.ITempFileManager tempFileManager) {
        super(tempFileManager);
    }

    public void initialise(File contentFile, boolean deleteFileAfterwards) {
        this.streamContent = new ContentFile(contentFile, deleteFileAfterwards);
    }

    public void initialiseEmpty() {
        this.streamContent = new ContentArray(null, 0);
    }

    public OutputStream initialiseGetOutputStreamForStreamContentInitialisation() {
        assert (this.contentInitialisationStream == null);
        assert (this.streamContent == null);
        this.contentInitialisationStream = new ContentInitialisationStream(512);
        return this.contentInitialisationStream;
    }

    @Override
    public synchronized long getTotalStreamLength() {
        if (this.streamContent == null) {
            return -1L;
        }
        return this.streamContent.getTotalStreamLength();
    }

    public synchronized long getMark() {
        return this.mark;
    }

    public synchronized void setMark(long mark) {
        this.mark = mark;
    }

    public long getAvailable(long startIndex, long maxBytes) {
        assert (maxBytes >= 0L);
        long totalStreamLength = this.getTotalStreamLength();
        if (totalStreamLength != -1L) {
            long availableBytesFromStartIndex = totalStreamLength - startIndex;
            if (availableBytesFromStartIndex < 0L) {
                return 0L;
            }
            return Math.min(maxBytes, availableBytesFromStartIndex);
        }
        return 0L;
    }

    public synchronized void copyToStream(OutputStream destinationStream, long startIndex, long length, AbstractStreamDataBuffer.IBufferTransferProgressWatchdog watchdog) throws IOException {
        assert (this.streamContent != null);
        if (length > 0L) {
            int bufferSize = 2048;
            if (length < (long)bufferSize) {
                bufferSize = (int)length;
            }
            ByteBuffer bb = ByteBuffer.allocate(bufferSize);
            assert (bb.hasArray());
            long totalBytesCopied = 0L;
            while (totalBytesCopied < length) {
                long bytesRemaining = length - totalBytesCopied;
                if ((long)bb.capacity() > bytesRemaining) {
                    bb = ByteBuffer.allocate((int)bytesRemaining);
                    assert (bb.hasArray());
                } else {
                    bb.clear();
                }
                int readResult = this.streamContent.read(bb, startIndex + totalBytesCopied);
                bb.flip();
                assert (bb.remaining() == readResult);
                assert (bb.remaining() == bb.capacity());
                destinationStream.write(bb.array(), bb.arrayOffset() + bb.position(), bb.remaining());
                if (watchdog != null) {
                    watchdog.noteTransferActivity(bb.remaining());
                }
                totalBytesCopied += (long)bb.remaining();
            }
        }
    }

    @Override
    public void dispose() {
        if (this.streamContent != null) {
            try {
                this.streamContent.dispose();
            }
            catch (Exception e) {
                LOGGER.error("Problem while disposing stream content.", (Throwable)e);
            }
        }
        if (this.contentInitialisationStream != null) {
            this.contentInitialisationStream.dispose();
        }
        super.dispose();
    }

    public void getStatus(IStatusReceiver statusReceiver) {
        statusReceiver.initialise(this, this.getTotalStreamLength(), this.getMark() + 1L);
    }

    private static class ContentArray
    extends StreamContent {
        private byte[] buf;
        private final int count;

        private ContentArray(byte[] buf, int count) {
            assert (count == 0 || buf != null);
            this.buf = buf;
            this.count = count;
        }

        @Override
        public long getTotalStreamLength() {
            return this.count;
        }

        @Override
        public int do_read(ByteBuffer dst, long position) throws IOException {
            if (position >= (long)this.count) {
                assert (false);
                return -1;
            }
            int maxBytesTillEndOfBuffer = (int)((long)this.count - position);
            assert (maxBytesTillEndOfBuffer > 0);
            int resultBytes = Math.min(dst.remaining(), maxBytesTillEndOfBuffer);
            dst.put(this.buf, (int)position, resultBytes);
            return resultBytes;
        }

        @Override
        public void dispose() {
            this.buf = null;
            super.dispose();
        }
    }

    private static class ContentFile
    extends StreamContent {
        private final File contentFile;
        private final boolean deleteFileAfterwards;
        private final long fileLength;
        private FileChannel randomAccessFilechannel;

        private ContentFile(File contentFile, boolean deleteFileAfterwards) {
            this.contentFile = contentFile;
            this.deleteFileAfterwards = deleteFileAfterwards;
            this.fileLength = contentFile.length();
            this.randomAccessFilechannel = null;
        }

        @Override
        public long getTotalStreamLength() {
            return this.fileLength;
        }

        private FileChannel getRandomAccessFilechannel() throws IOException {
            if (this.randomAccessFilechannel == null) {
                RandomAccessFile randomAccessFile = new RandomAccessFile(this.contentFile, "rw");
                this.randomAccessFilechannel = randomAccessFile.getChannel();
            }
            return this.randomAccessFilechannel;
        }

        @Override
        public int do_read(ByteBuffer dst, long position) throws IOException {
            return this.getRandomAccessFilechannel().read(dst, position);
        }

        @Override
        public void dispose() {
            if (this.randomAccessFilechannel != null) {
                try {
                    this.randomAccessFilechannel.close();
                }
                catch (Exception e) {
                    LOGGER.error("Problem while closing filechannel refering to obsolete tmp file.", (Throwable)e);
                }
            }
            if (this.deleteFileAfterwards) {
                try {
                    FileHelper.deleteExistingFileOrDirectory((File)this.contentFile);
                }
                catch (JvmExternalResourceInteractionException e) {
                    LOGGER.error("Unable to delete obsolete file " + this.contentFile + " when streambuffer was disposed.", (Throwable)e);
                }
            }
            super.dispose();
        }
    }

    public class ContentInitialisationStream
    extends OutputStream {
        private byte[] buf;
        private long count;
        private FileOutputStream fileOutputStream;

        public ContentInitialisationStream(int size) {
            this.buf = new byte[size];
            this.count = 0L;
            this.fileOutputStream = null;
        }

        private void ensureRoom(long minBufSize) throws IOException {
            if (this.fileOutputStream != null) {
                assert (this.buf == null);
            } else {
                assert (this.buf != null);
                assert (this.count <= 10240L);
                assert (this.fileOutputStream == null);
                if (minBufSize > 10240L) {
                    this.fileOutputStream = new FileOutputStream(StreamDataBuffer.this.getTempFile());
                    this.fileOutputStream.write(this.buf, 0, (int)this.count);
                    this.fileOutputStream.flush();
                    assert (StreamDataBuffer.this.getTempFile().length() == this.count);
                    this.buf = null;
                } else if (minBufSize > (long)this.buf.length) {
                    byte[] newbuf = new byte[Math.min(Math.max(this.buf.length << 1, (int)minBufSize), 10240)];
                    System.arraycopy(this.buf, 0, newbuf, 0, (int)this.count);
                    this.buf = newbuf;
                }
            }
        }

        @Override
        public void write(int b) throws IOException {
            long newcount = this.count + 1L;
            this.ensureRoom(newcount);
            if (this.fileOutputStream != null) {
                this.fileOutputStream.write(b);
            } else {
                this.buf[(int)this.count] = (byte)b;
            }
            this.count = newcount;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            long newcount = this.count + (long)len;
            this.ensureRoom(newcount);
            if (this.fileOutputStream != null) {
                this.fileOutputStream.write(b, off, len);
            } else {
                System.arraycopy(b, off, this.buf, (int)this.count, len);
            }
            this.count = newcount;
        }

        @Override
        public void flush() throws IOException {
            if (this.fileOutputStream != null) {
                this.fileOutputStream.flush();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.fileOutputStream != null) {
                this.fileOutputStream.close();
            }
            if (StreamDataBuffer.this.streamContent == null) {
                if (this.fileOutputStream != null) {
                    StreamDataBuffer.this.streamContent = new ContentFile(StreamDataBuffer.this.getTempFile(), false);
                    assert (StreamDataBuffer.this.getTempFile().length() == this.count);
                } else {
                    StreamDataBuffer.this.streamContent = new ContentArray(this.buf, (int)this.count);
                }
                StreamDataBuffer.this.contentInitialisationStream = null;
                this.dispose();
            }
        }

        public void dispose() {
            this.buf = null;
            if (this.fileOutputStream != null) {
                try {
                    this.fileOutputStream.close();
                }
                catch (Exception e) {
                    LOGGER.error("Problem while closing contentInitialisationStream file stream", (Throwable)e);
                }
            }
        }
    }

    public static interface IStatusReceiver {
        public void initialise(StreamDataBuffer var1, long var2, long var4);
    }

    private static abstract class StreamContent {
        private boolean isDisposed = false;

        private StreamContent() {
        }

        public abstract long getTotalStreamLength();

        public final int read(ByteBuffer dst, long position) throws IOException {
            if (this.isDisposed) {
                assert (false);
                throw new IOException("StreamDataBuffer.content is disposed.");
            }
            return this.do_read(dst, position);
        }

        public abstract int do_read(ByteBuffer var1, long var2) throws IOException;

        public void dispose() {
            this.isDisposed = true;
        }
    }
}

