/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.dialogs.admin.swt;

import de.plans.psc.client.dialogs.admin.swt.Messages;
import de.plans.psc.shared.PSCPermissionConstants;
import de.plans.psc.shared.message.EOPermission;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class PermissionListWrapper
implements ILabelProvider,
IStructuredContentProvider {
    private final ListViewer viewer;
    private List permissions = new ArrayList();
    private List derivedPermissions = new ArrayList();

    public PermissionListWrapper(Composite c, int style) {
        this.viewer = new ListViewer(c, style);
        this.viewer.setLabelProvider((IBaseLabelProvider)this);
        this.viewer.setContentProvider((IContentProvider)this);
    }

    public void clear() {
        this.permissions.clear();
        this.derivedPermissions.clear();
        this.updateListView();
    }

    public void setPermissions(List permissions) {
        this.permissions = permissions;
        this.updateListView();
    }

    public void addPermissions(List newPermissions) {
        int i = newPermissions.size() - 1;
        while (i > -1) {
            EOPermission newPermission = (EOPermission)newPermissions.get(i);
            this.addPermission(newPermission);
            --i;
        }
        this.updateListView();
    }

    private void addPermission(EOPermission p) {
        boolean alreadyContained = false;
        int i = this.permissions.size() - 1;
        while (i > -1) {
            EOPermission availablePermission = (EOPermission)this.permissions.get(i);
            if (!availablePermission.hasEqualRights(p)) {
                alreadyContained = true;
                break;
            }
            --i;
        }
        if (!alreadyContained) {
            this.permissions.add(p);
        }
    }

    public void setDerivedPermissions(List permissions) {
        this.derivedPermissions = permissions;
        this.updateListView();
    }

    public void addDerivedPermissions(List newPermissions) {
        int i = newPermissions.size() - 1;
        while (i > -1) {
            EOPermission newPermission = (EOPermission)newPermissions.get(i);
            this.addDerivedPermission(newPermission);
            --i;
        }
        this.updateListView();
    }

    private void addDerivedPermission(EOPermission p) {
        boolean alreadyContained = false;
        int i = this.derivedPermissions.size() - 1;
        while (i > -1) {
            EOPermission availablePermission = (EOPermission)this.derivedPermissions.get(i);
            if (!availablePermission.hasEqualRights(p)) {
                alreadyContained = true;
                break;
            }
            --i;
        }
        if (!alreadyContained) {
            this.derivedPermissions.add(p);
        }
    }

    private void updateListView() {
        ArrayList list = new ArrayList();
        list.addAll(this.permissions);
        list.addAll(this.derivedPermissions);
        this.viewer.setInput(list);
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        EOPermission permission = (EOPermission)element;
        String prefix = this.derivedPermissions.contains(element) ? Messages.getString("PermissionListWrapper.(G)__1") : "";
        return String.valueOf(prefix) + PSCPermissionConstants.getPermissionName((EOPermission)permission);
    }

    public Object[] getElements(Object inputElement) {
        return ((List)inputElement).toArray();
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public List getSelectedPrivileges() {
        StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
        return selection.toList();
    }

    public ListViewer getViewer() {
        return this.viewer;
    }
}

