/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.communication.transmissionprocessor;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.lang.reflect.Method;
import java.net.URL;
import javax.net.ssl.SSLContext;

public class SunJvmBug6514454Workaround {
    private static final ILogger LOGGER = Logger.getLogger(SunJvmBug6514454Workaround.class);
    private static final boolean workaround_enabled;

    static {
        boolean vm_has_bug_6514454 = false;
        try {
            String java_vm_vendor = System.getProperty("java.vm.vendor");
            String java_version = System.getProperty("java.version");
            vm_has_bug_6514454 = "Sun Microsystems Inc.".equalsIgnoreCase(java_vm_vendor) && ("1.6.0".equalsIgnoreCase(java_version) || "1.6.0_01".equalsIgnoreCase(java_version) || "1.6.0_02".equalsIgnoreCase(java_version) || "1.6.0_03".equalsIgnoreCase(java_version));
        }
        catch (Throwable th) {
            LOGGER.error("Problem while detecting if SunJvmBug6514454Workaround is needed.", th);
        }
        workaround_enabled = vm_has_bug_6514454;
        if (workaround_enabled) {
            LOGGER.debug("The SSL implementation of this Java VM is buggy - enabling workaround to avoid connection failures.");
        }
    }

    private SunJvmBug6514454Workaround() {
    }

    public static void fixHttpsClientSetup(URL serverURL) {
        if (workaround_enabled && "https".equalsIgnoreCase(serverURL.getProtocol())) {
            try {
                Method method = SSLContext.class.getMethod("getDefault", null);
                SSLContext context = (SSLContext)method.invoke(null, null);
                context.createSSLEngine();
            }
            catch (Throwable th) {
                LOGGER.debug("SunJvmBug6514454Workaround just ignored:", th);
            }
        }
    }
}

