/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.util;

import de.plans.lib.util.Hex;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

public class MacAddressRetriever {
    static String macAddress;

    static {
        block32: {
            macAddress = null;
            Process p = null;
            BufferedReader in = null;
            try {
                try {
                    String osname = System.getProperty("os.name");
                    if (osname.startsWith("Windows")) {
                        p = Runtime.getRuntime().exec(new String[]{"ipconfig", "/all"}, null);
                        in = new BufferedReader(new InputStreamReader(p.getInputStream()));
                        String l = null;
                        while ((l = in.readLine()) != null) {
                            macAddress = MacAddressRetriever.parse(l = l.trim());
                            if (macAddress == null || !macAddress.startsWith("00-") || Hex.parseInt(macAddress) == 0) continue;
                            break block32;
                        }
                        break block32;
                    }
                    if (new File("/sbin/ifconfig").exists()) {
                        p = Runtime.getRuntime().exec(new String[]{"/sbin/ifconfig", "-a"}, null);
                        in = new BufferedReader(new InputStreamReader(p.getInputStream()));
                        String l = null;
                        while ((l = in.readLine()) != null) {
                            macAddress = MacAddressRetriever.parse(l = l.trim());
                            if (macAddress == null || !macAddress.startsWith("00:") || Hex.parseInt(macAddress) == 0) continue;
                            break block32;
                        }
                        break block32;
                    }
                    if (!osname.startsWith("Solaris")) break block32;
                    p = Runtime.getRuntime().exec(new String[]{"arp", "`uname -n`"}, null);
                    in = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    String l = null;
                    while ((l = in.readLine()) != null) {
                        macAddress = MacAddressRetriever.parse(l = l.trim());
                        if (macAddress == null || !macAddress.startsWith("00-") || Hex.parseInt(macAddress) == 0) continue;
                        break;
                    }
                }
                catch (SecurityException securityException) {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (p == null) break block32;
                    try {
                        p.destroy();
                    }
                    catch (Exception exception) {
                    }
                }
                catch (IOException iOException) {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (p == null) break block32;
                    try {
                        p.destroy();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
                if (p != null) {
                    try {
                        p.destroy();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public static String getMacAddress() {
        return macAddress;
    }

    private static String parse(String in) {
        if (in == null || in.length() < 3) {
            return null;
        }
        int octets = 0;
        int lastIndex = -1;
        char c = in.charAt(in.length() - 3);
        if (c == ':') {
            lastIndex = in.lastIndexOf(58);
            if (lastIndex == in.length() - 3) {
                ++octets;
                int old = lastIndex;
                while (octets != 5 && lastIndex != -1 && lastIndex > 1) {
                    --lastIndex;
                    if (old - (lastIndex = in.lastIndexOf(58, lastIndex)) != 3) continue;
                    ++octets;
                    old = lastIndex;
                }
            }
        } else if (c == '-' && (lastIndex = in.lastIndexOf(45)) == in.length() - 3) {
            ++octets;
            int old = lastIndex;
            while (octets != 5 && lastIndex != -1 && lastIndex > 1) {
                --lastIndex;
                if (old - (lastIndex = in.lastIndexOf(45, lastIndex)) != 3) continue;
                ++octets;
                old = lastIndex;
            }
        }
        if (octets == 5 && lastIndex > 1) {
            return in.substring(lastIndex - 2);
        }
        return null;
    }
}

