/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.ErrorHandler;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.DirectFileRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.DirectWriteRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.net.Advertiser;
import org.apache.logging.log4j.core.util.Booleans;
import org.apache.logging.log4j.core.util.Integers;

@Plugin(name="PSCRollingFile", category="Core", elementType="appender", printObject=true)
public final class LogFileAppender
extends AbstractAppender {
    private static LogFileAppender singleInstance;
    private static String fileNameOverwrite;
    private static Long maxFileSizeOverwrite;
    public static final String PLUGIN_NAME = "PSCRollingFile";
    private Builder builder = null;
    private Instance instance = null;
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private ErrorHandler errorHandler = null;

    static {
        fileNameOverwrite = null;
        maxFileSizeOverwrite = null;
    }

    public static synchronized LogFileAppender getInstanceIfInitialized() {
        return singleInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized LogFileAppender getInstance(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, Property[] properties) {
        if (singleInstance != null) return singleInstance;
        singleInstance = new LogFileAppender(name, filter, layout, ignoreExceptions, properties);
        Class<LogFileAppender> clazz = LogFileAppender.class;
        synchronized (LogFileAppender.class) {
            if (maxFileSizeOverwrite == null) return singleInstance;
            singleInstance.setAttributes(fileNameOverwrite, maxFileSizeOverwrite);
            fileNameOverwrite = null;
            maxFileSizeOverwrite = null;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return singleInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setLogFileAttributes(String fileName, long maxFileSize) {
        LogFileAppender logFileAppender = LogFileAppender.getInstanceIfInitialized();
        if (logFileAppender != null) {
            logFileAppender.setAttributes(fileName, maxFileSize);
            return;
        }
        Class<LogFileAppender> clazz = LogFileAppender.class;
        synchronized (LogFileAppender.class) {
            fileNameOverwrite = fileName;
            maxFileSizeOverwrite = maxFileSize;
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return;
        }
    }

    private LogFileAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, Property[] properties) {
        super(name, filter, layout, ignoreExceptions, properties);
    }

    public String getLogFileName() {
        String fileName = "";
        if (this.builder == null) {
            fileName = this.builder.fileName;
        }
        return fileName;
    }

    private void built(Builder builder, Instance instance) {
        if (this.instance != null) {
            ErrorHandler errorHandler = this.instance.getHandler();
            instance.setHandler(errorHandler);
            this.instance.stop();
        }
        this.builder = builder;
        this.instance = instance;
    }

    public void setAttributes(String fileName, long maxFileSize) {
        if (this.builder != null) {
            Instance oldInstance = this.instance;
            this.instance = null;
            Instance newInstance = ((Builder)((Builder)((Object)this.builder.withFileName(fileName))).withPolicy((TriggeringPolicy)SizeBasedTriggeringPolicy.createPolicy((String)Long.toString(maxFileSize)))).buildInstance();
            if (!newInstance.isInitialized() && (this.isInitialized() || this.isStarting() || this.isStarted())) {
                newInstance.initialize();
            }
            if (!newInstance.isStarted() && (this.isStarting() || this.isStarted())) {
                newInstance.start();
            }
            this.instance = newInstance;
            if (oldInstance != null && oldInstance.isStarted()) {
                oldInstance.stop();
            }
        }
    }

    @Deprecated
    public static <B extends Builder<B>> LogFileAppender createAppender(String fileName, String filePattern, String append, String name, String bufferedIO, String bufferSizeStr, String immediateFlush, TriggeringPolicy policy, RolloverStrategy strategy, Layout<? extends Serializable> layout, Filter filter, String ignore, String advertise, String advertiseUri, Configuration config) {
        int bufferSize = Integers.parseInt((String)bufferSizeStr, (int)8192);
        return ((Builder)((Object)((Builder)((Object)((Builder)((Builder)((Object)((Builder)((Builder)((Builder)((Builder)((Builder)((Object)((Builder)((Builder)((Builder)((Builder)((Object)((Builder)((Object)((Builder)((Object)LogFileAppender.newBuilder())).withAdvertise(Boolean.parseBoolean(advertise)))).withAdvertiseUri(advertiseUri))).withAppend(Booleans.parseBoolean((String)append, (boolean)true)).withBufferedIo(Booleans.parseBoolean((String)bufferedIO, (boolean)true))).withBufferSize(bufferSize)).setConfiguration(config)).withFileName(fileName))).withFilePattern(filePattern).setFilter(filter)).setIgnoreExceptions(Booleans.parseBoolean((String)ignore, (boolean)true))).withImmediateFlush(Booleans.parseBoolean((String)immediateFlush, (boolean)true))).setLayout(layout)).withCreateOnDemand(false))).withLocking(false).setName(name)).withPolicy(policy))).withStrategy(strategy))).build();
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    public LifeCycle.State getState() {
        if (this.instance != null) {
            return this.instance.getState();
        }
        return super.getState();
    }

    public void initialize() {
        if (this.instance != null) {
            this.instance.initialize();
        }
        super.initialize();
    }

    public void start() {
        if (this.instance != null) {
            this.instance.start();
        }
        super.start();
    }

    public void stop() {
        if (this.instance != null) {
            this.instance.stop();
        }
        super.stop();
    }

    public boolean isStarted() {
        if (this.instance != null) {
            return this.instance.isStarted();
        }
        return super.isStarted();
    }

    public boolean isStopped() {
        if (this.instance != null) {
            return this.instance.isStopped();
        }
        return super.isStopped();
    }

    public boolean requiresLocation() {
        if (this.instance != null) {
            return this.instance.requiresLocation();
        }
        return super.requiresLocation();
    }

    public void append(LogEvent event) {
        if (this.instance != null) {
            this.instance.append(event);
        }
    }

    public String getName() {
        if (this.instance != null) {
            return this.instance.getName();
        }
        return PLUGIN_NAME;
    }

    public Layout<? extends Serializable> getLayout() {
        if (this.instance != null) {
            return this.instance.getLayout();
        }
        return super.getLayout();
    }

    public boolean ignoreExceptions() {
        if (this.instance != null) {
            return this.instance.ignoreExceptions();
        }
        return super.ignoreExceptions();
    }

    public ErrorHandler getHandler() {
        if (this.instance != null) {
            return this.instance.getHandler();
        }
        return this.errorHandler;
    }

    public void setHandler(ErrorHandler handler) {
        if (this.instance != null) {
            this.instance.setHandler(handler);
        }
        this.errorHandler = handler;
    }

    public synchronized void addFilter(Filter filter) {
        if (this.instance != null) {
            this.instance.addFilter(filter);
        }
        super.addFilter(filter);
    }

    public Filter getFilter() {
        if (this.instance != null) {
            return this.instance.getFilter();
        }
        return super.getFilter();
    }

    public boolean hasFilter() {
        if (this.instance != null) {
            return this.instance.hasFilter();
        }
        return super.hasFilter();
    }

    public boolean isFiltered(LogEvent event) {
        if (this.instance != null) {
            return this.instance.isFiltered(event);
        }
        return super.isFiltered(event);
    }

    public synchronized void removeFilter(Filter filter) {
        if (this.instance != null) {
            this.instance.removeFilter(filter);
        }
        super.removeFilter(filter);
    }

    public Property[] getPropertyArray() {
        if (this.instance != null) {
            return this.instance.getPropertyArray();
        }
        return super.getPropertyArray();
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractOutputStreamAppender.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<LogFileAppender> {
        @PluginBuilderAttribute
        private String fileName;
        @PluginBuilderAttribute
        @Required
        private String filePattern;
        @PluginBuilderAttribute
        private boolean append = true;
        @PluginBuilderAttribute
        private boolean locking;
        @PluginElement(value="Policy")
        @Required
        private TriggeringPolicy policy;
        @PluginElement(value="Strategy")
        private RolloverStrategy strategy;
        @PluginBuilderAttribute
        private boolean advertise;
        @PluginBuilderAttribute
        private String advertiseUri;
        @PluginBuilderAttribute
        private boolean createOnDemand;
        @PluginBuilderAttribute
        private String filePermissions;
        @PluginBuilderAttribute
        private String fileOwner;
        @PluginBuilderAttribute
        private String fileGroup;

        private Instance buildInstance() {
            boolean isBufferedIo = this.isBufferedIo();
            int bufferSize = this.getBufferSize();
            if (this.getName() == null) {
                LOGGER.error("LogFileAppender '{}': No name provided.", (Object)this.getName());
                return null;
            }
            if (!isBufferedIo && bufferSize > 0) {
                LOGGER.warn("LogFileAppender '{}': The bufferSize is set to {} but bufferedIO is not true", (Object)this.getName(), (Object)bufferSize);
            }
            if (this.filePattern == null) {
                LOGGER.error("LogFileAppender '{}': No file name pattern provided.", (Object)this.getName());
                return null;
            }
            if (this.policy == null) {
                LOGGER.error("LogFileAppender '{}': No TriggeringPolicy provided.", (Object)this.getName());
                return null;
            }
            if (this.strategy == null) {
                this.strategy = this.fileName != null ? DefaultRolloverStrategy.newBuilder().withCompressionLevelStr(String.valueOf(-1)).withConfig(this.getConfiguration()).build() : DirectWriteRolloverStrategy.newBuilder().withCompressionLevelStr(String.valueOf(-1)).withConfig(this.getConfiguration()).build();
            } else if (this.fileName == null && !(this.strategy instanceof DirectFileRolloverStrategy)) {
                LOGGER.error("LogFileAppender '{}': When no file name is provided a {} must be configured", (Object)this.getName(), (Object)DirectFileRolloverStrategy.class.getSimpleName());
                return null;
            }
            Layout layout = this.getOrCreateLayout();
            RollingFileManager manager = RollingFileManager.getFileManager((String)this.fileName, (String)this.filePattern, (boolean)this.append, (boolean)isBufferedIo, (TriggeringPolicy)this.policy, (RolloverStrategy)this.strategy, (String)this.advertiseUri, (Layout)layout, (int)bufferSize, (boolean)this.isImmediateFlush(), (boolean)this.createOnDemand, (String)this.filePermissions, (String)this.fileOwner, (String)this.fileGroup, (Configuration)this.getConfiguration());
            if (manager == null) {
                return null;
            }
            manager.initialize();
            return new Instance(this.getName(), layout, this.getFilter(), manager, this.fileName, this.filePattern, this.isIgnoreExceptions(), !isBufferedIo || this.isImmediateFlush(), this.advertise ? this.getConfiguration().getAdvertiser() : null, this.getPropertyArray());
        }

        public LogFileAppender build() {
            Instance instance = this.buildInstance();
            String name = instance.getName();
            Filter filter = instance.getFilter();
            Layout layout = instance.getLayout();
            boolean ignoreExceptions = instance.ignoreExceptions();
            Property[] properties = instance.getPropertyArray();
            LogFileAppender logFileAppender = LogFileAppender.getInstance(name, filter, (Layout<? extends Serializable>)layout, ignoreExceptions, properties);
            logFileAppender.built(this, instance);
            return logFileAppender;
        }

        public String getAdvertiseUri() {
            return this.advertiseUri;
        }

        public String getFileName() {
            return this.fileName;
        }

        public boolean isAdvertise() {
            return this.advertise;
        }

        public boolean isAppend() {
            return this.append;
        }

        public boolean isCreateOnDemand() {
            return this.createOnDemand;
        }

        public boolean isLocking() {
            return this.locking;
        }

        public String getFilePermissions() {
            return this.filePermissions;
        }

        public String getFileOwner() {
            return this.fileOwner;
        }

        public String getFileGroup() {
            return this.fileGroup;
        }

        public B withAdvertise(boolean advertise) {
            this.advertise = advertise;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withAdvertiseUri(String advertiseUri) {
            this.advertiseUri = advertiseUri;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withAppend(boolean append) {
            this.append = append;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withFileName(String fileName) {
            this.fileName = fileName;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withCreateOnDemand(boolean createOnDemand) {
            this.createOnDemand = createOnDemand;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withLocking(boolean locking) {
            this.locking = locking;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public String getFilePattern() {
            return this.filePattern;
        }

        public TriggeringPolicy getPolicy() {
            return this.policy;
        }

        public RolloverStrategy getStrategy() {
            return this.strategy;
        }

        public B withFilePattern(String filePattern) {
            this.filePattern = filePattern;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withPolicy(TriggeringPolicy policy) {
            this.policy = policy;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withStrategy(RolloverStrategy strategy) {
            this.strategy = strategy;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withFilePermissions(String filePermissions) {
            this.filePermissions = filePermissions;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withFileOwner(String fileOwner) {
            this.fileOwner = fileOwner;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withFileGroup(String fileGroup) {
            this.fileGroup = fileGroup;
            return (B)((Object)((Builder)this.asBuilder()));
        }
    }

    private static class Instance
    extends AbstractOutputStreamAppender<RollingFileManager> {
        private final String fileName;
        private final String filePattern;
        private Object advertisement;
        private final Advertiser advertiser;

        private Instance(String name, Layout<? extends Serializable> layout, Filter filter, RollingFileManager manager, String fileName, String filePattern, boolean ignoreExceptions, boolean immediateFlush, Advertiser advertiser, Property[] properties) {
            super(name, layout, filter, ignoreExceptions, immediateFlush, properties, (OutputStreamManager)manager);
            if (advertiser != null) {
                HashMap<String, String> configuration = new HashMap<String, String>(layout.getContentFormat());
                configuration.put("contentType", layout.getContentType());
                configuration.put("name", name);
                this.advertisement = advertiser.advertise(configuration);
            }
            this.fileName = fileName;
            this.filePattern = filePattern;
            this.advertiser = advertiser;
        }

        public boolean stop(long timeout, TimeUnit timeUnit) {
            this.setStopping();
            boolean stopped = super.stop(timeout, timeUnit, false);
            if (this.advertiser != null) {
                this.advertiser.unadvertise(this.advertisement);
            }
            this.setStopped();
            return stopped;
        }

        public void append(LogEvent event) {
            ((RollingFileManager)this.getManager()).checkRollover(event);
            super.append(event);
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getFilePattern() {
            return this.filePattern;
        }

        public <T extends TriggeringPolicy> T getTriggeringPolicy() {
            return (T)((RollingFileManager)this.getManager()).getTriggeringPolicy();
        }
    }
}

