/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.structure;

import de.plans.lib.structure.AbstractStructure;
import de.plans.lib.structure.IStructureElement;
import de.plans.lib.structure.IStructureElementVisitor;
import java.util.Collection;

public abstract class AbstractStructureTraverser {
    private final IStructureElementVisitor visitor;
    private final AbstractStructure structure;

    public AbstractStructureTraverser(AbstractStructure structure, IStructureElementVisitor visitor) {
        assert (structure != null) : "strucutre is null";
        assert (visitor != null) : "visitor is null";
        this.structure = structure;
        this.visitor = visitor;
    }

    protected boolean visit(IStructureElement element) {
        return this.visitor.visit(element);
    }

    protected Collection getAllElements() {
        return this.structure.getAllElements();
    }

    protected int getStructureTypeHint() {
        return this.structure.getStructureTypeHint();
    }
}

