/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.util.valueranges;

import com.arcway.lib.java.SetterSuccess;
import de.plans.lib.util.valueranges.IString;
import de.plans.lib.util.valueranges.IValueRangeHelperText;
import de.plans.lib.util.valueranges.ValueString;
import java.text.ParseException;

public class ValueRangeHelperString
implements IValueRangeHelperText {
    protected boolean lastCheckWasSuccessful = true;
    protected String lastErrorMessage_part1 = "";
    protected String lastErrorMessage_part2 = "";
    protected String lastErrorMessage_withoutDescription = "";
    private final IString persistentLocation;
    protected boolean isUsingEmptyStringSymbol;

    public ValueRangeHelperString(IString associatedPersistentLocation) {
        this.persistentLocation = associatedPersistentLocation;
        this.isUsingEmptyStringSymbol = false;
    }

    public ValueRangeHelperString(IString associatedPersistentLocation, boolean shallUseEmptyStringSymbol) {
        this.persistentLocation = associatedPersistentLocation;
        this.isUsingEmptyStringSymbol = shallUseEmptyStringSymbol;
    }

    @Override
    public boolean check(String valueToCheck) {
        assert (valueToCheck != null) : "valueToCheck must not be null";
        this.lastCheckWasSuccessful = true;
        return this.lastCheckWasSuccessful;
    }

    @Override
    public SetterSuccess setPersistentValue(String newValue) {
        assert (newValue != null) : "new value must not be null";
        if (this.check(newValue)) {
            if (this.isUsingEmptyStringSymbol && "".equals(newValue)) {
                newValue = "";
            }
            String oldValue = this.persistentLocation.getValue();
            this.persistentLocation.setValue(newValue);
            boolean valueChanged = oldValue == null && this.persistentLocation.getValue() != null || oldValue != null && !oldValue.equals(this.persistentLocation.getValue());
            return valueChanged ? SetterSuccess.VALUE_CHANGED : SetterSuccess.VALUE_DID_NOT_CHANGE;
        }
        return SetterSuccess.NEW_VALUE_COULD_NOT_BE_APPLIED;
    }

    @Override
    public String getDisplayFormat() {
        assert (this.persistentLocation != null) : "moduleDataAttribute must not be null";
        String displayString = this.persistentLocation.getValue();
        if (this.isUsingEmptyStringSymbol) {
            if (displayString != null && !displayString.trim().equals("")) {
                return displayString;
            }
            return "";
        }
        if (displayString != null) {
            return displayString;
        }
        return "";
    }

    public static IString getValue(String displayRepresentation) throws ParseException {
        return new ValueString(displayRepresentation);
    }

    @Override
    public String getErrorMessage(String description) {
        if (this.lastCheckWasSuccessful) {
            return "";
        }
        if (description == null) {
            return this.lastErrorMessage_withoutDescription;
        }
        return String.valueOf(this.lastErrorMessage_part1) + description + this.lastErrorMessage_part2;
    }
}

