/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.util.valueranges;

import com.arcway.lib.java.SetterSuccess;
import de.plans.lib.util.valueranges.IInteger;
import de.plans.lib.util.valueranges.IValueRangeHelperText;
import de.plans.lib.util.valueranges.Messages;

public class ValueRangeHelperInteger
implements IValueRangeHelperText {
    private static final String ERROR_MSG_PARTI = Messages.getString("ValueRangeHelperInteger.ErrorMsg.PartI");
    private static final String ERROR_MSG_PARTII = Messages.getString("ValueRangeHelperInteger.ErrorMsg.PartII");
    private final IInteger persistentLocation;
    private boolean lastCheckWasSuccessful = true;

    public ValueRangeHelperInteger(IInteger associatedPersistentLocation) {
        this.persistentLocation = associatedPersistentLocation;
    }

    @Override
    public boolean check(String valueToCheck) {
        try {
            Integer.parseInt(valueToCheck);
            this.lastCheckWasSuccessful = true;
        }
        catch (NumberFormatException e) {
            this.lastCheckWasSuccessful = false;
        }
        return this.lastCheckWasSuccessful;
    }

    @Override
    public SetterSuccess setPersistentValue(String newValue) {
        if (this.check(newValue)) {
            try {
                int oldValue = this.persistentLocation.getValue();
                this.persistentLocation.setValue(Integer.parseInt(newValue));
                return oldValue != this.persistentLocation.getValue() ? SetterSuccess.VALUE_CHANGED : SetterSuccess.VALUE_DID_NOT_CHANGE;
            }
            catch (NumberFormatException e) {
                return SetterSuccess.NEW_VALUE_COULD_NOT_BE_APPLIED;
            }
        }
        return SetterSuccess.NEW_VALUE_COULD_NOT_BE_APPLIED;
    }

    @Override
    public String getDisplayFormat() {
        assert (this.persistentLocation != null) : "persistentLocation must not be null";
        return "" + this.persistentLocation.getValue();
    }

    @Override
    public String getErrorMessage(String description) {
        if (!this.lastCheckWasSuccessful) {
            if (description != null) {
                return String.valueOf(description) + ERROR_MSG_PARTII;
            }
            return String.valueOf(ERROR_MSG_PARTI) + ERROR_MSG_PARTII;
        }
        return "";
    }
}

