/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.ui.editor.playground;

import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.java.collections.ISortedSet_;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import com.arcway.lib.ui.editor.IPlaygroundManager;
import com.arcway.lib.ui.editor.datatype.IEditorMessageSet;
import com.arcway.lib.ui.editor.datatype.IEditorModelAccess;
import com.arcway.lib.ui.editor.exception.EEXDataValidation;
import com.arcway.lib.ui.editor.exception.EEXLockDenied;
import com.arcway.lib.ui.editor.exception.EEXNotReproducibleSnapshot;
import com.arcway.lib.ui.editor.exception.EEXObjectReferenceCannotBeResolved;
import com.arcway.lib.ui.editor.exception.EEXPermissionDenied;
import com.arcway.lib.ui.editor.exception.EEXRepositoryAccessException;
import com.arcway.lib.ui.editor.exception.EEXSnapshotClosed;
import com.arcway.lib.ui.editor.playground.AbstractPropertyOrCategoryPlayground;
import com.arcway.lib.ui.editor.playground.IPropertyPlaygroundFactory;
import com.arcway.lib.ui.editor.playground.IPropertyTypeInformation;
import com.arcway.lib.ui.editor.playground.PlaygroundError;
import com.arcway.lib.ui.editor.widgetAdapter.IPropertyWidgetAdapter;
import com.arcway.lib.ui.modelaccess.IModelAccess;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class PropertyPlayground<PROPERTY_OR_CATEGORY_REFERENCE, PROPERTY_REFERENCE extends PROPERTY_OR_CATEGORY_REFERENCE, OBJECT_TYPE_CATEGORY_REFERENCE extends PROPERTY_OR_CATEGORY_REFERENCE, OBJECT_REFERENCE>
extends AbstractPropertyOrCategoryPlayground<IPropertyWidgetAdapter, Object, String, PROPERTY_OR_CATEGORY_REFERENCE, PROPERTY_REFERENCE, OBJECT_TYPE_CATEGORY_REFERENCE, OBJECT_REFERENCE> {
    private final PROPERTY_REFERENCE propertyReference;
    private Map<String, String> valueRange;

    public PropertyPlayground(PROPERTY_REFERENCE propertyReference, IEditorModelAccess<PROPERTY_OR_CATEGORY_REFERENCE, PROPERTY_REFERENCE, OBJECT_TYPE_CATEGORY_REFERENCE, OBJECT_REFERENCE> modelAccessAgent, IPlaygroundManager playgroundManager) {
        super(modelAccessAgent, playgroundManager);
        this.propertyReference = propertyReference;
    }

    @Override
    protected PROPERTY_REFERENCE getPropertyOrCategoryReference() {
        return this.propertyReference;
    }

    @Override
    protected OBJECT_REFERENCE getObjectReference() {
        return this.getModelAccessAgent().getContentReferenceInterpreter().getObjectReferenceFromPropertyReference(this.propertyReference);
    }

    @Override
    protected IHasher_<Object> getPropertyOrCategoryValueHasher() {
        return this.getContentReferenceInterpreter().getPropertyValueHasher(this.propertyReference);
    }

    @Override
    protected Object getDefaultValueForPropertyOrCategory() throws EEXLockDenied, EEXSnapshotClosed, EEXNotReproducibleSnapshot {
        return this.getCurrentModelAndModificationsAccessAgent().getDefaultValueForProperty(this.propertyReference);
    }

    @Override
    protected ISortedSet_<String> getValueRangeKeysForPropertyOrCatgeory() {
        return this.getCurrentModelAndModificationsAccessAgent().getValueRangeKeysForPropertyAsEditorValue(this.propertyReference);
    }

    @Override
    protected Object getCurrentValueForPropertyOrCategory() throws EEXObjectReferenceCannotBeResolved, EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        return this.getCurrentModelAndModificationsAccessAgent().getCurrentValueForProperty(this.propertyReference);
    }

    @Override
    protected boolean isPropertyOrCategoryModified() {
        return this.getCurrentModelAndModificationsAccessAgent().isPropertyModified(this.propertyReference);
    }

    @Override
    protected Object getModifiedPropertyOrCategoryValue() {
        return this.getCurrentModelAndModificationsAccessAgent().getModifiedPropertyValue(this.propertyReference);
    }

    @Override
    protected Object getToBePropertyOrCategoryValue() throws EEXRepositoryAccessException, EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        return this.getCurrentModelAndModificationsAccessAgent().getToBePropertyValue(this.propertyReference);
    }

    @Override
    protected void setNewPropertyOrCategoryValue(Object newValue) throws EEXRepositoryAccessException, EEXNotReproducibleSnapshot, EEXSnapshotClosed, EEXDataValidation, JvmExternalResourceInteractionException {
        this.getCurrentModelAndModificationsAccessAgent().setPropertyValue(this.propertyReference, newValue);
    }

    @Override
    protected void resetPropertyOrCategoryValue(Object newValue) throws EEXRepositoryAccessException, EEXNotReproducibleSnapshot, EEXSnapshotClosed, EEXDataValidation, JvmExternalResourceInteractionException {
        this.getCurrentModelAndModificationsAccessAgent().resetPropertyValue(this.propertyReference, newValue);
    }

    @Override
    protected void refreshPropertyOrCategoryValue() throws EEXRepositoryAccessException, EEXNotReproducibleSnapshot, EEXSnapshotClosed, EEXDataValidation, JvmExternalResourceInteractionException {
        this.getCurrentModelAndModificationsAccessAgent().refreshPropertyValue(this.propertyReference);
    }

    @Override
    protected void checkPermissionForModifyData() throws EEXPermissionDenied, EEXSnapshotClosed, EEXNotReproducibleSnapshot {
        this.getLockAndPermissionProvider().checkPermissionForModifyProperty(this.propertyReference);
    }

    @Override
    protected void acquireModifyLockForPropertyOrCategory() throws EEXLockDenied, EEXSnapshotClosed, EEXNotReproducibleSnapshot {
        this.getLockAndPermissionProvider().acquireModifyLockForProperty(this.propertyReference);
    }

    @Override
    protected void releaseModifyLockForPropertyOrCategory() {
        this.getLockAndPermissionProvider().releaseModifyLockForProperty(this.propertyReference);
    }

    @Override
    protected IEditorMessageSet getPropertyOrCategoryMessages() throws EEXNotReproducibleSnapshot {
        return this.getCurrentModelAndModificationsAccessAgent().getPropertyMessages(this.propertyReference);
    }

    @Override
    protected boolean mayInfluencePlaygroundVisibility() {
        return false;
    }

    public List<Object> getParentsValues() {
        try {
            return this.getCurrentModelAndModificationsAccessAgent().getAncestorsValuesForProperty(this.propertyReference);
        }
        catch (EEXNotReproducibleSnapshot exNRS) {
            this.setError(new PlaygroundError(exNRS));
            return Collections.emptyList();
        }
        catch (EEXSnapshotClosed e) {
            this.setError(new PlaygroundError(e));
            return Collections.emptyList();
        }
    }

    public Object getParentsValue() {
        try {
            return this.getCurrentModelAndModificationsAccessAgent().getParentsValueForProperty(this.propertyReference);
        }
        catch (EEXNotReproducibleSnapshot exNRS) {
            this.setError(new PlaygroundError(exNRS));
            return Collections.emptyList();
        }
        catch (EEXSnapshotClosed e) {
            this.setError(new PlaygroundError(e));
            return Collections.emptyList();
        }
    }

    public IPropertyTypeInformation getPropertyTypeInformation() {
        return this.getContentReferenceInterpreter().getPropertyTypeInformation(this.propertyReference);
    }

    public boolean isWithTimeComponent() {
        return this.getCurrentModelAndModificationsAccessAgent().isDatePropertyWithTimeComponent(this.propertyReference);
    }

    public String getLabel(String key) {
        if (this.valueRange == null) {
            this.valueRange = this.getCurrentModelAndModificationsAccessAgent().getValueRangeForPropertyAsEditorValue(this.propertyReference);
        }
        return this.valueRange.get(key);
    }

    public static class PlaygroundFactory
    implements IPropertyPlaygroundFactory {
        @Override
        public <PROPERTY_OR_CATEGORY_REFERENCE, PROPERTY_REFERENCE extends PROPERTY_OR_CATEGORY_REFERENCE, OBJECT_TYPE_CATEGORY_REFERENCE extends PROPERTY_OR_CATEGORY_REFERENCE, OBJECT_REFERENCE> PropertyPlayground<PROPERTY_OR_CATEGORY_REFERENCE, PROPERTY_REFERENCE, OBJECT_TYPE_CATEGORY_REFERENCE, OBJECT_REFERENCE> createPropertyPlayground(PROPERTY_REFERENCE propertyReference, IModelAccess<PROPERTY_OR_CATEGORY_REFERENCE, PROPERTY_REFERENCE, OBJECT_TYPE_CATEGORY_REFERENCE, OBJECT_REFERENCE> modelAccessAgent, IPlaygroundManager playgroundManager) {
            PropertyPlayground playground = new PropertyPlayground(propertyReference, (IEditorModelAccess)modelAccessAgent, playgroundManager);
            playground.init();
            return playground;
        }
    }
}

