/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.ui.editor.playground;

import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.ui.editor.IPlaygroundManager;
import com.arcway.lib.ui.editor.datatype.IEditorModelAccess;
import com.arcway.lib.ui.editor.datatype.ITextProvider;
import com.arcway.lib.ui.editor.exception.EEXRepositoryAccessException;
import com.arcway.lib.ui.editor.playground.IEditorPlayground;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapter;
import com.arcway.lib.ui.modelaccess.agent.IContentReferenceInterpreter;
import com.arcway.lib.ui.modelaccess.agent.ICurrentModelAndModificationsAccessAgent;
import com.arcway.lib.ui.modelaccess.agent.ILockAndPermissionProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AbstractPlayground<WIDGET_ADAPTER_TYPE extends IWidgetAdapter, PROPERTY_OR_CATEGORY_REFERENCE, PROPERTY_REFERENCE extends PROPERTY_OR_CATEGORY_REFERENCE, OBJECT_TYPE_CATEGORY_REFERENCE extends PROPERTY_OR_CATEGORY_REFERENCE, OBJECT_REFERENCE>
implements IEditorPlayground<WIDGET_ADAPTER_TYPE> {
    private final IEditorModelAccess<PROPERTY_OR_CATEGORY_REFERENCE, PROPERTY_REFERENCE, OBJECT_TYPE_CATEGORY_REFERENCE, OBJECT_REFERENCE> modelAccessAgent;
    private final IPlaygroundManager playgroundManager;
    private final List<WIDGET_ADAPTER_TYPE> adapterList = new ArrayList<WIDGET_ADAPTER_TYPE>();
    private ITextProvider lockMessage;
    private ITextProvider permissionMessage;

    public AbstractPlayground(IEditorModelAccess<PROPERTY_OR_CATEGORY_REFERENCE, PROPERTY_REFERENCE, OBJECT_TYPE_CATEGORY_REFERENCE, OBJECT_REFERENCE> modelAccessAgent, IPlaygroundManager playgroundManager) {
        this.modelAccessAgent = modelAccessAgent;
        this.playgroundManager = playgroundManager;
    }

    protected IEditorModelAccess<PROPERTY_OR_CATEGORY_REFERENCE, PROPERTY_REFERENCE, OBJECT_TYPE_CATEGORY_REFERENCE, OBJECT_REFERENCE> getModelAccessAgent() {
        return this.modelAccessAgent;
    }

    protected IPlaygroundManager getPlaygroundManager() {
        return this.playgroundManager;
    }

    @Override
    public void addWidgetAdapter(WIDGET_ADAPTER_TYPE adapter) {
        this.adapterList.add(adapter);
    }

    @Override
    public Collection<? extends WIDGET_ADAPTER_TYPE> getWidgetAdapters() {
        return this.adapterList;
    }

    protected final void sendUpdateSignalToAdapters(IWidgetAdapter initiatingWidgetAdapter) {
        for (IWidgetAdapter element : this.adapterList) {
            element.update(initiatingWidgetAdapter == null ? IWidgetAdapter.WidgetUpdateMode.UPDATE_VALUE : (element == initiatingWidgetAdapter ? IWidgetAdapter.WidgetUpdateMode.DONT_UPDATE_VALUE : IWidgetAdapter.WidgetUpdateMode.UPDATE_VALUE_IF_PLAYGROUND_VALUE_DIFFERS));
        }
    }

    @Override
    public void setVisible(boolean visible) {
        for (IWidgetAdapter widgetAdapter : this.getWidgetAdapters()) {
            widgetAdapter.setWidgetVisible(visible);
        }
    }

    protected ICurrentModelAndModificationsAccessAgent<PROPERTY_OR_CATEGORY_REFERENCE, PROPERTY_REFERENCE, OBJECT_TYPE_CATEGORY_REFERENCE, OBJECT_REFERENCE> getCurrentModelAndModificationsAccessAgent() {
        return this.modelAccessAgent.getCurrentModelAndModificationsAccessAgent();
    }

    protected ILockAndPermissionProvider<PROPERTY_REFERENCE, OBJECT_TYPE_CATEGORY_REFERENCE> getLockAndPermissionProvider() {
        return this.modelAccessAgent.getLockAndPermissionProvider();
    }

    protected IContentReferenceInterpreter<PROPERTY_OR_CATEGORY_REFERENCE, PROPERTY_REFERENCE, OBJECT_TYPE_CATEGORY_REFERENCE, OBJECT_REFERENCE> getContentReferenceInterpreter() {
        return this.modelAccessAgent.getContentReferenceInterpreter();
    }

    protected PresentationContext getCurrentPresentationContext() {
        return this.playgroundManager.getCurrentPresentationContext();
    }

    protected ITextProvider getMessageForException(EEXRepositoryAccessException e) {
        return this.getPlaygroundManager().getMessageForException(e);
    }

    @Override
    public void setLockMessageText(ITextProvider lockMessage) {
        this.lockMessage = lockMessage;
    }

    @Override
    public String getLockMessageText() {
        return this.lockMessage == null ? null : this.lockMessage.getText(this.getCurrentPresentationContext());
    }

    @Override
    public void setPermissionMessageText(ITextProvider permissionMessage) {
        this.permissionMessage = permissionMessage;
    }

    @Override
    public String getPermissionMessageText() {
        return this.permissionMessage == null ? null : this.permissionMessage.getText(this.getCurrentPresentationContext());
    }

    @Override
    public void addScheduledTask(Runnable task) {
        this.playgroundManager.addScheduledTask(task);
    }

    @Override
    public void removeScheduledTask(Runnable task) {
        this.playgroundManager.removeScheduledTask(task);
    }

    @Override
    public void addCloseVeto(IWidgetAdapter widgetAdapter, ITextProvider veto) {
        this.playgroundManager.addCloseVeto(widgetAdapter, veto);
    }

    @Override
    public void removeCloseVeto(IWidgetAdapter widgetAdapter) {
        this.playgroundManager.removeCloseVeto(widgetAdapter);
    }
}

