/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics.text;

public class TextStyle {
    private final String fontName;
    private final boolean bold;
    private final boolean italic;

    public TextStyle(TextStyle textStyle) {
        assert (textStyle != null) : "textStyle = null";
        this.fontName = textStyle.getFontName();
        this.bold = textStyle.isBold();
        this.italic = textStyle.isItalic();
    }

    public TextStyle(String fontName) {
        assert (fontName != null) : "fontName = null";
        this.fontName = fontName;
        this.bold = false;
        this.italic = false;
    }

    public TextStyle(String fontName, boolean bold, boolean italic) {
        assert (fontName != null) : "fontName = null";
        this.fontName = fontName;
        this.bold = bold;
        this.italic = italic;
    }

    public boolean isBold() {
        return this.bold;
    }

    public String getFontName() {
        return this.fontName;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public boolean isEqualTextStyle(TextStyle otherTextStyle) {
        return this.bold == otherTextStyle.bold && this.italic == otherTextStyle.italic && this.fontName.equals(otherTextStyle.fontName);
    }
}

