/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics.saveimage;

public class ByteBuffer {
    private static final int CLUSTER_SIZE = 4096;
    private static final float ENLARGING_FACTOR = 1.4f;
    private byte[] buf = new byte[4096];
    private int cursor = 0;
    private int size = 0;

    public ByteBuffer() {
        this.clear();
    }

    public void clear() {
        this.buf = new byte[4096];
        this.cursor = 0;
        this.size = 0;
    }

    int read() {
        return this.buf[this.cursor++];
    }

    int read(byte[] target, int off, int len) {
        if (this.size - this.cursor == 0) {
            return -1;
        }
        int bytesRead = Math.min(len, Math.min(target.length, this.size - this.cursor));
        if (bytesRead > 0) {
            System.arraycopy(this.buf, this.cursor, target, off, bytesRead);
            this.cursor += bytesRead;
        }
        return bytesRead;
    }

    void write(int b) {
        if (this.size == this.buf.length) {
            this.enlarge(1);
        }
        this.buf[this.cursor] = (byte)b;
        ++this.cursor;
        this.size = Math.max(this.cursor, this.size);
    }

    int write(byte[] source, int off, int len) {
        if (len > 0) {
            if (this.size + len > this.buf.length) {
                this.enlarge(this.size + len - this.buf.length);
            }
            System.arraycopy(source, off, this.buf, this.cursor, len);
            this.cursor += len;
            this.size = Math.max(this.cursor, this.size);
        }
        return len;
    }

    void seek(long pos) {
        this.cursor = (int)pos;
    }

    int getFilePointer() {
        return this.cursor;
    }

    int length() {
        return this.size;
    }

    void close() {
    }

    private void enlarge(int minimum) {
        int newSize = Math.max(this.buf.length + 4096, Math.max(this.size + minimum, Math.round((float)this.buf.length * 1.4f)));
        byte[] newBuf = new byte[newSize];
        System.arraycopy(this.buf, 0, newBuf, 0, this.size);
        this.buf = newBuf;
    }

    public byte[] toByteArray() {
        byte[] newBuf = new byte[this.size];
        System.arraycopy(this.buf, 0, newBuf, 0, this.size);
        return newBuf;
    }
}

