/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics.device;

import com.arcway.lib.geometry.Corner;
import com.arcway.lib.geometry.Corners;
import com.arcway.lib.geometry.Direction;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Line;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.Transformation;
import com.arcway.lib.geometry.TransformationAffiliate;
import com.arcway.lib.geometry.TurnedRectangle;
import com.arcway.lib.geometry.polygon.Polygon;
import com.arcway.lib.graphics.Alignment;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.EXNoMoreHandles;
import com.arcway.lib.graphics.FillColor;
import com.arcway.lib.graphics.IRenderer;
import com.arcway.lib.graphics.device.IDeviceRunnable;
import com.arcway.lib.graphics.devicedrivers.DeviceDriverGetBounds;
import com.arcway.lib.graphics.devicedrivers.IDeviceDriver;
import com.arcway.lib.graphics.fillstyles.FillStyle;
import com.arcway.lib.graphics.image.IOffscreenBitmap;
import com.arcway.lib.graphics.linemarkers.LineMarker;
import com.arcway.lib.graphics.linestyles.LineStyle;
import com.arcway.lib.graphics.plugin.DefaultRendererExtensionPoint;
import com.arcway.lib.graphics.text.IFont;
import com.arcway.lib.graphics.text.TextStyle;
import com.arcway.lib.stringtools.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Device {
    private static final boolean DRAW_TEXT_DEBUGGING_MARKERS = false;
    private Transformation transformationAppliedByDevice = TransformationAffiliate.newTransformationNOP();
    protected IDeviceDriver driver;
    private static ThreadLocal<IFont> currentFontThreadLocal = new ThreadLocal();
    private static ThreadLocal<TextStyle> currentTextStyleThreadLocal = new ThreadLocal();

    public static int calculateNumberOfTextLines(String text, TextStyle textStyle, double textHeight, double width) {
        int nrOfTextLines;
        Device device = new Device(new DeviceDriverGetBounds(), Transformation.NOP);
        try {
            nrOfTextLines = device.getNumberOfTextLines(text, textStyle, textHeight, width);
        }
        finally {
            device.disposeDriver();
        }
        return nrOfTextLines;
    }

    public static double calculateTextLength(String text, TextStyle textStyle, double textHeight) {
        double length;
        Device device = new Device(new DeviceDriverGetBounds(), Transformation.NOP);
        try {
            length = device.getTextLength(text, textStyle, textHeight);
        }
        finally {
            device.disposeDriver();
        }
        return length;
    }

    public Device(IDeviceDriver driver, Transformation mmToDriver) {
        assert (driver != null) : "driver is null";
        this.driver = driver;
        this.transformationAppliedByDevice = mmToDriver;
    }

    public IDeviceDriver getDriver() {
        return this.driver;
    }

    public <T extends Throwable> void subElement(String elementName, String elementTypeID, String elementID, Transformation optionalTransformation, IDeviceRunnable<T> runnable) throws T {
        Transformation optionalTransformationChecked = optionalTransformation != null ? (optionalTransformation.isNOPTransformation() ? null : optionalTransformation) : null;
        Transformation transformationAppliedByDeviceBackup = this.transformationAppliedByDevice;
        try {
            TransformationAffiliate additionalTrafoForDriver;
            Transformation additionalTrafoForDevice;
            if (optionalTransformationChecked != null) {
                if (this.driver.driverSupportsTransformationForSubElements() && optionalTransformationChecked instanceof TransformationAffiliate && transformationAppliedByDeviceBackup instanceof TransformationAffiliate) {
                    TransformationAffiliate currentDeviceTransformation = (TransformationAffiliate)transformationAppliedByDeviceBackup;
                    TransformationAffiliate additionalTransformation = (TransformationAffiliate)optionalTransformationChecked;
                    TransformationAffiliate shearAndRotateToBeAppliedSecond = additionalTransformation.extractShearAndRotateToBeAppliedLast();
                    TransformationAffiliate scaleAndTranslateToBeAppliedFirst = additionalTransformation.transform(shearAndRotateToBeAppliedSecond.getInverse());
                    TransformationAffiliate shearAndRotateToBeAppliedLast = currentDeviceTransformation.getInverse().transform(shearAndRotateToBeAppliedSecond).transform(currentDeviceTransformation);
                    additionalTrafoForDevice = scaleAndTranslateToBeAppliedFirst;
                    additionalTrafoForDriver = shearAndRotateToBeAppliedLast;
                } else {
                    additionalTrafoForDevice = optionalTransformationChecked;
                    additionalTrafoForDriver = null;
                }
            } else {
                additionalTrafoForDevice = null;
                additionalTrafoForDriver = null;
            }
            if (additionalTrafoForDevice != null && additionalTrafoForDevice.isNOPTransformation()) {
                additionalTrafoForDevice = null;
            }
            if (additionalTrafoForDriver != null && additionalTrafoForDriver.isNOPTransformation()) {
                additionalTrafoForDriver = null;
            }
            if (additionalTrafoForDevice != null) {
                this.transformationAppliedByDevice = additionalTrafoForDevice.transform(this.transformationAppliedByDevice);
            }
            this.driver.subElement(elementName, elementTypeID, elementID, additionalTrafoForDriver, runnable);
        }
        finally {
            this.transformationAppliedByDevice = transformationAppliedByDeviceBackup;
        }
    }

    public void text(TurnedRectangle r, Alignment a, String text, TextStyle textStyle, double textSize, Color textColor, boolean wrap) {
        assert (r != null) : "r is null";
        assert (a != null) : "a is null";
        assert (text != null) : "text is null";
        assert (textStyle != null) : "textStyle is null";
        assert (textSize > 0.0) : "textHeight not greater 0";
        assert (textColor != null) : "textColor is null";
        this.transformAndDrawText(r, a, text, textStyle, textSize, textColor, wrap);
    }

    public void text(Rectangle r, Alignment a, String text, TextStyle textStyle, double textSize, Color textColor, boolean wrap) {
        assert (r != null) : "r is null";
        assert (a != null) : "a is null";
        assert (text != null) : "text is null";
        assert (textStyle != null) : "textStyle is null";
        assert (textSize > 0.0) : "textHeight not greater 0";
        assert (textColor != null) : "textColor is null";
        TurnedRectangle turnedRectangle = new TurnedRectangle(r);
        this.transformAndDrawText(turnedRectangle, a, text, textStyle, textSize, textColor, wrap);
    }

    public double getTextLength(String text, TextStyle textStyle, double textHeight) {
        assert (text != null) : "text is null";
        assert (textStyle != null) : "textStyle is null";
        assert (textHeight > 0.0) : "textHeight not greater 0";
        return this.transformAndGetTransformedTextLength(text, textStyle, textHeight);
    }

    public double getTextLineHeight(TextStyle textStyle, double textHeight) {
        assert (textHeight > 0.0) : "textHeight not greater 0";
        return this.transformAndGetTransformedTextLineHeight(textStyle, textHeight);
    }

    public int getNumberOfTextLines(String text, TextStyle textStyle, double textHeight, double width) {
        assert (text != null) : "text is null";
        assert (textStyle != null) : "textStyle is null";
        assert (textHeight > 0.0) : "textHeight not greater 0";
        return this.transformAndGetNumberOfTextLines(text, textStyle, textHeight, width);
    }

    public double getTextLength(String text, TextStyle textStyle, double textHeight, int numberOfLines) {
        assert (text != null) : "text is null";
        assert (textStyle != null) : "textStyle is null";
        assert (textHeight > 0.0) : "textHeight not greater 0";
        assert (numberOfLines > 0);
        return this.transformAndGetTransformedTextLength(text, textStyle, textHeight, numberOfLines);
    }

    public void marker(Point position, double angle, double lineThickness, Color lineColor, FillColor fillColor, LineMarker lineMarker) {
        assert (position != null);
        assert (lineThickness > -1.0E-10);
        assert (lineColor != null);
        assert (lineMarker != null);
        double coronaWidth = 0.0;
        this.markerCorona(position, angle, lineThickness, lineColor, fillColor, lineMarker, coronaWidth);
    }

    public void markerCorona(Point position, double angle, double lineThickness, Color lineColor, FillColor fillColor, LineMarker lineMarker, double coronaWidth) {
        assert (position != null);
        assert (lineThickness > -1.0E-10);
        assert (lineColor != null);
        assert (lineMarker != null);
        assert (coronaWidth > -1.0E-10);
        lineMarker.draw(this, position, lineColor, lineThickness, fillColor, angle, coronaWidth);
    }

    public void polyline(Corners corners, double lineThickness, Color lineColor, LineStyle lineStyle) {
        assert (corners != null) : "corners is null";
        assert (lineColor != null) : "lineColor is null";
        assert (lineStyle != null) : "lineStyle is null";
        Polygon polygon = new Polygon(corners, false);
        this.polyline(polygon, lineThickness, lineColor, lineStyle);
    }

    public void polyline(Corners corners, double lineThickness, Color lineColor, LineStyle lineStyle, LineMarker startMarker, LineMarker endMarker) {
        assert (corners != null) : "corners is null";
        assert (lineColor != null) : "lineColor is null";
        assert (lineStyle != null) : "lineStyle is null";
        assert (startMarker != null) : "startMarker is null";
        assert (endMarker != null) : "endMarker is null";
        Polygon polygon = new Polygon(corners, false);
        this.polyline(polygon, lineThickness, lineColor, lineStyle, startMarker, endMarker);
    }

    public void polyline(Corners corners, double lineThickness, Color lineColor, LineStyle lineStyle, LineMarker startMarker, Color startColor, FillColor startFillColor, LineMarker endMarker) {
        assert (corners != null) : "corners is null";
        assert (lineColor != null) : "lineColor is null";
        assert (lineStyle != null) : "lineStyle is null";
        assert (startMarker != null) : "startMarker is null";
        assert (startColor != null) : "startColor is null";
        assert (endMarker != null) : "endMarker is null";
        Polygon polygon = new Polygon(corners, false);
        this.polyline(polygon, lineThickness, lineColor, lineStyle, startMarker, startColor, startFillColor, endMarker);
    }

    public void polyline(Corners corners, double lineThickness, Color lineColor, LineStyle lineStyle, LineMarker startMarker, double startSize, LineMarker endMarker) {
        assert (corners != null) : "corners is null";
        assert (lineColor != null) : "lineColor is null";
        assert (lineStyle != null) : "lineStyle is null";
        assert (startMarker != null) : "startMarker is null";
        assert (endMarker != null) : "endMarker is null";
        Polygon polygon = new Polygon(corners, false);
        this.polyline(polygon, lineThickness, lineColor, lineStyle, startMarker, startSize, endMarker);
    }

    public void polyline(Corners corners, double lineThickness, Color lineColor, LineStyle lineStyle, LineMarker startMarker, LineMarker endMarker, Color endColor, FillColor endFillColor) {
        assert (corners != null) : "corners is null";
        assert (lineColor != null) : "lineColor is null";
        assert (lineStyle != null) : "lineStyle is null";
        assert (startMarker != null) : "startMarker is null";
        assert (endMarker != null) : "endMarker is null";
        assert (endColor != null) : "endColor is null";
        Polygon polygon = new Polygon(corners, false);
        this.polyline(polygon, lineThickness, lineColor, lineStyle, startMarker, endMarker, endColor, endFillColor);
    }

    public void polyline(Corners corners, double lineThickness, Color lineColor, LineStyle lineStyle, LineMarker startMarker, LineMarker endMarker, double endSize) {
        assert (corners != null) : "corners is null";
        assert (lineColor != null) : "lineColor is null";
        assert (lineStyle != null) : "lineStyle is null";
        assert (startMarker != null) : "startMarker is null";
        assert (endMarker != null) : "endMarker is null";
        Polygon polygon = new Polygon(corners, false);
        this.polyline(polygon, lineThickness, lineColor, lineStyle, startMarker, endMarker, endSize);
    }

    public void polyline(Corners corners, double lineThickness, Color lineColor, LineStyle lineStyle, LineMarker startMarker, double startSize, LineMarker endMarker, double endSize) {
        assert (corners != null) : "corners is null";
        assert (lineColor != null) : "lineColor is null";
        assert (lineStyle != null) : "lineStyle is null";
        assert (startMarker != null) : "startMarker is null";
        assert (endMarker != null) : "endMarker is null";
        Polygon polygon = new Polygon(corners, false);
        this.polyline(polygon, lineThickness, lineColor, lineStyle, startMarker, startSize, endMarker, endSize);
    }

    public void polyline(Corners corners, double lineThickness, Color lineColor, LineStyle lineStyle, LineMarker startMarker, Color startColor, FillColor startFillColor, LineMarker endMarker, Color endColor, FillColor endFillColor) {
        assert (corners != null) : "corners is null";
        assert (lineColor != null) : "lineColor is null";
        assert (lineStyle != null) : "lineStyle is null";
        assert (startMarker != null) : "startMarker is null";
        assert (startColor != null) : "startColor is null";
        assert (endMarker != null) : "endMarker is null";
        assert (endColor != null) : "endColor is null";
        Polygon polygon = new Polygon(corners, false);
        this.polyline(polygon, lineThickness, lineColor, lineStyle, startMarker, startColor, startFillColor, endMarker, endColor, endFillColor);
    }

    public void polyline(Corners corners, double lineThickness, Color lineColor, LineStyle lineStyle, LineMarker startMarker, Color startColor, FillColor startFillColor, double startSize, LineMarker endMarker) {
        assert (corners != null) : "corners is null";
        assert (lineColor != null) : "lineColor is null";
        assert (lineStyle != null) : "lineStyle is null";
        assert (startMarker != null) : "startMarker is null";
        assert (startColor != null) : "startColor is null";
        assert (endMarker != null) : "endMarker is null";
        Polygon polygon = new Polygon(corners, false);
        this.polyline(polygon, lineThickness, lineColor, lineStyle, startMarker, startColor, startFillColor, startSize, endMarker);
    }

    public void polyline(Corners corners, double lineThickness, Color lineColor, LineStyle lineStyle, LineMarker startMarker, LineMarker endMarker, Color endColor, FillColor endFillColor, double endSize) {
        assert (corners != null) : "corners is null";
        assert (lineColor != null) : "lineColor is null";
        assert (lineStyle != null) : "lineStyle is null";
        assert (startMarker != null) : "startMarker is null";
        assert (endMarker != null) : "endMarker is null";
        assert (endColor != null) : "endColor is null";
        Polygon polygon = new Polygon(corners, false);
        this.polyline(polygon, lineThickness, lineColor, lineStyle, startMarker, endMarker, endColor, endFillColor, endSize);
    }

    public void polyline(Corners corners, double lineThickness, Color lineColor, LineStyle lineStyle, LineMarker startMarker, Color startColor, FillColor startFillColor, double startSize, LineMarker endMarker, Color endColor, FillColor endFillColor, double endSize) {
        assert (corners != null) : "corners is null";
        assert (lineColor != null) : "lineColor is null";
        assert (lineStyle != null) : "lineStyle is null";
        assert (startMarker != null) : "startMarker is null";
        assert (startColor != null) : "startColor is null";
        assert (endMarker != null) : "endMarker is null";
        assert (endColor != null) : "endColor is null";
        double coronaWidth = 0.0;
        Polygon polygon = new Polygon(corners, false);
        this.polyline(polygon, lineThickness, lineColor, lineStyle, startMarker, startColor, startFillColor, startSize, endMarker, endColor, endFillColor, endSize, coronaWidth);
    }

    public void polyline(Polygon polygon, double lineThickness, Color lineColor, LineStyle lineStyle, LineMarker startMarker, LineMarker endMarker) {
        assert (polygon != null) : "polygon is null";
        assert (lineColor != null) : "lineColor is null";
        assert (lineStyle != null) : "lineStyle is null";
        assert (startMarker != null) : "startMarker is null";
        assert (endMarker != null) : "endMarker is null";
        Color startColor = lineColor;
        FillColor startFillColor = FillColor.TRANSPARENT;
        double startSize = 1.0;
        Color endColor = lineColor;
        FillColor endFillColor = FillColor.TRANSPARENT;
        double endSize = 1.0;
        double coronaWidth = 0.0;
        this.polyline(polygon, lineThickness, lineColor, lineStyle, startMarker, startColor, startFillColor, startSize, endMarker, endColor, endFillColor, endSize, coronaWidth);
    }

    public void polyline(Polygon polygon, double lineThickness, Color lineColor, LineStyle lineStyle, LineMarker startMarker, Color startColor, FillColor startFillColor, LineMarker endMarker) {
        assert (polygon != null) : "polygon is null";
        assert (lineColor != null) : "lineColor is null";
        assert (lineStyle != null) : "lineStyle is null";
        assert (startMarker != null) : "startMarker is null";
        assert (startColor != null) : "startColor is null";
        assert (endMarker != null) : "endMarker is null";
        double startSize = 1.0;
        Color endColor = lineColor;
        FillColor endFillColor = FillColor.TRANSPARENT;
        double endSize = 1.0;
        double coronaWidth = 0.0;
        this.polyline(polygon, lineThickness, lineColor, lineStyle, startMarker, startColor, startFillColor, startSize, endMarker, endColor, endFillColor, endSize, coronaWidth);
    }

    public void polyline(Polygon polygon, double lineThickness, Color lineColor, LineStyle lineStyle, LineMarker startMarker, double startSize, LineMarker endMarker) {
        assert (polygon != null) : "polygon is null";
        assert (lineColor != null) : "lineColor is null";
        assert (lineStyle != null) : "lineStyle is null";
        assert (startMarker != null) : "startMarker is null";
        assert (endMarker != null) : "endMarker is null";
        Color startColor = lineColor;
        FillColor startFillColor = FillColor.TRANSPARENT;
        Color endColor = lineColor;
        FillColor endFillColor = FillColor.TRANSPARENT;
        double endSize = 1.0;
        double coronaWidth = 0.0;
        this.polyline(polygon, lineThickness, lineColor, lineStyle, startMarker, startColor, startFillColor, startSize, endMarker, endColor, endFillColor, endSize, coronaWidth);
    }

    public void polyline(Polygon polygon, double lineThickness, Color lineColor, LineStyle lineStyle, LineMarker startMarker, LineMarker endMarker, Color endColor, FillColor endFillColor) {
        assert (polygon != null) : "polygon is null";
        assert (lineColor != null) : "lineColor is null";
        assert (lineStyle != null) : "lineStyle is null";
        assert (startMarker != null) : "startMarker is null";
        assert (endMarker != null) : "endMarker is null";
        assert (endColor != null) : "endColor is null";
        Color startColor = lineColor;
        FillColor startFillColor = FillColor.TRANSPARENT;
        double startSize = 1.0;
        double endSize = 1.0;
        double coronaWidth = 0.0;
        this.polyline(polygon, lineThickness, lineColor, lineStyle, startMarker, startColor, startFillColor, startSize, endMarker, endColor, endFillColor, endSize, coronaWidth);
    }

    public void polyline(Polygon polygon, double lineThickness, Color lineColor, LineStyle lineStyle, LineMarker startMarker, LineMarker endMarker, double endSize) {
        assert (polygon != null) : "polygon is null";
        assert (lineColor != null) : "lineColor is null";
        assert (lineStyle != null) : "lineStyle is null";
        assert (startMarker != null) : "startMarker is null";
        assert (endMarker != null) : "endMarker is null";
        Color startColor = lineColor;
        FillColor startFillColor = FillColor.TRANSPARENT;
        double startSize = 1.0;
        Color endColor = lineColor;
        FillColor endFillColor = FillColor.TRANSPARENT;
        double coronaWidth = 0.0;
        this.polyline(polygon, lineThickness, lineColor, lineStyle, startMarker, startColor, startFillColor, startSize, endMarker, endColor, endFillColor, endSize, coronaWidth);
    }

    public void polyline(Polygon polygon, double lineThickness, Color lineColor, LineStyle lineStyle, LineMarker startMarker, double startSize, LineMarker endMarker, double endSize) {
        assert (polygon != null) : "polygon is null";
        assert (lineColor != null) : "lineColor is null";
        assert (lineStyle != null) : "lineStyle is null";
        assert (startMarker != null) : "startMarker is null";
        assert (endMarker != null) : "endMarker is null";
        Color startColor = lineColor;
        FillColor startFillColor = FillColor.TRANSPARENT;
        Color endColor = lineColor;
        FillColor endFillColor = FillColor.TRANSPARENT;
        double coronaWidth = 0.0;
        this.polyline(polygon, lineThickness, lineColor, lineStyle, startMarker, startColor, startFillColor, startSize, endMarker, endColor, endFillColor, endSize, coronaWidth);
    }

    public void polyline(Polygon polygon, double lineThickness, Color lineColor, LineStyle lineStyle, LineMarker startMarker, Color startColor, FillColor startFillColor, LineMarker endMarker, Color endColor, FillColor endFillColor) {
        assert (polygon != null) : "polygon is null";
        assert (lineColor != null) : "lineColor is null";
        assert (lineStyle != null) : "lineStyle is null";
        assert (startMarker != null) : "startMarker is null";
        assert (startColor != null) : "startColor is null";
        assert (endMarker != null) : "endMarker is null";
        assert (endColor != null) : "endColor is null";
        double startSize = 1.0;
        double endSize = 1.0;
        double coronaWidth = 0.0;
        this.polyline(polygon, lineThickness, lineColor, lineStyle, startMarker, startColor, startFillColor, startSize, endMarker, endColor, endFillColor, endSize, coronaWidth);
    }

    public void polyline(Polygon polygon, double lineThickness, Color lineColor, LineStyle lineStyle, LineMarker startMarker, Color startColor, FillColor startFillColor, double startSize, LineMarker endMarker) {
        assert (polygon != null) : "polygon is null";
        assert (lineColor != null) : "lineColor is null";
        assert (lineStyle != null) : "lineStyle is null";
        assert (startMarker != null) : "startMarker is null";
        assert (startColor != null) : "startColor is null";
        assert (endMarker != null) : "endMarker is null";
        Color endColor = lineColor;
        FillColor endFillColor = FillColor.TRANSPARENT;
        double endSize = 1.0;
        double coronaWidth = 0.0;
        this.polyline(polygon, lineThickness, lineColor, lineStyle, startMarker, startColor, startFillColor, startSize, endMarker, endColor, endFillColor, endSize, coronaWidth);
    }

    public void polyline(Polygon polygon, double lineThickness, Color lineColor, LineStyle lineStyle, LineMarker startMarker, LineMarker endMarker, Color endColor, FillColor endFillColor, double endSize) {
        assert (polygon != null) : "polygon is null";
        assert (lineColor != null) : "lineColor is null";
        assert (lineStyle != null) : "lineStyle is null";
        assert (startMarker != null) : "startMarker is null";
        assert (endMarker != null) : "endMarker is null";
        assert (endColor != null) : "endColor is null";
        Color startColor = lineColor;
        FillColor startFillColor = FillColor.TRANSPARENT;
        double startSize = 1.0;
        double coronaWidth = 0.0;
        this.polyline(polygon, lineThickness, lineColor, lineStyle, startMarker, startColor, startFillColor, startSize, endMarker, endColor, endFillColor, endSize, coronaWidth);
    }

    public void polylineCorona(Polygon polygon, double lineThickness, Color lineColor, LineMarker startMarker, Color startColor, FillColor startFillColor, double startSize, LineMarker endMarker, Color endColor, FillColor endFillColor, double endSize, double coronaWidth) {
        assert (polygon != null) : "polygon is null";
        assert (lineColor != null) : "lineColor is null";
        assert (startMarker != null) : "startMarker is null";
        assert (startColor != null) : "startColor is null";
        assert (endMarker != null) : "endMarker is null";
        assert (endColor != null) : "endColor is null";
        LineStyle lineStyle = LineStyle.SOLID;
        this.polyline(polygon, lineThickness, lineColor, lineStyle, startMarker, startColor, startFillColor, startSize, endMarker, endColor, endFillColor, endSize, coronaWidth);
    }

    public void polyline(Polygon polygon, double lineThickness, Color lineColor, LineStyle lineStyle, LineMarker startMarker, Color startColor, FillColor startFillColor, double startSize, LineMarker endMarker, Color endColor, FillColor endFillColor, double endSize) {
        assert (polygon != null) : "polygon is null";
        assert (lineColor != null) : "lineColor is null";
        assert (lineStyle != null) : "lineStyle is null";
        assert (startMarker != null) : "startMarker is null";
        assert (startColor != null) : "startColor is null";
        assert (endMarker != null) : "endMarker is null";
        assert (endColor != null) : "endColor is null";
        double coronaWidth = 0.0;
        this.polyline(polygon, lineThickness, lineColor, lineStyle, startMarker, startColor, startFillColor, startSize, endMarker, endColor, endFillColor, endSize, coronaWidth);
    }

    private void polyline(Polygon polygon, double lineThickness, Color lineColor, LineStyle lineStyle, LineMarker startMarker, Color startColor, FillColor startFillColor, double startSize, LineMarker endMarker, Color endColor, FillColor endFillColor, double endSize, double coronaWidth) {
        double startSizeTemp = startSize;
        double endSizeTemp = endSize;
        assert (polygon != null) : "polygon is null";
        assert (lineColor != null) : "lineColor is null";
        assert (lineStyle != null) : "lineStyle is null";
        assert (startMarker != null) : "startMarker is null";
        assert (startColor != null) : "startColor is null";
        assert (endMarker != null) : "endMarker is null";
        assert (endColor != null) : "endColor is null";
        if (polygon.getPolygonCornerPointCount() >= 1) {
            if (polygon.getPolygonCornerPointCount() == 1) {
                this.transformAndDrawPolygon(polygon, lineThickness + 2.0 * coronaWidth, lineColor, lineStyle, 0.0, 0.0);
            } else {
                this.transformAndDrawPolygon(polygon, lineThickness + 2.0 * coronaWidth, lineColor, lineStyle, startMarker.arcLength(startSizeTemp *= lineThickness) + coronaWidth, endMarker.arcLength(endSizeTemp *= lineThickness) + coronaWidth);
                if (startMarker.getType() != 1 && !startColor.transparent) {
                    Point first = polygon.getPolygonCornerPoint(0);
                    Point first_next = polygon.point(startMarker.arcLength(startSizeTemp));
                    if (first_next == null) {
                        Line l = new Line(first, polygon.getPolygonCornerPoint(1));
                        first_next = l.getCenter();
                    }
                    double startAngle = 0.0;
                    if (GeoVector.getDistance(first_next, first) > 1.0E-10) {
                        startAngle = GeoVector.getDifferenceVectorAngle(first_next, first);
                    } else {
                        Point polygonCornerPoint1 = polygon.getPolygonCornerPoint(1);
                        if (GeoVector.getDistance(first, polygonCornerPoint1) > 1.0E-10) {
                            startAngle = GeoVector.getDifferenceVectorAngle(first, polygonCornerPoint1);
                        }
                    }
                    startMarker.draw(this, first, startColor, startSizeTemp, startFillColor, startAngle, coronaWidth);
                }
                if (endMarker.getType() != 1 && !endColor.transparent) {
                    double arcLength = polygon.arcLength();
                    Point last = polygon.getPolygonCornerPoint(polygon.getPolygonCornerPointCount() - 1);
                    Point last_prev = polygon.point(arcLength - endMarker.arcLength(endSizeTemp));
                    if (last_prev == null) {
                        Line l = new Line(last, polygon.getPolygonCornerPoint(polygon.getPolygonCornerPointCount() - 2));
                        last_prev = l.getCenter();
                    }
                    double endAngle = 0.0;
                    if (GeoVector.getDistance(last_prev, last) > 1.0E-10) {
                        endAngle = GeoVector.getDifferenceVectorAngle(last_prev, last);
                    } else {
                        Point polygonCornerPointNextToLast = polygon.getPolygonCornerPoint(polygon.getPolygonCornerPointCount() - 2);
                        if (GeoVector.getDistance(last, polygonCornerPointNextToLast) > 1.0E-10) {
                            endAngle = GeoVector.getDifferenceVectorAngle(last, polygonCornerPointNextToLast);
                        }
                    }
                    endMarker.draw(this, last, endColor, endSizeTemp, endFillColor, endAngle, coronaWidth);
                }
            }
        }
    }

    public void polyline(Polygon polygon, double lineThickness, Color lineColor, LineStyle lineStyle) {
        assert (polygon != null) : "polygon is null";
        assert (lineColor != null) : "lineColor is null";
        assert (lineStyle != null) : "lineStyle is null";
        this.polygonDraw(polygon, lineThickness, lineColor, lineStyle);
    }

    public void polygon(Corners corners, double lineThickness, Color lineColor, LineStyle lineStyle) {
        assert (corners != null) : "corners is null";
        assert (lineColor != null) : "lineColor is null";
        assert (lineStyle != null) : "lineStyle is null";
        Polygon polygon = new Polygon(corners, true);
        this.polygon(polygon, lineThickness, lineColor, lineStyle);
    }

    public void polygon(Corners corners, FillColor fillColor, FillStyle fillStyle) {
        assert (corners != null) : "corners is null";
        assert (fillColor != null) : "fillColor is null";
        assert (fillStyle != null) : "fillStyle is null";
        Polygon polygon = new Polygon(corners, true);
        this.polygon(polygon, fillColor, fillStyle);
    }

    public void polygon(Corners corners, FillColor fillColor, FillStyle fillStyle, double lineThickness, Color lineColor, LineStyle lineStyle) {
        assert (corners != null) : "corners is null";
        assert (fillColor != null) : "fillColor is null";
        assert (fillStyle != null) : "fillStyle is null";
        assert (lineColor != null) : "lineColor is null";
        assert (lineStyle != null) : "lineStyle is null";
        Polygon polygon = new Polygon(corners, true);
        this.polygon(polygon, fillColor, fillStyle, lineThickness, lineColor, lineStyle);
    }

    public void polygon(Polygon polygon, Color color, int alpha) {
        assert (polygon != null) : "polygon is null";
        assert (color != null) : "fillColor is null";
        assert (alpha >= 0 && alpha <= 255);
        this.transformAndFillPolygon(polygon, color, alpha);
    }

    public void polygon(Polygon polygon, FillColor fillColor, FillStyle fillStyle) {
        assert (polygon != null) : "polygon is null";
        assert (fillColor != null) : "fillColor is null";
        assert (fillStyle != null) : "fillStyle is null";
        fillStyle.draw(this, polygon, fillColor);
    }

    public void polygonCorona(Polygon polygon, double lineThickness, Color lineColor, double coronaWidth) {
        assert (polygon != null) : "polygon is null";
        assert (lineColor != null) : "lineColor is null";
        this.polygonDraw(polygon, lineThickness + 2.0 * coronaWidth, lineColor, LineStyle.SOLID);
    }

    public void polygon(Polygon polygon, double lineThickness, Color lineColor, LineStyle lineStyle) {
        assert (polygon != null) : "polygon is null";
        assert (lineColor != null) : "lineColor is null";
        assert (lineStyle != null) : "lineStyle is null";
        this.polygonDraw(polygon, lineThickness, lineColor, lineStyle);
    }

    public void polygon(Polygon polygon, FillColor fillColor, FillStyle fillStyle, double lineThickness, Color lineColor, LineStyle lineStyle) {
        assert (polygon != null) : "polygon is null";
        assert (fillColor != null) : "fillColor is null";
        assert (fillStyle != null) : "fillStyle is null";
        assert (lineColor != null) : "lineColor is null";
        assert (lineStyle != null) : "lineStyle is null";
        this.polygon(polygon, fillColor, fillStyle);
        this.polygon(polygon, lineThickness, lineColor, lineStyle);
    }

    public boolean supportsNullImage() {
        return this.driver.supportsNullImage();
    }

    public void image(IOffscreenBitmap image, Rectangle scaleToRectangle) {
        this.image(image, scaleToRectangle, 255);
    }

    public void image(IOffscreenBitmap image, Rectangle scaleToRectangle, int alpha) {
        int imageH;
        int imageW;
        assert (this.supportsNullImage() || image != null);
        assert (scaleToRectangle != null);
        if (image == null) {
            imageW = 1;
            imageH = 1;
        } else {
            imageW = image.getWidthInPixels();
            imageH = image.getHeightInPixels();
        }
        if (imageW > 0 && imageH > 0) {
            this.transformAndDrawImage(image, 0, 0, imageW, imageH, scaleToRectangle, alpha);
        }
    }

    public void image(IOffscreenBitmap image, int x, int y, int w, int h, Rectangle scaleToRectangle) {
        this.image(image, x, y, w, h, scaleToRectangle, 255);
    }

    public void image(IOffscreenBitmap image, int x, int y, int w, int h, Rectangle scaleToRectangle, int alpha) {
        int imageH;
        int imageW;
        assert (this.supportsNullImage() || image != null);
        assert (scaleToRectangle != null);
        if (image == null) {
            imageW = x + w;
            imageH = y + h;
        } else {
            imageW = image.getWidthInPixels();
            imageH = image.getHeightInPixels();
        }
        if (imageW > 0 && imageH > 0) {
            assert (x >= 0);
            assert (y >= 0);
            assert (w > 0);
            assert (h > 0);
            assert (x < imageW);
            assert (y < imageH);
            assert (w <= imageW - x);
            assert (h <= imageH - y);
            this.transformAndDrawImage(image, x, y, w, h, scaleToRectangle, alpha);
        }
    }

    protected void polygonDraw(Polygon polygon, double lineThickness, Color lineColor, LineStyle lineStyle) {
        this.transformAndDrawPolygon(polygon, lineThickness, lineColor, lineStyle, 0.0, 0.0);
    }

    public void disposeDriver() {
        this.driver.dispose();
    }

    private synchronized void transformAndDrawPolygon(Polygon polygon, double lineThickness, Color lineColor, LineStyle lineStyle, double skipAtBeginning, double skipAtEnd) {
        double lineThicknessTransformed;
        double skipAtBeginningTemp = skipAtBeginning;
        double skipAtEndTemp = skipAtEnd;
        if (lineStyle != LineStyle.NONE && !lineColor.transparent && lineThickness > 1.0E-10 && (lineThicknessTransformed = new GeoVector(0.0, lineThickness).turn(45.0).transform(Point.ORIGIN, this.transformationAppliedByDevice).abs()) > 1.0E-10) {
            Polygon polygonTransformed = polygon.getTransformedPolygon(this.transformationAppliedByDevice);
            this.driver.setLineStyle(lineStyle);
            this.driver.setLineColor(lineColor);
            this.driver.setLineWidth(lineThicknessTransformed);
            this.driver.setLineScale(lineThicknessTransformed);
            if (polygonTransformed.isClosed()) {
                this.driver.polygon(polygonTransformed);
            } else {
                int corners = polygon.getPolygonCornerPointCount();
                if (corners >= 2) {
                    GeoVector skipAtBeginningV = new GeoVector(polygon.getPolygonCornerPoint(0), polygon.getPolygonCornerPoint(1));
                    GeoVector skipAtEndV = new GeoVector(polygon.getPolygonCornerPoint(corners - 1), polygon.getPolygonCornerPoint(corners - 2));
                    if (skipAtBeginningV.abs() > 1.0E-10) {
                        skipAtBeginningV = skipAtBeginningV.scaleToLength(skipAtBeginningTemp);
                    }
                    if (skipAtEndV.abs() > 1.0E-10) {
                        skipAtEndV = skipAtEndV.scaleToLength(skipAtEndTemp);
                    }
                    skipAtBeginningTemp = skipAtBeginningV.transform(polygon.getPolygonCornerPoint(0), this.transformationAppliedByDevice).abs();
                    skipAtEndTemp = skipAtEndV.transform(polygon.getPolygonCornerPoint(corners - 1), this.transformationAppliedByDevice).abs();
                } else {
                    skipAtBeginningTemp = 0.0;
                    skipAtEndTemp = 0.0;
                }
                this.driver.polyline(polygonTransformed, skipAtBeginningTemp, skipAtEndTemp);
            }
        }
    }

    private synchronized void transformAndFillPolygon(Polygon polygon, Color color, int alpha) {
        this.driver.setFillAttributes(color, alpha);
        this.driver.fill(polygon.getTransformedPolygon(this.transformationAppliedByDevice));
    }

    private synchronized double transformAndGetTransformedTextLength(String text, TextStyle textStyle, double textHeight, int numberOfLines) {
        double textLength;
        double textLengthTransformed;
        Point lowerRightTransformed;
        Point lowerLeftTransformed;
        double rLengthTransformed;
        assert (text != null) : "text is null";
        assert (textStyle != null) : "textStyle is null";
        assert (textHeight > 0.0) : "textHeight not greater 0";
        IFont currentFont = Device.updateFont(textStyle);
        double transformedTextHeight = this.getTransformedTextHeight(textHeight);
        List textLines = StringUtil.splitTextLines((String)text);
        if (textLines.size() == 1 && ((String)textLines.get(0)).length() == 0) {
            textLines = Collections.emptyList();
        }
        if (Math.abs(rLengthTransformed = new GeoVector(lowerLeftTransformed = Point.ORIGIN, lowerRightTransformed = new Point(textLengthTransformed = Device.getTextLengthForMultiLineText(currentFont, transformedTextHeight, textLines, numberOfLines), 0.0)).abs()) > 1.0E-10) {
            double rLength = new GeoVector(lowerLeftTransformed, lowerRightTransformed).transform(lowerLeftTransformed, this.transformationAppliedByDevice.getInverse()).abs();
            textLength = textLengthTransformed * rLength / rLengthTransformed;
        } else {
            textLength = 0.0;
        }
        return textLength;
    }

    private double transformAndGetTransformedTextLength(String text, TextStyle textStyle, double textHeight) {
        double textLength;
        assert (text != null) : "text is null";
        assert (textStyle != null) : "textStyle is null";
        assert (textHeight > 0.0) : "textHeight not greater 0";
        IFont currentFont = Device.updateFont(textStyle);
        double transformedTextHeight = this.getTransformedTextHeight(textHeight);
        double textLengthTransformed = 0.0;
        List<String> lines = StringUtil.splitTextLines((String)text);
        if (lines.size() == 1 && ((String)lines.get(0)).length() == 0) {
            lines = Collections.emptyList();
        }
        for (String currentLine : lines) {
            textLengthTransformed = Math.max(textLengthTransformed, currentFont.getTextLength(currentLine) * transformedTextHeight);
        }
        Point lowerLeftTransformed = Point.ORIGIN;
        Point lowerRightTransformed = new Point(textLengthTransformed, 0.0);
        double rLengthTransformed = new GeoVector(lowerLeftTransformed, lowerRightTransformed).abs();
        if (Math.abs(rLengthTransformed) > 1.0E-10) {
            double rLength = new GeoVector(lowerLeftTransformed, lowerRightTransformed).transform(lowerLeftTransformed, this.transformationAppliedByDevice.getInverse()).abs();
            textLength = textLengthTransformed * rLength / rLengthTransformed;
        } else {
            textLength = 0.0;
        }
        return textLength;
    }

    private synchronized double transformAndGetTransformedTextLineHeight(TextStyle textStyle, double textHeight) {
        double textLineHeight;
        assert (textStyle != null) : "textStyle is null";
        assert (textHeight > 0.0) : "textHeight not greater 0";
        Device.updateFont(textStyle);
        double textLineHeightTransformed = this.getTransformedTextHeight(textHeight);
        Point upperLeftTransformed = Point.ORIGIN;
        Point lowerLeftTransformed = new Point(0.0, textLineHeightTransformed);
        double rLineHeightTransformed = new GeoVector(upperLeftTransformed, lowerLeftTransformed).abs();
        if (Math.abs(rLineHeightTransformed) > 1.0E-10) {
            double rLineHeight = new GeoVector(upperLeftTransformed, lowerLeftTransformed).transform(upperLeftTransformed, this.transformationAppliedByDevice.getInverse()).abs();
            textLineHeight = textLineHeightTransformed * rLineHeight / rLineHeightTransformed;
        } else {
            textLineHeight = 0.0;
        }
        return textLineHeight;
    }

    private double getTransformedTextHeight(double textHeight) {
        double transformedTextHeight;
        Point lowerLeft = Point.ORIGIN;
        Point upperLeft = Point.Point_0_minus1;
        double rTextHeight = new GeoVector(lowerLeft, upperLeft).abs();
        if (Math.abs(rTextHeight) > 1.0E-10) {
            double rTextHeightTransformed = new GeoVector(lowerLeft, upperLeft).transform(lowerLeft, this.transformationAppliedByDevice).abs();
            transformedTextHeight = textHeight * rTextHeightTransformed / rTextHeight;
        } else {
            transformedTextHeight = 0.0;
        }
        return transformedTextHeight;
    }

    private static double getTextLengthForMultiLineText(IFont currentFont, double textLineHeight, List<String> textLines, int numberOfLines) {
        double unwrappedTextLength = 0.0;
        for (String line : textLines) {
            unwrappedTextLength = Math.max(unwrappedTextLength, currentFont.getTextLength(line) * textLineHeight);
        }
        if (numberOfLines == 1) {
            return unwrappedTextLength;
        }
        double maxLengthCandidate = unwrappedTextLength / (double)numberOfLines;
        List<String> lines = Device.wrapText(currentFont, textLineHeight, textLines, maxLengthCandidate);
        while (lines.size() > numberOfLines) {
            double shortestParticleLength = Double.POSITIVE_INFINITY;
            int i = 1;
            while (i < lines.size()) {
                String line = lines.get(i);
                List lineElements = StringUtil.wrapTextLine((String)line);
                String firstParticle = ((String)lineElements.get(0)).trim();
                int j = 0;
                while (firstParticle.length() == 0 && j < lineElements.size()) {
                    firstParticle = ((String)lineElements.get(j)).trim();
                    ++j;
                }
                double firstParticleLength = currentFont.getTextLength(firstParticle) * textLineHeight;
                if (firstParticleLength > 1.0E-10 && firstParticleLength < shortestParticleLength) {
                    shortestParticleLength = firstParticleLength;
                }
                ++i;
            }
            lines = Device.wrapText(currentFont, textLineHeight, textLines, maxLengthCandidate += shortestParticleLength + shortestParticleLength * 0.05);
        }
        double longestLineLength = 0.0;
        for (String line : lines) {
            double lineLength = currentFont.getTextLength(line) * textLineHeight;
            if (!(lineLength > longestLineLength)) continue;
            longestLineLength = lineLength;
        }
        return longestLineLength;
    }

    private synchronized int transformAndGetNumberOfTextLines(String text, TextStyle textStyle, double textHeight, double width) {
        double widthTransformed;
        if (Math.abs(width) > 1.0E-10) {
            Point lowerLeft = Point.ORIGIN;
            Point lowerRight = new Point(width, 0.0);
            widthTransformed = new GeoVector(lowerLeft, lowerRight).transform(lowerLeft, this.transformationAppliedByDevice).abs();
        } else {
            widthTransformed = 0.0;
        }
        IFont currentFont = Device.updateFont(textStyle);
        double lineHeightTransformed = this.getTransformedTextHeight(textHeight);
        List<String> textLines = Device.wrapTextLinesTransformed(currentFont, lineHeightTransformed, text, widthTransformed);
        return textLines.size();
    }

    private synchronized void transformAndDrawText(TurnedRectangle r, Alignment a, String text, TextStyle textStyle, double lineHeight, Color textColor, boolean wrap) {
        if (!textColor.transparent && lineHeight > 1.0E-10) {
            Point upperLeft = r.getUpperLeft();
            Point lowerLeft = r.getLowerLeft();
            Point upperRight = r.getUpperRight();
            Point lowerRight = r.getLowerRight();
            Point transformedUpperLeft = upperLeft.transform(this.transformationAppliedByDevice);
            Point transformedUpperRight = upperRight.transform(this.transformationAppliedByDevice);
            Point transformedLowerLeft = lowerLeft.transform(this.transformationAppliedByDevice);
            Point transformedLowerRight = lowerRight.transform(this.transformationAppliedByDevice);
            TurnedRectangle clippingR = r.transform(this.transformationAppliedByDevice);
            if (this.driver.isNotInterestedInRealTextDrawing()) {
                this.driver.text(transformedUpperLeft, 0.0, "", clippingR);
            } else {
                double transformedLineHeight;
                GeoVector transformedUpperBorder = new GeoVector(transformedUpperLeft, transformedUpperRight);
                GeoVector transformedLowerBorder = new GeoVector(transformedLowerLeft, transformedLowerRight);
                GeoVector transformedLeftBorder = new GeoVector(transformedUpperLeft, transformedLowerLeft);
                GeoVector transformedRightBorder = new GeoVector(transformedUpperRight, transformedLowerRight);
                GeoVector leftBorder = new GeoVector(upperLeft, lowerLeft);
                double rHeight = leftBorder.abs();
                if (Math.abs(rHeight) > 1.0E-10) {
                    double rHeightTransformed = transformedLeftBorder.abs();
                    transformedLineHeight = lineHeight * rHeightTransformed / rHeight;
                } else {
                    transformedLineHeight = 0.0;
                }
                if (transformedLineHeight > 1.0E-10) {
                    IFont currentFont = Device.updateFont(textStyle);
                    double transformedTextTop = currentFont.getTextTop() * transformedLineHeight;
                    double transformedTextAscent = currentFont.getTextAscent() * transformedLineHeight;
                    double transformedTextDescent = currentFont.getTextDescent() * transformedLineHeight;
                    this.driver.setTextSize(transformedLineHeight, transformedTextTop, transformedTextAscent, transformedTextDescent);
                    this.driver.setTextAlignment(a.h);
                    this.driver.setTextColor(textColor);
                    this.driver.setTextFontName(textStyle.getFontName());
                    this.driver.setTextBold(textStyle.isBold());
                    this.driver.setTextItalic(textStyle.isItalic());
                    double lineLengthMax = Math.min(transformedUpperBorder.abs(), transformedLowerBorder.abs());
                    List<String> textLines = wrap ? Device.wrapTextLinesTransformed(currentFont, transformedLineHeight, text, lineLengthMax) : StringUtil.splitTextLines((String)text);
                    int lines = textLines.size();
                    if (lines > 1 || lines == 1 && textLines.get(0).length() > 0) {
                        Point lineStartRight;
                        Point lineStartLeft;
                        GeoVector lineOffsetRightForBottom;
                        GeoVector lineOffsetRightForTop;
                        GeoVector lineStepRightLineHeight;
                        GeoVector lineFirstLineRightFromTop;
                        GeoVector lineFirstLineRightHeight;
                        GeoVector lineOffsetLeftForBottom;
                        GeoVector lineOffsetLeftForTop;
                        GeoVector lineStepLeftLineHeight;
                        GeoVector lineFirstLineLeftFromTop;
                        GeoVector lineFirstLineLeftHeight;
                        double transformedFirstLineHeight = (currentFont.getTextTop() - currentFont.getTextDescent()) * transformedLineHeight;
                        double transformedFirstLineFromTop = currentFont.getTextTop() * transformedFirstLineHeight;
                        double offsetForTop = 0.0;
                        double offsetForBottom = 0.0;
                        if (transformedLeftBorder.abs() > 1.0E-10) {
                            lineFirstLineLeftHeight = transformedLeftBorder.scaleToLength(transformedFirstLineHeight);
                            lineFirstLineLeftFromTop = transformedLeftBorder.scaleToLength(transformedFirstLineFromTop);
                            lineStepLeftLineHeight = transformedLeftBorder.scaleToLength(transformedLineHeight);
                            lineOffsetLeftForTop = transformedLeftBorder.scaleToLength(offsetForTop);
                            lineOffsetLeftForBottom = transformedLeftBorder.scaleToLength(offsetForBottom);
                        } else {
                            lineFirstLineLeftHeight = GeoVector.NULL;
                            lineFirstLineLeftFromTop = GeoVector.NULL;
                            lineStepLeftLineHeight = GeoVector.NULL;
                            lineOffsetLeftForTop = GeoVector.NULL;
                            lineOffsetLeftForBottom = GeoVector.NULL;
                        }
                        GeoVector leftTotal = GeoVector.add(lineFirstLineLeftHeight, lineStepLeftLineHeight.scale(lines - 1));
                        if (transformedRightBorder.abs() > 1.0E-10) {
                            lineFirstLineRightHeight = transformedRightBorder.scaleToLength(transformedFirstLineHeight);
                            lineFirstLineRightFromTop = transformedRightBorder.scaleToLength(transformedFirstLineFromTop);
                            lineStepRightLineHeight = transformedRightBorder.scaleToLength(transformedLineHeight);
                            lineOffsetRightForTop = transformedRightBorder.scaleToLength(offsetForTop);
                            lineOffsetRightForBottom = transformedRightBorder.scaleToLength(offsetForBottom);
                        } else {
                            lineFirstLineRightHeight = GeoVector.NULL;
                            lineFirstLineRightFromTop = GeoVector.NULL;
                            lineStepRightLineHeight = GeoVector.NULL;
                            lineOffsetRightForTop = GeoVector.NULL;
                            lineOffsetRightForBottom = GeoVector.NULL;
                        }
                        GeoVector rightTotal = GeoVector.add(lineFirstLineRightHeight, lineStepRightLineHeight.scale(lines - 1));
                        switch (a.v) {
                            case 8: {
                                lineStartLeft = transformedUpperLeft.movePoint(lineFirstLineLeftFromTop).movePoint(lineOffsetLeftForTop);
                                lineStartRight = transformedUpperRight.movePoint(lineFirstLineRightFromTop).movePoint(lineOffsetRightForTop);
                                break;
                            }
                            case 32: {
                                lineStartLeft = transformedLowerLeft.movePoint(GeoVector.add(leftTotal.turn180(), lineFirstLineLeftFromTop)).movePoint(lineOffsetLeftForBottom);
                                lineStartRight = transformedLowerRight.movePoint(GeoVector.add(rightTotal.turn180(), lineFirstLineRightFromTop)).movePoint(lineOffsetRightForBottom);
                                break;
                            }
                            default: {
                                lineStartLeft = transformedUpperLeft.movePoint(GeoVector.add(GeoVector.add(transformedLeftBorder, leftTotal.turn180()).scale(0.5), lineFirstLineLeftFromTop));
                                lineStartRight = transformedUpperRight.movePoint(GeoVector.add(GeoVector.add(transformedRightBorder, rightTotal.turn180()).scale(0.5), lineFirstLineRightFromTop));
                            }
                        }
                        Point currentPositionLeft = lineStartLeft;
                        Point currentPositionRight = lineStartRight;
                        int line = 0;
                        while (line < lines) {
                            Point currentPosition;
                            Direction textDirection;
                            GeoVector textOffsetRight;
                            GeoVector textOffsetLeft;
                            String lineText = StringUtil.removeLineBreaksAndControlCharacters((String)textLines.get(line));
                            double textLength = currentFont.getTextLength(lineText) * transformedLineHeight;
                            GeoVector lineBaseline = new GeoVector(currentPositionLeft, currentPositionRight);
                            if (lineBaseline.abs() > 1.0E-10) {
                                textOffsetLeft = lineBaseline.scaleToLength(currentFont.getLeftOffset() * transformedLineHeight);
                                textOffsetRight = lineBaseline.scaleToLength(currentFont.getRightOffset() * transformedLineHeight);
                                textDirection = lineBaseline.getDirection();
                            } else {
                                textOffsetLeft = GeoVector.NULL;
                                textOffsetRight = GeoVector.NULL;
                                textDirection = r.getDirection();
                            }
                            switch (a.h) {
                                case 1: {
                                    currentPosition = currentPositionLeft.movePoint(textOffsetLeft);
                                    break;
                                }
                                case 2: {
                                    currentPosition = currentPositionLeft.movePoint(lineBaseline.scale(0.5));
                                    break;
                                }
                                case 4: {
                                    currentPosition = currentPositionRight.movePoint(textOffsetRight.turn180());
                                    break;
                                }
                                default: {
                                    currentPosition = currentPositionLeft.movePoint(lineBaseline.scale(0.5));
                                }
                            }
                            this.driver.setTextDirection(textDirection);
                            this.driver.text(currentPosition, textLength, lineText, clippingR);
                            currentPositionLeft = currentPositionLeft.movePoint(lineStepLeftLineHeight);
                            currentPositionRight = currentPositionRight.movePoint(lineStepRightLineHeight);
                            ++line;
                        }
                    }
                }
            }
        }
    }

    private void drawTextDebuggingMarker(IFont currentFont, Point p, Direction direction, int alignment, String text, double textLineHeigth) {
        double xOffset;
        GeoVector length = new GeoVector(currentFont.getTextLength(text) * textLineHeigth, 0.0).turn(direction.getAngle());
        GeoVector leftLength = new GeoVector(-currentFont.getLeftOffset() * textLineHeigth, 0.0).turn(direction.getAngle());
        GeoVector rightLength = new GeoVector(currentFont.getRightOffset() * textLineHeigth, 0.0).turn(direction.getAngle());
        switch (alignment) {
            case 2: {
                xOffset = -length.abs() / 2.0;
                break;
            }
            case 4: {
                xOffset = -length.abs();
                break;
            }
            default: {
                xOffset = 0.0;
            }
        }
        GeoVector offset = new GeoVector(xOffset, 0.0).turn(direction.getAngle());
        Point beginBase = p.movePoint(offset);
        GeoVector lineDistance = new GeoVector(0.0, textLineHeigth).turn(direction.getAngle());
        Point beginTop = beginBase.movePoint(lineDistance.scale(-currentFont.getTextTop()));
        Point beginAscent = beginBase.movePoint(lineDistance.scale(-currentFont.getTextAscent()));
        Point beginHalf = beginBase.movePoint(lineDistance.scale(-currentFont.getTextHalf()));
        Point beginDecent = beginBase.movePoint(lineDistance.scale(-currentFont.getTextDescent()));
        Point beginBottom = beginTop.movePoint(lineDistance);
        Point endTop = beginTop.movePoint(length);
        Point endAscent = beginAscent.movePoint(length);
        Point endHalf = beginHalf.movePoint(length);
        Point endBase = beginBase.movePoint(length);
        Point endDecent = beginDecent.movePoint(length);
        Point endBottom = beginBottom.movePoint(length);
        Point beginLeft = beginBottom.movePoint(leftLength);
        Point endLeft = beginTop.movePoint(leftLength);
        Point beginRight = endBottom.movePoint(rightLength);
        Point endRight = endTop.movePoint(rightLength);
        Line top = new Line(beginTop, endTop);
        Line ascent = new Line(beginAscent, endAscent);
        Line half = new Line(beginHalf, endHalf);
        Line base = new Line(beginBase, endBase);
        Line decent = new Line(beginDecent, endDecent);
        Line bottom = new Line(beginBottom, endBottom);
        Line left = new Line(beginLeft, endLeft);
        Line right = new Line(beginRight, endRight);
        this.drawDebuggingLine(top);
        this.drawDebuggingLine(ascent);
        this.drawDebuggingLine(half);
        this.drawDebuggingLine(base);
        this.drawDebuggingLine(decent);
        this.drawDebuggingLine(bottom);
        this.drawDebuggingLine(left);
        this.drawDebuggingLine(right);
    }

    private void drawDebuggingRectangle(Rectangle rectangle, double width) {
        this.drawDebuggingPolyline(rectangle.toPoints(), width);
    }

    private void drawDebuggingRectangle(TurnedRectangle rectangle, double width) {
        this.drawDebuggingPolyline(rectangle.toPoints(), width);
    }

    private void drawDebuggingPolyline(Points points, double width) {
        this.driver.setLineScale(1.0);
        this.driver.setLineStyle(LineStyle.SOLID);
        this.driver.setLineWidth(new GeoVector(0.2 * width, 0.0).transform(Point.ORIGIN, this.transformationAppliedByDevice).abs());
        if (width > 6.0) {
            this.driver.setLineColor(Color.RED);
        } else if (width < 3.0) {
            this.driver.setLineColor(Color.ORANGE);
        } else {
            this.driver.setLineColor(Color.BLUE);
        }
        Corners marker = new Corners(points, 0.0);
        Polygon polyline = new Polygon(marker, true);
        this.driver.polygon(polyline);
    }

    private void drawDebuggingLine(Line line) {
        this.driver.setLineScale(1.0);
        this.driver.setLineStyle(LineStyle.SOLID);
        this.driver.setLineWidth(1.0);
        this.driver.setLineColor(Color.GREEN);
        Corners marker = new Corners();
        marker.add(new Corner(line.start, 0.0));
        marker.add(new Corner(line.end, 0.0));
        Polygon polyline = new Polygon(marker, false);
        this.driver.polyline(polyline, 0.0, 0.0);
    }

    private static List<String> wrapTextLinesTransformed(IFont currentFont, double textLineHeight, String text, double lineLengthMax) {
        List<String> textLines;
        List<String> textLinesUnwrapped = StringUtil.splitTextLines((String)text);
        if (textLinesUnwrapped.size() == 1 && ((String)textLinesUnwrapped.get(0)).length() == 0) {
            textLinesUnwrapped = Collections.emptyList();
        }
        if (lineLengthMax > 1.0E-10) {
            textLines = new ArrayList<String>(textLinesUnwrapped.size() * 3);
            for (String line : textLinesUnwrapped) {
                List<String> wrappedLines = Device.wrapText(currentFont, textLineHeight, line, lineLengthMax);
                textLines.addAll(wrappedLines);
            }
        } else {
            textLines = textLinesUnwrapped;
        }
        return textLines;
    }

    private static List<String> wrapText(IFont currentFont, double textLineHeight, List<String> textLinesToWrap, double maxWidth) {
        ArrayList<String> newLines = new ArrayList<String>();
        for (String line : textLinesToWrap) {
            newLines.addAll(Device.wrapText(currentFont, textLineHeight, line, maxWidth));
        }
        return newLines;
    }

    private static List<String> wrapText(IFont currentFont, double textLineHeight, String textToWrap, double maxWidth) {
        List lineElements = StringUtil.wrapTextLine((String)textToWrap);
        ArrayList<String> wrappedTextLines = new ArrayList<String>(lineElements.size());
        String currentLine = null;
        for (String lineElement : lineElements) {
            String lineToTest = currentLine == null ? lineElement.trim() : (String.valueOf(currentLine) + lineElement).trim();
            double length = (currentFont.getLeftOffset() + currentFont.getTextLength(lineToTest) + currentFont.getRightOffset()) * textLineHeight;
            if (currentLine != null && length >= maxWidth) {
                Device.addTrimmedLine(currentLine, wrappedTextLines);
                currentLine = lineElement;
                continue;
            }
            currentLine = currentLine == null ? lineElement : String.valueOf(currentLine) + lineElement;
        }
        if (currentLine != null) {
            Device.addTrimmedLine(currentLine, wrappedTextLines);
        }
        return wrappedTextLines;
    }

    private static void addTrimmedLine(String lineToAdd, List<String> lines) {
        String trimmedLine = lineToAdd.trim();
        lines.add(trimmedLine);
    }

    private synchronized void transformAndDrawImage(IOffscreenBitmap image, int sourceX, int sourceY, int sourceW, int sourceH, Rectangle targetRectangle, int alpha) {
        TurnedRectangle turnedRectangle = new TurnedRectangle(targetRectangle);
        TurnedRectangle transformedTargetRectangle = turnedRectangle.transform(this.transformationAppliedByDevice);
        this.driver.drawImage(image, sourceX, sourceY, sourceW, sourceH, transformedTargetRectangle, alpha);
    }

    private static IFont updateFont(TextStyle newTextStyle) {
        TextStyle currentTextStyle = currentTextStyleThreadLocal.get();
        IFont currentFont = currentFontThreadLocal.get();
        if (currentTextStyle == null || !currentTextStyle.isEqualTextStyle(newTextStyle)) {
            if (currentFont != null) {
                currentFont.dispose();
            }
            currentTextStyle = newTextStyle;
            currentTextStyleThreadLocal.set(currentTextStyle);
            try {
                IRenderer renderer = DefaultRendererExtensionPoint.getInstance().getDefaultRendererManager().getDefaultRendererOfCurrentThread();
                currentFont = renderer.createFont(currentTextStyle);
                currentFontThreadLocal.set(currentFont);
            }
            catch (EXNoMoreHandles e) {
                throw new RuntimeException(e);
            }
        }
        return currentFont;
    }
}

