/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.geometry;

import com.arcway.lib.geometry.Arc;
import com.arcway.lib.geometry.Direction;
import com.arcway.lib.geometry.Line;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.Ray;
import com.arcway.lib.geometry.polygon.PolygonProcessor;

public class InterceptRayPolygonProcessor
extends PolygonProcessor {
    private final Ray ray;
    private final Points interceptPoints = new Points(50);

    public InterceptRayPolygonProcessor(Ray ray) {
        this.ray = ray;
    }

    @Override
    public void processArc(Direction comingFrom, Arc arc, Direction goingTo) {
        this.interceptPoints.addAll(this.ray.getInterceptPoints(arc));
    }

    @Override
    public void processLine(Direction comingFrom, Line line, Direction goingTo) {
        if (this.ray.isParallel(line)) {
            boolean startPointIsOnRay = this.ray.isOnRay(line.start);
            boolean endPointIsOnRay = this.ray.isOnRay(line.end);
            if (startPointIsOnRay && endPointIsOnRay) {
                this.interceptPoints.add(line.start);
                this.interceptPoints.add(line.end);
            } else if (startPointIsOnRay) {
                this.interceptPoints.add(line.start);
                this.interceptPoints.add(this.ray.getEntryPoint());
            } else if (endPointIsOnRay) {
                this.interceptPoints.add(line.end);
                this.interceptPoints.add(this.ray.getEntryPoint());
            }
        } else {
            Point iPoint = this.ray.getInterceptPoint(line);
            if (iPoint != null) {
                this.interceptPoints.add(iPoint);
            }
        }
    }

    @Override
    public void processPoint(Point point) {
        if (this.ray.isOnRay(point)) {
            this.interceptPoints.add(Point.getAsPoint(point));
        }
    }

    public Points getInterceptPoints() {
        return this.interceptPoints;
    }
}

