/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.logging;

import com.arcway.lib.logging.ILogger;

public class StdOutStdErrLogger
implements ILogger {
    private static final boolean fatal_enabled;
    private static final boolean error_enabled;
    private static final boolean warn_enabled;
    private static final boolean info_enabled;
    private static final boolean debug_enabled;
    private static final boolean debug_all_enabled;
    private final String loggerName;

    static {
        String level;
        try {
            level = System.getProperty("com.arcway.lib.logging.StdOutStdErrLogger.level");
        }
        catch (Exception e) {
            level = null;
        }
        if ("DISABLED".equals(level)) {
            fatal_enabled = false;
            error_enabled = false;
            warn_enabled = false;
            info_enabled = false;
            debug_enabled = false;
            debug_all_enabled = false;
        } else if ("FATAL".equals(level)) {
            fatal_enabled = true;
            error_enabled = false;
            warn_enabled = false;
            info_enabled = false;
            debug_enabled = false;
            debug_all_enabled = false;
        } else if ("ERROR".equals(level)) {
            fatal_enabled = true;
            error_enabled = true;
            warn_enabled = false;
            info_enabled = false;
            debug_enabled = false;
            debug_all_enabled = false;
        } else if ("WARN".equals(level)) {
            fatal_enabled = true;
            error_enabled = true;
            warn_enabled = true;
            info_enabled = false;
            debug_enabled = false;
            debug_all_enabled = false;
        } else if ("INFO".equals(level)) {
            fatal_enabled = true;
            error_enabled = true;
            warn_enabled = true;
            info_enabled = true;
            debug_enabled = false;
            debug_all_enabled = false;
        } else if ("DEBUG".equals(level)) {
            fatal_enabled = true;
            error_enabled = true;
            warn_enabled = true;
            info_enabled = true;
            debug_enabled = true;
            debug_all_enabled = false;
        } else if ("DEBUG_ALL".equals(level)) {
            fatal_enabled = true;
            error_enabled = true;
            warn_enabled = true;
            info_enabled = true;
            debug_enabled = true;
            debug_all_enabled = true;
        } else {
            fatal_enabled = true;
            error_enabled = true;
            warn_enabled = true;
            info_enabled = false;
            debug_enabled = false;
            debug_all_enabled = false;
        }
    }

    public StdOutStdErrLogger(String loggerName) {
        this.loggerName = loggerName;
    }

    public StdOutStdErrLogger(Class<?> clazz) {
        this.loggerName = clazz.getName();
    }

    @Override
    public void trace(String message) {
    }

    @Override
    public void debug(int debugCategory, String message) {
        if (debug_enabled) {
            System.err.println("[DEBUG-" + debugCategory + "] " + this.loggerName + ": " + message);
        }
    }

    @Override
    public void debug(String message) {
        if (debug_enabled) {
            System.err.println("[DEBUG] " + this.loggerName + ": " + message);
        }
    }

    @Override
    public void debug(String message, Throwable t) {
        if (debug_enabled) {
            System.err.println("[DEBUG] " + this.loggerName + ": " + message);
            t.printStackTrace();
        }
    }

    @Override
    public void debug(int debugCategory, String message, Throwable t) {
        if (debug_enabled) {
            System.err.println("[DEBUG-" + debugCategory + "] " + this.loggerName + ": " + message);
            t.printStackTrace();
        }
    }

    @Override
    public void error(String message) {
        if (error_enabled) {
            System.err.println("[ERROR] " + this.loggerName + ": " + message);
            new Exception().printStackTrace(System.err);
        }
    }

    @Override
    public void error(String message, Throwable t) {
        if (error_enabled) {
            System.err.println("[ERROR] " + this.loggerName + ": " + message);
            t.printStackTrace();
        }
    }

    @Override
    public void error(Throwable t) {
        if (error_enabled) {
            System.err.println("[ERROR] " + this.loggerName + ": ");
            t.printStackTrace();
        }
    }

    @Override
    public void fatal(String message) {
        if (fatal_enabled) {
            System.err.println("[FATAL] " + this.loggerName + ": " + message);
            new Exception().printStackTrace(System.err);
        }
    }

    @Override
    public void fatal(String message, Throwable t) {
        if (fatal_enabled) {
            System.err.println("[FATAL] " + this.loggerName + ": " + message);
            t.printStackTrace();
        }
    }

    @Override
    public void fatal(Throwable t) {
        if (fatal_enabled) {
            System.err.println("[FATAL] " + this.loggerName + ": ");
            t.printStackTrace();
        }
    }

    @Override
    public void info(String message) {
        if (info_enabled) {
            System.err.println("[INFO] " + this.loggerName + ": " + message);
        }
    }

    @Override
    public void info(String message, Throwable t) {
        if (info_enabled) {
            System.err.println("[INFO] " + this.loggerName + ": " + message);
            t.printStackTrace();
        }
    }

    @Override
    public void warn(String message) {
        if (warn_enabled) {
            System.err.println("[WARNING] " + this.loggerName + ": " + message);
            new Exception().printStackTrace(System.err);
        }
    }

    @Override
    public void warn(String message, Throwable t) {
        if (warn_enabled) {
            System.err.println("[WARNING] " + this.loggerName + ": " + message);
            t.printStackTrace();
        }
    }

    @Override
    public void warn(Throwable t) {
        if (warn_enabled) {
            System.err.println("[WARNING] " + this.loggerName + ": ");
            t.printStackTrace();
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return info_enabled;
    }

    @Override
    public boolean isDebugEnabled() {
        return debug_enabled;
    }

    @Override
    public boolean isDebugEnabled(int debugCategory) {
        return debug_all_enabled;
    }

    @Override
    public boolean isTraceEnabled() {
        return false;
    }
}

