/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.uiframework.widgets;

import com.arcway.lib.eclipse.uiframework.widgets.AbstractDataWidget;
import com.arcway.lib.eclipse.uiframework.widgets.IEclipseCompositeWidget;
import com.arcway.lib.java.collections.ISortedSet_;
import com.arcway.lib.ui.editor.EnumerationItem;
import com.arcway.lib.ui.editor.datatype.ICompositeWidget;
import com.arcway.lib.ui.editor.parameters.WidgetParameters;
import com.arcway.lib.ui.editor.widgetAdapter.IDataWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapter;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class SingleChoiceWidget
extends AbstractDataWidget
implements Listener {
    private Control control;
    private Composite widgetComposite;
    private Object[] keys;
    private int latestSelectionIndex;

    public SingleChoiceWidget(WidgetParameters parameters, ICompositeWidget parent, IDataWidgetAdapter adapter) {
        super(parameters, adapter, (IEclipseCompositeWidget)parent);
        assert (parent instanceof IEclipseCompositeWidget);
    }

    @Override
    public void createControl(Composite parentComposite) {
        FormToolkit toolkit = this.getFormToolkit();
        this.widgetComposite = parentComposite;
        ISortedSet_ value = (ISortedSet_)this.getWidgetAdapter().getValue(IWidgetAdapter.WidgetUpdateMode.UPDATE_VALUE);
        boolean isModificationPermitted = this.getWidgetAdapter().isModificationPermitted();
        boolean isModificationLocked = this.getWidgetAdapter().isModificationLocked();
        if (!(this.isEditable() && isModificationPermitted && isModificationLocked)) {
            this.createUneditableControl(toolkit, (ISortedSet_<EnumerationItem>)value);
        } else if (value != null && !value.isEmpty()) {
            this.createEditableControl(toolkit, (ISortedSet_<EnumerationItem>)value);
            this.control.addListener(13, (Listener)this);
        } else {
            this.createUneditableControl(toolkit, (ISortedSet_<EnumerationItem>)value);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void updateWidget_internal(IWidgetAdapter.WidgetUpdateMode mode) {
        if (mode != IWidgetAdapter.WidgetUpdateMode.DONT_UPDATE_VALUE) {
            ISortedSet_ value = (ISortedSet_)this.getWidgetAdapter().getValue(mode);
            String val = "-";
            int index = 0;
            for (EnumerationItem item : value) {
                if (item.isChecked()) {
                    val = item.getLabel();
                    this.latestSelectionIndex = index;
                    break;
                }
                ++index;
            }
            if (val == "-") {
                this.latestSelectionIndex = 0;
            }
            if (this.control != null) {
                if (!(this.isEditable() && this.getWidgetAdapter().isModificationPermitted() && this.getWidgetAdapter().isModificationLocked())) {
                    if (!(this.control instanceof Text)) {
                        this.refreshWidget();
                        return;
                    }
                    ((Text)this.control).setText(val);
                } else {
                    if (!(this.control instanceof Combo)) {
                        this.refreshWidget();
                        return;
                    }
                    this.control.removeListener(13, (Listener)this);
                    ((Combo)this.control).setText(val);
                    this.control.addListener(13, (Listener)this);
                }
            }
        }
        this.updateWidgetMessageDisplay();
    }

    @Override
    public void refreshWidget_internal() {
        if (this.widgetComposite != null) {
            FormToolkit toolkit = this.getFormToolkit();
            this.control.dispose();
            ISortedSet_ value = (ISortedSet_)this.getWidgetAdapter().getValue(IWidgetAdapter.WidgetUpdateMode.UPDATE_VALUE);
            boolean isModificationPermitted = this.getWidgetAdapter().isModificationPermitted();
            boolean isModificationLocked = this.getWidgetAdapter().isModificationLocked();
            if (!(this.isEditable() && isModificationPermitted && isModificationLocked)) {
                this.createUneditableControl(toolkit, (ISortedSet_<EnumerationItem>)value);
            } else if (value != null && !value.isEmpty()) {
                this.createEditableControl(toolkit, (ISortedSet_<EnumerationItem>)value);
                this.control.addListener(13, (Listener)this);
            } else {
                this.createUneditableControl(toolkit, (ISortedSet_<EnumerationItem>)value);
            }
            this.updateWidgetMessageDisplay();
            this.widgetComposite.pack();
        }
    }

    public Object getCurrentValue() {
        int selectionIndex = this.latestSelectionIndex;
        if (this.isEditable() && this.getWidgetAdapter().isModificationPermitted() && this.getWidgetAdapter().isModificationLocked() && this.control instanceof Combo) {
            selectionIndex = ((Combo)this.control).getSelectionIndex();
            if (selectionIndex != -1) {
                this.latestSelectionIndex = selectionIndex;
            }
            selectionIndex = this.latestSelectionIndex;
        }
        return this.keys[selectionIndex];
    }

    public void setValue(Object value) {
        String label = "";
        int index = 0;
        for (EnumerationItem item : (ISortedSet_)this.getWidgetAdapter().getValue(IWidgetAdapter.WidgetUpdateMode.UPDATE_VALUE)) {
            if (item.getKey() != null && item.getKey().equals(value)) {
                label = item.getLabel();
                this.latestSelectionIndex = index;
                break;
            }
            ++index;
        }
        if (label == "") {
            this.latestSelectionIndex = 0;
        }
        if (this.control instanceof Text) {
            ((Text)this.control).setText(label);
        }
        if (this.control instanceof Combo) {
            ((Combo)this.control).setText(label);
        }
    }

    public void handleEvent(Event event) {
        this.getWidgetAdapter().widgetModified();
    }

    private void createEditableControl(FormToolkit toolkit, ISortedSet_<EnumerationItem> value) {
        toolkit.setBorderStyle(2048);
        this.control = new Combo(this.widgetComposite, 0x800808);
        this.control.setToolTipText(this.getTooltipText());
        if (value != null && !value.isEmpty()) {
            this.keys = new Object[value.size()];
            int index = 0;
            for (EnumerationItem item : value) {
                String label = item.getLabel();
                if (label != null) {
                    ((Combo)this.control).add(label);
                    this.keys[index] = item.getKey();
                    if (item.isChecked()) {
                        ((Combo)this.control).setText(label);
                        this.latestSelectionIndex = index;
                    }
                }
                ++index;
            }
        } else {
            this.control.setEnabled(false);
        }
        TableWrapData td = new TableWrapData(256);
        this.control.setLayoutData((Object)td);
    }

    private void createUneditableControl(FormToolkit toolkit, ISortedSet_<EnumerationItem> value) {
        toolkit.setBorderStyle(0);
        String val = "-";
        if (value != null && !value.isEmpty()) {
            int index = 0;
            this.keys = new Object[value.size()];
            for (EnumerationItem enumItem : value) {
                String label = enumItem.getLabel();
                if (label != null) {
                    this.keys[index] = enumItem.getKey();
                    if (enumItem.isChecked()) {
                        val = label;
                        this.latestSelectionIndex = index;
                    }
                }
                ++index;
            }
        }
        this.control = toolkit.createText(this.widgetComposite, val);
        TableWrapData td = new TableWrapData(256);
        this.control.setLayoutData((Object)td);
        ((Text)this.control).setEditable(false);
    }
}

