/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.uiframework.editors;

import com.arcway.lib.eclipse.Messages;
import com.arcway.lib.eclipse.plugin.ARCWAYEclipseLibPlugin;
import com.arcway.lib.eclipse.resources.DecoratedImage;
import com.arcway.lib.eclipse.resources.DecoratedImageCache;
import com.arcway.lib.eclipse.resources.ImageCache;
import com.arcway.lib.eclipse.resources.ResourceDisposer;
import com.arcway.lib.eclipse.uiframework.editors.EclipseUIFrameWork;
import com.arcway.lib.graphics.Alignment;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.ui.dialog.imports.IImportDialogEditorLabelAndLayoutProvider;
import com.arcway.lib.ui.editor.EXUnknownInput;
import com.arcway.lib.ui.editor.IEditorClosingDecider;
import com.arcway.lib.ui.editor.IEditorController;
import com.arcway.lib.ui.editor.PlaygroundManager;
import com.arcway.lib.ui.editor.WidgetFactoryController;
import com.arcway.lib.ui.editor.datatype.IEditor;
import com.arcway.lib.ui.editor.datatype.IEditorModelAccess;
import com.arcway.lib.ui.editor.exception.EEXLockDenied;
import com.arcway.lib.ui.editor.exception.EEXNotReproducibleSnapshot;
import com.arcway.lib.ui.editor.exception.EEXSnapshotClosed;
import com.arcway.lib.ui.modelaccess.ILayout;
import com.arcway.lib.ui.modelaccess.factory.IModelAccessAndLayoutFactory;
import com.arcway.lib.ui.modelaccess.factory.ModelAccessAndLayoutFactoryExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.PartInitException;

public class EditorInput
implements IEditorInput {
    private final Object input;
    private final boolean startInEditMode;
    private PresentationContext presentationContext = PresentationContext.getVirtualMachineUserLocaleForNow();
    private static final WidgetFactoryController widgetFactory = new WidgetFactoryController(EclipseUIFrameWork.UI_TYPE_ID);

    public EditorInput(Object input) {
        this(input, false);
    }

    public EditorInput(Object input, boolean startInEditModeRequested) {
        this.input = input;
        this.startInEditMode = startInEditModeRequested;
        this.updatePresentationContextToNow();
    }

    public void updatePresentationContextToNow() {
        this.presentationContext = PresentationContext.getVirtualMachineUserLocaleForNow();
    }

    public PresentationContext getCurrentPresentationContext() {
        return this.presentationContext;
    }

    public boolean exists() {
        IModelAccessAndLayoutFactory modelAccessAgentAndLayout = this.getModelAccessAgentAndLayoutFactory();
        boolean exists = modelAccessAgentAndLayout != null ? modelAccessAgentAndLayout.exists(this.input) : false;
        return exists;
    }

    public ImageDescriptor getImageDescriptor() {
        IModelAccessAndLayoutFactory modelAccessAgentAndLayout = this.getModelAccessAgentAndLayoutFactory();
        return EditorInput.getImageDescriptor((IImportDialogEditorLabelAndLayoutProvider)modelAccessAgentAndLayout, this.input, this.presentationContext);
    }

    public static ImageDescriptor getImageDescriptor(IImportDialogEditorLabelAndLayoutProvider modelAccessAgentAndLayout, Object input, PresentationContext presentationContext) {
        IStreamResource icon16x16;
        ImageDescriptor imageDescriptor = modelAccessAgentAndLayout != null ? ((icon16x16 = modelAccessAgentAndLayout.getIcon16x16(input, presentationContext)) != null ? ImageCache.getImageDescriptor(modelAccessAgentAndLayout.getIcon16x16(input, presentationContext)) : ImageDescriptor.getMissingImageDescriptor()) : ImageDescriptor.getMissingImageDescriptor();
        return imageDescriptor;
    }

    public Image getTitleImage(IEditorPart editor, IStreamResource decorator) {
        Image image;
        IModelAccessAndLayoutFactory modelAccessAgentAndLayout = this.getModelAccessAgentAndLayoutFactory();
        if (modelAccessAgentAndLayout != null) {
            IStreamResource icon16x16 = modelAccessAgentAndLayout.getIcon16x16(this.input, this.presentationContext);
            if (icon16x16 != null) {
                if (decorator != null) {
                    DecoratedImage decoratedImage = new DecoratedImage(ImageCache.getImage(editor.getSite().getShell().getDisplay(), icon16x16), ImageCache.getImage(editor.getSite().getShell().getDisplay(), decorator), new Alignment(1, 32));
                    image = DecoratedImageCache.getImage(editor.getSite().getShell().getDisplay(), decoratedImage);
                } else {
                    image = ImageCache.getImage(editor.getSite().getShell().getDisplay(), icon16x16);
                }
                ResourceDisposer.markResourceAsSingleton((Resource)image);
            } else {
                image = ImageDescriptor.getMissingImageDescriptor().createImage();
            }
        } else {
            image = ImageDescriptor.getMissingImageDescriptor().createImage();
        }
        return image;
    }

    public String getName() {
        IModelAccessAndLayoutFactory modelAccessAgentAndLayout = this.getModelAccessAgentAndLayoutFactory();
        return EditorInput.getName((IImportDialogEditorLabelAndLayoutProvider)modelAccessAgentAndLayout, this.input, this.presentationContext);
    }

    public static String getName(IImportDialogEditorLabelAndLayoutProvider modelAccessAgentAndLayout, Object input, PresentationContext presentationContext) {
        String name = null;
        if (modelAccessAgentAndLayout != null && (name = modelAccessAgentAndLayout.getName(input, presentationContext)) != null && name.length() > 40) {
            name = String.valueOf(name.substring(0, 37)) + "...";
        }
        if (name == null) {
            name = "???";
        }
        return name;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        IModelAccessAndLayoutFactory modelAccessAgentAndLayout = this.getModelAccessAgentAndLayoutFactory();
        return EditorInput.getToolTipText((IImportDialogEditorLabelAndLayoutProvider)modelAccessAgentAndLayout, this.input, this.presentationContext);
    }

    public static String getToolTipText(IImportDialogEditorLabelAndLayoutProvider modelAccessAgentAndLayout, Object input, PresentationContext presentationContext) {
        String toolTipText = null;
        if (modelAccessAgentAndLayout != null) {
            toolTipText = modelAccessAgentAndLayout.getToolTipText(input, presentationContext);
        }
        if (toolTipText == null) {
            toolTipText = "???";
        }
        return toolTipText;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public boolean equals(Object obj) {
        boolean equals;
        IModelAccessAndLayoutFactory editorFactory = this.getModelAccessAgentAndLayoutFactory();
        if (obj instanceof EditorInput) {
            EditorInput editorInput = (EditorInput)obj;
            equals = editorFactory != null ? editorFactory.areInputsEqual(this.input, editorInput.input) : obj == this;
        } else {
            equals = obj == this;
        }
        return equals;
    }

    public int hashCode() {
        IModelAccessAndLayoutFactory editorFactory = this.getModelAccessAgentAndLayoutFactory();
        int hashCode = editorFactory != null ? editorFactory.getHashCodeForInput(this.input) : 0;
        return hashCode;
    }

    private IModelAccessAndLayoutFactory getModelAccessAgentAndLayoutFactory() {
        return ModelAccessAndLayoutFactoryExtensionPoint.getInstance().getModelAccessAgentFactory(this.input);
    }

    public IEditorController setupEditor(final IEditor editor) throws PartInitException {
        PlaygroundManager editorController = null;
        try {
            final IModelAccessAndLayoutFactory modelAccessAgentAndLayoutFactory = ModelAccessAndLayoutFactoryExtensionPoint.getInstance().getModelAccessAgentFactory(this.input);
            if (modelAccessAgentAndLayoutFactory == null) {
                throw new EXUnknownInput();
            }
            IEditorModelAccess modelAccess = modelAccessAgentAndLayoutFactory.createModelAccess(this.input);
            if (modelAccess == null) {
                throw new EXUnknownInput();
            }
            ILayout layout = modelAccessAgentAndLayoutFactory.createLayout(this.input);
            editorController = new PlaygroundManager(modelAccess, layout, widgetFactory, editor, new IEditorClosingDecider(){

                public boolean isEditorToClose() {
                    return !modelAccessAgentAndLayoutFactory.exists(EditorInput.this.input) && editor.notInCreateMode();
                }
            });
        }
        catch (EXUnknownInput e) {
            throw new PartInitException(Messages.getString("Editor.wrongInput", this.getCurrentPresentationContext().getLocale()), (Throwable)e);
        }
        catch (EEXNotReproducibleSnapshot e) {
            throw new PartInitException(Messages.getString("Editor.notReproducibleSnapshot", this.getCurrentPresentationContext().getLocale()), (Throwable)e);
        }
        catch (EEXLockDenied e) {
            throw new PartInitException((IStatus)new Status(1, ARCWAYEclipseLibPlugin.getDefault().getPluginID(), Messages.getString("Editor.noLockError", this.getCurrentPresentationContext().getLocale()), (Throwable)e));
        }
        catch (EEXSnapshotClosed e) {
            throw new PartInitException(Messages.getString("Editor.snapshotClosed", this.getCurrentPresentationContext().getLocale()), (Throwable)e);
        }
        return editorController;
    }

    public Object getInput() {
        return this.input;
    }

    public boolean isStartInEditModeRequested() {
        return this.startInEditMode;
    }
}

