/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.transfer;

import com.arcway.lib.eclipse.transfer.AbstractTransferAgentForMultipleObjectTransfer;
import com.arcway.lib.eclipse.transfer.ExByteArrayDecodingFailed;
import com.arcway.lib.eclipse.transfer.ExByteArrayEncodingFailed;
import com.arcway.lib.eclipse.transfer.MultipleObjectTransferContent;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;

public class TransferContentBackdoorStorage {
    private static final ILogger logger = Logger.getLogger(TransferContentBackdoorStorage.class);
    private static Object currentKey = null;
    private static MultipleObjectTransferContent currentContent = null;
    private static byte[] serializedContentCache = null;
    private static Object lastRequestingListenerCache = null;
    private static Object copiedContentForLastRequestingListenerCache;

    private TransferContentBackdoorStorage() {
    }

    public static synchronized void setContent(Object key, MultipleObjectTransferContent content) {
        assert (key != null);
        assert (content != null);
        assert (content.getTransferAgent() != null);
        assert (content.getObjectToTransfer() != null);
        if (currentKey != null) {
            logger.error("Concurrent access to TransferContentBackdoorStorage. Current key: " + currentKey + ", new key: " + key, new Exception().fillInStackTrace());
            TransferContentBackdoorStorage.clearContent(currentKey);
        }
        currentKey = key;
        currentContent = content;
    }

    public static synchronized void clearContent(Object key) {
        assert (key != null);
        if (currentKey != key) {
            logger.error("Clearing TransferContentBackdoorStorage concurrently / which is already clean. Current key: " + currentKey + ", clearing key: " + key, new Exception().fillInStackTrace());
        }
        currentKey = null;
        currentContent = null;
        TransferContentBackdoorStorage.clearGetContentCaches();
    }

    public static synchronized Object getContent(AbstractTransferAgentForMultipleObjectTransfer wishedTransferAgent, Object requestingListener) {
        Object copiedObject;
        assert (wishedTransferAgent != null);
        if (currentContent != null && currentContent.getTransferAgent() == wishedTransferAgent) {
            if (requestingListener == null) {
                copiedObject = TransferContentBackdoorStorage.createCopy(TransferContentBackdoorStorage.getSerializedContent());
            } else if (requestingListener == lastRequestingListenerCache) {
                assert (copiedContentForLastRequestingListenerCache != null);
                copiedObject = copiedContentForLastRequestingListenerCache;
            } else {
                copiedContentForLastRequestingListenerCache = copiedObject = TransferContentBackdoorStorage.createCopy(TransferContentBackdoorStorage.getSerializedContent());
                lastRequestingListenerCache = requestingListener;
            }
        } else {
            copiedObject = null;
        }
        return copiedObject;
    }

    private static Object createCopy(byte[] serializedContent) {
        Object copy;
        AbstractTransferAgentForMultipleObjectTransfer currentTransferAgent = currentContent.getTransferAgent();
        try {
            copy = currentTransferAgent.byteArrayToJava(serializedContent);
        }
        catch (ExByteArrayDecodingFailed e) {
            copy = null;
            logger.error("Unable to decode MultipleObjectTransfer Content.", (Throwable)e);
        }
        return copy;
    }

    private static byte[] getSerializedContent() {
        if (serializedContentCache == null) {
            Object originalObject = currentContent.getObjectToTransfer();
            AbstractTransferAgentForMultipleObjectTransfer currentTransferAgent = currentContent.getTransferAgent();
            try {
                serializedContentCache = currentTransferAgent.javaToByteArray(originalObject);
            }
            catch (ExByteArrayEncodingFailed e) {
                logger.error("Unable to create ByteArrayEncoding of data (Clipboard) Transfer will fail.", (Throwable)e);
            }
        }
        return serializedContentCache;
    }

    private static void clearGetContentCaches() {
        serializedContentCache = null;
        lastRequestingListenerCache = null;
        copiedContentForLastRequestingListenerCache = null;
    }
}

