/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.gui;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class EclipseSWTHelper {
    private static final ILogger logger = Logger.getLogger(EclipseSWTHelper.class);

    public static void makeEqualWidth(Control control1, Control control2) {
        int w1 = control1.computeSize((int)-1, (int)-1).x;
        int w2 = control2.computeSize((int)-1, (int)-1).x;
        int width = Math.max(w1, w2);
        GridData g1 = (GridData)control1.getLayoutData();
        GridData g2 = (GridData)control2.getLayoutData();
        g1.widthHint = width;
        g2.widthHint = width;
    }

    public static Shell getShell() {
        IWorkbenchWindow workbenchWindow = EclipseSWTHelper.getWorkbenchWindow(false);
        Shell parentShell = workbenchWindow != null ? workbenchWindow.getShell() : null;
        if (parentShell == null) {
            logger.debug("Unable to retrieve a existing SWT Shell.", (Throwable)new Exception("Unable to retrieve a existing SWT Shell."));
            assert (false);
        }
        return parentShell;
    }

    private static IWorkbenchWindow getWorkbenchWindow(boolean logFailure) {
        IWorkbenchWindow[] workbenchWindows;
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (workbenchWindow == null && (workbenchWindows = PlatformUI.getWorkbench().getWorkbenchWindows()).length > 0) {
            workbenchWindow = workbenchWindows[0];
        }
        if (logFailure && workbenchWindow == null) {
            logger.debug("Unable to retrieve useable IWorkbenchWindow.", (Throwable)new Exception("Unable to retrieve useable IWorkbenchWindow."));
            assert (false);
        }
        return workbenchWindow;
    }

    public static IWorkbenchPage getWorkbenchPage(IWorkbenchWindow p_workbenchWindow) {
        IWorkbenchWindow workbenchWindow = p_workbenchWindow;
        if (workbenchWindow == null) {
            workbenchWindow = EclipseSWTHelper.getWorkbenchWindow(false);
        }
        if (workbenchWindow != null) {
            IWorkbenchPage[] pages;
            IWorkbenchPage page = workbenchWindow.getActivePage();
            if (page == null && (pages = workbenchWindow.getPages()).length > 0) {
                page = pages[0];
            }
            return page;
        }
        logger.debug("Unable to retrieve useable IWorkbenchPage.", (Throwable)new Exception("Unable to retrieve useable IWorkbenchPage."));
        assert (false);
        return null;
    }

    public static Control createScrollableComposite(Composite base, int minimumViewportMinWidth, int maximumViewportMinWidth, IScrollableContentCreator contentCreator) {
        GridLayout baseLayout = new GridLayout();
        baseLayout.marginWidth = 0;
        baseLayout.marginHeight = 0;
        base.setLayout((Layout)baseLayout);
        final ScrolledComposite scrollingComposite = new ScrolledComposite(base, 768);
        GridData gridData = new GridData(4, 4, true, true);
        scrollingComposite.setLayoutData((Object)gridData);
        scrollingComposite.setExpandHorizontal(true);
        scrollingComposite.setExpandVertical(true);
        scrollingComposite.setOrigin(0, 0);
        final Composite contentComposite = new Composite((Composite)scrollingComposite, 0);
        contentComposite.setBackground(base.getDisplay().getSystemColor(19));
        contentCreator.createContent(contentComposite);
        Point preferredSize = contentComposite.computeSize(-1, -1);
        int effectiveMinimumWidth = preferredSize.x;
        if (minimumViewportMinWidth != -1) {
            effectiveMinimumWidth = Math.max(effectiveMinimumWidth, minimumViewportMinWidth);
        }
        if (maximumViewportMinWidth != -1) {
            effectiveMinimumWidth = Math.min(effectiveMinimumWidth, maximumViewportMinWidth);
        }
        final int finalEffectiveMinimumWidth = effectiveMinimumWidth;
        scrollingComposite.setMinWidth(effectiveMinimumWidth);
        scrollingComposite.setMinHeight(preferredSize.y);
        scrollingComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int availableHorizontalSpace = Math.max(scrollingComposite.getClientArea().width, finalEffectiveMinimumWidth);
                Point preferredSizeForCurrentHorizontalSpace = contentComposite.computeSize(availableHorizontalSpace, -1);
                scrollingComposite.setMinHeight(preferredSizeForCurrentHorizontalSpace.y);
            }
        });
        scrollingComposite.setContent((Control)contentComposite);
        return scrollingComposite;
    }

    public static final void setBoldFont(Control control, boolean reduceSize) {
        FontData[] fontData;
        Font font = control.getFont();
        FontData[] fontDataArray = fontData = font.getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fontDataItem = fontDataArray[n2];
            fontDataItem.setStyle(1);
            if (reduceSize) {
                fontDataItem.setHeight((int)((float)fontDataItem.getHeight() * 0.9f));
            }
            ++n2;
        }
        final Font newFont = new Font((Device)control.getDisplay(), fontData);
        control.setFont(newFont);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                newFont.dispose();
            }
        });
    }

    public static interface IScrollableContentCreator {
        public void createContent(Composite var1);
    }
}

