/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.ole.excel.impl;

import au.com.swz.swttocom.swt.ResourceManager;
import au.com.swz.swttocom.swt.types.AbstractOleEventsListener;
import au.com.swz.swttocom.swt.types.AutomationObjectImpl;
import au.com.swz.swttocom.swt.types.IManagedAutomationObject;
import au.com.swz.swttocom.swt.types.pointer.BooleanPointer;
import com.arcway.lib.eclipse.ole.excel.WorkbookEvents;
import com.arcway.lib.eclipse.ole.excel.impl.HyperlinkImpl;
import com.arcway.lib.eclipse.ole.excel.impl.PivotTableImpl;
import com.arcway.lib.eclipse.ole.excel.impl.RangeImpl;
import com.arcway.lib.eclipse.ole.excel.impl.WindowImpl;
import com.arcway.lib.eclipse.ole.excel.impl.XmlMapImpl;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.Variant;

public class WorkbookEventsListener
extends AbstractOleEventsListener {
    private final Set<WorkbookEvents> listeners = new HashSet<WorkbookEvents>();

    public WorkbookEventsListener(ResourceManager resourceManager) {
        super(resourceManager);
    }

    public boolean addListener(WorkbookEvents listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(WorkbookEvents listener) {
        return this.listeners.remove(listener);
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public void handleEvent(OleEvent oleEvent) {
        Variant[] arguments;
        switch (oleEvent.type) {
            case 1923: {
                this.fireOpen(oleEvent);
                break;
            }
            case 304: {
                this.fireActivate(oleEvent);
                break;
            }
            case 1530: {
                this.fireDeactivate(oleEvent);
                break;
            }
            case 1546: {
                this.fireBeforeClose(oleEvent);
                break;
            }
            case 1547: {
                this.fireBeforeSave(oleEvent);
                break;
            }
            case 1549: {
                this.fireBeforePrint(oleEvent);
                break;
            }
            case 1550: {
                this.fireNewSheet(oleEvent);
                break;
            }
            case 1552: {
                this.fireAddinInstall(oleEvent);
                break;
            }
            case 1553: {
                this.fireAddinUninstall(oleEvent);
                break;
            }
            case 1554: {
                this.fireWindowResize(oleEvent);
                break;
            }
            case 1556: {
                this.fireWindowActivate(oleEvent);
                break;
            }
            case 1557: {
                this.fireWindowDeactivate(oleEvent);
                break;
            }
            case 1558: {
                this.fireSheetSelectionChange(oleEvent);
                break;
            }
            case 1559: {
                this.fireSheetBeforeDoubleClick(oleEvent);
                break;
            }
            case 1560: {
                this.fireSheetBeforeRightClick(oleEvent);
                break;
            }
            case 1561: {
                this.fireSheetActivate(oleEvent);
                break;
            }
            case 1562: {
                this.fireSheetDeactivate(oleEvent);
                break;
            }
            case 1563: {
                this.fireSheetCalculate(oleEvent);
                break;
            }
            case 1564: {
                this.fireSheetChange(oleEvent);
                break;
            }
            case 1854: {
                this.fireSheetFollowHyperlink(oleEvent);
                break;
            }
            case 2157: {
                this.fireSheetPivotTableUpdate(oleEvent);
                break;
            }
            case 2158: {
                this.firePivotTableCloseConnection(oleEvent);
                break;
            }
            case 2159: {
                this.firePivotTableOpenConnection(oleEvent);
                break;
            }
            case 2266: {
                this.fireSync(oleEvent);
                break;
            }
            case 2283: {
                this.fireBeforeXmlImport(oleEvent);
                break;
            }
            case 2285: {
                this.fireAfterXmlImport(oleEvent);
                break;
            }
            case 2287: {
                this.fireBeforeXmlExport(oleEvent);
                break;
            }
            case 2288: {
                this.fireAfterXmlExport(oleEvent);
            }
        }
        Variant[] variantArray = arguments = oleEvent.arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            Variant argument = variantArray[n2];
            argument.dispose();
            ++n2;
        }
    }

    private void fireOpen(OleEvent oleEvent) {
        for (WorkbookEvents l : this.listeners) {
            l.Open();
        }
    }

    private void fireActivate(OleEvent oleEvent) {
        for (WorkbookEvents l : this.listeners) {
            l.Activate();
        }
    }

    private void fireDeactivate(OleEvent oleEvent) {
        for (WorkbookEvents l : this.listeners) {
            l.Deactivate();
        }
    }

    private void fireBeforeClose(OleEvent oleEvent) {
        BooleanPointer cancel = new BooleanPointer(oleEvent.arguments[0].getByRef(), this.getResourceManager());
        for (WorkbookEvents l : this.listeners) {
            l.BeforeClose(cancel);
        }
        cancel.setAddress(0);
    }

    private void fireBeforeSave(OleEvent oleEvent) {
        boolean saveAsUI = oleEvent.arguments[0].getBoolean();
        BooleanPointer cancel = new BooleanPointer(oleEvent.arguments[1].getByRef(), this.getResourceManager());
        for (WorkbookEvents l : this.listeners) {
            l.BeforeSave(saveAsUI, cancel);
        }
        cancel.setAddress(0);
    }

    private void fireBeforePrint(OleEvent oleEvent) {
        BooleanPointer cancel = new BooleanPointer(oleEvent.arguments[0].getByRef(), this.getResourceManager());
        for (WorkbookEvents l : this.listeners) {
            l.BeforePrint(cancel);
        }
        cancel.setAddress(0);
    }

    private void fireNewSheet(OleEvent oleEvent) {
        AutomationObjectImpl sh = new AutomationObjectImpl(oleEvent.arguments[0], this.getResourceManager());
        for (WorkbookEvents l : this.listeners) {
            l.NewSheet((IManagedAutomationObject)sh);
        }
    }

    private void fireAddinInstall(OleEvent oleEvent) {
        for (WorkbookEvents l : this.listeners) {
            l.AddinInstall();
        }
    }

    private void fireAddinUninstall(OleEvent oleEvent) {
        for (WorkbookEvents l : this.listeners) {
            l.AddinUninstall();
        }
    }

    private void fireWindowResize(OleEvent oleEvent) {
        WindowImpl wn = new WindowImpl(oleEvent.arguments[0], this.getResourceManager());
        for (WorkbookEvents l : this.listeners) {
            l.WindowResize(wn);
        }
    }

    private void fireWindowActivate(OleEvent oleEvent) {
        WindowImpl wn = new WindowImpl(oleEvent.arguments[0], this.getResourceManager());
        for (WorkbookEvents l : this.listeners) {
            l.WindowActivate(wn);
        }
    }

    private void fireWindowDeactivate(OleEvent oleEvent) {
        WindowImpl wn = new WindowImpl(oleEvent.arguments[0], this.getResourceManager());
        for (WorkbookEvents l : this.listeners) {
            l.WindowDeactivate(wn);
        }
    }

    private void fireSheetSelectionChange(OleEvent oleEvent) {
        AutomationObjectImpl sh = new AutomationObjectImpl(oleEvent.arguments[0], this.getResourceManager());
        RangeImpl target = new RangeImpl(oleEvent.arguments[1], this.getResourceManager());
        for (WorkbookEvents l : this.listeners) {
            l.SheetSelectionChange((IManagedAutomationObject)sh, target);
        }
    }

    private void fireSheetBeforeDoubleClick(OleEvent oleEvent) {
        AutomationObjectImpl sh = new AutomationObjectImpl(oleEvent.arguments[0], this.getResourceManager());
        RangeImpl target = new RangeImpl(oleEvent.arguments[1], this.getResourceManager());
        BooleanPointer cancel = new BooleanPointer(oleEvent.arguments[2].getByRef(), this.getResourceManager());
        for (WorkbookEvents l : this.listeners) {
            l.SheetBeforeDoubleClick((IManagedAutomationObject)sh, target, cancel);
        }
        cancel.setAddress(0);
    }

    private void fireSheetBeforeRightClick(OleEvent oleEvent) {
        AutomationObjectImpl sh = new AutomationObjectImpl(oleEvent.arguments[0], this.getResourceManager());
        RangeImpl target = new RangeImpl(oleEvent.arguments[1], this.getResourceManager());
        BooleanPointer cancel = new BooleanPointer(oleEvent.arguments[2].getByRef(), this.getResourceManager());
        for (WorkbookEvents l : this.listeners) {
            l.SheetBeforeRightClick((IManagedAutomationObject)sh, target, cancel);
        }
        cancel.setAddress(0);
    }

    private void fireSheetActivate(OleEvent oleEvent) {
        AutomationObjectImpl sh = new AutomationObjectImpl(oleEvent.arguments[0], this.getResourceManager());
        for (WorkbookEvents l : this.listeners) {
            l.SheetActivate((IManagedAutomationObject)sh);
        }
    }

    private void fireSheetDeactivate(OleEvent oleEvent) {
        AutomationObjectImpl sh = new AutomationObjectImpl(oleEvent.arguments[0], this.getResourceManager());
        for (WorkbookEvents l : this.listeners) {
            l.SheetDeactivate((IManagedAutomationObject)sh);
        }
    }

    private void fireSheetCalculate(OleEvent oleEvent) {
        AutomationObjectImpl sh = new AutomationObjectImpl(oleEvent.arguments[0], this.getResourceManager());
        for (WorkbookEvents l : this.listeners) {
            l.SheetCalculate((IManagedAutomationObject)sh);
        }
    }

    private void fireSheetChange(OleEvent oleEvent) {
        AutomationObjectImpl sh = new AutomationObjectImpl(oleEvent.arguments[0], this.getResourceManager());
        RangeImpl target = new RangeImpl(oleEvent.arguments[1], this.getResourceManager());
        for (WorkbookEvents l : this.listeners) {
            l.SheetChange((IManagedAutomationObject)sh, target);
        }
    }

    private void fireSheetFollowHyperlink(OleEvent oleEvent) {
        AutomationObjectImpl sh = new AutomationObjectImpl(oleEvent.arguments[0], this.getResourceManager());
        HyperlinkImpl target = new HyperlinkImpl(oleEvent.arguments[1], this.getResourceManager());
        for (WorkbookEvents l : this.listeners) {
            l.SheetFollowHyperlink((IManagedAutomationObject)sh, target);
        }
    }

    private void fireSheetPivotTableUpdate(OleEvent oleEvent) {
        AutomationObjectImpl sh = new AutomationObjectImpl(oleEvent.arguments[0], this.getResourceManager());
        PivotTableImpl target = new PivotTableImpl(oleEvent.arguments[1], this.getResourceManager());
        for (WorkbookEvents l : this.listeners) {
            l.SheetPivotTableUpdate((IManagedAutomationObject)sh, target);
        }
    }

    private void firePivotTableCloseConnection(OleEvent oleEvent) {
        PivotTableImpl target = new PivotTableImpl(oleEvent.arguments[0], this.getResourceManager());
        for (WorkbookEvents l : this.listeners) {
            l.PivotTableCloseConnection(target);
        }
    }

    private void firePivotTableOpenConnection(OleEvent oleEvent) {
        PivotTableImpl target = new PivotTableImpl(oleEvent.arguments[0], this.getResourceManager());
        for (WorkbookEvents l : this.listeners) {
            l.PivotTableOpenConnection(target);
        }
    }

    private void fireSync(OleEvent oleEvent) {
        int syncEventType = oleEvent.arguments[0].getInt();
        for (WorkbookEvents l : this.listeners) {
            l.Sync(syncEventType);
        }
    }

    private void fireBeforeXmlImport(OleEvent oleEvent) {
        XmlMapImpl map = new XmlMapImpl(oleEvent.arguments[0], this.getResourceManager());
        String url = oleEvent.arguments[1].getString();
        boolean isRefresh = oleEvent.arguments[2].getBoolean();
        BooleanPointer cancel = new BooleanPointer(oleEvent.arguments[3].getByRef(), this.getResourceManager());
        for (WorkbookEvents l : this.listeners) {
            l.BeforeXmlImport(map, url, isRefresh, cancel);
        }
        cancel.setAddress(0);
    }

    private void fireAfterXmlImport(OleEvent oleEvent) {
        XmlMapImpl map = new XmlMapImpl(oleEvent.arguments[0], this.getResourceManager());
        boolean isRefresh = oleEvent.arguments[1].getBoolean();
        int result = oleEvent.arguments[2].getInt();
        for (WorkbookEvents l : this.listeners) {
            l.AfterXmlImport(map, isRefresh, result);
        }
    }

    private void fireBeforeXmlExport(OleEvent oleEvent) {
        XmlMapImpl map = new XmlMapImpl(oleEvent.arguments[0], this.getResourceManager());
        String url = oleEvent.arguments[1].getString();
        BooleanPointer cancel = new BooleanPointer(oleEvent.arguments[2].getByRef(), this.getResourceManager());
        for (WorkbookEvents l : this.listeners) {
            l.BeforeXmlExport(map, url, cancel);
        }
        cancel.setAddress(0);
    }

    private void fireAfterXmlExport(OleEvent oleEvent) {
        XmlMapImpl map = new XmlMapImpl(oleEvent.arguments[0], this.getResourceManager());
        String url = oleEvent.arguments[1].getString();
        int result = oleEvent.arguments[2].getInt();
        for (WorkbookEvents l : this.listeners) {
            l.AfterXmlExport(map, url, result);
        }
    }
}

