/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.ole.excel;

import au.com.swz.swttocom.swt.ResourceManager;
import au.com.swz.swttocom.swt.types.TypeUtils;
import com.arcway.lib.eclipse.ole.excel.WorkbookEvents;
import com.arcway.lib.eclipse.ole.excel._Workbook;
import com.arcway.lib.eclipse.ole.excel.impl.WorkbookEventsListener;
import com.arcway.lib.eclipse.ole.excel.impl._WorkbookImpl;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.text.MessageFormat;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IDispatch;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleListener;
import org.eclipse.swt.ole.win32.Variant;

public class Workbook
extends _WorkbookImpl {
    private static final ILogger logger = Logger.getLogger(Workbook.class);
    public static final GUID CLSID = TypeUtils.IIDFromString((String)"{00020819-0000-0000-C000-000000000046}");
    private WorkbookEventsListener workbookEvents;

    public Workbook(OleAutomation oleAutomation, ResourceManager resourceManager) {
        super(oleAutomation, resourceManager);
    }

    public Workbook(Variant variant, ResourceManager resourceManager) {
        super(variant, resourceManager);
    }

    public static _Workbook create(int dwClsContext, ResourceManager resourceManager, boolean callingOleRunIsRequired) {
        if (!callingOleRunIsRequired) {
            int[] ppv = new int[1];
            int result = COM.CoCreateInstance((GUID)CLSID, (int)0, (int)dwClsContext, (GUID)COM.IIDIDispatch, (int[])ppv);
            if (result != 0) {
                OLE.error((int)1001, (int)result);
            }
            Variant v = new Variant(new IDispatch(ppv[0]));
            return new _WorkbookImpl(v, resourceManager);
        }
        int[] ppv = new int[1];
        int coCreateInstanceResult = COM.CoCreateInstance((GUID)CLSID, (int)0, (int)dwClsContext, (GUID)COM.IIDIUnknown, (int[])ppv);
        if (coCreateInstanceResult != 0) {
            OLE.error((int)1001, (int)coCreateInstanceResult);
        }
        IUnknown objIUnknown = new IUnknown(ppv[0]);
        try {
            int[] ppvObject;
            int queryIDispatchResult;
            int oleRunResult = COM.OleRun((int)objIUnknown.getAddress());
            if (oleRunResult != 0) {
                logger.debug(MessageFormat.format("Initialisation of COM Server CLSID={0} failed. (errorcode={1}). ", CLSID.toString(), oleRunResult));
                OLE.error((int)1014, (int)coCreateInstanceResult);
            }
            if ((queryIDispatchResult = objIUnknown.QueryInterface(COM.IIDIDispatch, ppvObject = new int[1])) != 0) {
                try {
                    OLE.error((int)1003, (int)queryIDispatchResult);
                }
                catch (SWTException e) {
                    try {
                        Exception cause = new Exception(MessageFormat.format("Additional Information: Problem occured while trying to initialise COM Server CLSID={0}, objIUnknown.getAddress()={1}.). ", CLSID.toString(), String.valueOf(objIUnknown.getAddress())));
                        e.initCause((Throwable)cause);
                    }
                    catch (Exception e1) {
                        throw e;
                    }
                }
            }
            IDispatch disp = new IDispatch(ppvObject[0]);
            Variant appVariant = new Variant(disp);
            _WorkbookImpl _WorkbookImpl2 = new _WorkbookImpl(appVariant, resourceManager);
            return _WorkbookImpl2;
        }
        finally {
            objIUnknown.Release();
        }
    }

    public boolean addWorkbookEventsListener(WorkbookEvents listener) {
        if (this.workbookEvents == null) {
            this.workbookEvents = new WorkbookEventsListener(this.getResourceManager());
            this.addEventListener(WorkbookEvents.IID, 1923, (OleListener)this.workbookEvents);
            this.addEventListener(WorkbookEvents.IID, 304, (OleListener)this.workbookEvents);
            this.addEventListener(WorkbookEvents.IID, 1530, (OleListener)this.workbookEvents);
            this.addEventListener(WorkbookEvents.IID, 1546, (OleListener)this.workbookEvents);
            this.addEventListener(WorkbookEvents.IID, 1547, (OleListener)this.workbookEvents);
            this.addEventListener(WorkbookEvents.IID, 1549, (OleListener)this.workbookEvents);
            this.addEventListener(WorkbookEvents.IID, 1550, (OleListener)this.workbookEvents);
            this.addEventListener(WorkbookEvents.IID, 1552, (OleListener)this.workbookEvents);
            this.addEventListener(WorkbookEvents.IID, 1553, (OleListener)this.workbookEvents);
            this.addEventListener(WorkbookEvents.IID, 1554, (OleListener)this.workbookEvents);
            this.addEventListener(WorkbookEvents.IID, 1556, (OleListener)this.workbookEvents);
            this.addEventListener(WorkbookEvents.IID, 1557, (OleListener)this.workbookEvents);
            this.addEventListener(WorkbookEvents.IID, 1558, (OleListener)this.workbookEvents);
            this.addEventListener(WorkbookEvents.IID, 1559, (OleListener)this.workbookEvents);
            this.addEventListener(WorkbookEvents.IID, 1560, (OleListener)this.workbookEvents);
            this.addEventListener(WorkbookEvents.IID, 1561, (OleListener)this.workbookEvents);
            this.addEventListener(WorkbookEvents.IID, 1562, (OleListener)this.workbookEvents);
            this.addEventListener(WorkbookEvents.IID, 1563, (OleListener)this.workbookEvents);
            this.addEventListener(WorkbookEvents.IID, 1564, (OleListener)this.workbookEvents);
            this.addEventListener(WorkbookEvents.IID, 1854, (OleListener)this.workbookEvents);
            this.addEventListener(WorkbookEvents.IID, 2157, (OleListener)this.workbookEvents);
            this.addEventListener(WorkbookEvents.IID, 2158, (OleListener)this.workbookEvents);
            this.addEventListener(WorkbookEvents.IID, 2159, (OleListener)this.workbookEvents);
            this.addEventListener(WorkbookEvents.IID, 2266, (OleListener)this.workbookEvents);
            this.addEventListener(WorkbookEvents.IID, 2283, (OleListener)this.workbookEvents);
            this.addEventListener(WorkbookEvents.IID, 2285, (OleListener)this.workbookEvents);
            this.addEventListener(WorkbookEvents.IID, 2287, (OleListener)this.workbookEvents);
            this.addEventListener(WorkbookEvents.IID, 2288, (OleListener)this.workbookEvents);
        }
        return this.workbookEvents.addListener(listener);
    }

    public boolean removeWorkbookEventsListener(WorkbookEvents listener) {
        boolean bRtn = this.workbookEvents.removeListener(listener);
        if (this.workbookEvents.isEmpty()) {
            this.removeEventListener(WorkbookEvents.IID, 1923, (OleListener)this.workbookEvents);
            this.removeEventListener(WorkbookEvents.IID, 304, (OleListener)this.workbookEvents);
            this.removeEventListener(WorkbookEvents.IID, 1530, (OleListener)this.workbookEvents);
            this.removeEventListener(WorkbookEvents.IID, 1546, (OleListener)this.workbookEvents);
            this.removeEventListener(WorkbookEvents.IID, 1547, (OleListener)this.workbookEvents);
            this.removeEventListener(WorkbookEvents.IID, 1549, (OleListener)this.workbookEvents);
            this.removeEventListener(WorkbookEvents.IID, 1550, (OleListener)this.workbookEvents);
            this.removeEventListener(WorkbookEvents.IID, 1552, (OleListener)this.workbookEvents);
            this.removeEventListener(WorkbookEvents.IID, 1553, (OleListener)this.workbookEvents);
            this.removeEventListener(WorkbookEvents.IID, 1554, (OleListener)this.workbookEvents);
            this.removeEventListener(WorkbookEvents.IID, 1556, (OleListener)this.workbookEvents);
            this.removeEventListener(WorkbookEvents.IID, 1557, (OleListener)this.workbookEvents);
            this.removeEventListener(WorkbookEvents.IID, 1558, (OleListener)this.workbookEvents);
            this.removeEventListener(WorkbookEvents.IID, 1559, (OleListener)this.workbookEvents);
            this.removeEventListener(WorkbookEvents.IID, 1560, (OleListener)this.workbookEvents);
            this.removeEventListener(WorkbookEvents.IID, 1561, (OleListener)this.workbookEvents);
            this.removeEventListener(WorkbookEvents.IID, 1562, (OleListener)this.workbookEvents);
            this.removeEventListener(WorkbookEvents.IID, 1563, (OleListener)this.workbookEvents);
            this.removeEventListener(WorkbookEvents.IID, 1564, (OleListener)this.workbookEvents);
            this.removeEventListener(WorkbookEvents.IID, 1854, (OleListener)this.workbookEvents);
            this.removeEventListener(WorkbookEvents.IID, 2157, (OleListener)this.workbookEvents);
            this.removeEventListener(WorkbookEvents.IID, 2158, (OleListener)this.workbookEvents);
            this.removeEventListener(WorkbookEvents.IID, 2159, (OleListener)this.workbookEvents);
            this.removeEventListener(WorkbookEvents.IID, 2266, (OleListener)this.workbookEvents);
            this.removeEventListener(WorkbookEvents.IID, 2283, (OleListener)this.workbookEvents);
            this.removeEventListener(WorkbookEvents.IID, 2285, (OleListener)this.workbookEvents);
            this.removeEventListener(WorkbookEvents.IID, 2287, (OleListener)this.workbookEvents);
            this.removeEventListener(WorkbookEvents.IID, 2288, (OleListener)this.workbookEvents);
            this.workbookEvents = null;
        }
        return bRtn;
    }
}

