/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.interFace.datatype.lib;

import com.arcway.frontend.definition.lib.interFace.datatype.AbstractFrontendDataType;
import com.arcway.frontend.definition.lib.interFace.datatype.FrontendDataTypeParameters;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataType;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataTypeParameters;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataTypeRegistration;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendExceptionTypeRegistration;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.Messages;
import com.arcway.frontend.definition.lib.interFace.declaration.label.FrontendLabel;
import com.arcway.frontend.definition.lib.interFace.label.IFrontendLabel;
import com.arcway.frontend.definition.lib.interFace.type.IFrontendExceptionType;
import com.arcway.frontend.definition.lib.interFace.type.exceptions.AbstractFrontendDataValidationExceptionType;
import com.arcway.frontend.definition.lib.interFace.type.manager.IFrontendTypeManager;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.resource.FileResourceInPackage;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.property.IRepositoryPropertySample;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeParameters;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.lib.high.implementation.access.RepositoryPropertySample;
import com.arcway.repository.lib.high.registration.data.lib.RDTDuration64Bitmsec;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;

public class FDTDuration64Bitmsec
extends AbstractFrontendDataType {
    private static final IStreamResource ICON_16x16 = new FileResourceInPackage(FDTDuration64Bitmsec.class, "duration.gif");
    private final RDTDuration64Bitmsec repositoryDataType = RDTDuration64Bitmsec.getInstance();

    public static FDTDuration64Bitmsec getInstance(IFrontendTypeManager frontendTypeManager) {
        FDTDuration64Bitmsec frontendDataType = (FDTDuration64Bitmsec)frontendTypeManager.getFrontendDataType((IRepositoryDataType)RDTDuration64Bitmsec.getInstance());
        return frontendDataType;
    }

    public boolean isInMinutes(IFrontendDataTypeParameters parameters) {
        Parameters typedParameters = (Parameters)parameters;
        return typedParameters.isInMinutes();
    }

    public boolean isInHours(IFrontendDataTypeParameters parameters) {
        Parameters typedParameters = (Parameters)parameters;
        return typedParameters.isInHours();
    }

    public FDTDuration64Bitmsec(IFrontendTypeManager frontendTypeManager) {
        super(frontendTypeManager);
    }

    @Override
    public IRepositoryDataType getRepositoryDataType() {
        return this.repositoryDataType;
    }

    @Override
    public IFrontendLabel getLabel(Locale userLocale) {
        return Messages.createFrontendLabel("FDTDuration64Bitmsec", userLocale, ICON_16x16);
    }

    @Override
    public IFrontendLabel getLabelForValue(IRepositoryData value, IRepositoryDataTypeParameters repositoryDataTypeParameters, IFrontendDataTypeParameters frontendDataTypeParameters, PresentationContext userLocale) {
        FrontendLabel label;
        Long valueAsLong = this.repositoryDataType.dataToValue(value);
        if (valueAsLong != null) {
            String valueAsString;
            if (this.isInMinutes(frontendDataTypeParameters)) {
                valueAsString = Long.valueOf(valueAsLong / 60000L).toString();
            } else if (this.isInHours(frontendDataTypeParameters)) {
                valueAsString = new Long(valueAsLong / 3600000L).toString();
            } else {
                DateFormat dateFormat = DateFormat.getTimeInstance(3, this.getRepositoryLocale());
                valueAsString = dateFormat.format(new Date(valueAsLong));
            }
            label = new FrontendLabel(valueAsString, null);
        } else {
            label = new FrontendLabel(Messages.getString("FDT.NULL", this.getRepositoryLocale()), NULL_ICON_16x16);
        }
        return label;
    }

    @Override
    public ICollection_<IFrontendExceptionTypeRegistration> getFrontendExceptionTypeRegistrations() {
        ArrayList_ frontendExceptionTypeRegistrations = new ArrayList_();
        frontendExceptionTypeRegistrations.add((Object)new AbstractFrontendDataType.FETValueNotSet.FrontendExceptionTypeRegistration());
        frontendExceptionTypeRegistrations.add((Object)new FETDuration64BitmsecValueInvalid.FrontendExceptionTypeRegistration());
        return frontendExceptionTypeRegistrations;
    }

    @Override
    public Object getCurrentValueAsEditorValue(IRepositoryData value, IFrontendDataTypeParameters parameters) {
        Long longVal = this.repositoryDataType.dataToValue(value);
        if (longVal != null) {
            long returnVal = 0L;
            if (this.isInMinutes(parameters)) {
                returnVal = longVal / 60000L;
            } else if (this.isInHours(parameters)) {
                returnVal = longVal / 3600000L;
            }
            return returnVal;
        }
        return null;
    }

    @Override
    public IRepositoryPropertySample getPropertySampleForEditorValue(Object editorValue, IRepositoryPropertyType propertyType, IFrontendDataTypeParameters frontendParameters) {
        Long longVal = (Long)editorValue;
        Long newValue = null;
        if (longVal != null) {
            long newVal = 0L;
            if (this.isInMinutes(frontendParameters)) {
                newVal = longVal * 60000L;
            } else if (this.isInHours(frontendParameters)) {
                newVal = longVal * 3600000L;
            }
            newValue = newVal;
        }
        IRepositoryData data = this.repositoryDataType.createData(newValue);
        return new RepositoryPropertySample(data);
    }

    @Override
    public void disposePropertySample(IRepositoryPropertySample repositoryPropertySample) {
    }

    @Override
    public boolean hasResourcesAllocated() {
        return false;
    }

    public static class FETDuration64BitmsecValueInvalid
    extends AbstractFrontendDataValidationExceptionType<RDTDuration64Bitmsec.EXDurationValueInvalid> {
        private FETDuration64BitmsecValueInvalid(IFrontendTypeManager frontendTypeManager) {
            super(frontendTypeManager);
        }

        @Override
        protected Class<RDTDuration64Bitmsec.EXDurationValueInvalid> getConcreteRepositoryExceptionType() {
            return RDTDuration64Bitmsec.EXDurationValueInvalid.class;
        }

        @Override
        protected String getExceptionMessage(PresentationContext presentationContext, RDTDuration64Bitmsec.EXDurationValueInvalid exception) {
            int lengthDiagnostics = exception.getLengthDiagnostics();
            if (lengthDiagnostics == 2) {
                return Messages.getString("EXValueInvalid.Duration64Bitmsec.TooLow", presentationContext.getLocale());
            }
            if (lengthDiagnostics == 3) {
                return Messages.getString("EXValueInvalid.Duration64Bitmsec.TooHigh", presentationContext.getLocale());
            }
            return Messages.getString("EXValueInvalid.Duration64Bitmsec", presentationContext.getLocale());
        }

        public static class FrontendExceptionTypeRegistration
        implements IFrontendExceptionTypeRegistration {
            @Override
            public IFrontendExceptionType createFrontendExceptionType(IFrontendTypeManager frontendTypeManager) {
                return new FETDuration64BitmsecValueInvalid(frontendTypeManager);
            }
        }
    }

    public static class FrontendDataTypeRegistration
    implements IFrontendDataTypeRegistration {
        @Override
        public IFrontendDataType createFrontendDataType(IFrontendTypeManager frontendTypeManager) {
            return new FDTDuration64Bitmsec(frontendTypeManager);
        }
    }

    public static final class Parameters
    extends FrontendDataTypeParameters {
        private static final int IN_MINUTES = 1;
        private static final int IN_HOURS = 0;
        public static final Parameters IS_IN_MINUTES = new Parameters(1);
        public static final Parameters IS_IN_HOURS = new Parameters(0);
        private final int mode;

        public Parameters(int mode) {
            this.mode = mode;
        }

        private boolean isInMinutes() {
            return this.mode == 1;
        }

        private boolean isInHours() {
            return this.mode == 0;
        }
    }
}

