/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.implementation.type;

import com.arcway.frontend.definition.lib.implementation.type.BestMatchingFrontendLabel;
import com.arcway.frontend.definition.lib.implementation.type.manager.FrontendTypeManager;
import com.arcway.frontend.definition.lib.interFace.declaration.AbstractFrontendTypeDeclaration;
import com.arcway.frontend.definition.lib.interFace.declaration.label.FrontendLabel;
import com.arcway.frontend.definition.lib.interFace.label.IFrontendLabel;
import com.arcway.frontend.definition.lib.interFace.type.IAbstractFrontendType;
import com.arcway.frontend.definition.lib.interFace.type.manager.IFrontendTypeManager;
import com.arcway.lib.java.Assert;
import com.arcway.repository.interFace.registration.type.IRepositoryDeclarationItem;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import java.util.Locale;

public abstract class AbstractFrontendType
implements IAbstractFrontendType {
    private final FrontendTypeManager frontendTypeManager;
    private final IRepositoryDeclarationItem declarationItem;
    private final BestMatchingFrontendLabel label;

    public AbstractFrontendType(FrontendTypeManager frontendTypeManager, IRepositoryDeclarationItem declarationItem) {
        Assert.checkArgumentBeeingNotNull((Object)frontendTypeManager);
        this.frontendTypeManager = frontendTypeManager;
        this.declarationItem = declarationItem;
        this.label = new BestMatchingFrontendLabel(frontendTypeManager.getRepositoryLocale());
        this.label.updateLabel(null, new FrontendLabel(declarationItem.getRepositoryDeclarationItemID().toCanonicalString(), null), Integer.MAX_VALUE);
    }

    @Override
    public IRepositoryDeclarationItem getRepositoryDeclarationItem() {
        return this.declarationItem;
    }

    public FrontendTypeManager getFrontendTypeManagerImplementation() {
        return this.frontendTypeManager;
    }

    @Override
    public IFrontendTypeManager getFrontendTypeManager() {
        return this.getFrontendTypeManagerImplementation();
    }

    public BestMatchingFrontendLabel getLabelImplementation() {
        return this.label;
    }

    @Override
    public IFrontendLabel getLabel() {
        return this.getLabelImplementation();
    }

    protected void loadAbstractDeclaration(Locale declarationLocale, AbstractFrontendTypeDeclaration declaration, int inheritanceLevel) {
        this.getLabelImplementation().updateLabel(declarationLocale, declaration.getLabelDeclaration(), inheritanceLevel);
    }

    public IRepositoryTypeManagerRO getRepositoryTypeManager() {
        return this.getFrontendTypeManager().getRepositoryTypeManager();
    }
}

