/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.requirementsmodule2migrator;

import com.arcway.cockpit.frame.client.project.datainterchange.ProjectFileAccess;
import com.arcway.cockpit.frame.client.project.migration.ICockpitMigrator;
import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOFrameData_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOProject_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.V0_EOFactory;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.modules.V0_EOFactory_ForModules;
import com.arcway.cockpit.frame.client.project.migration.access_both.version3.EOUserDefinedAttributeType_V3;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricProjectDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricServerDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version3.HistoricProjectDumpView_3_;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.IHistoricProjectFileView;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.version3.HistoricProjectFileView_3_;
import com.arcway.cockpit.modulelib2.client.migration.version3.framework.IModuleDataMigratorExtension;
import com.arcway.cockpit.modulelib2.client.migration.version3.framework.ModuleDataMigrationProcessor;
import com.arcway.cockpit.requirementsmodule2migrator.PermissionMigrator;
import com.arcway.cockpit.requirementsmodule2migrator.RQM2_TO_RQM3_MigratorExtension;
import com.arcway.cockpit.requirementsmodule2migrator.ReportTemplateMigrator;
import com.arcway.lib.codec.EXDecoderException;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.MultiplexEncodableObjectFactory;
import de.plans.lib.xml.encoding.XMLContext;
import de.plans.psc.shared.message.EOPermission;
import de.plans.psc.shared.message.PSCPlainMessageDataFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class RQM2_TO_RQM3_Migrator
implements ICockpitMigrator {
    public static final String KEY = "requirementsmodule-2-migrator";
    private static final Collection<IModuleDataMigratorExtension> MIGRATOR_EXTENSIONS = Collections.singleton(new RQM2_TO_RQM3_MigratorExtension());
    private static final MultiplexEncodableObjectFactory EO_FACTORY = new MultiplexEncodableObjectFactory(new IEncodableObjectFactory[]{V0_EOFactory.getDefault(), V0_EOFactory_ForModules.getDefault(), PSCPlainMessageDataFactory.getDefault(), new IEncodableObjectFactory(){

        public EncodableObjectBase createEncodableObject(String name, XMLContext context) throws EXDecoderException {
            if (name.equals("frame.UserDefinedAttributeType")) {
                return new EOUserDefinedAttributeType_V3(context);
            }
            return null;
        }
    }});
    private static final String DATA_TYPE_ID_REPORT_TEMPLATE = "com.arcway.cockpit.object.data.report_template";

    public String getKey() {
        return KEY;
    }

    public int getSourceVersion() {
        return 3;
    }

    public List<String> getRequiredPreceedingMigrators() {
        return Arrays.asList("com.arcway.cockpit.frame.client.project.migration.migrators.version3.projectmetadatamigrator", "LocalLinkMigrator", "bug3144-migrator", "repairversionedmoduledata-migrator");
    }

    public IEncodableObjectFactory getRequiredEOFactoryForProjectFileMainData() {
        return EO_FACTORY;
    }

    public void migrateServerDump(IHistoricServerDumpView serverDump) throws MigrationFailedException {
    }

    public void migrateProjectDump(IHistoricProjectDumpView projectDump) throws MigrationFailedException {
        try {
            HistoricProjectDumpView_3_ historicView = (HistoricProjectDumpView_3_)projectDump;
            List projects = historicView.getAllProjects();
            if (projects != null) {
                for (EOProject_V0 currentProject : projects) {
                    Map dataTypeID_2_oldAttributeTypeID_2_newCustomPropertyUID = ModuleDataMigrationProcessor.migrateProjectDump((HistoricProjectDumpView_3_)historicView, (EOProject_V0)currentProject, (IEncodableObjectFactory)EO_FACTORY, MIGRATOR_EXTENSIONS);
                    EOList permissions = historicView.readPermissions(currentProject);
                    PermissionMigrator.migratePermissions((Collection<EOPermission>)permissions, dataTypeID_2_oldAttributeTypeID_2_newCustomPropertyUID);
                    EncodableObjectBase encodableObjectFrameData = historicView.readDataFile(currentProject, "frameData.xml", null, (IEncodableObjectFactory)EO_FACTORY);
                    if (encodableObjectFrameData == null || !(encodableObjectFrameData instanceof EOList)) {
                        throw new MigrationFailedException("The user defined attributes file (frameData.xml) does not exist or the currently processed data is not of expected type EOList.");
                    }
                    EOList frameDataList = (EOList)encodableObjectFrameData;
                    this.migrateRepTemplates(frameDataList);
                    historicView.writeDataFile(currentProject, "frameData.xml", null, encodableObjectFrameData);
                }
            }
        }
        catch (EXDecoderException e) {
            throw new MigrationFailedException((Throwable)e);
        }
    }

    public void migrateACP(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        this.migrateACTorACP(projectFile);
    }

    public void migrateACT(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        this.migrateACTorACP(projectFile);
    }

    private void migrateACTorACP(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        HistoricProjectFileView_3_ projectFileView_3_ = (HistoricProjectFileView_3_)projectFile;
        try {
            Map dataTypeID_2_oldAttributeTypeID_2_newCustomPropertyUID = ModuleDataMigrationProcessor.migrateProjectFile((HistoricProjectFileView_3_)projectFileView_3_, MIGRATOR_EXTENSIONS);
            EOList basePermissionList = projectFileView_3_.getDataList("permissions");
            PermissionMigrator.migratePermissions((Collection<EOPermission>)basePermissionList, dataTypeID_2_oldAttributeTypeID_2_newCustomPropertyUID);
            EOList baseFrameDataList = projectFileView_3_.getDataList("frame_data");
            for (Object o : baseFrameDataList) {
                EOList frameDataList;
                if (!(o instanceof EOList) || !(frameDataList = (EOList)o).getRole().equals(DATA_TYPE_ID_REPORT_TEMPLATE)) continue;
                ReportTemplateMigrator.migrateReportTemplates((Collection<EOFrameData_V0>)frameDataList);
            }
        }
        catch (ProjectFileAccess.ProjectFileAccessException pfaE) {
            throw new MigrationFailedException((Throwable)pfaE);
        }
    }

    private void migrateRepTemplates(EOList<?> frameDataList) throws MigrationFailedException {
        EOList repTemplateContainer = new EOList();
        for (Object o : frameDataList) {
            if (o instanceof EOFrameData_V0) {
                EOFrameData_V0 frameData = (EOFrameData_V0)o;
                if (!frameData.getTypeID().equals(DATA_TYPE_ID_REPORT_TEMPLATE)) continue;
                repTemplateContainer.add((EncodableObjectBase)frameData);
                continue;
            }
            throw new MigrationFailedException("The frame data list contains elements not of expected type EOFrameData_V0: " + o.getClass().getName());
        }
        ReportTemplateMigrator.migrateReportTemplates((Collection<EOFrameData_V0>)repTemplateContainer);
    }
}

