/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.rqm1.rqm1migrator;

import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOLinkDataContainer_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOLinkLog_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOLinkUE_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOLink_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOModuleData_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOProject_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOVersionedModuleData_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.V0_EOFactory;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.modules.EOModuleDataContainer_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.modules.EOModuleXMLDataEnvelope_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.modules.V0_EOFactory_ForModules;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version0.HistoricProjectDumpView_0_;
import com.arcway.cockpit.rqm1.rqm1migrator.Converter;
import com.arcway.cockpit.rqm1.rqm1migrator.messages.AttributeValueConstants;
import com.arcway.cockpit.rqm1.rqm1migrator.messages.EOReqOld;
import com.arcway.cockpit.rqm1.rqm1migrator.messages.EOReqSet;
import com.arcway.cockpit.rqm1.rqm1migrator.messages.EORequirement;
import com.arcway.cockpit.rqm1.rqm1migrator.messages.EORequirementNote;
import com.arcway.cockpit.rqm1.rqm1migrator.messages.MessageDataFactory;
import com.arcway.cockpit.rqm1.rqm1migrator.messages.ModuleIdentification;
import com.arcway.cockpit.rqm1.rqm1migrator.messages.RequirementSetConstants;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.java.collectionmaps.SetMap;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.MessageDataFactoryForBasicEOs;
import de.plans.lib.xml.encoding.MessageDataFactoryForUnknownEOs;
import de.plans.lib.xml.encoding.MultiplexEncodableObjectFactory;
import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RQM1Migrator_ForDumps {
    private static final ILogger logger = Logger.getLogger(RQM1Migrator_ForDumps.class);
    private static final String DUMP_FILE_NAME_REQ = "rqm_req.xml";
    private static final String DUMP_FILE_NAME_REQ_LOG = "rqm_req_log.xml";
    private static final String DUMP_FILE_NAME_LINK_UE = "rqm_link_ue.xml";
    private static final String DUMP_FILE_NAME_NOTE = "rqm_notes.xml";
    private static final String DUMP_FILE_NAME_REQ_SET = "rqm_req_set.xml";
    private static final String MODULE_ID_RQM1 = "RQM";

    public static void migrateData(EOProject_V0 project, HistoricProjectDumpView_0_ historicViewOnProjectDump) throws MigrationFailedException {
        try {
            Iterator<Object> i;
            EOLinkDataContainer_V0 linkData;
            File rqm1UELinksFile;
            File rqm1SetDataFile;
            File rqm1NotesDataFile;
            String projectUID = project.getProjectUID();
            Collection requirementLogs = null;
            Collection requirementNotes = null;
            Collection requirementSets = null;
            EOList moduleUELinks = null;
            ArrayList<EOVersionedModuleData_V0> newRequirementLogs = new ArrayList<EOVersionedModuleData_V0>();
            ArrayList<EOModuleData_V0> newStamps = null;
            ArrayList<EOVersionedModuleData_V0> newStampLogs = new ArrayList<EOVersionedModuleData_V0>();
            ArrayList<EOLink_V0> newLinks = new ArrayList<EOLink_V0>();
            ArrayList linksToBeDeleted = new ArrayList();
            HashMap<String, EOModuleData_V0> reqMap = new HashMap<String, EOModuleData_V0>();
            HashMap<String, EOModuleData_V0> setMap = new HashMap<String, EOModuleData_V0>();
            HashMap<String, EOModuleData_V0> stampMap = new HashMap<String, EOModuleData_V0>();
            HashMap<String, EORequirement> oldReqLogMap = new HashMap<String, EORequirement>();
            HashMap<String, EORequirement> newOldReqLogMap = new HashMap<String, EORequirement>();
            Map newStateLogMap = new HashMap();
            HashMap<String, EOVersionedModuleData_V0> versionLogMap = new HashMap<String, EOVersionedModuleData_V0>();
            HashMap<String, EOVersionedModuleData_V0> requirementCategoryLogMap = new HashMap<String, EOVersionedModuleData_V0>();
            Map newStampNewCat = new HashMap();
            HashMap stampCategoryUIDMap = new HashMap();
            HashMap<String, EOVersionedModuleData_V0> stampCategoryLogUIDMap = new HashMap<String, EOVersionedModuleData_V0>();
            HashMap<String, EOVersionedModuleData_V0> stampUIDLogMap = new HashMap<String, EOVersionedModuleData_V0>();
            HashMap requirementKeyversionLog = new HashMap();
            HashMap requirementKeycategoryLog = new HashMap();
            HashMap requirementKeystateLog = new HashMap();
            HashMap<String, EOVersionedModuleData_V0> uidSetLog = new HashMap<String, EOVersionedModuleData_V0>();
            HashMap reqUIDset = new HashMap();
            HashMap reqUIDstate = new HashMap();
            HashMap reqUIDversion = new HashMap();
            HashMap reqUIDcategory = new HashMap();
            SetMap newReqStamps = new SetMap();
            EOList reqData = (EOList)historicViewOnProjectDump.readDataFile(project, DUMP_FILE_NAME_REQ, MODULE_ID_RQM1, (IEncodableObjectFactory)new MultiplexEncodableObjectFactory(new IEncodableObjectFactory[]{MessageDataFactory.getInstance(), V0_EOFactory_ForModules.getDefault(), MessageDataFactoryForBasicEOs.getDefault()}), false);
            if (reqData == null) {
                return;
            }
            Collection requirements = RQM1Migrator_ForDumps.restoreOldRequirements((Collection)reqData);
            File rqm1DataDirectory = new File(historicViewOnProjectDump.getProjectDirectory(project), MODULE_ID_RQM1);
            File rqm1LogFile = new File(rqm1DataDirectory, DUMP_FILE_NAME_REQ_LOG);
            if (rqm1LogFile.exists()) {
                EOList reqDataLogs = (EOList)historicViewOnProjectDump.readDataFile(project, DUMP_FILE_NAME_REQ_LOG, MODULE_ID_RQM1, (IEncodableObjectFactory)new MultiplexEncodableObjectFactory(new IEncodableObjectFactory[]{MessageDataFactory.getInstance(), V0_EOFactory_ForModules.getDefault(), MessageDataFactoryForBasicEOs.getDefault()}));
                requirementLogs = RQM1Migrator_ForDumps.restoreOldRequirements((Collection)reqDataLogs);
            }
            if ((rqm1NotesDataFile = new File(rqm1DataDirectory, DUMP_FILE_NAME_NOTE)).exists()) {
                EOList notesData = (EOList)historicViewOnProjectDump.readDataFile(project, DUMP_FILE_NAME_NOTE, MODULE_ID_RQM1, (IEncodableObjectFactory)new MultiplexEncodableObjectFactory(new IEncodableObjectFactory[]{MessageDataFactory.getInstance(), V0_EOFactory_ForModules.getDefault(), MessageDataFactoryForBasicEOs.getDefault()}));
                requirementNotes = RQM1Migrator_ForDumps.restoreOldNotes((Collection)notesData);
            }
            if ((rqm1SetDataFile = new File(rqm1DataDirectory, DUMP_FILE_NAME_REQ_SET)).exists()) {
                EOList reqSetData = (EOList)historicViewOnProjectDump.readDataFile(project, DUMP_FILE_NAME_REQ_SET, MODULE_ID_RQM1, (IEncodableObjectFactory)new MultiplexEncodableObjectFactory(new IEncodableObjectFactory[]{MessageDataFactory.getInstance(), V0_EOFactory_ForModules.getDefault(), MessageDataFactoryForBasicEOs.getDefault()}));
                requirementSets = RQM1Migrator_ForDumps.restoreOldReqSets((Collection)reqSetData);
            }
            if ((rqm1UELinksFile = new File(rqm1DataDirectory, DUMP_FILE_NAME_LINK_UE)).exists()) {
                moduleUELinks = (EOList)historicViewOnProjectDump.readDataFile(project, DUMP_FILE_NAME_LINK_UE, MODULE_ID_RQM1, (IEncodableObjectFactory)new MultiplexEncodableObjectFactory(new IEncodableObjectFactory[]{MessageDataFactory.getInstance(), V0_EOFactory_ForModules.getDefault(), V0_EOFactory.getDefault(), MessageDataFactoryForBasicEOs.getDefault()}));
            }
            if ((linkData = historicViewOnProjectDump.readLinks(project)) == null) {
                throw new MigrationFailedException("Can't read link data.");
            }
            ArrayList<EOLink_V0> frameUELinks = new ArrayList<EOLink_V0>();
            ArrayList<EOLink_V0> reqLinks = new ArrayList<EOLink_V0>();
            for (EOLink_V0 link : linkData.getLinks()) {
                if ("LinkReqUniqueElement".equals(link.getLinkTypeID())) {
                    frameUELinks.add(link);
                }
                if (!"LinkReqRef".equals(link.getLinkTypeID())) continue;
                reqLinks.add(link);
            }
            ArrayList<EOModuleData_V0> newSets = new ArrayList<EOModuleData_V0>();
            for (EOReqSet oldSet : requirementSets) {
                EOModuleData_V0 newSet = RQM1Migrator_ForDumps.migrateReqSet(oldSet, projectUID);
                newSets.add(newSet);
                setMap.put(oldSet.getUID(), newSet);
            }
            ArrayList<EOModuleData_V0> newRequirements = new ArrayList<EOModuleData_V0>();
            for (EORequirement oldReq : requirements) {
                EOModuleData_V0 newReq = RQM1Migrator_ForDumps.migrateRequirement(oldReq, projectUID);
                newRequirements.add(newReq);
                reqMap.put(oldReq.getUID(), newReq);
            }
            if (requirementNotes != null) {
                newStamps = new ArrayList<EOModuleData_V0>();
                i = requirementNotes.iterator();
                while (i.hasNext()) {
                    EORequirementNote oldNote = (EORequirementNote)i.next();
                    EOModuleData_V0 newStamp = RQM1Migrator_ForDumps.migrateStamp(oldNote, projectUID);
                    if (reqMap.containsKey(oldNote.getRequirementsUid())) {
                        newStamps.add(newStamp);
                        stampMap.put(oldNote.getUID(), newStamp);
                        EOModuleData_V0 newReq = (EOModuleData_V0)reqMap.get(oldNote.getRequirementsUid());
                        newReqStamps.add((Object)newReq.getUid(), (Object)newStamp);
                        EOLink_V0 eOLink_V0 = new EOLink_V0(projectUID, newReq.getUid(), newStamp.getUid(), ModuleIdentification.getRQM2ModuleID(), "StampRequirement");
                        newLinks.add(eOLink_V0);
                        continue;
                    }
                    logger.warn("Note without requirement: " + oldNote.toString());
                    i.remove();
                }
            }
            Map statesMap = RQM1Migrator_ForDumps.createInitialRequirementStates(projectUID);
            if (frameUELinks != null) {
                newLinks.addAll(RQM1Migrator_ForDumps.migrateFrameUELinks(frameUELinks, projectUID, reqMap));
                linksToBeDeleted.addAll(frameUELinks);
            }
            if (moduleUELinks != null) {
                newLinks.addAll(RQM1Migrator_ForDumps.migrateModuleUELinks((Collection)moduleUELinks, projectUID, reqMap));
            }
            RQM1Migrator_ForDumps.createStateLinks(requirements, reqMap, newLinks, statesMap, reqUIDstate, projectUID);
            Collection newRequirementStates = statesMap.values();
            newStateLogMap = RQM1Migrator_ForDumps.createInitialRequirementStateLogs(statesMap);
            Collection newVersions = RQM1Migrator_ForDumps.createVersions(requirements, reqMap, newLinks, reqUIDversion, projectUID);
            Collection newRequirementCategories = RQM1Migrator_ForDumps.createRequirementCategories(requirements, reqMap, newLinks, reqUIDcategory, projectUID);
            if (requirementNotes != null) {
                newStampNewCat = RQM1Migrator_ForDumps.createStampCategoriesAndLinks(stampMap, requirementNotes, newLinks, projectUID, stampCategoryUIDMap);
            }
            RQM1Migrator_ForDumps.createSetLinks(requirementSets, setMap, newLinks, projectUID);
            RQM1Migrator_ForDumps.createReqSetLinks(requirements, setMap, reqMap, newLinks, projectUID, reqUIDset);
            newLinks.addAll(RQM1Migrator_ForDumps.migrateReqLinks(reqMap, reqLinks, projectUID));
            linksToBeDeleted.addAll(reqLinks);
            if (requirementLogs != null) {
                for (EORequirement oldLog : requirementLogs) {
                    EOVersionedModuleData_V0 newLog = RQM1Migrator_ForDumps.migrateRequirementLog(oldLog, reqMap, projectUID);
                    newRequirementLogs.add(newLog);
                    String key = RQM1Migrator_ForDumps.getUIDVersionKey(oldLog.getUID(), oldLog.getModCount() + 1);
                    oldReqLogMap.put(key, oldLog);
                    key = RQM1Migrator_ForDumps.getUIDVersionKey(newLog.getUid(), newLog.getModCount());
                    newOldReqLogMap.put(key, oldLog);
                }
            }
            List sortedRequirementLogs = RQM1Migrator_ForDumps.sortLogs(newRequirementLogs);
            RQM1Migrator_ForDumps.createAttributeLogs(projectUID, sortedRequirementLogs, newOldReqLogMap, statesMap, newStateLogMap, versionLogMap, requirementCategoryLogMap, requirementKeystateLog, requirementKeyversionLog, requirementKeycategoryLog);
            for (EOModuleData_V0 version : newVersions) {
                EOVersionedModuleData_V0 versionLog = new EOVersionedModuleData_V0(version);
                String string = versionLog.getAttribute("version");
                if (versionLogMap.containsKey(string)) continue;
                versionLogMap.put(string, versionLog);
            }
            for (EOModuleData_V0 category : newRequirementCategories) {
                EOVersionedModuleData_V0 categoryLog = new EOVersionedModuleData_V0(category);
                String string = categoryLog.getAttribute("category");
                if (requirementCategoryLogMap.containsKey(string)) continue;
                requirementCategoryLogMap.put(string, categoryLog);
            }
            ArrayList<EOVersionedModuleData_V0> newSetLogs = new ArrayList<EOVersionedModuleData_V0>();
            for (EOModuleData_V0 set : newSets) {
                EOVersionedModuleData_V0 newLog = new EOVersionedModuleData_V0(set);
                newSetLogs.add(newLog);
                uidSetLog.put(newLog.getUid(), newLog);
            }
            EOModuleData_V0 unknownSet = RQM1Migrator_ForDumps.getNewModuleData("rqm2.set", projectUID);
            unknownSet.addAttribute("set_name", "unknown");
            unknownSet.addAttribute("set_description", "");
            unknownSet.addAttribute("set_pattern", Integer.toString(0));
            unknownSet.addAttribute("set_prefix", "UNK");
            unknownSet.addAttribute("set_prefix_default", Boolean.toString(true));
            EOVersionedModuleData_V0 unknownSetLog = new EOVersionedModuleData_V0(unknownSet);
            newSetLogs.add(unknownSetLog);
            uidSetLog.put(unknownSetLog.getUid(), unknownSetLog);
            for (EOModuleData_V0 eOModuleData_V0 : stampCategoryUIDMap.values()) {
                EOVersionedModuleData_V0 stampCategoryLog = new EOVersionedModuleData_V0(eOModuleData_V0);
                stampCategoryLogUIDMap.put(stampCategoryLog.getUid(), stampCategoryLog);
            }
            for (Map.Entry entry : newStampNewCat.entrySet()) {
                EOModuleData_V0 stamp = (EOModuleData_V0)entry.getKey();
                EOModuleData_V0 stampCategory = (EOModuleData_V0)entry.getValue();
                EOVersionedModuleData_V0 stampLog = new EOVersionedModuleData_V0(stamp);
                EOVersionedModuleData_V0 stampCategoryLog = (EOVersionedModuleData_V0)stampCategoryLogUIDMap.get(stampCategory.getUid());
                EOLinkLog_V0 linkLog = new EOLinkLog_V0(projectUID, stampCategoryLog.getUid(), stampCategoryLog.getModCount(), stampLog.getUid(), stampLog.getModCount(), ModuleIdentification.getRQM2ModuleID(), "StampStampCategory");
                stampLog.addOutLink(linkLog);
                newStampLogs.add(stampLog);
                stampUIDLogMap.put(stampLog.getUid(), stampLog);
            }
            i = newRequirements.iterator();
            while (i.hasNext()) {
                RQM1Migrator_ForDumps.createNewReqLogs(projectUID, newRequirementLogs, newStateLogMap, versionLogMap, requirementCategoryLogMap, stampUIDLogMap, requirementKeyversionLog, requirementKeycategoryLog, requirementKeystateLog, reqUIDstate, reqUIDversion, reqUIDcategory, newReqStamps, i);
            }
            i = newRequirementLogs.iterator();
            while (i.hasNext()) {
                RQM1Migrator_ForDumps.createLogAttributeLinks(projectUID, oldReqLogMap, requirementKeyversionLog, requirementKeycategoryLog, requirementKeystateLog, uidSetLog, reqUIDset, i, unknownSetLog);
            }
            Collection collection = versionLogMap.values();
            Collection requirementCategoryLogs = requirementCategoryLogMap.values();
            RQM1Migrator_ForDumps.insertItems(project, historicViewOnProjectDump, newRequirements, newVersions, newSets, newStamps, newRequirementCategories, newRequirementStates, stampCategoryUIDMap);
            RQM1Migrator_ForDumps.insertEditions(project, historicViewOnProjectDump, newRequirementLogs, newSetLogs, newStampLogs, newStateLogMap, stampCategoryLogUIDMap, collection, requirementCategoryLogs);
            linkData.getLinks().removeAll(linksToBeDeleted);
            linkData.getLinks().addAll(newLinks);
            historicViewOnProjectDump.deleteDataDirectory(project, MODULE_ID_RQM1);
        }
        catch (EXDecoderException e) {
            throw new MigrationFailedException((Throwable)e);
        }
    }

    private static void insertEditions(EOProject_V0 project, HistoricProjectDumpView_0_ historicViewOnDumpFile, Collection newRequirementLogs, Collection newSetLogs, Collection newStampLogs, Map newStateLogMap, Map stampCategoryLogUIDMap, Collection versionLogs, Collection requirementCategoryLogs) throws MigrationFailedException {
        try {
            EOList moduleDataLogs = (EOList)historicViewOnDumpFile.readDataFile(project, "cmm_data_log.xml", "cmm", (IEncodableObjectFactory)new MultiplexEncodableObjectFactory(new IEncodableObjectFactory[]{V0_EOFactory_ForModules.getDefault(), V0_EOFactory.getDefault(), MessageDataFactoryForBasicEOs.getDefault(), MessageDataFactoryForUnknownEOs.getDefault()}));
            EOModuleDataContainer_V0 requirementsContainer = new EOModuleDataContainer_V0();
            requirementsContainer.setDataTypeUID("rqm2.requirement");
            requirementsContainer.setModuleDataItems(new EOList(newRequirementLogs));
            moduleDataLogs.add((EncodableObjectBase)requirementsContainer);
            EOModuleDataContainer_V0 setsContainer = new EOModuleDataContainer_V0();
            setsContainer.setDataTypeUID("rqm2.set");
            setsContainer.setModuleDataItems(new EOList(newSetLogs));
            moduleDataLogs.add((EncodableObjectBase)setsContainer);
            EOModuleDataContainer_V0 versionsContainer = new EOModuleDataContainer_V0();
            versionsContainer.setDataTypeUID("rqm2.version");
            versionsContainer.setModuleDataItems(new EOList(versionLogs));
            moduleDataLogs.add((EncodableObjectBase)versionsContainer);
            EOModuleDataContainer_V0 statesContainer = new EOModuleDataContainer_V0();
            statesContainer.setDataTypeUID("rqm2.requirementState");
            statesContainer.setModuleDataItems(new EOList(newStateLogMap.values()));
            moduleDataLogs.add((EncodableObjectBase)statesContainer);
            if (newStampLogs != null) {
                EOModuleDataContainer_V0 stampsContainer = new EOModuleDataContainer_V0();
                stampsContainer.setDataTypeUID("rqm2.stamp");
                stampsContainer.setModuleDataItems(new EOList(newStampLogs));
                moduleDataLogs.add((EncodableObjectBase)stampsContainer);
            }
            EOModuleDataContainer_V0 categoriesContainer = new EOModuleDataContainer_V0();
            categoriesContainer.setDataTypeUID("rqm2.category");
            categoriesContainer.setModuleDataItems(new EOList(requirementCategoryLogs));
            moduleDataLogs.add((EncodableObjectBase)categoriesContainer);
            EOModuleDataContainer_V0 stampCategoriesContainer = new EOModuleDataContainer_V0();
            stampCategoriesContainer.setDataTypeUID("rqm2.stampCategory");
            stampCategoriesContainer.setModuleDataItems(new EOList(stampCategoryLogUIDMap.values()));
            moduleDataLogs.add((EncodableObjectBase)stampCategoriesContainer);
            boolean success = historicViewOnDumpFile.writeDataFile(project, "cmm_data_log.xml", "cmm", (EncodableObjectBase)moduleDataLogs);
            if (!success) {
                throw new MigrationFailedException("Can't write back migrated rqm data logs.");
            }
        }
        catch (EXDecoderException e) {
            throw new MigrationFailedException((Throwable)e);
        }
    }

    private static void insertItems(EOProject_V0 project, HistoricProjectDumpView_0_ historicViewOnDumpFile, Collection newRequirements, Collection newVersions, Collection newSets, Collection newStamps, Collection newRequirementCategories, Collection newRequirementStates, Map stampCategoryUIDMap) throws MigrationFailedException {
        try {
            EOList moduleData = (EOList)historicViewOnDumpFile.readDataFile(project, "cmm_data.xml", "cmm", (IEncodableObjectFactory)new MultiplexEncodableObjectFactory(new IEncodableObjectFactory[]{V0_EOFactory_ForModules.getDefault(), V0_EOFactory.getDefault(), MessageDataFactoryForBasicEOs.getDefault(), MessageDataFactoryForUnknownEOs.getDefault()}));
            EOModuleDataContainer_V0 requirementsContainer = new EOModuleDataContainer_V0();
            requirementsContainer.setDataTypeUID("rqm2.requirement");
            requirementsContainer.setModuleDataItems(new EOList(newRequirements));
            moduleData.add((EncodableObjectBase)requirementsContainer);
            EOModuleDataContainer_V0 setsContainer = new EOModuleDataContainer_V0();
            setsContainer.setDataTypeUID("rqm2.set");
            setsContainer.setModuleDataItems(new EOList(newSets));
            moduleData.add((EncodableObjectBase)setsContainer);
            EOModuleDataContainer_V0 versionsContainer = new EOModuleDataContainer_V0();
            versionsContainer.setDataTypeUID("rqm2.version");
            versionsContainer.setModuleDataItems(new EOList(newVersions));
            moduleData.add((EncodableObjectBase)versionsContainer);
            EOModuleDataContainer_V0 statesContainer = new EOModuleDataContainer_V0();
            statesContainer.setDataTypeUID("rqm2.requirementState");
            statesContainer.setModuleDataItems(new EOList(newRequirementStates));
            moduleData.add((EncodableObjectBase)statesContainer);
            if (newStamps != null) {
                EOModuleDataContainer_V0 stampsContainer = new EOModuleDataContainer_V0();
                stampsContainer.setDataTypeUID("rqm2.stamp");
                stampsContainer.setModuleDataItems(new EOList(newStamps));
                moduleData.add((EncodableObjectBase)stampsContainer);
            }
            EOModuleDataContainer_V0 categoriesContainer = new EOModuleDataContainer_V0();
            categoriesContainer.setDataTypeUID("rqm2.category");
            categoriesContainer.setModuleDataItems(new EOList(newRequirementCategories));
            moduleData.add((EncodableObjectBase)categoriesContainer);
            EOModuleDataContainer_V0 stampCategoriesContainer = new EOModuleDataContainer_V0();
            stampCategoriesContainer.setDataTypeUID("rqm2.stampCategory");
            stampCategoriesContainer.setModuleDataItems(new EOList(stampCategoryUIDMap.values()));
            moduleData.add((EncodableObjectBase)stampCategoriesContainer);
            boolean success = historicViewOnDumpFile.writeDataFile(project, "cmm_data.xml", "cmm", (EncodableObjectBase)moduleData);
            if (!success) {
                throw new MigrationFailedException("Can't write back migrated rqm data.");
            }
        }
        catch (EXDecoderException e) {
            throw new MigrationFailedException((Throwable)e);
        }
    }

    private static void createNewReqLogs(String projectUID, Collection newRequirementLogs, Map newStateLogMap, Map versionLogMap, Map requirementCategoryLogMap, Map stampUIDLogMap, Map requirementKeyversionLog, Map requirementKeycategoryLog, Map requirementKeystateLog, Map reqUIDstate, Map reqUIDversion, Map reqUIDcategory, SetMap newReqStamps, Iterator i) {
        EOModuleData_V0 category;
        EOModuleData_V0 version;
        EOModuleData_V0 requirement = (EOModuleData_V0)i.next();
        EOVersionedModuleData_V0 requirementLog = new EOVersionedModuleData_V0(requirement);
        Set stamps = newReqStamps.get((Object)requirementLog.getUid());
        for (EOModuleData_V0 stamp : stamps) {
            EOVersionedModuleData_V0 stampLog = (EOVersionedModuleData_V0)stampUIDLogMap.get(stamp.getUid());
            EOLinkLog_V0 linkLog = new EOLinkLog_V0(projectUID, requirementLog.getUid(), requirementLog.getModCount(), stampLog.getUid(), stampLog.getModCount(), ModuleIdentification.getRQM2ModuleID(), "StampRequirement");
            requirementLog.addInLink(linkLog);
        }
        String reqKey = RQM1Migrator_ForDumps.getUIDVersionKey(requirementLog.getUid(), requirementLog.getModCount());
        EOModuleData_V0 state = (EOModuleData_V0)reqUIDstate.get(requirement.getUid());
        if (state != null) {
            EOVersionedModuleData_V0 stateLog = (EOVersionedModuleData_V0)newStateLogMap.get(RQM1Migrator_ForDumps.getUIDVersionKey(state.getUid(), state.getModCount()));
            requirementKeystateLog.put(reqKey, stateLog);
        }
        if ((version = (EOModuleData_V0)reqUIDversion.get(requirement.getUid())) != null) {
            String versionValue = version.getAttribute("version");
            EOVersionedModuleData_V0 versionLog = (EOVersionedModuleData_V0)versionLogMap.get(versionValue);
            requirementKeyversionLog.put(reqKey, versionLog);
        }
        if ((category = (EOModuleData_V0)reqUIDcategory.get(requirement.getUid())) != null) {
            String categoryValue = category.getAttribute("category");
            EOVersionedModuleData_V0 categoryLog = (EOVersionedModuleData_V0)requirementCategoryLogMap.get(categoryValue);
            requirementKeycategoryLog.put(reqKey, categoryLog);
        }
        newRequirementLogs.add(requirementLog);
    }

    private static void createLogAttributeLinks(String projectUID, Map oldReqLogMap, Map requirementKeyversionLog, Map requirementKeycategoryLog, Map requirementKeystateLog, Map uidSetLog, Map reqUIDset, Iterator i, EOVersionedModuleData_V0 unknownSetLog) {
        EOVersionedModuleData_V0 categoryLog;
        EOVersionedModuleData_V0 versionLog;
        int requirementLogModCount;
        EOVersionedModuleData_V0 requirementLog = (EOVersionedModuleData_V0)i.next();
        String requirementLogUID = requirementLog.getUid();
        String reqLogKey = RQM1Migrator_ForDumps.getUIDVersionKey(requirementLogUID, requirementLogModCount = requirementLog.getModCount());
        EORequirement oldLog = (EORequirement)((Object)oldReqLogMap.get(reqLogKey));
        String setUID = oldLog != null ? oldLog.getUID() : ((EOModuleData_V0)reqUIDset.get(requirementLogUID)).getUid();
        EOVersionedModuleData_V0 setLog = (EOVersionedModuleData_V0)uidSetLog.get(setUID);
        if (setLog == null) {
            setLog = unknownSetLog;
        }
        EOLinkLog_V0 linkLog = new EOLinkLog_V0(projectUID, setUID, setLog.getModCount(), requirementLogUID, requirementLogModCount, ModuleIdentification.getRQM2ModuleID(), "RequirementRequirementSet");
        setLog.addInLink(linkLog);
        EOVersionedModuleData_V0 stateLog = (EOVersionedModuleData_V0)requirementKeystateLog.get(reqLogKey);
        if (stateLog != null) {
            linkLog = new EOLinkLog_V0(projectUID, stateLog.getUid(), stateLog.getModCount(), requirementLogUID, requirementLogModCount, ModuleIdentification.getRQM2ModuleID(), "RequirementState");
            requirementLog.addOutLink(linkLog);
        }
        if ((versionLog = (EOVersionedModuleData_V0)requirementKeyversionLog.get(reqLogKey)) != null) {
            linkLog = new EOLinkLog_V0(projectUID, versionLog.getUid(), versionLog.getModCount(), requirementLogUID, requirementLogModCount, ModuleIdentification.getRQM2ModuleID(), "RequirementVersion");
            requirementLog.addOutLink(linkLog);
        }
        if ((categoryLog = (EOVersionedModuleData_V0)requirementKeycategoryLog.get(reqLogKey)) != null) {
            linkLog = new EOLinkLog_V0(projectUID, categoryLog.getUid(), categoryLog.getModCount(), requirementLogUID, requirementLogModCount, ModuleIdentification.getRQM2ModuleID(), "RequirementCategory");
            requirementLog.addOutLink(linkLog);
        }
    }

    private static Collection migrateReqLinks(Map reqMap, Collection reqLinks, String projectUID) {
        ArrayList<EOLink_V0> newLinks = new ArrayList<EOLink_V0>();
        for (EOLink_V0 oldLink : reqLinks) {
            EOLink_V0 newLink = new EOLink_V0(projectUID, ((EOModuleData_V0)reqMap.get(oldLink.getLinkableObjectUID())).getUid(), ((EOModuleData_V0)reqMap.get(oldLink.getModuleDataUID())).getUid(), ModuleIdentification.getRQM2ModuleID(), "RequirementRequirement");
            newLinks.add(newLink);
        }
        return newLinks;
    }

    private static Collection restoreOldReqSets(Collection data) {
        ArrayList<EOReqSet> sets = new ArrayList<EOReqSet>(data.size());
        for (Object element : data) {
            EOReqSet set = RQM1Migrator_ForDumps.extractSet(element);
            if (set == null) continue;
            sets.add(set);
        }
        return sets;
    }

    private static EOReqSet extractSet(Object o) {
        if (o instanceof EOReqSet) {
            return (EOReqSet)((Object)o);
        }
        if (o instanceof EOModuleXMLDataEnvelope_V0) {
            return Converter.convertEnvelopeIntoReqSet((EOModuleXMLDataEnvelope_V0)o);
        }
        logger.error("RQM2 OldRequirementDumpAgent.extractRequirement() -- Wrong type in dump file: " + o.getClass().getName());
        return null;
    }

    private static Collection restoreOldNotes(Collection data) {
        ArrayList<EORequirementNote> notes = new ArrayList<EORequirementNote>(data.size());
        for (Object element : data) {
            EORequirementNote note = RQM1Migrator_ForDumps.extractNote(element);
            if (note == null) continue;
            notes.add(note);
        }
        return notes;
    }

    private static EORequirementNote extractNote(Object o) {
        if (o instanceof EORequirementNote) {
            return (EORequirementNote)o;
        }
        if (o instanceof EOModuleXMLDataEnvelope_V0) {
            return Converter.convertEnvelopeIntoNote((EOModuleXMLDataEnvelope_V0)o);
        }
        logger.error("RQM2 OldRequirementDumpAgent.extractRequirement() -- Wrong type in dump file: " + o.getClass().getName());
        return null;
    }

    private static Collection restoreOldRequirements(Collection data) {
        ArrayList<EORequirement> requirements = new ArrayList<EORequirement>(data.size());
        for (Object element : data) {
            EORequirement req = RQM1Migrator_ForDumps.extractRequirement(element);
            if (req == null) continue;
            requirements.add(req);
        }
        return requirements;
    }

    private static EORequirement extractRequirement(Object o) {
        if (o instanceof EOReqOld) {
            return ((EOReqOld)((Object)o)).createEORequirement();
        }
        if (o instanceof EORequirement) {
            return (EORequirement)((Object)o);
        }
        if (o instanceof EOModuleXMLDataEnvelope_V0) {
            return Converter.convertEnvelopeIntoRequirement((EOModuleXMLDataEnvelope_V0)o);
        }
        logger.error("RQM2 OldRequirementDumpAgent.extractRequirement() -- Wrong type in dump file: " + o.getClass().getName());
        return null;
    }

    private static EOModuleData_V0 migrateReqSet(EOReqSet set, String projectUID) {
        EOModuleData_V0 data = new EOModuleData_V0();
        data.setUid(set.getUID());
        data.setProjectUID(projectUID);
        data.setDatatypeUID("rqm2.set");
        data.addAttribute("set_description", set.getDescription());
        data.addAttribute("set_name", set.getSetName());
        data.addAttribute("set_pattern", RQM1Migrator_ForDumps.convertReqSetIDPattern(set.getReqIDPattern()));
        data.addAttribute("set_prefix", set.getReqIDPrefix());
        data.addAttribute("set_prefix_default", Boolean.toString(set.isStandardPrefix()));
        Timestamp creationDate = set.getDateOfCreation();
        if (creationDate == null) {
            creationDate = new Timestamp(System.currentTimeMillis());
        }
        data.addAttribute("abstractmoduledata_creationDate", Long.toString(creationDate.getTime()));
        Timestamp modificationDate = set.getDateOfChange();
        if (modificationDate == null) {
            modificationDate = new Timestamp(System.currentTimeMillis());
        }
        data.addAttribute("abstractmoduledata_modificationDate", Long.toString(modificationDate.getTime()));
        data.addAttribute("abstractmoduledata_creator", set.getAuthor());
        data.addAttribute("abstractmoduledata_modifier", set.getModifier());
        data.addAttribute("abstractmoduledata_modificationCount", Integer.toString(set.getModCount()));
        return data;
    }

    private static String convertReqSetIDPattern(String oldPattern) {
        String[] idPatterns = RequirementSetConstants.ID_PATTERNS;
        int maxLength = idPatterns.length;
        return Integer.toString(Math.min(oldPattern.length(), maxLength) - 1);
    }

    private static EOModuleData_V0 migrateRequirement(EORequirement req, String projectUID) {
        EOModuleData_V0 newReq = new EOModuleData_V0();
        newReq.setUid(req.getUID());
        newReq.setProjectUID(projectUID);
        newReq.setDatatypeUID("rqm2.requirement");
        newReq.addAttribute("req_description", req.getDescription());
        String dissatisfaction = AttributeValueConstants.getNewAttributeValue(req.getDissatisfaction());
        if (dissatisfaction == null) {
            logger.warn("Unknown value for dissatisfaction:" + req.getDissatisfaction());
            dissatisfaction = AttributeValueConstants.getNewAttributeValue("");
        }
        newReq.addAttribute("req_dissatisfaction", dissatisfaction);
        String effort = AttributeValueConstants.getNewAttributeValue(req.getEffortToChange());
        if (effort == null) {
            logger.warn("Unknown value for effort: " + req.getEffortToChange() + " Replacing with default value");
            effort = AttributeValueConstants.getNewAttributeValue("");
        }
        newReq.addAttribute("req_effortToChange", effort);
        newReq.addAttribute("req_fit", req.getFitCriterion());
        newReq.addAttribute("req_id", req.getId());
        String partAgree = AttributeValueConstants.getNewAttributeValue(req.getPartOfAgreement());
        if (partAgree == null) {
            logger.warn("Unknown value for part of agreement. Replacing with default value");
            partAgree = AttributeValueConstants.getNewAttributeValue("");
        }
        newReq.addAttribute("req_partOfAgreement", partAgree);
        String priority = AttributeValueConstants.getNewAttributeValue(req.getPriority());
        if (priority == null) {
            logger.warn("Unknown value for priority. Replacing with default value");
            priority = AttributeValueConstants.getNewAttributeValue("");
        }
        newReq.addAttribute("req_priority", priority);
        String probChange = AttributeValueConstants.getNewAttributeValue(req.getProbToChange());
        if (probChange == null) {
            logger.warn("Unknown value for probability of change. Replacing with default value");
            probChange = AttributeValueConstants.getNewAttributeValue("");
        }
        newReq.addAttribute("req_probabilityOfChange", probChange);
        String satisfaction = AttributeValueConstants.getNewAttributeValue(req.getSatisfaction());
        if (satisfaction == null) {
            logger.warn("Unknown value for satisfaction. Replacing with default value");
            satisfaction = AttributeValueConstants.getNewAttributeValue("");
        }
        newReq.addAttribute("req_satisfaction", satisfaction);
        newReq.addAttribute("req_title", req.getTitle());
        String type = AttributeValueConstants.getNewAttributeValue(req.getType());
        if (type == null) {
            logger.warn("Unknown value for type. Replacing with default value");
            type = AttributeValueConstants.getNewAttributeValue("");
        }
        newReq.addAttribute("req_type", type);
        newReq.addAttribute("req_INITIATOR", req.getInitiator());
        newReq.addAttribute("abstractmoduledata_creator", req.getAuthor());
        newReq.addAttribute("abstractmoduledata_modifier", req.getModifier());
        int modCount = req.getModCount() + 1;
        newReq.addAttribute("abstractmoduledata_modificationCount", Integer.toString(modCount));
        newReq.setModCount(modCount);
        Timestamp creationDate = req.getDateOfCreation();
        long lCreatDate = creationDate != null ? ((Date)creationDate).getTime() : System.currentTimeMillis();
        newReq.addAttribute("abstractmoduledata_creationDate", Long.toString(lCreatDate));
        Timestamp modificationDate = req.getDateOfChange();
        long lModDate = modificationDate != null ? ((Date)modificationDate).getTime() : lCreatDate;
        newReq.addAttribute("abstractmoduledata_modificationDate", Long.toString(lModDate));
        newReq.setModTime(lModDate);
        return newReq;
    }

    private static EOVersionedModuleData_V0 migrateRequirementLog(EORequirement log, Map reqMap, String projectUID) {
        EOVersionedModuleData_V0 reqLog = new EOVersionedModuleData_V0(RQM1Migrator_ForDumps.migrateRequirement(log, projectUID));
        reqLog.setUid(((EOModuleData_V0)reqMap.get(log.getUID())).getUid());
        return reqLog;
    }

    private static List sortLogs(Collection logs) {
        ArrayList logList = new ArrayList(logs);
        Collections.sort(logList, new Comparator(){

            public int compare(Object o1, Object o2) {
                EOVersionedModuleData_V0 log1 = (EOVersionedModuleData_V0)o1;
                EOVersionedModuleData_V0 log2 = (EOVersionedModuleData_V0)o2;
                int timeCompare = log1.getModTime() < log2.getModTime() ? -1 : (log1.getModTime() > log2.getModTime() ? 1 : 0);
                return timeCompare != 0 ? timeCompare : log1.getUid().compareTo(log2.getUid());
            }
        });
        return logList;
    }

    private static void createAttributeLogs(String projectUID, List sortedRequirementLogs, Map requirementLogMap, Map stateMap, Map newStateKeyLogs, Map newVersionLogs, Map newCategoryLogs, Map reqState, Map reqVersion, Map reqCategory) {
        for (EOVersionedModuleData_V0 requirement : sortedRequirementLogs) {
            String oldCategory;
            EORequirement oldRequirement = (EORequirement)((Object)requirementLogMap.get(RQM1Migrator_ForDumps.getUIDVersionKey(requirement.getUid(), requirement.getModCount())));
            String oldState = oldRequirement.getStatus().trim();
            EOModuleData_V0 newState = (EOModuleData_V0)stateMap.get(oldState);
            if (newState == null) {
                logger.warn("Unknown state: " + oldState + " Ignoring.");
            } else {
                EOVersionedModuleData_V0 newStateLog = (EOVersionedModuleData_V0)newStateKeyLogs.get(RQM1Migrator_ForDumps.getUIDVersionKey(newState.getUid(), newState.getModCount()));
                EOLinkLog_V0 link = new EOLinkLog_V0(projectUID, newStateLog.getUid(), newStateLog.getModCount(), requirement.getUid(), requirement.getModCount(), ModuleIdentification.getRQM2ModuleID(), "RequirementState");
                requirement.addOutLink(link);
                reqState.put(RQM1Migrator_ForDumps.getUIDVersionKey(requirement.getUid(), requirement.getModCount()), newStateLog);
            }
            String oldVersion = oldRequirement.getVersion().trim();
            if (oldVersion.length() > 0) {
                EOVersionedModuleData_V0 newVersion = (EOVersionedModuleData_V0)newVersionLogs.get(oldVersion);
                if (newVersion == null) {
                    newVersion = RQM1Migrator_ForDumps.getNewVersionedModuleData("rqm2.version", projectUID);
                    newVersion.addAttribute("rqm2.version", oldVersion);
                    newVersionLogs.put(oldVersion, newVersion);
                }
                EOLinkLog_V0 link = new EOLinkLog_V0(projectUID, newVersion.getUid(), newVersion.getModCount(), requirement.getUid(), requirement.getModCount(), ModuleIdentification.getRQM2ModuleID(), "RequirementVersion");
                requirement.addOutLink(link);
                reqVersion.put(RQM1Migrator_ForDumps.getUIDVersionKey(requirement.getUid(), requirement.getModCount()), newVersion);
            }
            if ((oldCategory = oldRequirement.getCategory().trim()).length() <= 0) continue;
            EOVersionedModuleData_V0 newCategory = (EOVersionedModuleData_V0)newCategoryLogs.get(oldCategory);
            if (newCategory == null) {
                newCategory = RQM1Migrator_ForDumps.getNewVersionedModuleData("rqm2.category", projectUID);
                newCategory.addAttribute("rqm2.category", oldCategory);
                newCategoryLogs.put(oldCategory, newCategory);
            }
            EOLinkLog_V0 link = new EOLinkLog_V0(projectUID, newCategory.getUid(), newCategory.getModCount(), requirement.getUid(), requirement.getModCount(), ModuleIdentification.getRQM2ModuleID(), "RequirementCategory");
            requirement.addOutLink(link);
            reqCategory.put(RQM1Migrator_ForDumps.getUIDVersionKey(requirement.getUid(), requirement.getModCount()), newCategory);
        }
    }

    private static EOModuleData_V0 migrateStamp(EORequirementNote note, String projectUID) {
        EOModuleData_V0 stamp = new EOModuleData_V0();
        stamp.setUid(note.getUID());
        stamp.setProjectUID(projectUID);
        stamp.setDatatypeUID("rqm2.stamp");
        stamp.addAttribute("stamp_text", note.getText());
        stamp.addAttribute("abstractmoduledata_creationDate", Long.toString(note.getDateCreation().getTime()));
        stamp.addAttribute("abstractmoduledata_modificationDate", Long.toString(note.getDateModification().getTime()));
        stamp.addAttribute("abstractmoduledata_creator", note.getAuthorName());
        stamp.addAttribute("abstractmoduledata_modifier", note.getModifier());
        stamp.addAttribute("abstractmoduledata_modificationCount", Integer.toString(note.getModCount()));
        return stamp;
    }

    private static Collection migrateModuleUELinks(Collection oldLinks, String projectUID, Map reqMap) {
        ArrayList<EOLink_V0> newLinks = new ArrayList<EOLink_V0>();
        for (EOLinkUE_V0 oldLink : oldLinks) {
            EOModuleData_V0 requirement = (EOModuleData_V0)reqMap.get(oldLink.getDataUID());
            if (requirement == null) continue;
            EOLink_V0 newLink = new EOLink_V0(oldLink, "RequirementUniqueElement", ModuleIdentification.getRQM2ModuleID());
            newLink.setProjectUID(projectUID);
            newLinks.add(newLink);
            newLink.setModuleDataUID(requirement.getUid());
        }
        return newLinks;
    }

    private static Collection migrateFrameUELinks(Collection oldLinks, String projectUID, Map reqMap) {
        ArrayList<EOLink_V0> newLinks = new ArrayList<EOLink_V0>();
        for (EOLink_V0 oldLink : oldLinks) {
            EOModuleData_V0 requirement = (EOModuleData_V0)reqMap.get(oldLink.getModuleDataUID());
            if (requirement != null) {
                EOLink_V0 newLink = new EOLink_V0(oldLink);
                newLink.setLinkTypeID("RequirementUniqueElement");
                newLink.setModuleID(ModuleIdentification.getRQM2ModuleID());
                newLink.setProjectUID(projectUID);
                newLink.setModuleDataUID(requirement.getUid());
                newLinks.add(newLink);
                continue;
            }
            logger.warn("UE link without requirement: " + oldLink.toString());
        }
        return newLinks;
    }

    private static Map createStampCategoriesAndLinks(Map oldNewStampsMapping, Collection oldNotes, Collection newLinks, String projectUID, Map categoryUIDMap) {
        HashMap<String, EOModuleData_V0> usedCategories = new HashMap<String, EOModuleData_V0>();
        HashMap<EOModuleData_V0, EOModuleData_V0> stampCategoryMap = new HashMap<EOModuleData_V0, EOModuleData_V0>();
        for (EORequirementNote note : oldNotes) {
            EOModuleData_V0 category;
            String categoryName = note.getCategory().trim();
            if (usedCategories.containsKey(categoryName)) {
                category = (EOModuleData_V0)usedCategories.get(categoryName);
            } else {
                category = RQM1Migrator_ForDumps.getNewModuleData("rqm2.stampCategory", projectUID);
                category.addAttribute("stampCategoryName", categoryName);
                usedCategories.put(categoryName, category);
                categoryUIDMap.put(category.getUid(), category);
            }
            EOModuleData_V0 stamp = (EOModuleData_V0)oldNewStampsMapping.get(note.getUID());
            EOLink_V0 link = new EOLink_V0(projectUID, category.getUid(), stamp.getUid(), ModuleIdentification.getRQM2ModuleID(), "StampStampCategory");
            newLinks.add(link);
            stampCategoryMap.put(stamp, category);
        }
        return stampCategoryMap;
    }

    private static Collection createRequirementCategories(Collection oldRequirements, Map reqMap, Collection newLinks, Map reqUIDcategory, String projectUID) {
        HashMap<String, EOModuleData_V0> usedCategories = new HashMap<String, EOModuleData_V0>();
        for (EORequirement oldReq : oldRequirements) {
            EOModuleData_V0 category;
            String categoryName = oldReq.getCategory().trim();
            if (categoryName.length() <= 0) continue;
            if (usedCategories.containsKey(categoryName)) {
                category = (EOModuleData_V0)usedCategories.get(categoryName);
            } else {
                category = RQM1Migrator_ForDumps.getNewModuleData("rqm2.category", projectUID);
                category.addAttribute("category", categoryName);
                usedCategories.put(categoryName, category);
            }
            EOModuleData_V0 newReq = (EOModuleData_V0)reqMap.get(oldReq.getUID());
            EOLink_V0 link = new EOLink_V0(projectUID, category.getUid(), newReq.getUid(), ModuleIdentification.getRQM2ModuleID(), "RequirementCategory");
            newLinks.add(link);
            reqUIDcategory.put(newReq.getUid(), category);
        }
        return usedCategories.values();
    }

    private static Collection createVersions(Collection oldRequirements, Map reqMap, Collection newLinks, Map reqUIDversion, String projectUID) {
        HashMap<String, EOModuleData_V0> usedVersions = new HashMap<String, EOModuleData_V0>();
        for (EORequirement requirement : oldRequirements) {
            EOModuleData_V0 version;
            String versionName = RQM1Migrator_ForDumps.getVersion(requirement);
            if (versionName.length() <= 0) continue;
            if (usedVersions.containsKey(versionName)) {
                version = (EOModuleData_V0)usedVersions.get(versionName);
            } else {
                version = RQM1Migrator_ForDumps.getNewModuleData("rqm2.version", projectUID);
                version.addAttribute("version", versionName);
                usedVersions.put(versionName, version);
            }
            EOModuleData_V0 newRequirement = (EOModuleData_V0)reqMap.get(requirement.getUID());
            EOLink_V0 link = new EOLink_V0(projectUID, version.getUid(), newRequirement.getUid(), ModuleIdentification.getRQM2ModuleID(), "RequirementVersion");
            newLinks.add(link);
            reqUIDversion.put(newRequirement.getUid(), version);
        }
        return usedVersions.values();
    }

    private static void createStateLinks(Collection oldRequirements, Map reqMap, Collection newLinks, Map states, Map reqUIDstate, String projectUID) {
        for (EORequirement oldReq : oldRequirements) {
            EOModuleData_V0 newReq = (EOModuleData_V0)reqMap.get(oldReq.getUID());
            String status = oldReq.getStatus();
            if (status == null || status.equals("")) continue;
            EOModuleData_V0 newState = (EOModuleData_V0)states.get(status);
            if (newState == null) {
                newState = new EOModuleData_V0();
                newState.setDatatypeUID("rqm2.requirementState");
                newState.setProjectUID(projectUID);
                newState.setUid(UUIDGenerator.getUniqueID());
                newState.setModCount(1);
                newState.setModTime(System.currentTimeMillis());
                newState.addAttribute("requirementStateSetState", status);
                newState.addAttribute("abstractmoduledata_modificationDate", Long.toString(newState.getModTime()));
                newState.addAttribute("abstractmoduledata_creationDate", Long.toString(newState.getModTime()));
                newState.addAttribute("abstractmoduledata_creator", oldReq.getModifier());
                newState.addAttribute("abstractmoduledata_modifier", oldReq.getModifier());
                newState.addAttribute("abstractmoduledata_modificationCount", "1");
                states.put(status, newState);
            }
            EOLink_V0 link = new EOLink_V0(projectUID, newState.getUid(), newReq.getUid(), ModuleIdentification.getRQM2ModuleID(), "RequirementState");
            newLinks.add(link);
            reqUIDstate.put(newReq.getUid(), newState);
        }
    }

    private static String getVersion(EORequirement req) {
        return req.getVersion().trim();
    }

    private static EOModuleData_V0 getNewModuleData(String dataTypeUID, String projectUID) {
        EOModuleData_V0 data = new EOModuleData_V0();
        long currentTime = System.currentTimeMillis();
        int modCount = 1;
        data.setProjectUID(projectUID);
        data.setDatatypeUID(dataTypeUID);
        data.addAttribute("abstractmoduledata_creationDate", Long.toString(currentTime));
        data.addAttribute("abstractmoduledata_modificationDate", Long.toString(currentTime));
        data.setModTime(currentTime);
        data.addAttribute("abstractmoduledata_modificationCount", Integer.toString(modCount));
        data.setModCount(modCount);
        data.setUid(UUIDGenerator.getUniqueID());
        return data;
    }

    private static EOVersionedModuleData_V0 getNewVersionedModuleData(String dataTypeUID, String projectUID) {
        EOVersionedModuleData_V0 version = new EOVersionedModuleData_V0(RQM1Migrator_ForDumps.getNewModuleData(dataTypeUID, projectUID));
        version.setModCount(1);
        return version;
    }

    private static void createSetLinks(Collection oldSets, Map mapOldNewSets, Collection newLinks, String projectUID) {
        for (EOReqSet oldSet : oldSets) {
            EOModuleData_V0 newSet = (EOModuleData_V0)mapOldNewSets.get(oldSet.getUID());
            String parentUID = oldSet.getParentUID();
            if (parentUID == null) continue;
            EOModuleData_V0 parent = (EOModuleData_V0)mapOldNewSets.get(parentUID);
            EOLink_V0 link = new EOLink_V0(projectUID, parent.getUid(), newSet.getUid(), ModuleIdentification.getRQM2ModuleID(), "RequirementSetRequirementSet");
            newLinks.add(link);
        }
    }

    private static void createReqSetLinks(Collection requirements, Map setMap, Map reqMap, Collection newLinks, String projectUID, Map reqUIDset) {
        for (EORequirement oldReq : requirements) {
            EOModuleData_V0 newReq = (EOModuleData_V0)reqMap.get(oldReq.getUID());
            EOModuleData_V0 set = (EOModuleData_V0)setMap.get(oldReq.getReqsetUID());
            EOLink_V0 link = new EOLink_V0(projectUID, set.getUid(), newReq.getUid(), ModuleIdentification.getRQM2ModuleID(), "RequirementRequirementSet");
            newLinks.add(link);
            reqUIDset.put(newReq.getUid(), set);
        }
    }

    private static Map createInitialRequirementStates(String projectUID) {
        HashMap states = new HashMap();
        return states;
    }

    private static Map createInitialRequirementStateLogs(Map states) {
        HashMap<String, EOVersionedModuleData_V0> stateLogs = new HashMap<String, EOVersionedModuleData_V0>(states.size());
        for (Map.Entry mapEntry : states.entrySet()) {
            EOVersionedModuleData_V0 stateLog = new EOVersionedModuleData_V0((EOModuleData_V0)mapEntry.getValue());
            stateLogs.put(RQM1Migrator_ForDumps.getUIDVersionKey(stateLog.getUid(), stateLog.getModCount()), stateLog);
        }
        return stateLogs;
    }

    private static String getUIDVersionKey(String UID, int modCount) {
        return "UID: " + UID + "modCount: " + modCount;
    }
}

