/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.ppm1.ppm1migrator;

import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOProject_V0;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version0.HistoricProjectDumpView_0_;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version0.HistoricServerDumpView_0_;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.codec.EXDecoderException;
import de.plans.lib.xml.encoding.EOList;
import de.plans.psc.shared.message.EOPermission;
import java.util.ArrayList;
import java.util.Collection;

public class PPM1PermissionMigrator {
    public static void migratePermissions(EOProject_V0 project, HistoricProjectDumpView_0_ historicViewOnProjectDump) throws MigrationFailedException {
        try {
            EOList permissions = historicViewOnProjectDump.readPermissions(project);
            PPM1PermissionMigrator.migratePermissions((Collection<EOPermission>)permissions);
        }
        catch (EXDecoderException e) {
            throw new MigrationFailedException((Throwable)e);
        }
    }

    public static void migratePermissions(HistoricServerDumpView_0_ historicViewOnServerDump) {
        EOList permissions = historicViewOnServerDump.getPermissionList();
        PPM1PermissionMigrator.migratePermissions((Collection<EOPermission>)permissions);
    }

    private static void migratePermissions(Collection<EOPermission> permissions) {
        ArrayList<EOPermission> permissionsToRemove = new ArrayList<EOPermission>(permissions.size());
        ArrayList<EOPermission> permissionsToAdd = new ArrayList<EOPermission>(permissions.size());
        for (EOPermission permission : permissions) {
            String operandType = permission.getOperandType();
            String operation = permission.getOperation();
            String operandUID = permission.getOperandUID();
            String newOperation = null;
            String newOperandType = null;
            String newOperandUID = null;
            boolean isPMMPermission = false;
            if (operandType.equals("treeElement")) {
                isPMMPermission = true;
                newOperandType = "ppm2.prmOperand.projectPlan";
                if (operation.equals("editTask")) {
                    newOperation = "ppm2.editProjectPlanOrTask";
                } else if (operation.equals("editWorkItem")) {
                    newOperation = "ppm2.editContainedWorkItems";
                }
                newOperandUID = operandUID;
            } else if (operandType.equals("project")) {
                if (operation.equals("editPMProjects")) {
                    isPMMPermission = true;
                    newOperandType = "ppm2.prmOperand.root";
                    newOperation = "ppm2.createProjectPlan";
                    newOperandUID = "PPM2_Permission_Root";
                } else if (operation.equals("editGlobalWorkItems")) {
                    isPMMPermission = true;
                    newOperandType = "ppm2.prmOperand.root";
                    newOperation = "ppm2.editUnassignedWorkItems";
                    newOperandUID = "PPM2_Permission_Root";
                }
            }
            if (!isPMMPermission) continue;
            permissionsToRemove.add(permission);
            EOPermission newPermission = new EOPermission();
            newPermission.setPermissionUID(UUIDGenerator.getUniqueID());
            newPermission.setSubSetType(permission.getSubSetType());
            newPermission.setSubSetUID(permission.getSubSetUID());
            newPermission.setOperation(newOperation);
            newPermission.setOperandType(newOperandType);
            newPermission.setOperandUID(newOperandUID);
            newPermission.setOwnerID(permission.getOwnerID());
            newPermission.setOwnerType(permission.getOwnerType());
            permissionsToAdd.add(newPermission);
        }
        permissions.removeAll(permissionsToRemove);
        permissions.addAll(permissionsToAdd);
    }
}

