/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.planimporter.wizard;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.gui.wizards.NoLicenseWizardPage;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeModifyProjectsAndSectionsAndPlans;
import com.arcway.cockpit.frame.client.global.selection.CockpitSelectionManager;
import com.arcway.cockpit.frame.client.global.selection.CockpitSelectionService;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.IFrameSectionManager;
import com.arcway.cockpit.frame.client.project.ISectionAddID;
import com.arcway.cockpit.frame.client.project.core.framedata.Attribute;
import com.arcway.cockpit.frame.client.project.core.framedata.EXModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeText;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlanRW;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.SectionAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IImportedPlan;
import com.arcway.cockpit.frame.client.project.planagents.PlanAgentManager;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.planimporter.Messages;
import com.arcway.cockpit.planimporter.converter.CustomAttributesConverter;
import com.arcway.cockpit.planimporter.converter.IPlansConverter;
import com.arcway.cockpit.planimporter.exceptions.EXImportFailedException;
import com.arcway.cockpit.planimporter.wizard.PlanImportAttributePage;
import com.arcway.cockpit.planimporter.wizard.PlanImportConversionPage;
import com.arcway.cockpit.planimporter.wizard.PlanImportUniqueElementPage;
import com.arcway.lib.eclipse.file.tmp.SessionTempDirectoryManager;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import com.arcway.planagent.controllinginterface.planagent.EXSetupPlanException;
import com.arcway.planagent.controllinginterface.planagent.EXWriteAccessDeniedException;
import com.arcway.planagent.controllinginterface.planagent.plugin.EXPlanTypeUnknown;
import com.arcway.planagent.controllinginterface.planagent.plugin.PlanAgentExtensionMgr;
import com.arcway.planagent.planimporterexporter.IDataElement;
import com.arcway.planagent.planimporterexporter.plans.Plan;
import com.arcway.planagent.planimporterexporter.plans.PlanDirectory;
import com.arcway.planagent.planimporterexporter.plans.Plans;
import com.arcway.planagent.planmodel.PlanModelDirectAccessTool;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanRO;
import com.arcway.planagent.planmodel.implementation.PMPlan;
import de.plans.lib.eclipse.JFaceProgressMonitorToProgressDisplayAdapter;
import de.plans.lib.util.gui.IProgressDisplay;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class PlansImportWizard
extends Wizard
implements IImportWizard {
    private static final ILogger logger = Logger.getLogger(PlansImportWizard.class);
    private PlanImportConversionPage secondPage;
    private PlanImportAttributePage thirdPage;
    private PlanImportUniqueElementPage fourthPage;
    private Plans importedPlans;
    private final ISection parentSection;
    private final IPlansConverter plansConverter;
    private Map<String, IImportedPlan> plansToCreateUEOccurences;
    private final IFrameProjectAgent projectAgent;
    private int workReported;
    private IPlan createdPlanFile;

    public PlansImportWizard(IFrameProjectAgent projectAgent, ISection parentSection, IPlansConverter plansConverter) {
        assert (projectAgent != null);
        assert (plansConverter != null);
        this.projectAgent = projectAgent;
        this.parentSection = parentSection;
        this.plansConverter = plansConverter;
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.getString("PlanImport.title", Locale.getDefault()));
        this.addPages();
    }

    public void addPages() {
        if (this.projectAgent.getServerLicenseManager().isLicenseOperationAllowed((IClientFunctionLicenseType)ClientFunctionLicenseTypeModifyProjectsAndSectionsAndPlans.getInstance())) {
            this.secondPage = new PlanImportConversionPage(Messages.getString("PlanImportConversion.title", Locale.getDefault()), this.plansConverter, this, this.projectAgent.getLanguage());
            this.secondPage.init();
            this.addPage((IWizardPage)this.secondPage);
            this.thirdPage = new PlanImportAttributePage(Messages.getString("PlanImportAttributes.title", Locale.getDefault()), this.plansConverter, this.projectAgent, this.parentSection, this);
            this.thirdPage.init();
            this.addPage((IWizardPage)this.thirdPage);
            this.fourthPage = new PlanImportUniqueElementPage(Messages.getString("PlanImportUniqueElement.title", Locale.getDefault()), this.plansConverter, this.projectAgent);
            this.fourthPage.init();
            this.addPage((IWizardPage)this.fourthPage);
        } else {
            NoLicenseWizardPage nl_page = new NoLicenseWizardPage(Messages.getString("PlanImportConversion.title"), (IClientFunctionLicenseType)ClientFunctionLicenseTypeModifyProjectsAndSectionsAndPlans.getInstance());
            this.addPage((IWizardPage)nl_page);
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean performFinish() {
        if (this.importedPlans != null) {
            final Collection plansToImport = this.importedPlans.getCheckedPlansAndDirectories();
            final int workUnits = this.importedPlans.getNumberOfCheckedPlansAndPlanDirectories();
            final ISection section = this.thirdPage.getSelectedSection();
            this.plansToCreateUEOccurences = new HashMap<String, IImportedPlan>();
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    JFaceProgressMonitorToProgressDisplayAdapter progressDisplay = new JFaceProgressMonitorToProgressDisplayAdapter(monitor);
                    progressDisplay.beginQuantifiedTask(Messages.getString("PlansImportWizard.SavingPlans", Locale.getDefault()), workUnits, false);
                    try {
                        PlansImportWizard.this.createPlanAndDirectory(plansToImport, section, (IProgressDisplay)progressDisplay);
                    }
                    catch (EXImportFailedException e) {
                        throw new InvocationTargetException(e, e.getLocalizedMessage());
                    }
                    catch (EXNoPermission e) {
                        throw new InvocationTargetException(e, e.getMessage());
                    }
                    catch (EXNoLock e) {
                        throw new InvocationTargetException(e, e.getMessage());
                    }
                    progressDisplay.endTask();
                    progressDisplay.beginQuantifiedTask(Messages.getString("PlansImportWizard.ImportingUniqueElements", Locale.getDefault()), workUnits, false);
                    PlansImportWizard.this.fourthPage.toPerformFinish(PlansImportWizard.this.plansToCreateUEOccurences, (IProgressDisplay)progressDisplay);
                    progressDisplay.endTask();
                }
            };
            try {
                this.getContainer().run(false, false, runnable);
            }
            catch (InvocationTargetException e) {
                logger.error("InvocationTargetException", (Throwable)e);
                String errorMessage = e.getMessage();
                this.thirdPage.setErrorMessage(errorMessage);
                this.thirdPage.setPageComplete(false);
                this.fourthPage.setErrorMessage(errorMessage);
                this.fourthPage.setPageComplete(false);
                return false;
            }
            catch (InterruptedException e) {
                logger.error("InterruptedException", (Throwable)e);
                return false;
            }
            if (plansToImport.size() == 1 && this.createdPlanFile != null) {
                IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                this.projectAgent.getPlanEditorManager().openSinglePlanEditorInProjectorMode(workbenchWindow.getActivePage(), this.createdPlanFile, false);
                CockpitSelectionService ss = CockpitSelectionManager.getSelectionService((ISelectionService)workbenchWindow.getSelectionService());
                ss.fireSelection((ICockpitProjectData)this.createdPlanFile, workbenchWindow.getActivePage().getActivePart());
            } else {
                IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                CockpitSelectionService ss = CockpitSelectionManager.getSelectionService((ISelectionService)workbenchWindow.getSelectionService());
                ss.fireSelection((ICockpitProjectData)section, workbenchWindow.getActivePage().getActivePart());
            }
            this.dispose();
            return true;
        }
        return false;
    }

    public void dispose() {
        super.dispose();
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            page.dispose();
            ++n2;
        }
        if (this.importedPlans != null) {
            this.importedPlans.dispose();
        }
        if (this.plansToCreateUEOccurences != null) {
            this.plansToCreateUEOccurences.clear();
        }
    }

    public void setConversionErrorMessage(String message, int type) {
        this.thirdPage.setConversionErrorMessage(message, type);
    }

    public void updateConstructionElements() {
        this.fourthPage.setPlansInput(this.importedPlans);
    }

    public void updateImportedPlans(Plans plans) {
        this.importedPlans = plans;
        this.thirdPage.setPlansInput(this.importedPlans);
    }

    private void createPlanAndDirectory(Collection<Object> plansToImport, ISection section, IProgressDisplay progressDisplay) throws EXImportFailedException, EXNoPermission, EXNoLock {
        ArrayList<String> noPermissionForPlansOrPlanDirectories = new ArrayList<String>();
        for (Object object : plansToImport) {
            IFrameSectionManager sectionManager = this.projectAgent.getFrameSectionManager();
            if (object instanceof PlanDirectory) {
                PlanDirectory directory = (PlanDirectory)object;
                String directoryName = directory.getName().trim();
                progressDisplay.reportQuantifiedProgress(this.workReported++, directoryName);
                try {
                    ISection newSection = this.createSectionForPlanDirectory(sectionManager, directory, section);
                    Collection checkedPlans = directory.getCheckedPlansAndDirectories();
                    this.createPlanAndDirectory(checkedPlans, newSection, progressDisplay);
                }
                catch (EXNoPermission e) {
                    noPermissionForPlansOrPlanDirectories.add(directoryName);
                }
            }
            if (!(object instanceof Plan)) continue;
            Plan plan = (Plan)object;
            String planName = plan.getName().trim();
            progressDisplay.reportQuantifiedProgress(this.workReported++, planName);
            try {
                this.createdPlanFile = this.createPlanFile(plan, section, progressDisplay);
            }
            catch (EXWriteAccessDeniedException e) {
                noPermissionForPlansOrPlanDirectories.add(planName);
            }
            catch (PlanAgentManager.EXPlanAgentLaunchException e) {
                logger.error(Messages.getString("PlansImportWizard.errorDuringPlanImport", Locale.getDefault()), (Throwable)e);
                throw new EXImportFailedException();
            }
            catch (IOException e) {
                logger.error(Messages.getString("PlansImportWizard.errorDuringPlanImport", Locale.getDefault()), (Throwable)e);
                throw new EXImportFailedException();
            }
            catch (EXPlanTypeUnknown e) {
                logger.error(Messages.getString("PlansImportWizard.errorDuringPlanImport", Locale.getDefault()), (Throwable)e);
                throw new EXImportFailedException();
            }
            catch (EXSetupPlanException e) {
                logger.error(Messages.getString("PlansImportWizard.errorDuringPlanImport", Locale.getDefault()), (Throwable)e);
                throw new EXImportFailedException();
            }
            catch (JvmExternalResourceInteractionException e) {
                logger.error(Messages.getString("PlansImportWizard.errorDuringPlanImport", Locale.getDefault()), (Throwable)e);
                throw new EXImportFailedException();
            }
        }
        if (!noPermissionForPlansOrPlanDirectories.isEmpty()) {
            String errorMessage = String.valueOf(Messages.getString("PlansImportWizard.noPermission", Locale.getDefault())) + " ";
            boolean firstName = true;
            for (String name : noPermissionForPlansOrPlanDirectories) {
                if (firstName) {
                    errorMessage = String.valueOf(errorMessage) + name;
                    firstName = false;
                    continue;
                }
                errorMessage = String.valueOf(errorMessage) + ", " + name;
            }
            throw new EXNoPermission(errorMessage);
        }
    }

    private IPlan createPlanFile(Plan plan, ISection section, IProgressDisplay progressDisplay) throws PlanAgentManager.EXPlanAgentLaunchException, EXWriteAccessDeniedException, IOException, EXPlanTypeUnknown, EXSetupPlanException, JvmExternalResourceInteractionException, EXImportFailedException {
        IPMPlanRO loadedPlan = plan.getLoadedPlan();
        String planDescription = plan.getDescription();
        if (planDescription == null) {
            planDescription = "";
        }
        String planName = loadedPlan.getName().trim();
        String planTypeID = loadedPlan.getType();
        File tempFile = SessionTempDirectoryManager.createSessionTempFile((String)("temp" + this.workReported), (String)PlanAgentExtensionMgr.getDefault().getPlanTypeDescriptionForType(planTypeID).getFileExtension());
        ((PMPlan)loadedPlan).getPlanModelMgr().save(tempFile);
        try {
            IPlanRW newPlan = null;
            try {
                Collection<IAttribute> customAttributes = CustomAttributesConverter.convertIntoFrameAttributes(this.projectAgent, (IDataElement)plan, "com.arcway.cockpit.plan");
                boolean planFileAlreadyStored = false;
                IImportedPlan importedPlan = this.projectAgent.getFrameUniqueElementMgr().importPlan(section, null, planTypeID, planName, planDescription, null, customAttributes, tempFile, planFileAlreadyStored, progressDisplay);
                String newUID = importedPlan.getPlan().getUID();
                newPlan = this.projectAgent.getFrameSectionManager().getPlanRW(newUID);
                PlanModelDirectAccessTool.setPlanUID((IPMPlanRO)loadedPlan, (String)newUID);
                this.plansToCreateUEOccurences.put(newUID, importedPlan);
            }
            catch (EXModificationProblem e) {
                ModificationProblemsDialog md = new ModificationProblemsDialog(e.getModificationProblems(), Messages.getString("PlansImportWizard.error", Locale.getDefault()), this.getShell());
                md.open();
                throw new EXImportFailedException();
            }
            IPlanRW iPlanRW = newPlan;
            return iPlanRW;
        }
        finally {
            try {
                FileHelper.deleteExistingFileOrDirectory((File)tempFile);
            }
            catch (JvmExternalResourceInteractionException e) {
                logger.warn("unable to delete obsolete temp file", (Throwable)e);
            }
        }
    }

    private ISection createSectionForPlanDirectory(IFrameSectionManager sectionManager, PlanDirectory directory, ISection parentSect) throws EXNoPermission {
        String directoryName = directory.getName().trim();
        String directoryDescription = directory.getDescription();
        ISection createdSection = null;
        ArrayList<Object> attributes = new ArrayList<Object>();
        if (directoryDescription != null) {
            Object directoryDescriptionValue = DataTypeText.getInstanceText().getAttributeValueFromString(directoryDescription, null, null);
            Attribute description = new Attribute(SectionAttributeTypesProvider.ATTRID_DESCRIPTION, directoryDescriptionValue);
            attributes.add(description);
        }
        attributes.addAll(CustomAttributesConverter.convertIntoFrameAttributes(this.projectAgent, (IDataElement)directory, "com.arcway.cockpit.section"));
        ISectionAddID addID = sectionManager.requestSectionAdditionPermission(directoryName, parentSect, null, attributes);
        if (!addID.permissionGranted()) {
            throw new EXNoPermission("Could not import folder " + addID.getModificationProblem().getHumanReadableDescriptionOfCause());
        }
        createdSection = sectionManager.addSection(addID);
        return createdSection;
    }
}

