/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.planimporter.aris2epc.converter;

import com.arcway.cockpit.planimporter.SourceFileType;
import com.arcway.cockpit.planimporter.aris2epc.Messages;
import com.arcway.cockpit.planimporter.aris2epc.converter.AMLReader;
import com.arcway.cockpit.planimporter.aris2epc.converter.ArisImportAnchoringContext;
import com.arcway.cockpit.planimporter.aris2epc.converter.ImportPass;
import com.arcway.cockpit.planimporter.aris2epc.plugin.Activator;
import com.arcway.cockpit.planimporter.aris2epc.resource.Icons16x16;
import com.arcway.cockpit.planimporter.converter.IPlansConverter;
import com.arcway.cockpit.planimporter.exceptions.EXFileImportException;
import com.arcway.cockpit.planimporter.exceptions.EXFileNotFormattedCorrectly;
import com.arcway.cockpit.planimporter.exceptions.EXNoPlanFoundException;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.graphics.Alignment;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.FillColor;
import com.arcway.lib.graphics.fillstyles.FillStyle;
import com.arcway.lib.graphics.linemarkers.LineMarker;
import com.arcway.lib.graphics.linestyles.LineStyle;
import com.arcway.lib.graphics.text.TextStyle;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.planagent.planimporterexporter.DataElement;
import com.arcway.planagent.planimporterexporter.IDataElement;
import com.arcway.planagent.planimporterexporter.plans.Plan;
import com.arcway.planagent.planimporterexporter.plans.PlanDirectory;
import com.arcway.planagent.planimporterexporter.plans.Plans;
import com.arcway.planagent.planmodel.PlanModelDirectAccessTool;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanRW;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import com.arcway.planagent.planmodel.anchoring.IAnchoringContext;
import com.arcway.planagent.planmodel.appearance.FillAppearance;
import com.arcway.planagent.planmodel.appearance.IFillAppearance;
import com.arcway.planagent.planmodel.appearance.IFillAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineAppearance;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineMarkerAppearance;
import com.arcway.planagent.planmodel.appearance.ILineMarkerAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ITextAppearanceRO;
import com.arcway.planagent.planmodel.appearance.LineAppearance;
import com.arcway.planagent.planmodel.appearance.LineMarkerAppearance;
import com.arcway.planagent.planmodel.appearance.TextAppearance;
import com.arcway.planagent.planmodel.base.access.readonly.IPMPlanElementWithNameSupplementRO;
import com.arcway.planagent.planmodel.base.access.readonly.IPMPlanElementWithOptionalShadowRO;
import com.arcway.planagent.planmodel.base.transactions.TACreateNameSupplement;
import com.arcway.planagent.planmodel.base.transactions.TACreatePlaneComment;
import com.arcway.planagent.planmodel.base.transactions.TACreateTextSupplement;
import com.arcway.planagent.planmodel.base.transactions.TASetPlanElementNameSupplement;
import com.arcway.planagent.planmodel.base.transactions.TAUpdateShadowFigures;
import com.arcway.planagent.planmodel.bpre.epc.access.readonly.IPMPlanElementBPREEPCEventRO;
import com.arcway.planagent.planmodel.bpre.epc.access.readonly.IPMPlanElementBPREEPCFunctionRO;
import com.arcway.planagent.planmodel.bpre.epc.access.readonly.IPMPlanElementBPREEPCLogicalOperatorRO;
import com.arcway.planagent.planmodel.bpre.epc.appearance.BPREEPCANDSymbolAppearance;
import com.arcway.planagent.planmodel.bpre.epc.appearance.IBPREEPCLogicalOperatorSymbolAppearanceRO;
import com.arcway.planagent.planmodel.bpre.epc.transactions.TACreateBPREEPCControlFlow;
import com.arcway.planagent.planmodel.bpre.epc.transactions.TACreateBPREEPCEvent;
import com.arcway.planagent.planmodel.bpre.epc.transactions.TACreateBPREEPCFunction;
import com.arcway.planagent.planmodel.bpre.epc.transactions.TACreateBPREEPCLogicalOperatorAND;
import com.arcway.planagent.planmodel.bpre.epc.transactions.TACreateBPREEPCLogicalOperatorOR;
import com.arcway.planagent.planmodel.bpre.epc.transactions.TACreateBPREEPCLogicalOperatorSymbolAND;
import com.arcway.planagent.planmodel.bpre.epc.transactions.TACreateBPREEPCLogicalOperatorSymbolOR;
import com.arcway.planagent.planmodel.bpre.epc.transactions.TACreateBPREEPCLogicalOperatorSymbolXOR;
import com.arcway.planagent.planmodel.bpre.epc.transactions.TACreateBPREEPCLogicalOperatorXOR;
import com.arcway.planagent.planmodel.cm.access.readonly.IPMPlanElementPlaneCommentRO;
import com.arcway.planagent.planmodel.implementation.EXPlanModelObjectFactoryException;
import com.arcway.planagent.planmodel.implementation.PMPlan;
import com.arcway.planagent.planmodel.implementation.PlanModelMgr;
import com.arcway.planagent.planmodel.routing.IRoutingParameters;
import com.arcway.planagent.planmodel.transactions.Transaction;
import de.plans.lib.eclipse.PlugInClassExtensionFactoryException;
import de.plans.lib.util.gui.IProgressDisplay;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Aris2EPCConverter
implements IPlansConverter {
    private static final ILogger logger = Logger.getLogger(Aris2EPCConverter.class);
    private static final ActionParameters ARIS_IMPORT_ACTION_PARAMETERS = new ActionParameters((IAnchoringContext)new ArisImportAnchoringContext(), IRoutingParameters.DUMMY);
    private static final String IMPORT_EEPC_AS_COMMENT = "com.arcway.cockpit.planimporter.aris2epc.importeepcascomment";
    Map<String, Node> objectDefinitions = new HashMap<String, Node>();
    Map<String, Node> objectOccurences = new HashMap<String, Node>();
    Map<String, Node> fontDefinitions = new HashMap<String, Node>();
    private int workedReported = 0;
    private String projectLanguage;
    private int unlabeledElementCount;
    private static final FillColor DEFAULT_COCKPIT_EVENT_FILL_COLOR = new FillColor(255, 232, 232);
    private static final FillColor DEFAULT_ARIS_EVENT_FILL_COLOR = new FillColor(255, 175, 255);
    private static final FillColor DEFAULT_COCKPIT_FUNCTION_FILL_COLOR = new FillColor(224, 251, 193);
    private static final FillColor DEFAULT_ARIS_PROCESSPATH_FILL_COLOR = new FillColor(220, 220, 220);
    private static final FillColor DEFAULT_ARIS_FUNCTION_FILL_COLOR = new FillColor(150, 255, 150);
    private static final FillColor DEFAULT_ARIS_FUNCTION_SYS_FILL_COLOR = new FillColor(150, 255, 150);
    private static final FillColor DEFAULT_ARIS_FUNCTION_TRG_FILL_COLOR = new FillColor(204, 255, 153);
    private static final FillColor DEFAULT_COCKPIT_OPERATOR_FILL_COLOR = new FillColor(Color.WHITE);
    private static final FillColor DEFAULT_ARIS_OPERATOR_FILL_COLOR = new FillColor(180, 180, 180);
    private static final double DEFAULT_COCKPIT_PLAN_ELEMENT_LINE_THICKNESS = 0.5;
    private static final double DEFAULT_ARIS_PLAN_ELEMENT_LINE_THICKNESS = 0.3;
    private static final double DEFAULT_COCKPIT_CONTROLFLOW_LINE_THICKNESS = 0.25;
    private static final double DEFAULT_ARIS_CONTROLFLOW_LINE_THICKNESS = 0.3;
    private static final String LOCALE_ID = "LocaleId";
    private static final String LOCALE_ID_EN = "1033";
    private static final String LOCALE_ID_DE = "1031";
    private static final String LOCALE_ID_FR = "1036";
    private static final String LOCALE_ID_ES = "1034";
    private static final String LOCALE_ID_JP = "1041";
    private static final double ARIS_UNITS_PER_COCKPIT_PLAN_UNIT = 10.0;
    private static final double PLANUNITS_PER_MM_X = 1.0;
    private static final double PLANUNITS_PER_MM_Y = 1.0;
    private static final String SYMBOL_TYPE_EVENT = "ST_EV";
    private static final String SYMBOL_TYPE_FUNCTION = "ST_FUNC";
    private static final String SYMBOL_TYPE_FUNCTION_TRG = "ST_FUNC_TRG";
    private static final String SYMBOL_TYPE_FUNCTION_SYS = "ST_SYS_FUNC_TRG";
    private static final String SYMBOL_TYPE_PROCESS_INTERFACE = "ST_PRCS_IF";
    private static final String SYMBOL_TYPE_OPR_XOR = "ST_OPR_XOR_1";
    private static final String SYMBOL_TYPE_OPR_OR = "ST_OPR_OR_1";
    private static final String SYMBOL_TYPE_OPR_AND = "ST_OPR_AND_1";
    private static final String ATTRIBUTE_NAME_NAME = "AT_NAME";
    private static final String ATTRIBUTE_NAME_DESCRIPTION = "AT_DESC";
    private static final String ATTRIBUTE_NAME_CHANNEL_OCCURENCE = "CxnOcc";
    private static final String SRC_ARROW = "SrcArrow";
    private static final String TGT_ARROW = "TgtArrow";
    private static final String MODEL_TYPE_EPC = "MT_EEPC";

    public Plans convert(File file, IProgressDisplay progressDisplay, String language) throws EXNoPlanFoundException, EXFileNotFormattedCorrectly, EXFileImportException {
        this.projectLanguage = language;
        this.unlabeledElementCount = -1;
        Plans plans = new Plans();
        this.convertFile(file, plans, progressDisplay);
        this.objectDefinitions.clear();
        this.objectOccurences.clear();
        this.fontDefinitions.clear();
        return plans;
    }

    public IStreamResource getIcon16x16() {
        return Icons16x16.IMPORT;
    }

    public String getLocalizedDescription(Locale language) {
        return Messages.getString("Aris2EPCConverter.description", language);
    }

    public String getID() {
        return Messages.getString("Aris2EPCConverter.id");
    }

    public String getLocalizedName(Locale language) {
        return Messages.getString("Aris2EPCConverter.name", language);
    }

    public SourceFileType getSourceFileType() {
        return new SourceFileType("xml", false);
    }

    private void convertFile(File f, Plans plans, IProgressDisplay progressDisplay) throws EXFileNotFormattedCorrectly, EXFileImportException {
        String path = f.getAbsolutePath();
        int index = path.lastIndexOf(".") + 1;
        String extension = path.substring(index);
        if (this.getSourceFileType().isAllowedFileExtension(extension)) {
            AMLReader amlFile;
            progressDisplay.beginUnquantifiedTask(this.getLocalizedDescription(Locale.getDefault()), false);
            try {
                amlFile = new AMLReader(f);
            }
            catch (ParserConfigurationException e) {
                logger.error("ParserConfigurationException", (Throwable)e);
                throw new EXFileImportException(path, (Throwable)e);
            }
            catch (SAXException e) {
                throw new EXFileNotFormattedCorrectly(path);
            }
            catch (IOException e) {
                logger.error("IOException", (Throwable)e);
                throw new EXFileImportException(path, (Throwable)e);
            }
            Element root = amlFile.getAMLRootElement();
            NodeList fssNodeList = root.getElementsByTagName("FontStyleSheet");
            int i = 0;
            while (i < fssNodeList.getLength()) {
                Node fontStyleSheet = fssNodeList.item(i);
                String id = this.getAttributeFromNode(fontStyleSheet, "FontSS.ID");
                this.fontDefinitions.put(id, fontStyleSheet);
                ++i;
            }
            NodeList groupNodeList = root.getElementsByTagName("Group");
            Node rootGroup = groupNodeList.item(0);
            this.findObjectDefinitions(rootGroup, 0);
            this.findObjectOccurrences(rootGroup, 0);
            int minimalNumberOfObjects = this.objectDefinitions.size();
            if (minimalNumberOfObjects > 0) {
                progressDisplay.beginQuantifiedTask(this.getLocalizedDescription(Locale.getDefault()), minimalNumberOfObjects, false);
                this.convertPlansAndPlanDirectories(rootGroup, plans, progressDisplay);
            }
        }
    }

    private void convertPlansAndPlanDirectories(Node group, Plans plans, IProgressDisplay progressDisplay) {
        NodeList rootChildren = group.getChildNodes();
        int i = 0;
        while (i < rootChildren.getLength()) {
            Node item = rootChildren.item(i);
            String itemName = item.getNodeName();
            if (itemName.equals("Model")) {
                if (this.getAttributeFromNode(item, "Model.Type").equals(MODEL_TYPE_EPC)) {
                    String planName = this.getLocalizedNameFromNode(item);
                    if (planName == null) {
                        planName = "";
                    }
                    PMPlan pmPlan = null;
                    PlanModelMgr planManager = new PlanModelMgr();
                    try {
                        pmPlan = planManager.create("bpre.epc");
                        ((IPMPlanRW)pmPlan).setName(planName);
                        HashMap<String, IDataElement> planElement2planElementDescription = new HashMap<String, IDataElement>();
                        NodeList list = item.getChildNodes();
                        ArrayList<ImportPass> importPasses = new ArrayList<ImportPass>(2);
                        importPasses.add(new ImportPass(true, false));
                        importPasses.add(new ImportPass(false, true));
                        for (ImportPass currentImportPass : importPasses) {
                            this.generatePlanElements(currentImportPass, list, (IPMPlanRO)pmPlan, planElement2planElementDescription);
                        }
                        String planDescription = "";
                        Plan plan = new Plan((IPMPlanRO)pmPlan, planName, planDescription, planElement2planElementDescription, true);
                        this.extractCustomAttributes((IDataElement)plan, item);
                        plans.addPlan(plan);
                    }
                    catch (EXPlanModelObjectFactoryException e) {
                        logger.error("EXPlanModelObjectFactoryException", (Throwable)e);
                    }
                    catch (CoreException e) {
                        logger.error("CoreException", (Throwable)e);
                    }
                    catch (PlugInClassExtensionFactoryException e) {
                        logger.error("PlugInClassExtensionFactoryException", (Throwable)e);
                    }
                    progressDisplay.reportQuantifiedProgress(this.workedReported++, planName);
                }
            } else if (itemName.equals("Group")) {
                String planDirectoryName = this.getLocalizedNameFromNode(item);
                if (planDirectoryName == null) {
                    planDirectoryName = "";
                }
                String planDirectoryDescription = this.getLocalizedAttributeFromNode(item, ATTRIBUTE_NAME_DESCRIPTION, true);
                PlanDirectory planDirectory = new PlanDirectory(planDirectoryName, planDirectoryDescription, true);
                this.convertPlansAndPlanDirectories(item, (Plans)planDirectory, progressDisplay);
                this.extractCustomAttributes((IDataElement)planDirectory, item);
                plans.addPlanDirectory(planDirectory);
                ++this.workedReported;
            }
            ++i;
        }
    }

    private void generatePlanElements(ImportPass currentImportPass, NodeList list, IPMPlanRO pmPlan, Map<String, IDataElement> planElement2planElementDescription) {
        int j = 0;
        while (j < list.getLength()) {
            IPMPlanElementRO planElement;
            Node node = list.item(j);
            if (node.getNodeName().equals("ObjOcc") && (planElement = this.generatePlanElement(node, pmPlan, currentImportPass)) != null) {
                String objectDefinitionID = this.getAttributeFromNode(node, "ObjDef.IdRef");
                Node objectDefinition = this.objectDefinitions.get(objectDefinitionID);
                String planElementDescription = this.getLocalizedAttributeFromNode(objectDefinition, ATTRIBUTE_NAME_DESCRIPTION, true);
                DataElement planElementData = new DataElement(planElement.getName(), planElementDescription);
                this.extractCustomAttributes((IDataElement)planElementData, objectDefinition);
                planElement2planElementDescription.put(planElement.getUid(), (IDataElement)planElementData);
                ++this.workedReported;
            }
            ++j;
        }
    }

    private void extractCustomAttributes(IDataElement dataElement, Node node) {
        for (Node attribute : this.getChildrenFromNode(node, "AttrDef")) {
            Node attributeValueNode;
            String attributeType = this.getAttributeFromNode(attribute, "AttrDef.Type");
            if (attributeType.equals(ATTRIBUTE_NAME_NAME) || attributeType.equals(ATTRIBUTE_NAME_DESCRIPTION) || (attributeValueNode = this.getLocalizedChildNodeFromNode(attribute, "AttrValue")) == null) continue;
            String attributeValue = this.getPlainTextContent(attributeValueNode, true);
            dataElement.setCustomAttribute(attributeType, attributeValue);
        }
    }

    private String getStringForUnlabeledElement() {
        String groupname = this.projectLanguage.equalsIgnoreCase("de") ? Messages.getString("Aris2EPCConverter.unlabeled", Locale.GERMAN) : Messages.getString("Aris2EPCConverter.unlabeled", Locale.ENGLISH);
        return groupname;
    }

    private void findObjectDefinitions(Node group, int level) {
        NodeList rootChildren = group.getChildNodes();
        int i = 0;
        while (i < rootChildren.getLength()) {
            Node item = rootChildren.item(i);
            String itemName = item.getNodeName();
            if (itemName.equals("Group")) {
                this.findObjectDefinitions(item, level + 1);
            } else if (itemName.equals("ObjDef")) {
                String id = this.getAttributeFromNode(item, "ObjDef.ID");
                this.objectDefinitions.put(id, item);
            }
            ++i;
        }
    }

    private void findObjectOccurrences(Node group, int level) {
        NodeList rootChildren = group.getChildNodes();
        int i = 0;
        while (i < rootChildren.getLength()) {
            Node item = rootChildren.item(i);
            String itemName = item.getNodeName();
            if (itemName.equals("Group")) {
                this.findObjectOccurrences(item, level + 1);
            } else if (itemName.equals("Model")) {
                this.findObjectOccurrences(item, level + 1);
            } else if (itemName.equals("ObjOcc")) {
                String id = this.getAttributeFromNode(item, "ObjOcc.ID");
                this.objectOccurences.put(id, item);
            }
            ++i;
        }
    }

    private IPMPlanElementRO generatePlanElement(Node objOcc, IPMPlanRO pmPlan, ImportPass importPass) {
        IPMPlanElementRO planElement;
        double posX = 0.0;
        double posY = 0.0;
        double sizeX = 0.0;
        double sizeY = 0.0;
        String penColor = null;
        String penStyle = null;
        double penWidth = 0.0;
        String brushColor = null;
        String brushStyle = null;
        String brushHatch = null;
        String textAlignment = null;
        String fontID = null;
        String type = this.getAttributeFromNode(objOcc, "SymbolNum");
        NodeList objOccChildren = objOcc.getChildNodes();
        int i = 0;
        while (i < objOccChildren.getLength()) {
            Node item = objOccChildren.item(i);
            String itemName = item.getNodeName();
            if (importPass.importNodes()) {
                if (itemName.equals("Position")) {
                    posX = Double.parseDouble(this.getAttributeFromNode(item, "Pos.X")) * 1.0 / 10.0;
                    posY = Double.parseDouble(this.getAttributeFromNode(item, "Pos.Y")) * 1.0 / 10.0;
                } else if (itemName.equals("Size")) {
                    sizeX = Double.parseDouble(this.getAttributeFromNode(item, "Size.dX")) * 1.0 / 10.0;
                    sizeY = Double.parseDouble(this.getAttributeFromNode(item, "Size.dY")) * 1.0 / 10.0;
                } else if (itemName.equals("Pen")) {
                    penColor = this.getAttributeFromNode(item, "Color");
                    penStyle = this.getAttributeFromNode(item, "Style");
                    penWidth = Double.parseDouble(this.getAttributeFromNode(item, "Width")) * 1.0 / 10.0;
                } else if (itemName.equals("Brush")) {
                    brushColor = this.getAttributeFromNode(item, "Color");
                    brushStyle = this.getAttributeFromNode(item, "Style");
                    brushHatch = this.getAttributeFromNode(item, "Hatch");
                } else if (itemName.equals("AttrOcc") && this.getAttributeFromNode(item, "AttrTypeNum").equals(ATTRIBUTE_NAME_NAME)) {
                    textAlignment = this.getAttributeFromNode(item, "Port");
                    fontID = this.getAttributeFromNode(item, "FontSS.IdRef");
                }
            }
            if (importPass.importControlFlows() && itemName.equals(ATTRIBUTE_NAME_CHANNEL_OCCURENCE) && this.isConvertedPlanElement(type)) {
                this.generateControlFlow(pmPlan, item);
            }
            ++i;
        }
        if (importPass.importNodes()) {
            ILineAppearanceRO lineAppearance = this.getLineAppearance(penColor, penStyle, penWidth);
            if (lineAppearance.getLineThickness() == 0.3) {
                ((ILineAppearance)lineAppearance).setLineThickness(0.5);
            }
            IFillAppearanceRO fillAppearance = this.getFillAppearance(brushColor, brushStyle, brushHatch, type);
            ITextAppearanceRO textAppearance = this.getTextAppearance(textAlignment, fontID);
            String objectDefinitionID = this.getAttributeFromNode(objOcc, "ObjDef.IdRef");
            Node objectDefinition = this.objectDefinitions.get(objectDefinitionID);
            String planElementName = this.getLocalizedNameFromNode(objectDefinition);
            Point upperLeft = new Point(posX, posY);
            Point lowerRight = new Point(posX + sizeX, posY + sizeY);
            Rectangle rec = new Rectangle(upperLeft, lowerRight);
            if (type.equals(SYMBOL_TYPE_EVENT)) {
                planElement = this.generateEvent(pmPlan, planElementName, rec, lineAppearance, fillAppearance, textAppearance);
            } else if (type.equals(SYMBOL_TYPE_FUNCTION) || type.equals(SYMBOL_TYPE_FUNCTION_SYS) || type.equals(SYMBOL_TYPE_FUNCTION_TRG)) {
                planElement = this.generateFunction(pmPlan, planElementName, rec.toPoints(), lineAppearance, fillAppearance, textAppearance, false);
            } else if (type.equals(SYMBOL_TYPE_PROCESS_INTERFACE)) {
                planElement = this.generateFunction(pmPlan, planElementName, rec.toPoints(), lineAppearance, fillAppearance, textAppearance, true);
            } else if (type.equals(SYMBOL_TYPE_OPR_XOR) || type.equals(SYMBOL_TYPE_OPR_OR) || type.equals(SYMBOL_TYPE_OPR_AND)) {
                this.generateLogicalOperator(pmPlan, rec.toPoints(), lineAppearance, fillAppearance, textAppearance, type);
                planElement = null;
            } else {
                if (Activator.getDefault().getPreferenceStore().getBoolean(IMPORT_EEPC_AS_COMMENT)) {
                    this.generateComment(pmPlan, planElementName, rec.toPoints(), lineAppearance, fillAppearance, textAppearance);
                }
                planElement = null;
            }
        } else {
            planElement = null;
        }
        return planElement;
    }

    private boolean isConvertedPlanElement(String type) {
        if (type != null) {
            return type.equals(SYMBOL_TYPE_EVENT) || type.equals(SYMBOL_TYPE_FUNCTION) || type.equals(SYMBOL_TYPE_FUNCTION_SYS) || type.equals(SYMBOL_TYPE_FUNCTION_TRG) || type.equals(SYMBOL_TYPE_OPR_AND) || type.equals(SYMBOL_TYPE_OPR_OR) || type.equals(SYMBOL_TYPE_OPR_XOR) || type.equals(SYMBOL_TYPE_PROCESS_INTERFACE) || Activator.getDefault().getPreferenceStore().getBoolean(IMPORT_EEPC_AS_COMMENT);
        }
        return false;
    }

    private String getLocalizedNameFromNode(Node arisNode) {
        String arisNodeName = this.getLocalizedAttributeFromNode(arisNode, ATTRIBUTE_NAME_NAME, false);
        if (arisNodeName == null || arisNodeName.equals("")) {
            arisNodeName = this.getStringForUnlabeledElement();
            if (this.unlabeledElementCount > 0) {
                arisNodeName = String.valueOf(arisNodeName) + " (" + this.unlabeledElementCount + ")";
            }
            ++this.unlabeledElementCount;
        }
        return arisNodeName;
    }

    private void generateControlFlow(IPMPlanRO pmPlan, Node channelOcc) {
        String toObjOccID = this.getAttributeFromNode(channelOcc, "ToObjOcc.IdRef");
        Node toObjOcc = this.objectOccurences.get(toObjOccID);
        String symbolNum = this.getAttributeFromNode(toObjOcc, "SymbolNum");
        if (this.isConvertedPlanElement(symbolNum)) {
            String penColor = null;
            String penStyle = null;
            double penWidth = 0.0;
            Points linePoints = new Points();
            NodeList objOccChildren = channelOcc.getChildNodes();
            int i = 0;
            while (i < objOccChildren.getLength()) {
                Node item = objOccChildren.item(i);
                String itemName = item.getNodeName();
                if (itemName.equals("Position")) {
                    double x = Double.parseDouble(this.getAttributeFromNode(item, "Pos.X")) * 1.0 / 10.0;
                    double y = Double.parseDouble(this.getAttributeFromNode(item, "Pos.Y")) * 1.0 / 10.0;
                    linePoints.add(new Point(x, y));
                } else if (itemName.equals("Pen")) {
                    penColor = this.getAttributeFromNode(item, "Color");
                    penStyle = this.getAttributeFromNode(item, "Style");
                    penWidth = Double.parseDouble(this.getAttributeFromNode(item, "Width")) * 1.0 / 10.0;
                }
                ++i;
            }
            ILineAppearanceRO lineAppearance = this.getLineAppearance(penColor, penStyle, penWidth);
            ((ILineAppearance)lineAppearance).setCornerRadius(2.5);
            if (lineAppearance.getLineThickness() == 0.3) {
                ((ILineAppearance)lineAppearance).setLineThickness(0.25);
            }
            String srcArrow = this.getAttributeFromNode(channelOcc, SRC_ARROW);
            String tgtArrow = this.getAttributeFromNode(channelOcc, TGT_ARROW);
            ILineMarkerAppearanceRO startMarkerAppearance = this.getLineMarkerAppearance(srcArrow, SRC_ARROW, penColor);
            ILineMarkerAppearanceRO endMarkerAppearance = this.getLineMarkerAppearance(tgtArrow, TGT_ARROW, penColor);
            TACreateBPREEPCControlFlow createControlFlowTransaction = new TACreateBPREEPCControlFlow(pmPlan, ARIS_IMPORT_ACTION_PARAMETERS, linePoints, lineAppearance, startMarkerAppearance, endMarkerAppearance);
            this.executeTransaction((Transaction)createControlFlowTransaction);
        }
    }

    private void generateLogicalOperator(IPMPlanRO pmPlan, Points points, ILineAppearanceRO lineAppearance, IFillAppearanceRO fillAppearance, ITextAppearanceRO textAppearance, String type) {
        if (fillAppearance.getFillColor().equalsFillColor(DEFAULT_ARIS_OPERATOR_FILL_COLOR)) {
            ((IFillAppearance)fillAppearance).setFillColor(DEFAULT_COCKPIT_OPERATOR_FILL_COLOR);
        }
        IPMPlanElementBPREEPCLogicalOperatorRO planElement = null;
        ((ILineAppearance)lineAppearance).setCornerRadius(10.0);
        if (type.equals(SYMBOL_TYPE_OPR_XOR)) {
            TACreateBPREEPCLogicalOperatorXOR createLogicalOperatorTransaction = new TACreateBPREEPCLogicalOperatorXOR(pmPlan, ARIS_IMPORT_ACTION_PARAMETERS, points, lineAppearance, fillAppearance);
            this.executeTransaction((Transaction)createLogicalOperatorTransaction);
            planElement = createLogicalOperatorTransaction.getCreatedLogicalOperator();
            TACreateBPREEPCLogicalOperatorSymbolXOR setAndSymbolTransaction = new TACreateBPREEPCLogicalOperatorSymbolXOR(planElement, ARIS_IMPORT_ACTION_PARAMETERS, points, this.getLogicalOperatorSymbolAppearance(lineAppearance, textAppearance));
            this.executeTransaction((Transaction)setAndSymbolTransaction);
        } else if (type.equals(SYMBOL_TYPE_OPR_OR)) {
            TACreateBPREEPCLogicalOperatorOR createLogicalOperatorTransaction = new TACreateBPREEPCLogicalOperatorOR(pmPlan, ARIS_IMPORT_ACTION_PARAMETERS, points, lineAppearance, fillAppearance);
            this.executeTransaction((Transaction)createLogicalOperatorTransaction);
            planElement = createLogicalOperatorTransaction.getCreatedLogicalOperator();
            TACreateBPREEPCLogicalOperatorSymbolOR setAndSymbolTransaction = new TACreateBPREEPCLogicalOperatorSymbolOR(planElement, ARIS_IMPORT_ACTION_PARAMETERS, points, this.getLogicalOperatorSymbolAppearance(lineAppearance, textAppearance));
            this.executeTransaction((Transaction)setAndSymbolTransaction);
        } else if (type.equals(SYMBOL_TYPE_OPR_AND)) {
            TACreateBPREEPCLogicalOperatorAND createLogicalOperatorTransaction = new TACreateBPREEPCLogicalOperatorAND(pmPlan, ARIS_IMPORT_ACTION_PARAMETERS, points, lineAppearance, fillAppearance);
            this.executeTransaction((Transaction)createLogicalOperatorTransaction);
            planElement = createLogicalOperatorTransaction.getCreatedLogicalOperator();
            TACreateBPREEPCLogicalOperatorSymbolAND setAndSymbolTransaction = new TACreateBPREEPCLogicalOperatorSymbolAND(planElement, ARIS_IMPORT_ACTION_PARAMETERS, points, this.getLogicalOperatorSymbolAppearance(lineAppearance, textAppearance));
            this.executeTransaction((Transaction)setAndSymbolTransaction);
        }
    }

    private IPMPlanElementRO generateEvent(IPMPlanRO pmPlan, String elementName, Rectangle rec, ILineAppearanceRO lineAppearance, IFillAppearanceRO fillAppearance, ITextAppearanceRO textAppearance) {
        IPMPlanElementBPREEPCEventRO eventPlanElement;
        if (fillAppearance.getFillColor().equalsFillColor(DEFAULT_ARIS_EVENT_FILL_COLOR)) {
            ((IFillAppearance)fillAppearance).setFillColor(DEFAULT_COCKPIT_EVENT_FILL_COLOR);
        }
        TACreateBPREEPCEvent createEventTransaction = new TACreateBPREEPCEvent(pmPlan, ARIS_IMPORT_ACTION_PARAMETERS, rec, lineAppearance, fillAppearance);
        this.executeTransaction((Transaction)createEventTransaction);
        IPMPlanElementBPREEPCEventRO event = eventPlanElement = createEventTransaction.getCreatedEvent();
        PlanModelDirectAccessTool.setPlanElementUID((IPMPlanElementRO)event, (String)UUIDGenerator.getUniqueID());
        TACreateNameSupplement addNameSupplementTransaction = new TACreateNameSupplement((IPMPlanElementWithNameSupplementRO)eventPlanElement, (IPMFigureRO)eventPlanElement.getGeometryFigureRO(), ARIS_IMPORT_ACTION_PARAMETERS, textAppearance, rec.toPoints());
        this.executeTransaction((Transaction)addNameSupplementTransaction);
        TASetPlanElementNameSupplement setNameSupplementTransaction = new TASetPlanElementNameSupplement((IPMPlanElementWithNameSupplementRO)eventPlanElement, ARIS_IMPORT_ACTION_PARAMETERS, elementName);
        this.executeTransaction((Transaction)setNameSupplementTransaction);
        return event;
    }

    private IPMPlanElementRO generateFunction(IPMPlanRO pmPlan, String elementName, Points elementPoints, ILineAppearanceRO lineAppearance, IFillAppearanceRO fillAppearance, ITextAppearanceRO textAppearance, boolean hasShadow) {
        IPMPlanElementBPREEPCFunctionRO functionPlanElement;
        Points elePoints = elementPoints;
        if (!hasShadow && fillAppearance.getFillColor().equalsFillColor(DEFAULT_ARIS_FUNCTION_FILL_COLOR)) {
            ((IFillAppearance)fillAppearance).setFillColor(DEFAULT_COCKPIT_FUNCTION_FILL_COLOR);
        } else if (hasShadow && fillAppearance.getFillColor().equalsFillColor(DEFAULT_ARIS_PROCESSPATH_FILL_COLOR)) {
            ((IFillAppearance)fillAppearance).setFillColor(DEFAULT_COCKPIT_FUNCTION_FILL_COLOR);
        }
        if (hasShadow) {
            Rectangle rec = elePoints.getBounds();
            Point lowerRight = rec.lowerRight;
            Rectangle correctedRec = new Rectangle(rec.upperLeft, new Point(lowerRight.x - 5.2, lowerRight.y - 6.6));
            elePoints = correctedRec.toPoints();
        }
        TACreateBPREEPCFunction createFunctionTransaction = new TACreateBPREEPCFunction(pmPlan, ARIS_IMPORT_ACTION_PARAMETERS, elePoints, lineAppearance, fillAppearance);
        this.executeTransaction((Transaction)createFunctionTransaction);
        IPMPlanElementBPREEPCFunctionRO function = functionPlanElement = createFunctionTransaction.getCreatedFunction();
        PlanModelDirectAccessTool.setPlanElementUID((IPMPlanElementRO)function, (String)UUIDGenerator.getUniqueID());
        if (hasShadow) {
            TAUpdateShadowFigures updateShadowTransaction = new TAUpdateShadowFigures((IPMPlanElementWithOptionalShadowRO)functionPlanElement, true, ARIS_IMPORT_ACTION_PARAMETERS);
            this.executeTransaction((Transaction)updateShadowTransaction);
        }
        TACreateNameSupplement addNameSupplementTransaction = new TACreateNameSupplement((IPMPlanElementWithNameSupplementRO)functionPlanElement, ARIS_IMPORT_ACTION_PARAMETERS, textAppearance, elePoints);
        this.executeTransaction((Transaction)addNameSupplementTransaction);
        TASetPlanElementNameSupplement setNameSupplementTransaction = new TASetPlanElementNameSupplement((IPMPlanElementWithNameSupplementRO)functionPlanElement, ARIS_IMPORT_ACTION_PARAMETERS, elementName);
        this.executeTransaction((Transaction)setNameSupplementTransaction);
        return function;
    }

    private void generateComment(IPMPlanRO pmPlan, String elementName, Points elementPoints, ILineAppearanceRO lineAppearance, IFillAppearanceRO fillAppearance, ITextAppearanceRO textAppearance) {
        IPMPlanElementPlaneCommentRO planeCommentPlanElement;
        TACreatePlaneComment createPlaneCommentTransaction = new TACreatePlaneComment(pmPlan, ARIS_IMPORT_ACTION_PARAMETERS, elementPoints, lineAppearance, fillAppearance);
        this.executeTransaction((Transaction)createPlaneCommentTransaction);
        IPMPlanElementPlaneCommentRO comment = planeCommentPlanElement = createPlaneCommentTransaction.getCreatedPlaneComment();
        PlanModelDirectAccessTool.setPlanElementUID((IPMPlanElementRO)comment, (String)UUIDGenerator.getUniqueID());
        TACreateTextSupplement createTextSupplementTransaction = new TACreateTextSupplement(planeCommentPlanElement.getOutlineFigureRO(), "text", ARIS_IMPORT_ACTION_PARAMETERS, textAppearance, elementPoints, elementName);
        this.executeTransaction((Transaction)createTextSupplementTransaction);
    }

    private String getAttributeFromNode(Node node, String attribute) {
        NamedNodeMap map = node.getAttributes();
        Node attr = map.getNamedItem(attribute);
        if (attr != null) {
            return attr.getNodeValue();
        }
        return null;
    }

    private Collection<Node> getChildrenFromNode(Node node, String childNodeName) {
        NodeList children = node.getChildNodes();
        ArrayList<Node> collection = new ArrayList<Node>();
        int i = 0;
        while (i < children.getLength()) {
            Node item = children.item(i);
            String itemName = item.getNodeName();
            if (itemName.equals(childNodeName)) {
                collection.add(item);
            }
            ++i;
        }
        return collection;
    }

    private Node getLocalizedChildNodeFromNode(Node node, String nodeName) {
        Collection<Node> nodes = this.getChildrenFromNode(node, nodeName);
        Node[] localizedNodes = new Node[6];
        for (Node childNode : nodes) {
            String localeId = this.getAttributeFromNode(childNode, LOCALE_ID);
            String formattedId = null;
            if (localeId.equals(LOCALE_ID_EN)) {
                formattedId = "en";
                localizedNodes[0] = childNode;
            } else if (localeId.equals(LOCALE_ID_DE)) {
                formattedId = "de";
                localizedNodes[1] = childNode;
            } else if (localeId.equals(LOCALE_ID_ES)) {
                formattedId = "es";
                localizedNodes[2] = childNode;
            } else if (localeId.equals(LOCALE_ID_FR)) {
                formattedId = "fr";
                localizedNodes[3] = childNode;
            } else if (localeId.equals(LOCALE_ID_JP)) {
                formattedId = "ja";
                localizedNodes[4] = childNode;
            } else {
                localizedNodes[5] = childNode;
            }
            if (!this.projectLanguage.equalsIgnoreCase(formattedId)) continue;
            return childNode;
        }
        Node[] nodeArray = localizedNodes;
        int n = localizedNodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node childNode;
            childNode = nodeArray[n2];
            if (childNode != null) {
                return childNode;
            }
            ++n2;
        }
        return null;
    }

    private String getLocalizedAttributeFromNode(Node arisNode, String attributeName, boolean lineBreaksAllowed) {
        Collection<Node> nodes = this.getChildrenFromNode(arisNode, "AttrDef");
        for (Node attrDef : nodes) {
            Node nameNode;
            String attributeType = this.getAttributeFromNode(attrDef, "AttrDef.Type");
            if (!attributeType.equals(attributeName) || (nameNode = this.getLocalizedChildNodeFromNode(attrDef, "AttrValue")) == null) continue;
            return this.getPlainTextContent(nameNode, lineBreaksAllowed);
        }
        return null;
    }

    private String getPlainTextContent(Node textNode, boolean lineBreaksAllowed) {
        String plainTextContent = textNode.getTextContent();
        if (plainTextContent.trim().length() == 0) {
            StringBuffer textBuffer = new StringBuffer();
            this.appendPlainTextContent(textNode, textBuffer, lineBreaksAllowed);
            plainTextContent = textBuffer.toString();
        }
        return plainTextContent;
    }

    private void appendPlainTextContent(Node currentNode, StringBuffer textBuffer, boolean lineBreaksAllowed) {
        if (currentNode.getNodeType() == 1) {
            if (currentNode.getNodeName().equals("Paragraph")) {
                if (textBuffer.length() > 0) {
                    if (lineBreaksAllowed) {
                        textBuffer.append('\n');
                    } else {
                        textBuffer.append(' ');
                    }
                }
            } else if (currentNode.getNodeName().equals("PlainText")) {
                String content = this.getAttributeFromNode(currentNode, "TextValue");
                textBuffer.append(content);
            } else {
                Node childNode = currentNode.getFirstChild();
                while (childNode != null) {
                    this.appendPlainTextContent(childNode, textBuffer, lineBreaksAllowed);
                    childNode = childNode.getNextSibling();
                }
            }
        }
    }

    private ITextAppearanceRO getTextAppearance(String textAlignment, String fontID) {
        TextAppearance textAppearance = new TextAppearance();
        if (textAlignment != null) {
            if (textAlignment.equals("N")) {
                textAppearance.setAlignment(new Alignment(2, 8));
            } else if (textAlignment.equals("NE")) {
                textAppearance.setAlignment(new Alignment(4, 8));
            } else if (textAlignment.equals("E")) {
                textAppearance.setAlignment(new Alignment(4, 16));
            } else if (textAlignment.equals("SE")) {
                textAppearance.setAlignment(new Alignment(4, 32));
            } else if (textAlignment.equals("S")) {
                textAppearance.setAlignment(new Alignment(2, 32));
            } else if (textAlignment.equals("SW")) {
                textAppearance.setAlignment(new Alignment(1, 32));
            } else if (textAlignment.equals("W")) {
                textAppearance.setAlignment(new Alignment(1, 16));
            } else if (textAlignment.equals("NW")) {
                textAppearance.setAlignment(new Alignment(1, 8));
            } else {
                textAppearance.setAlignment(new Alignment(2, 16));
            }
        } else {
            textAppearance.setAlignment(new Alignment(2, 16));
        }
        if (fontID != null) {
            Node fontStyleSheet = this.fontDefinitions.get(fontID);
            Node fontNode = this.getLocalizedChildNodeFromNode(fontStyleSheet, "FontNode");
            if (fontNode != null) {
                String fontColor = this.getAttributeFromNode(fontNode, "Color");
                Color textColor = this.parseArisColor(fontColor);
                textAppearance.setTextColor(textColor);
                double textSize = Double.parseDouble(this.getAttributeFromNode(fontNode, "Height"));
                textSize = Math.abs(textSize) / 2.8346456692913384 / 0.8075987144168962 / 1.3333333333333333;
                textAppearance.setTextLineHeight(textSize);
                String fontFace = this.getAttributeFromNode(fontNode, "FaceName");
                String italic = this.getAttributeFromNode(fontNode, "Italic");
                int bold = Integer.parseInt(this.getAttributeFromNode(fontNode, "Weight"));
                if (italic.equals("NO")) {
                    textAppearance.setTextStyle(new TextStyle(fontFace, bold > 400, false));
                } else {
                    textAppearance.setTextStyle(new TextStyle(fontFace, bold > 400, true));
                }
            }
        } else {
            textAppearance.setTextColor(Color.BLUE);
        }
        return textAppearance;
    }

    private IFillAppearanceRO getFillAppearance(String color, String brushStyle, String brushHatch, String type) {
        FillAppearance fillAppearance = new FillAppearance();
        String brushColor = color;
        if (brushColor != null && brushStyle != null && brushHatch != null) {
            Color fillColor = this.parseArisColor(brushColor);
            fillAppearance.setFillStyle(FillStyle.SOLID);
            fillAppearance.setFillColor(new FillColor(fillColor));
        } else {
            fillAppearance.setFillStyle(FillStyle.SOLID);
            if (type.equals(SYMBOL_TYPE_EVENT)) {
                fillAppearance.setFillColor(DEFAULT_COCKPIT_EVENT_FILL_COLOR);
            } else if (type.equals(SYMBOL_TYPE_FUNCTION) || type.equals(SYMBOL_TYPE_PROCESS_INTERFACE)) {
                fillAppearance.setFillColor(DEFAULT_COCKPIT_FUNCTION_FILL_COLOR);
            } else if (type.equals(SYMBOL_TYPE_FUNCTION_SYS)) {
                fillAppearance.setFillColor(DEFAULT_ARIS_FUNCTION_SYS_FILL_COLOR);
            } else if (type.equals(SYMBOL_TYPE_FUNCTION_TRG)) {
                fillAppearance.setFillColor(DEFAULT_ARIS_FUNCTION_TRG_FILL_COLOR);
            } else if (type.equals(SYMBOL_TYPE_OPR_AND) || type.equals(SYMBOL_TYPE_OPR_OR) || type.equals(SYMBOL_TYPE_OPR_XOR)) {
                fillAppearance.setFillColor(DEFAULT_COCKPIT_OPERATOR_FILL_COLOR);
            }
        }
        return fillAppearance;
    }

    private ILineAppearanceRO getLineAppearance(String penColor, String penStyle, double penWidth) {
        LineAppearance lineAppearance = new LineAppearance();
        if (penColor != null && penStyle != null && penWidth != 0.0) {
            Color lineColor = this.parseArisColor(penColor);
            LineStyle lineStyle = null;
            lineStyle = penStyle.equals("1") ? LineStyle.DASH : (penStyle.equals("2") ? LineStyle.DASHSHORT : LineStyle.SOLID);
            lineAppearance.setLineColor(lineColor);
            lineAppearance.setLineStyle(lineStyle);
            lineAppearance.setLineThickness(penWidth);
        } else {
            lineAppearance.setLineColor(Color.BLACK);
            lineAppearance.setLineStyle(LineStyle.SOLID);
            lineAppearance.setLineThickness(0.5);
        }
        return lineAppearance;
    }

    private ILineMarkerAppearanceRO getLineMarkerAppearance(String arrowStyle, String arrow, String penColor) {
        LineMarkerAppearance lineMarkerAppearance = new LineMarkerAppearance();
        if (arrowStyle == null) {
            lineMarkerAppearance = this.getDefaultLineMarkerAppearance(arrow);
        } else if (arrowStyle.equals("ST_ARROW_SMPL_PNT") || arrowStyle.equals("ST_ARROW_2") || arrowStyle.equals("ST_SAP_ARROW_GREEN") || arrowStyle.equals("ST_SAP_ARROW_LIGHT_BLUE")) {
            lineMarkerAppearance.setLineMarkerStyle(LineMarker.ARROW);
        } else if (arrowStyle.equals("ST_ARROW_FILLED_CIRCLE")) {
            lineMarkerAppearance.setLineMarkerStyle(LineMarker.BOBBLE);
        } else if (arrowStyle.equals("ST_ARROW_15")) {
            lineMarkerAppearance.setLineMarkerStyle(LineMarker.BOBBLE);
            lineMarkerAppearance.setLineMarkerFillColor(new FillColor(Color.WHITE));
            lineMarkerAppearance.setLineMarkerSize(3.0);
        } else if (arrowStyle.equals("ST_ARROW_16")) {
            lineMarkerAppearance.setLineMarkerStyle(LineMarker.BOBBLE);
            lineMarkerAppearance.setLineMarkerSize(3.0);
        } else if (arrowStyle.equals("ST_ARROW_23")) {
            lineMarkerAppearance.setLineMarkerStyle(LineMarker.BOBBLE);
            lineMarkerAppearance.setLineMarkerFillColor(new FillColor(Color.GRAY));
            lineMarkerAppearance.setLineMarkerSize(3.0);
        } else if (arrowStyle.equals("ST_ARROW_EMPTY_CIRCLE") || arrowStyle.equals("ST_BPMN_MESSAGE_FLOW")) {
            lineMarkerAppearance.setLineMarkerStyle(LineMarker.BOBBLE);
            lineMarkerAppearance.setLineMarkerFillColor(new FillColor(Color.WHITE));
            lineMarkerAppearance.setLineMarkerSize(2.0);
        } else if (arrowStyle.equals("ST_ARROW_18") || arrowStyle.equals("ST_ARR_DIAM")) {
            lineMarkerAppearance.setLineMarkerStyle(LineMarker.RHOMBUS);
            lineMarkerAppearance.setLineMarkerFillColor(new FillColor(Color.BLACK));
        } else if (arrowStyle.equals("ST_ARR_GNRL") || arrowStyle.equals("ST_ARROW_8")) {
            lineMarkerAppearance.setLineMarkerStyle(LineMarker.TRIANGLE);
        } else if (arrowStyle.equals("ST_ARROW_FILLED_PNT_WHITE")) {
            lineMarkerAppearance.setLineMarkerStyle(LineMarker.TRIANGLE);
            lineMarkerAppearance.setLineMarkerSize(0.5);
        } else if (arrowStyle.equals("ST_ARROW_6")) {
            lineMarkerAppearance.setLineMarkerStyle(LineMarker.TRIANGLE);
            lineMarkerAppearance.setLineMarkerFillColor(new FillColor(Color.BLACK));
        } else if (arrowStyle.equals("ST_ARROW_FILLED_PNT") || arrowStyle.equals("ST_SAP_ARROW_BLUE") || arrowStyle.equals("ST_SAP_ARROW_ORANGE")) {
            lineMarkerAppearance.setLineMarkerStyle(LineMarker.TRIANGLE);
            lineMarkerAppearance.setLineMarkerFillColor(new FillColor(Color.BLACK));
            lineMarkerAppearance.setLineMarkerSize(0.5);
        } else if (arrowStyle.equals("ST_ARROW_1")) {
            lineMarkerAppearance.setLineMarkerStyle(LineMarker.TRIANGLE);
            lineMarkerAppearance.setLineMarkerFillColor(new FillColor(Color.GRAY));
        } else if (arrowStyle.equals("ST_ARROW_7")) {
            lineMarkerAppearance.setLineMarkerStyle(LineMarker.PEAKED_ARC);
        } else if (arrowStyle.equals("ST_ARROW_22")) {
            lineMarkerAppearance.setLineMarkerStyle(LineMarker.PEAKED_ARC_FILLED);
            lineMarkerAppearance.setLineMarkerFillColor(new FillColor(Color.WHITE));
        } else if (arrowStyle.equals("ST_ARROW_3")) {
            lineMarkerAppearance.setLineMarkerStyle(LineMarker.PEAKED_ARC_FILLED);
            lineMarkerAppearance.setLineMarkerFillColor(new FillColor(Color.GRAY));
        } else if (arrowStyle.equals("ST_ARROW_21")) {
            lineMarkerAppearance.setLineMarkerStyle(LineMarker.PEAKED_ARC_FILLED);
            lineMarkerAppearance.setLineMarkerFillColor(new FillColor(Color.WHITE));
        } else if (arrowStyle.equals("ST_AGGREG") || arrowStyle.equals("ST_ARROW_20") || arrowStyle.equals("ST_ARROW_19")) {
            lineMarkerAppearance.setLineMarkerStyle(LineMarker.RHOMBUS);
        } else if (arrowStyle.equals("ST_ARROW_17")) {
            lineMarkerAppearance.setLineMarkerStyle(LineMarker.RHOMBUS);
            lineMarkerAppearance.setLineMarkerFillColor(new FillColor(Color.GRAY));
        } else if (arrowStyle.equals("ST_ARROW_IEF_1") || arrowStyle.equals("ST_ARROW_IEF_C") || arrowStyle.equals("ST_ARROW_IEF_2") || arrowStyle.equals("ST_ARROW_IEF_CN") || arrowStyle.equals("ST_ARROW_IEF_N") || arrowStyle.equals("65535")) {
            lineMarkerAppearance.setLineMarkerStyle(LineMarker.NONE);
        } else {
            lineMarkerAppearance = this.getDefaultLineMarkerAppearance(arrow);
        }
        Color lineMarkerColor = this.parseArisColor(penColor);
        lineMarkerAppearance.setLineMarkerColor(lineMarkerColor);
        return lineMarkerAppearance;
    }

    private ILineMarkerAppearance getDefaultLineMarkerAppearance(String arrow) {
        LineMarkerAppearance lineMarkerAppearance = new LineMarkerAppearance();
        if (arrow.equals(TGT_ARROW)) {
            lineMarkerAppearance.setLineMarkerStyle(LineMarker.ROUNDED_ARC);
        } else if (arrow.equals(SRC_ARROW)) {
            lineMarkerAppearance.setLineMarkerStyle(LineMarker.NONE);
        }
        return lineMarkerAppearance;
    }

    private Color parseArisColor(String arisColor) {
        Color color = null;
        if (arisColor == null || arisColor.equals("0")) {
            color = new Color();
        } else {
            String fullArisColor = arisColor;
            while (fullArisColor.length() < 6) {
                fullArisColor = "0" + fullArisColor;
            }
            int b = Integer.parseInt(fullArisColor.substring(0, 2), 16);
            int g = Integer.parseInt(fullArisColor.substring(2, 4), 16);
            int r = Integer.parseInt(fullArisColor.substring(4, 6), 16);
            color = new Color(r, g, b);
        }
        return color;
    }

    private IBPREEPCLogicalOperatorSymbolAppearanceRO getLogicalOperatorSymbolAppearance(ILineAppearanceRO lineAppearance, ITextAppearanceRO textAppearance) {
        BPREEPCANDSymbolAppearance andSymbolAppearance = new BPREEPCANDSymbolAppearance();
        andSymbolAppearance.setColor(lineAppearance.getLineColor());
        andSymbolAppearance.setTextAppearance(textAppearance);
        return andSymbolAppearance;
    }

    private void executeTransaction(Transaction transaction) {
        if (transaction.isValid()) {
            transaction.dodo();
        }
    }
}

