/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.sdk;

import com.arcway.cockpit.p2.ui.UpdateUtil;
import com.arcway.lib.eclipse.update.EclipseP2DataAreaFix;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.Collection;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.sdk.PreloadingRepositoryHandler;
import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKMessages;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.ui.LoadMetadataRepositoryJob;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class InstallNewSoftwareHandler
extends PreloadingRepositoryHandler {
    private static final ILogger LOGGER = Logger.getLogger(InstallNewSoftwareHandler.class);

    public static InstallNewSoftwareHandler getInstallNewSoftwareHandler(final Collection<IInstallableUnit> initialSelections) {
        return new InstallNewSoftwareHandler(){

            @Override
            protected void doExecute(LoadMetadataRepositoryJob job) {
                this.getProvisioningUI().openInstallWizard(initialSelections, null, job);
            }
        };
    }

    private Shell getActiveShell(ExecutionEvent event) {
        if (event != null) {
            return HandlerUtil.getActiveShell((ExecutionEvent)event);
        }
        return ProvUI.getDefaultParentShell();
    }

    @Override
    public Object execute(ExecutionEvent event) {
        boolean forceUpdate;
        if (EclipseP2DataAreaFix.wasEclipseP2DataAreaFixAppliedDuringStartup()) {
            EclipseP2DataAreaFix.showRestartNeededBeforeChangingTheInstallation((Shell)this.getActiveShell(event));
            return null;
        }
        if (!UpdateUtil.isUnrestrictedInstallationChangePossible() && !(forceUpdate = UpdateUtil.showInstallRestrictionsDialogWithForkOption(this.getActiveShell(event)))) {
            return null;
        }
        try {
            return super.execute(event);
        }
        catch (IllegalStateException e) {
            UpdateUtil.showInstallationModificationRestrictionsInfoDialog(this.getActiveShell(event));
            LOGGER.error("Unable to change Installation.", (Throwable)e);
            return null;
        }
    }

    @Override
    protected void doExecute(LoadMetadataRepositoryJob job) {
        this.getProvisioningUI().openInstallWizard(null, null, job);
    }

    @Override
    protected boolean waitForPreload() {
        return !this.getProvisioningUI().getPolicy().getRepositoriesVisible();
    }

    @Override
    protected void setLoadJobProperties(Job loadJob) {
        super.setLoadJobProperties(loadJob);
        if (!this.waitForPreload()) {
            loadJob.setProperty(LoadMetadataRepositoryJob.SUPPRESS_AUTHENTICATION_JOB_MARKER, (Object)Boolean.toString(true));
            loadJob.setProperty(LoadMetadataRepositoryJob.SUPPRESS_REPOSITORY_EVENTS, (Object)Boolean.toString(true));
        }
    }

    @Override
    protected String getProgressTaskName() {
        return ProvSDKMessages.InstallNewSoftwareHandler_ProgressTaskName;
    }
}

