/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.migration.version3.repairversions;

import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOLinkLog_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOModuleData_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOVersionedModuleData_V0;
import com.arcway.cockpit.modulelib2.client.migration.version3.framework.ICommonModuleDataMigrator;
import com.arcway.cockpit.modulelib2.client.migration.version3.framework.IGenericItemMigratorTask;
import com.arcway.cockpit.modulelib2.client.migration.version3.framework.IModuleDataMigrationProcessor;
import com.arcway.cockpit.modulelib2.client.migration.version3.framework.IModuleDataMigrationProcessorConstructor;
import com.arcway.cockpit.modulelib2.client.migration.version3.framework.IModuleDataMigratorExtension;
import com.arcway.cockpit.modulelib2.client.migration.version3.framework.IModuleDataScanner;
import com.arcway.cockpit.modulelib2.client.migration.version3.framework.IVersionedItemMigrator;
import com.arcway.cockpit.modulelib2.client.migration.version3.framework.IVersionedModuleDataScanner;
import com.arcway.cockpit.modulelib2.client.migration.version3.framework.VersionedModuleDataID;
import com.arcway.lib.java.New;
import com.arcway.lib.java.collectionmaps.CollectionMap;
import com.arcway.lib.java.collectionmaps.SetMap;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class RepairVersionedModuleData_MigratorExtension
implements IModuleDataMigratorExtension {
    private static final ILogger LOGGER = Logger.getLogger(RepairVersionedModuleData_MigratorExtension.class);
    private static final int MODIFICATION_COUNT_INITIALVERSION = 1;
    private static final SortedSet<Integer> EMPTY_VERSIONS_SET = new TreeSet<Integer>();

    @Override
    public void constructMigrator(IModuleDataMigrationProcessorConstructor migratorConstructor) {
        migratorConstructor.addTask(new IGenericItemMigratorTask(){
            private final Map<String, EOModuleData_V0> uid_2_moduleData = new HashMap<String, EOModuleData_V0>();
            private final Map<String, SortedSet<Integer>> uid_2_exisitingVersions = new HashMap<String, SortedSet<Integer>>();
            private final CollectionMap<VersionedModuleDataID, Integer> versionedCopyInstructions = new SetMap();

            @Override
            public void installMigratorProcessors(final IModuleDataMigrationProcessor genericItemMigrator) {
                genericItemMigrator.addItemScanner(null, new IModuleDataScanner(){

                    @Override
                    public void scanModuleData(EOModuleData_V0 item) {
                        uid_2_moduleData.put(item.getUid(), item);
                    }
                });
                genericItemMigrator.addVersionedItemScanner(null, new IVersionedModuleDataScanner(){

                    @Override
                    public void scanVersionedModuleData(EOVersionedModuleData_V0 item) {
                        this.addToSortedSetMap(uid_2_exisitingVersions, item.getUid(), item.getModCount());
                    }
                });
                genericItemMigrator.addCommonMigrator(new ICommonModuleDataMigrator(){

                    @Override
                    public void migrateModuleData() {
                        HashSet allUIDs = New.hashSet((int)(uid_2_moduleData.size() + uid_2_exisitingVersions.size()));
                        allUIDs.addAll(uid_2_moduleData.keySet());
                        allUIDs.addAll(uid_2_exisitingVersions.keySet());
                        for (String uid : allUIDs) {
                            EOModuleData_V0 currentModuleData = (EOModuleData_V0)uid_2_moduleData.get(uid);
                            SortedSet existingVersions = this.getExistingVersions(uid);
                            int highestVersionNumber = this.getHighestVersionNumber(currentModuleData, existingVersions);
                            int modCount = 1;
                            while (modCount <= highestVersionNumber) {
                                Integer version = modCount;
                                SortedSet<Integer> tail = existingVersions.tailSet(version);
                                Integer matchingExistingVersion = tail.isEmpty() ? null : (Integer)tail.iterator().next();
                                if (matchingExistingVersion != null) {
                                    if (matchingExistingVersion != modCount) {
                                        versionedCopyInstructions.add((Object)new VersionedModuleDataID(uid, (int)matchingExistingVersion), (Object)version);
                                        this.addToSortedSetMap(uid_2_exisitingVersions, uid, modCount);
                                        LOGGER.debug("Module data " + uid + "/" + modCount + " in project " + genericItemMigrator.getProjectUID() + " was missing and therefore replaced with the newer version " + matchingExistingVersion + ".");
                                    }
                                } else if (currentModuleData != null) {
                                    genericItemMigrator.createVersionedData(currentModuleData, modCount);
                                    this.addToSortedSetMap(uid_2_exisitingVersions, uid, modCount);
                                    LOGGER.debug("Module data " + uid + "/" + modCount + " in project " + genericItemMigrator.getProjectUID() + " was missing and therefore replaced with the current version " + currentModuleData.getModCount() + ".");
                                } else if (!existingVersions.isEmpty()) {
                                    int highestExistingVersion = (Integer)existingVersions.last();
                                    versionedCopyInstructions.add((Object)new VersionedModuleDataID(uid, highestExistingVersion), (Object)version);
                                    this.addToSortedSetMap(uid_2_exisitingVersions, uid, modCount);
                                    LOGGER.debug("Module data " + uid + "/" + modCount + " in project " + genericItemMigrator.getProjectUID() + " was missing and therefore replaced with the newest version " + highestExistingVersion + ".");
                                } else {
                                    LOGGER.debug("Module data " + uid + "/" + modCount + " in project " + genericItemMigrator.getProjectUID() + " was deleted, but still referenced in some archived items.");
                                }
                                ++modCount;
                            }
                        }
                    }
                });
                genericItemMigrator.addVersionedItemMigrator(null, new IVersionedItemMigrator(){

                    @Override
                    public boolean migrateVersionedModuleData(EOVersionedModuleData_V0 item) {
                        boolean keepItem;
                        String uid = item.getUid();
                        EOModuleData_V0 currentModuleData = (EOModuleData_V0)uid_2_moduleData.get(uid);
                        SortedSet existingVersions = this.getExistingVersions(uid);
                        int highestVersionNumber = this.getHighestVersionNumber(currentModuleData, existingVersions);
                        if (item.getModCount() <= highestVersionNumber) {
                            int linkedVersion;
                            String linkedUID;
                            EOLinkLog_V0 link;
                            String itemUID = item.getUid();
                            Iterator<EOLinkLog_V0> i = item.getOutLinks().iterator();
                            while (i.hasNext()) {
                                link = (EOLinkLog_V0)i.next();
                                linkedUID = link.getLinkableObjectUID();
                                linkedVersion = link.getLinkableObjectVersion();
                                this.deleteLinkIfTargetNonExisting(item, itemUID, i, linkedUID, linkedVersion, "outgoing");
                            }
                            i = item.getInLinks().iterator();
                            while (i.hasNext()) {
                                link = (EOLinkLog_V0)i.next();
                                linkedUID = link.getModuleDataUID();
                                linkedVersion = link.getModuleDataVersion();
                                this.deleteLinkIfTargetNonExisting(item, itemUID, i, linkedUID, linkedVersion, "incoming");
                            }
                            VersionedModuleDataID thisVersion = new VersionedModuleDataID(item);
                            for (Integer targetVersion : versionedCopyInstructions.get((Object)thisVersion)) {
                                genericItemMigrator.createVersionedData((EOModuleData_V0)item, targetVersion);
                            }
                            keepItem = true;
                        } else {
                            keepItem = false;
                        }
                        return keepItem;
                    }

                    private void deleteLinkIfTargetNonExisting(EOVersionedModuleData_V0 item, String itemUID, Iterator<EOLinkLog_V0> i, String linkedUID, int linkedVersion, String linkType) {
                        SortedSet existingVersions = (SortedSet)uid_2_exisitingVersions.get(linkedUID);
                        if (existingVersions == null) {
                            existingVersions = EMPTY_VERSIONS_SET;
                        }
                        if (!existingVersions.contains(linkedVersion)) {
                            LOGGER.debug("Referenced module data " + linkedUID + "/" + linkedVersion + " in project " + genericItemMigrator.getProjectUID() + " not exisiting; deleted " + linkType + " reference from module data " + itemUID + "/" + item.getModCount() + ".");
                            i.remove();
                        }
                    }
                });
            }

            private void addToSortedSetMap(Map<String, SortedSet<Integer>> sortedSetMap, String uid, int version) {
                SortedSet<Integer> versions = sortedSetMap.get(uid);
                if (versions == null) {
                    versions = new TreeSet<Integer>();
                    sortedSetMap.put(uid, versions);
                }
                versions.add(version);
            }

            private int getHighestVersionNumber(EOModuleData_V0 currentModuleData, SortedSet<Integer> existingVersions) {
                int highestVersionNumber = currentModuleData != null ? currentModuleData.getModCount() : (!existingVersions.isEmpty() ? existingVersions.last() : 0);
                return highestVersionNumber;
            }

            private SortedSet<Integer> getExistingVersions(String uid) {
                SortedSet existingVersions = this.uid_2_exisitingVersions.get(uid);
                if (existingVersions == null) {
                    existingVersions = EMPTY_VERSIONS_SET;
                }
                return existingVersions;
            }
        });
    }
}

