/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.messages.attributes;

import com.arcway.cockpit.modulelib2.client.Messages;
import com.arcway.cockpit.modulelib2.client.messages.attributes.IModuleDataAttribute;
import com.arcway.cockpit.modulelib2.client.messages.attributes.IModuleDataAttributeFlag;
import com.arcway.lib.java.SetterSuccess;
import de.plans.lib.util.valueranges.IBoolean;
import de.plans.lib.util.valueranges.IValueRangeHelperFlag;
import de.plans.lib.util.valueranges.ValueRangeHelperBoolean;
import java.util.Locale;

public class ModuleDataAttributeBoolean
implements IModuleDataAttributeFlag,
IBoolean {
    private static final String STRING_REPESENTATION_FOR_TRUE_KEY = "ModuleDataAttributeBoolean.true";
    private static final String STRING_REPESENTATION_FOR_FALSE_KEY = "ModuleDataAttributeBoolean.false";
    private static final String STRING_REPESENTATION_FOR_TRUE = Messages.getString("ModuleDataAttributeBoolean.true");
    private static final String STRING_REPESENTATION_FOR_FALSE = Messages.getString("ModuleDataAttributeBoolean.false");
    private boolean value;
    private final ValueRangeHelperBoolean valueRangeHelper;

    public ModuleDataAttributeBoolean() {
        this.value = false;
        this.valueRangeHelper = new ValueRangeHelperBoolean((IBoolean)this);
    }

    public ModuleDataAttributeBoolean(boolean value) {
        this.value = value;
        this.valueRangeHelper = new ValueRangeHelperBoolean((IBoolean)this);
    }

    @Override
    public boolean getCanonicalDisplayRepresentation() {
        return this.valueRangeHelper.getDisplayFormat();
    }

    @Override
    public SetterSuccess setValueViaCanonicalDisplayRepresentation(boolean displayRepresentation) {
        return this.valueRangeHelper.setPersistentValue(displayRepresentation);
    }

    @Override
    public String getDisplayStringRepresentation() {
        return this.valueRangeHelper.getDisplayFormat() ? STRING_REPESENTATION_FOR_TRUE : STRING_REPESENTATION_FOR_FALSE;
    }

    @Override
    public String getDisplayStringRepresentation(Locale locale) {
        return this.valueRangeHelper.getDisplayFormat() ? ModuleDataAttributeBoolean.getStringRepresentationForTrue(locale) : ModuleDataAttributeBoolean.getStringRepresentationForFalse(locale);
    }

    @Override
    public SetterSuccess setValueViaDisplayStringRepresentation(String displayRepresentation) {
        if (displayRepresentation.equals(STRING_REPESENTATION_FOR_TRUE)) {
            return this.valueRangeHelper.setPersistentValue(true);
        }
        if (displayRepresentation.equals(STRING_REPESENTATION_FOR_FALSE)) {
            return this.valueRangeHelper.setPersistentValue(false);
        }
        return SetterSuccess.NEW_VALUE_COULD_NOT_BE_APPLIED;
    }

    public String getDisplayStringRepresentation(String trueValue, String falseValue) {
        return this.valueRangeHelper.getDisplayFormat() ? trueValue : falseValue;
    }

    @Override
    public String getUniqueStringRepresentation() {
        return Boolean.toString(this.value);
    }

    @Override
    public boolean setValueViaUniqueStringRepresentation(String uniqueStringRepresentation) {
        boolean oldValue = this.value;
        this.value = Boolean.valueOf(uniqueStringRepresentation);
        return oldValue ^ this.value;
    }

    @Override
    public IModuleDataAttribute copy() {
        return new ModuleDataAttributeBoolean(this.getValue());
    }

    public boolean getValue() {
        return this.value;
    }

    public void setValue(boolean value) {
        this.value = value;
    }

    @Override
    public IValueRangeHelperFlag getValueRangeHelper() {
        return new ValueRangeHelperBoolean((IBoolean)this);
    }

    public static String getStringRepresentationForTrue() {
        return STRING_REPESENTATION_FOR_TRUE;
    }

    public static String getStringRepresentationForTrue(Locale locale) {
        return Messages.getString(STRING_REPESENTATION_FOR_TRUE_KEY, locale);
    }

    public static String getStringRepresentationForFalse() {
        return STRING_REPESENTATION_FOR_FALSE;
    }

    public static String getStringRepresentationForFalse(Locale locale) {
        return Messages.getString(STRING_REPESENTATION_FOR_FALSE_KEY, locale);
    }
}

