/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui.filters;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractTextValuesFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.TableListFilterItem;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListener;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListenerManager;
import com.arcway.cockpit.modulelib2.client.core.IModelControllerProvider;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.frontend.definition.lib.interFace.label.IExpiringFrontendLabel;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import de.plans.lib.util.valueranges.IValueRangeHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class LinkedFrameDataTableListFilterItem
extends TableListFilterItem
implements IModuleProjectSwitchListener {
    private final IModelControllerProvider modelControllerProvider;
    private IModelController model;
    private final String frameDataTypeUid;
    private Comparator<? super String> comparator;
    private static final String NOT_SPECIFIED = IValueRangeHelper.NOT_SPECIFIED;

    public LinkedFrameDataTableListFilterItem(String name, String frameDataTypeUid, IModuleProjectSwitchListenerManager projectSwitchListenerManager, IModelControllerProvider modelControllerProvider, AbstractTextValuesFilter filter) {
        super(name, filter);
        this.modelControllerProvider = modelControllerProvider;
        this.frameDataTypeUid = frameDataTypeUid;
        projectSwitchListenerManager.registerProjectSwitchListener((IModuleProjectSwitchListener)this);
    }

    public LinkedFrameDataTableListFilterItem(String name, String frameDataTypeUid, IModelController modelController, AbstractTextValuesFilter filter) {
        super(name, filter);
        this.modelControllerProvider = null;
        this.model = modelController;
        this.frameDataTypeUid = frameDataTypeUid;
    }

    public Control createContent(Composite parent) {
        if (this.model != null) {
            Collection<IRepositoryObjectReference> items = this.model.getPlatformAccessAgent().getAllFrameDataItems(this.frameDataTypeUid);
            ArrayList<String> itemLabels = new ArrayList<String>(items.size() + 1);
            for (IRepositoryObjectReference item : items) {
                IExpiringFrontendLabel repositoryLabel = this.model.getPlatformAccessAgent().getLabelForPlatformObject(item);
                itemLabels.add(repositoryLabel != null && repositoryLabel.getText() != null ? repositoryLabel.getText() : null);
            }
            if (this.comparator != null) {
                Collections.sort(itemLabels, this.comparator);
            }
            this.clearFilterValues();
            itemLabels.add(0, "");
            for (String itemLabel : itemLabels) {
                if ("".equals(itemLabel)) {
                    this.addFilterValue(NOT_SPECIFIED, itemLabel);
                    continue;
                }
                this.addFilterValue(itemLabel, itemLabel);
            }
        } else {
            this.setFilterValues(Collections.EMPTY_LIST);
        }
        return super.createContent(parent);
    }

    public void projectSwitched(String projectUID) {
        this.model = this.modelControllerProvider.getModelController(projectUID);
    }

    public void setComparator(Comparator<? super String> comparator) {
        this.comparator = comparator;
    }
}

