/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui.editor.specification.structure;

import com.arcway.cockpit.modulelib2.client.gui.editor.specification.AbstractEditorSpecificationPart;
import com.arcway.cockpit.modulelib2.client.gui.editor.specification.IEditorSpecificationPart;
import com.arcway.cockpit.modulelib2.client.gui.editor.specification.structure.ColumnParameters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Column
extends AbstractEditorSpecificationPart {
    private final Map<String, AbstractEditorSpecificationPart> childMap = new HashMap<String, AbstractEditorSpecificationPart>();
    private final ColumnParameters columnParameters;

    public Column(List<AbstractEditorSpecificationPart> childList, ColumnParameters columnParameters) {
        int widgetListCounter = 1;
        for (AbstractEditorSpecificationPart part : childList) {
            part.setIndex(widgetListCounter);
            String partID = part.getID();
            this.childMap.put(partID, part);
            ++widgetListCounter;
        }
        this.columnParameters = columnParameters;
    }

    public List<AbstractEditorSpecificationPart> getChildList() {
        ArrayList<AbstractEditorSpecificationPart> list = new ArrayList<AbstractEditorSpecificationPart>(this.childMap.values());
        Column.sortSpecificationPartList(list);
        return list;
    }

    public AbstractEditorSpecificationPart getChild(String id) {
        return this.childMap.get(id);
    }

    public AbstractEditorSpecificationPart getChild(int index) {
        return this.getChildList().get(index);
    }

    public ColumnParameters getColumnParameters() {
        return this.columnParameters;
    }

    public List<IEditorSpecificationPart> getChildren() {
        ArrayList<IEditorSpecificationPart> children = new ArrayList<IEditorSpecificationPart>();
        children.addAll(this.childMap.values());
        children.add(this.columnParameters);
        return children;
    }

    @Override
    public String getTypeID() {
        return "Column";
    }
}

