/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui.editdialogs;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.modulelib2.client.Messages;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.IEditDialogErrorCallback;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.IModuleDataEditDialogProvider;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ModuleDataEditDialog
extends TitleAreaDialog
implements IEditDialogErrorCallback {
    private final IModuleDataEditDialogProvider provider;
    private boolean disableOKButton = false;
    private String projectUID;

    public ModuleDataEditDialog(IModuleDataEditDialogProvider provider, Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        assert (provider != null) : "provider must not be null";
        this.provider = provider;
        provider.setCallback(this);
    }

    protected Control createDialogArea(Composite parent) {
        Image dialogImage = this.provider.getDialogImage();
        String title = this.getTitle();
        this.getShell().setText(title);
        if (dialogImage != null) {
            this.getShell().setImage(dialogImage);
        }
        this.setTitle(title);
        this.setMessage(this.getDefaultMessage());
        return this.provider.createDialogArea(parent);
    }

    private String getTitle() {
        String title = Messages.getString("PropertiesDialog.Title");
        title = title.replaceAll("\\[ItemName\\]", this.provider.getPropertyName());
        return title;
    }

    private String getDefaultMessage() {
        String message = Messages.getString("PropertiesDialog.Message");
        message = message.replaceAll("\\[ItemName\\]", this.provider.getPropertyName());
        return message;
    }

    @Override
    public void clearErrorMessage() {
        this.setMessage(this.getDefaultMessage());
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(true);
        }
    }

    @Override
    public void setErrMsg(String errorMessage) {
        this.setMessage(errorMessage, 3);
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(false);
        } else {
            this.disableOKButton = true;
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(!this.disableOKButton);
    }

    protected void okPressed() {
        boolean exclusiveProjectLockIsConflicting;
        ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(this.projectUID);
        final boolean[] savedSuccessfully = new boolean[1];
        boolean bl = exclusiveProjectLockIsConflicting = !projectAgent.getLockManager().doWithBlockOfflineModeProjectLock(new Runnable(){

            @Override
            public void run() {
                if (ModuleDataEditDialog.this.provider.okPressed()) {
                    savedSuccessfully[0] = true;
                    ModuleDataEditDialog.super.okPressed();
                } else {
                    savedSuccessfully[0] = false;
                }
            }
        });
        if (exclusiveProjectLockIsConflicting) {
            this.setErrMsg(Messages.getString("CreationDialogues.ExclusiveProjectLockMessage.Message"));
            this.setCommitable(true);
        }
    }

    public boolean close() {
        if (this.getReturnCode() != 0) {
            this.provider.dialogCanceled();
        }
        return super.close();
    }

    public boolean initialiseDialogue(IModuleData[] items) {
        boolean successful = false;
        this.projectUID = items[0].getProjectUID();
        ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(this.projectUID);
        Throwable serverException = null;
        try {
            if (projectAgent.getLockManager().anotherClientHasProjectLock() != null) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("CreationDialogues.ExclusiveProjectLockMessage.Title"), (String)Messages.getString("CreationDialogues.ExclusiveProjectLockMessage.Message"));
            } else {
                this.provider.initialiseAdapter(items, null);
                successful = true;
            }
        }
        catch (ServerNotAvailableException e) {
            serverException = e;
        }
        catch (LoginCanceledException e) {
            serverException = e;
        }
        catch (EXServerException e) {
            serverException = e;
        }
        catch (UnknownServerException e) {
            serverException = e;
        }
        if (serverException != null) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("CreationDialogues.ExclusiveProjectLockMessage.Title"), (String)Messages.getString("CreationDialogues.ServerException" + serverException.getLocalizedMessage()));
        }
        return successful;
    }

    @Override
    public void setChangedStatus(boolean hasChanged) {
    }

    @Override
    public void setCommitable(boolean commitable) {
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(commitable);
        }
    }

    @Override
    public void setDirty() {
    }
}

